"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareEmojiReactionsView = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _classnames = _interopRequireDefault(require("classnames"));

var _reactionPickerController = _interopRequireDefault(require("../controllers/reaction-picker-controller"));

var _tooltip = _interopRequireDefault(require("../atom/tooltip"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareEmojiReactionsView extends _react.default.Component {
  constructor(props) {
    super(props);
    this.refAddButton = new _refHolder.default();
    this.refTooltip = new _refHolder.default();
  }

  render() {
    const viewerReacted = this.props.reactable.reactionGroups.filter(group => group.viewerHasReacted).map(group => group.content);
    const {
      reactionGroups
    } = this.props.reactable;
    const showAddButton = reactionGroups.length === 0 || reactionGroups.some(g => g.users.totalCount === 0);
    return _react.default.createElement("div", {
      className: "github-EmojiReactions btn-toolbar"
    }, showAddButton && _react.default.createElement("div", {
      className: "btn-group"
    }, _react.default.createElement("button", {
      className: "github-EmojiReactions-add btn icon icon-smiley",
      ref: this.refAddButton.setter,
      disabled: !this.props.reactable.viewerCanReact
    }), _react.default.createElement(_tooltip.default, {
      manager: this.props.tooltips,
      target: this.refAddButton,
      trigger: "click",
      className: "github-Popover",
      refTooltip: this.refTooltip
    }, _react.default.createElement(_reactionPickerController.default, {
      viewerReacted: viewerReacted,
      addReaction: this.props.addReaction,
      removeReaction: this.props.removeReaction,
      tooltipHolder: this.refTooltip
    }))), _react.default.createElement("div", {
      className: "btn-group"
    }, this.props.reactable.reactionGroups.map(group => {
      const emoji = _helpers.reactionTypeToEmoji[group.content];

      if (!emoji) {
        return null;
      }

      if (group.users.totalCount === 0) {
        return null;
      }

      const className = (0, _classnames.default)('github-EmojiReactions-group', 'btn', group.content.toLowerCase(), {
        selected: group.viewerHasReacted
      });
      const toggle = !group.viewerHasReacted ? () => this.props.addReaction(group.content) : () => this.props.removeReaction(group.content);
      const disabled = !this.props.reactable.viewerCanReact;
      return _react.default.createElement("button", {
        key: group.content,
        className: className,
        onClick: toggle,
        disabled: disabled
      }, _helpers.reactionTypeToEmoji[group.content], " \xA0 ", group.users.totalCount);
    })));
  }

}

exports.BareEmojiReactionsView = BareEmojiReactionsView;

_defineProperty(BareEmojiReactionsView, "propTypes", {
  // Relay response
  reactable: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    reactionGroups: _propTypes.default.arrayOf(_propTypes.default.shape({
      content: _propTypes.default.string.isRequired,
      viewerHasReacted: _propTypes.default.bool.isRequired,
      users: _propTypes.default.shape({
        totalCount: _propTypes.default.number.isRequired
      }).isRequired
    })).isRequired,
    viewerCanReact: _propTypes.default.bool.isRequired
  }).isRequired,
  // Atom environment
  tooltips: _propTypes.default.object.isRequired,
  // Action methods
  addReaction: _propTypes.default.func.isRequired,
  removeReaction: _propTypes.default.func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareEmojiReactionsView, {
  reactable: function () {
    const node = require("./__generated__/emojiReactionsView_reactable.graphql");

    if (node.hash && node.hash !== "fde156007f42d841401632fce79875d5") {
      console.error("The definition of 'emojiReactionsView_reactable' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/emojiReactionsView_reactable.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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