"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _path = _interopRequireDefault(require("path"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _issueishDetailItem = _interopRequireDefault(require("../items/issueish-detail-item"));

var _changedFileItem = _interopRequireDefault(require("../items/changed-file-item"));

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _propTypes2 = require("../prop-types");

var _reporterProxy = require("../reporter-proxy");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class FilePatchHeaderView extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "togglePatchCollapse", () => {
      if (this.props.isCollapsed) {
        (0, _reporterProxy.addEvent)('expand-file-patch', {
          component: this.constructor.name,
          package: 'github'
        });
        this.props.triggerExpand();
      } else {
        (0, _reporterProxy.addEvent)('collapse-file-patch', {
          component: this.constructor.name,
          package: 'github'
        });
        this.props.triggerCollapse();
      }
    });

    this.refMirrorButton = new _refHolder.default();
    this.refOpenFileButton = new _refHolder.default();
  }

  render() {
    return _react.default.createElement("header", {
      className: "github-FilePatchView-header"
    }, this.renderCollapseButton(), _react.default.createElement("span", {
      className: "github-FilePatchView-title"
    }, this.renderTitle()), this.renderButtonGroup());
  }

  renderCollapseButton() {
    if (this.props.itemType === _changedFileItem.default) {
      return null;
    }

    const icon = this.props.isCollapsed ? 'chevron-right' : 'chevron-down';
    return _react.default.createElement("button", {
      className: "github-FilePatchView-collapseButton",
      onClick: this.togglePatchCollapse
    }, _react.default.createElement(_octicon.default, {
      className: "github-FilePatchView-collapseButtonIcon",
      icon: icon
    }));
  }

  renderTitle() {
    if (this.props.itemType === _changedFileItem.default) {
      const status = this.props.stagingStatus;
      return _react.default.createElement("span", null, status[0].toUpperCase(), status.slice(1), " Changes for ", this.renderDisplayPath());
    } else {
      return this.renderDisplayPath();
    }
  }

  renderDisplayPath() {
    if (this.props.newPath && this.props.newPath !== this.props.relPath) {
      const oldPath = this.renderPath(this.props.relPath);
      const newPath = this.renderPath(this.props.newPath);
      return _react.default.createElement("span", null, oldPath, " ", _react.default.createElement("span", null, "\u2192"), " ", newPath);
    } else {
      return this.renderPath(this.props.relPath);
    }
  }

  renderPath(filePath) {
    const dirname = _path.default.dirname(filePath);

    const basename = _path.default.basename(filePath);

    if (dirname === '.') {
      return _react.default.createElement("span", {
        className: "gitub-FilePatchHeaderView-basename"
      }, basename);
    } else {
      return _react.default.createElement("span", null, dirname, _path.default.sep, _react.default.createElement("span", {
        className: "gitub-FilePatchHeaderView-basename"
      }, basename));
    }
  }

  renderButtonGroup() {
    if (this.props.itemType === _commitDetailItem.default || this.props.itemType === _issueishDetailItem.default) {
      return null;
    } else {
      return _react.default.createElement("span", {
        className: "btn-group"
      }, this.renderUndoDiscardButton(), this.renderMirrorPatchButton(), this.renderOpenFileButton(), this.renderToggleFileButton());
    }
  }

  renderUndoDiscardButton() {
    const unstagedChangedFileItem = this.props.itemType === _changedFileItem.default && this.props.stagingStatus === 'unstaged';

    if (unstagedChangedFileItem && this.props.hasUndoHistory) {
      return _react.default.createElement("button", {
        className: "btn icon icon-history",
        onClick: this.props.undoLastDiscard
      }, "Undo Discard");
    } else {
      return null;
    }
  }

  renderMirrorPatchButton() {
    if (!this.props.isPartiallyStaged) {
      return null;
    }

    const attrs = this.props.stagingStatus === 'unstaged' ? {
      iconClass: 'icon-tasklist',
      buttonText: 'View Staged'
    } : {
      iconClass: 'icon-list-unordered',
      buttonText: 'View Unstaged'
    };
    return _react.default.createElement(_react.Fragment, null, _react.default.createElement("button", {
      ref: this.refMirrorButton.setter,
      className: (0, _classnames.default)('btn', 'icon', attrs.iconClass),
      onClick: this.props.diveIntoMirrorPatch
    }, attrs.buttonText));
  }

  renderOpenFileButton() {
    let buttonText = 'Jump To File';

    if (this.props.hasMultipleFileSelections) {
      buttonText += 's';
    }

    return _react.default.createElement(_react.Fragment, null, _react.default.createElement("button", {
      ref: this.refOpenFileButton.setter,
      className: "btn icon icon-code github-FilePatchHeaderView-jumpToFileButton",
      onClick: this.props.openFile
    }, buttonText));
  }

  renderToggleFileButton() {
    const attrs = this.props.stagingStatus === 'unstaged' ? {
      buttonClass: 'icon-move-down',
      buttonText: 'Stage File'
    } : {
      buttonClass: 'icon-move-up',
      buttonText: 'Unstage File'
    };
    return _react.default.createElement("button", {
      className: (0, _classnames.default)('btn', 'icon', attrs.buttonClass),
      onClick: this.props.toggleFile
    }, attrs.buttonText);
  }

}

exports.default = FilePatchHeaderView;

_defineProperty(FilePatchHeaderView, "propTypes", {
  relPath: _propTypes.default.string.isRequired,
  newPath: _propTypes.default.string,
  stagingStatus: _propTypes.default.oneOf(['staged', 'unstaged']),
  isPartiallyStaged: _propTypes.default.bool,
  hasUndoHistory: _propTypes.default.bool,
  hasMultipleFileSelections: _propTypes.default.bool.isRequired,
  tooltips: _propTypes.default.object.isRequired,
  undoLastDiscard: _propTypes.default.func.isRequired,
  diveIntoMirrorPatch: _propTypes.default.func.isRequired,
  openFile: _propTypes.default.func.isRequired,
  // should probably change 'toggleFile' to 'toggleFileStagingStatus'
  // because the addition of another toggling function makes the old name confusing.
  toggleFile: _propTypes.default.func.isRequired,
  itemType: _propTypes2.ItemTypePropType.isRequired,
  isCollapsed: _propTypes.default.bool.isRequired,
  triggerExpand: _propTypes.default.func.isRequired,
  triggerCollapse: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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