"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _issueishDetailItem = _interopRequireDefault(require("../items/issueish-detail-item"));

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class FilePatchMetaView extends _react.default.Component {
  renderMetaControls() {
    if (this.props.itemType === _commitDetailItem.default || this.props.itemType === _issueishDetailItem.default) {
      return null;
    }

    return _react.default.createElement("div", {
      className: "github-FilePatchView-metaControls"
    }, _react.default.createElement("button", {
      className: (0, _classnames.default)('github-FilePatchView-metaButton', 'icon', this.props.actionIcon),
      onClick: this.props.action
    }, this.props.actionText));
  }

  render() {
    return _react.default.createElement("div", {
      className: "github-FilePatchView-meta"
    }, _react.default.createElement("div", {
      className: "github-FilePatchView-metaContainer"
    }, _react.default.createElement("header", {
      className: "github-FilePatchView-metaHeader"
    }, _react.default.createElement("h3", {
      className: "github-FilePatchView-metaTitle"
    }, this.props.title), this.renderMetaControls()), _react.default.createElement("div", {
      className: "github-FilePatchView-metaDetails"
    }, this.props.children)));
  }

}

exports.default = FilePatchMetaView;

_defineProperty(FilePatchMetaView, "propTypes", {
  title: _propTypes.default.string.isRequired,
  actionIcon: _propTypes.default.string.isRequired,
  actionText: _propTypes.default.string.isRequired,
  action: _propTypes.default.func.isRequired,
  children: _propTypes.default.element.isRequired,
  itemType: _propTypes2.ItemTypePropType.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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