"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = GitHubBlankUninitialized;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* istanbul ignore file */
function GitHubBlankUninitialized(props) {
  return _react.default.createElement("div", {
    className: "github-Local-Uninit github-Blank"
  }, _react.default.createElement("main", {
    className: "github-Blank-body"
  }, _react.default.createElement("div", {
    className: "github-Blank-LargeIcon icon icon-mark-github"
  }), _react.default.createElement("p", {
    className: "github-Blank-context"
  }, "This repository is not yet version controlled by git."), _react.default.createElement("p", {
    className: "github-Blank-option"
  }, _react.default.createElement("button", {
    className: "github-Blank-actionBtn btn icon icon-globe",
    onClick: props.openBoundPublishDialog
  }, "Initialize and publish on GitHub...")), _react.default.createElement("p", {
    className: "github-Blank-explanation"
  }, "Create a new GitHub repository, then track the existing content within this directory as a git repository configured to push there."), _react.default.createElement("p", {
    className: "github-Blank-footer github-Blank-explanation"
  }, "To initialize this directory as a git repository without publishing it to GitHub, visit the", _react.default.createElement("button", {
    className: "github-Blank-tabLink",
    onClick: props.openGitTab
  }, _react.default.createElement(_octicon.default, {
    icon: "git-commit"
  }), "Git tab."))));
}

GitHubBlankUninitialized.propTypes = {
  openBoundPublishDialog: _propTypes.default.func.isRequired,
  openGitTab: _propTypes.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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