"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareGithubDotcomMarkdown = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _issueishLink = require("./issueish-link");

var _userMentionTooltipItem = _interopRequireDefault(require("../items/user-mention-tooltip-item"));

var _issueishTooltipItem = _interopRequireDefault(require("../items/issueish-tooltip-item"));

var _relayEnvironment = _interopRequireDefault(require("./relay-environment"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareGithubDotcomMarkdown extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "handleClick", event => {
      if (event.target.dataset.url) {
        return this.props.handleClickEvent(event, event.target.dataset.url);
      } else {
        return null;
      }
    });

    _defineProperty(this, "openLinkInNewTab", event => {
      return this.props.openIssueishLinkInNewTab(event.target.dataset.url);
    });

    _defineProperty(this, "openLinkInThisTab", event => {
      const {
        repoOwner,
        repoName,
        issueishNumber
      } = (0, _issueishLink.getDataFromGithubUrl)(event.target.dataset.url);
      this.props.switchToIssueish(repoOwner, repoName, issueishNumber);
    });

    _defineProperty(this, "openLinkInBrowser", event => {
      return this.props.openLinkInBrowser(event.target.getAttribute('href'));
    });
  }

  componentDidMount() {
    this.commandSubscriptions = atom.commands.add(_reactDom.default.findDOMNode(this), {
      'github:open-link-in-new-tab': this.openLinkInNewTab,
      'github:open-link-in-browser': this.openLinkInBrowser,
      'github:open-link-in-this-tab': this.openLinkInThisTab
    });
    this.setupComponentHandlers();
    this.setupTooltipHandlers();
  }

  componentDidUpdate() {
    this.setupTooltipHandlers();
  }

  setupComponentHandlers() {
    this.component.addEventListener('click', this.handleClick);
    this.componentHandlers = new _eventKit.Disposable(() => {
      this.component.removeEventListener('click', this.handleClick);
    });
  }

  setupTooltipHandlers() {
    if (this.tooltipSubscriptions) {
      this.tooltipSubscriptions.dispose();
    }

    this.tooltipSubscriptions = new _eventKit.CompositeDisposable();
    this.component.querySelectorAll('.user-mention').forEach(node => {
      const item = new _userMentionTooltipItem.default(node.textContent, this.props.relayEnvironment);
      this.tooltipSubscriptions.add(atom.tooltips.add(node, {
        trigger: 'hover',
        delay: 0,
        class: 'github-Popover',
        item
      }));
      this.tooltipSubscriptions.add(new _eventKit.Disposable(() => item.destroy()));
    });
    this.component.querySelectorAll('.issue-link').forEach(node => {
      const item = new _issueishTooltipItem.default(node.getAttribute('href'), this.props.relayEnvironment);
      this.tooltipSubscriptions.add(atom.tooltips.add(node, {
        trigger: 'hover',
        delay: 0,
        class: 'github-Popover',
        item
      }));
      this.tooltipSubscriptions.add(new _eventKit.Disposable(() => item.destroy()));
    });
  }

  componentWillUnmount() {
    this.commandSubscriptions.dispose();
    this.componentHandlers.dispose();
    this.tooltipSubscriptions && this.tooltipSubscriptions.dispose();
  }

  render() {
    return _react.default.createElement("div", {
      className: `github-DotComMarkdownHtml native-key-bindings ${this.props.className}`,
      tabIndex: "-1",
      ref: c => {
        this.component = c;
      },
      dangerouslySetInnerHTML: {
        __html: this.props.html
      }
    });
  }

}

exports.BareGithubDotcomMarkdown = BareGithubDotcomMarkdown;

_defineProperty(BareGithubDotcomMarkdown, "propTypes", {
  relayEnvironment: _propTypes.default.object.isRequired,
  className: _propTypes.default.string,
  html: _propTypes.default.string.isRequired,
  switchToIssueish: _propTypes.default.func.isRequired,
  handleClickEvent: _propTypes.default.func,
  openIssueishLinkInNewTab: _propTypes.default.func,
  openLinkInBrowser: _propTypes.default.func
});

_defineProperty(BareGithubDotcomMarkdown, "defaultProps", {
  className: '',
  handleClickEvent: _issueishLink.handleClickEvent,
  openIssueishLinkInNewTab: _issueishLink.openIssueishLinkInNewTab,
  openLinkInBrowser: _issueishLink.openLinkInBrowser
});

class GithubDotcomMarkdown extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      lastMarkdown: null,
      html: null
    });
  }

  static getDerivedStateFromProps(props, state) {
    if (props.html) {
      return {
        html: props.html
      };
    }

    if (props.markdown && props.markdown !== state.lastMarkdown) {
      return {
        html: (0, _helpers.renderMarkdown)(props.markdown),
        lastMarkdown: props.markdown
      };
    }

    return null;
  }

  render() {
    return _react.default.createElement(_relayEnvironment.default.Consumer, null, relayEnvironment => _react.default.createElement(BareGithubDotcomMarkdown, _extends({
      relayEnvironment: relayEnvironment
    }, this.props, {
      html: this.state.html
    })));
  }

}

exports.default = GithubDotcomMarkdown;

_defineProperty(GithubDotcomMarkdown, "propTypes", {
  markdown: _propTypes.default.string,
  html: _propTypes.default.string
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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