"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _loadingView = _interopRequireDefault(require("./loading-view"));

var _queryErrorView = _interopRequireDefault(require("../views/query-error-view"));

var _githubLoginView = _interopRequireDefault(require("../views/github-login-view"));

var _remoteSelectorView = _interopRequireDefault(require("./remote-selector-view"));

var _githubTabHeaderContainer = _interopRequireDefault(require("../containers/github-tab-header-container"));

var _githubBlankNolocal = _interopRequireDefault(require("./github-blank-nolocal"));

var _githubBlankUninitialized = _interopRequireDefault(require("./github-blank-uninitialized"));

var _githubBlankNoremote = _interopRequireDefault(require("./github-blank-noremote"));

var _remoteContainer = _interopRequireDefault(require("../containers/remote-container"));

var _keytarStrategy = require("../shared/keytar-strategy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitHubTabView extends _react.default.Component {
  render() {
    return _react.default.createElement("div", {
      className: "github-GitHub",
      ref: this.props.rootHolder.setter
    }, this.renderHeader(), _react.default.createElement("div", {
      className: "github-GitHub-content"
    }, this.renderRemote()));
  }

  renderRemote() {
    if (this.props.token === null) {
      return _react.default.createElement(_loadingView.default, null);
    }

    if (this.props.token === _keytarStrategy.UNAUTHENTICATED) {
      return _react.default.createElement(_githubLoginView.default, {
        onLogin: this.props.handleLogin
      });
    }

    if (this.props.token === _keytarStrategy.INSUFFICIENT) {
      return _react.default.createElement(_githubLoginView.default, {
        onLogin: this.props.handleLogin
      }, _react.default.createElement("p", null, "Your token no longer has sufficient authorizations. Please re-authenticate and generate a new one."));
    }

    if (this.props.token instanceof Error) {
      return _react.default.createElement(_queryErrorView.default, {
        error: this.props.token,
        retry: this.props.handleTokenRetry,
        login: this.props.handleLogin,
        logout: this.props.handleLogout
      });
    }

    if (this.props.isLoading) {
      return _react.default.createElement(_loadingView.default, null);
    }

    if (this.props.repository.isAbsent() || this.props.repository.isAbsentGuess()) {
      return _react.default.createElement(_githubBlankNolocal.default, {
        openCreateDialog: this.props.openCreateDialog,
        openCloneDialog: this.props.openCloneDialog
      });
    }

    if (this.props.repository.isEmpty()) {
      return _react.default.createElement(_githubBlankUninitialized.default, {
        openBoundPublishDialog: this.props.openBoundPublishDialog,
        openGitTab: this.props.openGitTab
      });
    }

    if (this.props.currentRemote.isPresent()) {
      // Single, chosen or unambiguous remote
      return _react.default.createElement(_remoteContainer.default // Connection
      , {
        endpoint: this.props.currentRemote.getEndpoint(),
        token: this.props.token // Repository attributes
        ,
        refresher: this.props.refresher,
        pushInProgress: this.props.pushInProgress,
        workingDirectory: this.props.workingDirectory,
        workspace: this.props.workspace,
        remote: this.props.currentRemote,
        remotes: this.props.remotes,
        branches: this.props.branches,
        aheadCount: this.props.aheadCount // Action methods
        ,
        handleLogin: this.props.handleLogin,
        handleLogout: this.props.handleLogout,
        onPushBranch: () => this.props.handlePushBranch(this.props.currentBranch, this.props.currentRemote)
      });
    }

    if (this.props.manyRemotesAvailable) {
      // No chosen remote, multiple remotes hosted on GitHub instances
      return _react.default.createElement(_remoteSelectorView.default, {
        remotes: this.props.remotes,
        currentBranch: this.props.currentBranch,
        selectRemote: this.props.handleRemoteSelect
      });
    }

    return _react.default.createElement(_githubBlankNoremote.default, {
      openBoundPublishDialog: this.props.openBoundPublishDialog
    });
  }

  renderHeader() {
    return _react.default.createElement(_githubTabHeaderContainer.default // Connection
    , {
      endpoint: this.props.endpoint,
      token: this.props.token // Workspace
      ,
      currentWorkDir: this.props.workingDirectory,
      contextLocked: this.props.contextLocked,
      changeWorkingDirectory: this.props.changeWorkingDirectory,
      setContextLock: this.props.setContextLock,
      getCurrentWorkDirs: this.props.getCurrentWorkDirs // Event Handlers
      ,
      onDidChangeWorkDirs: this.props.onDidChangeWorkDirs
    });
  }

}

exports.default = GitHubTabView;

_defineProperty(GitHubTabView, "propTypes", {
  refresher: _propTypes2.RefresherPropType.isRequired,
  rootHolder: _propTypes2.RefHolderPropType.isRequired,
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes2.TokenPropType,
  // Workspace
  workspace: _propTypes.default.object.isRequired,
  workingDirectory: _propTypes.default.string,
  getCurrentWorkDirs: _propTypes.default.func.isRequired,
  changeWorkingDirectory: _propTypes.default.func.isRequired,
  contextLocked: _propTypes.default.bool.isRequired,
  setContextLock: _propTypes.default.func.isRequired,
  repository: _propTypes.default.object.isRequired,
  // Remotes
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  currentRemote: _propTypes2.RemotePropType.isRequired,
  manyRemotesAvailable: _propTypes.default.bool.isRequired,
  isLoading: _propTypes.default.bool.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  currentBranch: _propTypes2.BranchPropType.isRequired,
  aheadCount: _propTypes.default.number,
  pushInProgress: _propTypes.default.bool.isRequired,
  // Event Handlers
  handleLogin: _propTypes.default.func.isRequired,
  handleLogout: _propTypes.default.func.isRequired,
  handleTokenRetry: _propTypes.default.func.isRequired,
  handleWorkDirSelect: _propTypes.default.func,
  handlePushBranch: _propTypes.default.func.isRequired,
  handleRemoteSelect: _propTypes.default.func.isRequired,
  onDidChangeWorkDirs: _propTypes.default.func.isRequired,
  openCreateDialog: _propTypes.default.func.isRequired,
  openBoundPublishDialog: _propTypes.default.func.isRequired,
  openCloneDialog: _propTypes.default.func.isRequired,
  openGitTab: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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