"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _tooltip = _interopRequireDefault(require("../atom/tooltip"));

var _keystroke = _interopRequireDefault(require("../atom/keystroke"));

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _issueishDetailItem = _interopRequireDefault(require("../items/issueish-detail-item"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function theBuckStopsHere(event) {
  event.stopPropagation();
}

class HunkHeaderView extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'didMouseDown', 'renderButtons');
    this.refDiscardButton = new _refHolder.default();
  }

  render() {
    const conditional = {
      'github-HunkHeaderView--isSelected': this.props.isSelected,
      'github-HunkHeaderView--isHunkMode': this.props.selectionMode === 'hunk'
    };
    return _react.default.createElement("div", {
      className: (0, _classnames.default)('github-HunkHeaderView', conditional),
      onMouseDown: this.didMouseDown
    }, _react.default.createElement("span", {
      className: "github-HunkHeaderView-title"
    }, this.props.hunk.getHeader().trim(), " ", this.props.hunk.getSectionHeading().trim()), this.renderButtons());
  }

  renderButtons() {
    if (this.props.itemType === _commitDetailItem.default || this.props.itemType === _issueishDetailItem.default) {
      return null;
    } else {
      return _react.default.createElement(_react.Fragment, null, _react.default.createElement("button", {
        className: "github-HunkHeaderView-stageButton",
        onClick: this.props.toggleSelection,
        onMouseDown: theBuckStopsHere
      }, _react.default.createElement(_keystroke.default, {
        keymaps: this.props.keymaps,
        command: "core:confirm",
        refTarget: this.props.refTarget
      }), this.props.toggleSelectionLabel), this.props.stagingStatus === 'unstaged' && _react.default.createElement(_react.Fragment, null, _react.default.createElement("button", {
        ref: this.refDiscardButton.setter,
        className: "icon-trashcan github-HunkHeaderView-discardButton",
        onClick: this.props.discardSelection,
        onMouseDown: theBuckStopsHere
      }), _react.default.createElement(_tooltip.default, {
        manager: this.props.tooltips,
        target: this.refDiscardButton,
        title: this.props.discardSelectionLabel
      })));
    }
  }

  didMouseDown(event) {
    return this.props.mouseDown(event, this.props.hunk);
  }

}

exports.default = HunkHeaderView;

_defineProperty(HunkHeaderView, "propTypes", {
  refTarget: _propTypes2.RefHolderPropType.isRequired,
  hunk: _propTypes.default.object.isRequired,
  isSelected: _propTypes.default.bool.isRequired,
  stagingStatus: _propTypes.default.oneOf(['unstaged', 'staged']),
  selectionMode: _propTypes.default.oneOf(['hunk', 'line']).isRequired,
  toggleSelectionLabel: _propTypes.default.string,
  discardSelectionLabel: _propTypes.default.string,
  tooltips: _propTypes.default.object.isRequired,
  keymaps: _propTypes.default.object.isRequired,
  toggleSelection: _propTypes.default.func,
  discardSelection: _propTypes.default.func,
  mouseDown: _propTypes.default.func.isRequired,
  itemType: _propTypes2.ItemTypePropType.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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