"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _atom = require("atom");

var _tabGroup = _interopRequireDefault(require("../tab-group"));

var _tabbable = require("./tabbable");

var _dialogView = _interopRequireDefault(require("./dialog-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class InitDialog extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "accept", () => {
      const destPath = this.destinationPath.getText();

      if (destPath.length === 0) {
        return Promise.resolve();
      }

      return this.props.request.accept(destPath);
    });

    _defineProperty(this, "setAcceptEnablement", () => {
      const enablement = !this.destinationPath.isEmpty();

      if (enablement !== this.state.acceptEnabled) {
        this.setState({
          acceptEnabled: enablement
        });
      }
    });

    this.tabGroup = new _tabGroup.default();
    this.destinationPath = new _atom.TextBuffer({
      text: this.props.request.getParams().dirPath
    });
    this.sub = this.destinationPath.onDidChange(this.setAcceptEnablement);
    this.state = {
      acceptEnabled: !this.destinationPath.isEmpty()
    };
  }

  render() {
    return _react.default.createElement(_dialogView.default, {
      progressMessage: "Initializing...",
      acceptEnabled: this.state.acceptEnabled,
      acceptClassName: "icon icon-repo-create",
      acceptText: "Init",
      accept: this.accept,
      cancel: this.props.request.cancel,
      tabGroup: this.tabGroup,
      inProgress: this.props.inProgress,
      error: this.props.error,
      workspace: this.props.workspace,
      commands: this.props.commands
    }, _react.default.createElement("label", {
      className: "github-DialogLabel"
    }, "Initialize git repository in directory", _react.default.createElement(_tabbable.TabbableTextEditor, {
      tabGroup: this.tabGroup,
      commands: this.props.commands,
      autofocus: true,
      mini: true,
      preselect: true,
      readOnly: this.props.inProgress,
      buffer: this.destinationPath
    })));
  }

  componentDidMount() {
    this.tabGroup.autofocus();
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

}

exports.default = InitDialog;

_defineProperty(InitDialog, "propTypes", {
  // Model
  request: _propTypes.default.shape({
    getParams: _propTypes.default.func.isRequired,
    accept: _propTypes.default.func.isRequired,
    cancel: _propTypes.default.func.isRequired
  }).isRequired,
  inProgress: _propTypes.default.bool,
  error: _propTypes.default.instanceOf(Error),
  // Atom environment
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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