"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _accordion = _interopRequireDefault(require("./accordion"));

var _timeago = _interopRequireDefault(require("./timeago"));

var _statusDonutChart = _interopRequireDefault(require("./status-donut-chart"));

var _checkSuitesAccumulator = _interopRequireDefault(require("../containers/accumulators/check-suites-accumulator"));

var _queryErrorTile = _interopRequireDefault(require("./query-error-tile"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishListView extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderReviewsButton", () => {
      if (!this.props.needReviewsButton || this.props.issueishes.length < 1) {
        return null;
      }

      return _react.default.createElement("button", {
        className: "btn btn-primary btn-sm github-IssueishList-openReviewsButton",
        onClick: this.openReviews
      }, "See reviews");
    });

    _defineProperty(this, "openReviews", e => {
      e.stopPropagation();
      this.props.openReviews(this.props.issueishes[0]);
    });

    _defineProperty(this, "renderIssueish", issueish => {
      return _react.default.createElement(_checkSuitesAccumulator.default, {
        commit: issueish.getLatestCommit()
      }, ({
        runsBySuite
      }) => {
        issueish.setCheckRuns(runsBySuite);
        return _react.default.createElement(_react.Fragment, null, _react.default.createElement("img", {
          className: "github-IssueishList-item github-IssueishList-item--avatar",
          src: issueish.getAuthorAvatarURL(32),
          title: issueish.getAuthorLogin(),
          alt: issueish.getAuthorLogin()
        }), _react.default.createElement("span", {
          className: "github-IssueishList-item github-IssueishList-item--title"
        }, issueish.getTitle()), _react.default.createElement("span", {
          className: "github-IssueishList-item github-IssueishList-item--number"
        }, "#", issueish.getNumber()), this.renderStatusSummary(issueish.getStatusCounts()), _react.default.createElement(_timeago.default, {
          time: issueish.getCreatedAt(),
          displayStyle: "short",
          className: "github-IssueishList-item github-IssueishList-item--age"
        }), _react.default.createElement(_octicon.default, {
          icon: "ellipses",
          className: "github-IssueishList-item github-IssueishList-item--menu",
          onClick: event => this.showActionsMenu(event, issueish)
        }));
      });
    });

    _defineProperty(this, "renderLoadingTile", () => {
      return _react.default.createElement("div", {
        className: "github-IssueishList-loading"
      }, "Loading");
    });

    _defineProperty(this, "renderEmptyTile", () => {
      if (this.props.error) {
        return _react.default.createElement(_queryErrorTile.default, {
          error: this.props.error
        });
      }

      if (this.props.emptyComponent) {
        const EmptyComponent = this.props.emptyComponent;
        return _react.default.createElement(EmptyComponent, null);
      }

      return null;
    });

    _defineProperty(this, "renderMoreTile", () => {
      /* eslint-disable jsx-a11y/anchor-is-valid */
      if (this.props.onMoreClick) {
        return _react.default.createElement("div", {
          className: "github-IssueishList-more"
        }, _react.default.createElement("a", {
          onClick: this.props.onMoreClick
        }, "More..."));
      }

      return null;
    });
  }

  render() {
    return _react.default.createElement(_accordion.default, {
      leftTitle: this.props.title,
      isLoading: this.props.isLoading,
      results: this.props.issueishes,
      total: this.props.total,
      loadingComponent: this.renderLoadingTile,
      emptyComponent: this.renderEmptyTile,
      moreComponent: this.renderMoreTile,
      reviewsButton: this.renderReviewsButton,
      onClickItem: this.props.onIssueishClick
    }, this.renderIssueish);
  }

  showActionsMenu(event, issueish) {
    event.preventDefault();
    event.stopPropagation();
    this.props.showActionsMenu(issueish);
  }

  renderStatusSummary(statusCounts) {
    if (['success', 'failure', 'pending'].every(kind => statusCounts[kind] === 0)) {
      return _react.default.createElement(_octicon.default, {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "dash"
      });
    }

    if (statusCounts.success > 0 && statusCounts.failure === 0 && statusCounts.pending === 0) {
      return _react.default.createElement(_octicon.default, {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "check"
      });
    }

    if (statusCounts.success === 0 && statusCounts.failure > 0 && statusCounts.pending === 0) {
      return _react.default.createElement(_octicon.default, {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "x"
      });
    }

    return _react.default.createElement(_statusDonutChart.default, _extends({}, statusCounts, {
      className: "github-IssueishList-item github-IssueishList-item--status"
    }));
  }

}

exports.default = IssueishListView;

_defineProperty(IssueishListView, "propTypes", {
  title: _propTypes.default.string.isRequired,
  isLoading: _propTypes.default.bool.isRequired,
  total: _propTypes.default.number.isRequired,
  issueishes: _propTypes.default.arrayOf(_propTypes2.IssueishPropType).isRequired,
  repository: _propTypes.default.shape({
    defaultBranchRef: _propTypes.default.shape({
      prefix: _propTypes.default.string.isRequired,
      name: _propTypes.default.string.isRequired
    })
  }),
  needReviewsButton: _propTypes.default.bool,
  onIssueishClick: _propTypes.default.func.isRequired,
  onMoreClick: _propTypes.default.func,
  openReviews: _propTypes.default.func.isRequired,
  openOnGitHub: _propTypes.default.func.isRequired,
  showActionsMenu: _propTypes.default.func.isRequired,
  emptyComponent: _propTypes.default.func,
  error: _propTypes.default.object
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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