"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _modelObserver = _interopRequireDefault(require("../models/model-observer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ObserveModel extends _react.default.Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "fetchData", model => this.props.fetchData(model, ...this.props.fetchParams));

    _defineProperty(this, "didUpdate", () => {
      if (this.mounted) {
        const data = this.modelObserver.getActiveModelData();
        this.setState({
          data
        });
      }
    });

    this.state = {
      data: null
    };
    this.modelObserver = new _modelObserver.default({
      fetchData: this.fetchData,
      didUpdate: this.didUpdate
    });
  }

  componentDidMount() {
    this.mounted = true;
    this.modelObserver.setActiveModel(this.props.model);
  }

  componentDidUpdate(prevProps) {
    this.modelObserver.setActiveModel(this.props.model);

    if (!this.modelObserver.hasPendingUpdate() && prevProps.fetchParams.length !== this.props.fetchParams.length || prevProps.fetchParams.some((prevParam, i) => prevParam !== this.props.fetchParams[i])) {
      this.modelObserver.refreshModelData();
    }
  }

  render() {
    return this.props.children(this.state.data);
  }

  componentWillUnmount() {
    this.mounted = false;
    this.modelObserver.destroy();
  }

}

exports.default = ObserveModel;

_defineProperty(ObserveModel, "propTypes", {
  model: _propTypes.default.shape({
    onDidUpdate: _propTypes.default.func.isRequired
  }),
  fetchData: _propTypes.default.func.isRequired,
  fetchParams: _propTypes.default.arrayOf(_propTypes.default.any),
  children: _propTypes.default.func.isRequired
});

_defineProperty(ObserveModel, "defaultProps", {
  fetchParams: []
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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