"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class OfflineView extends _react.default.Component {
  componentDidMount() {
    window.addEventListener('online', this.props.retry);
  }

  componentWillUnmount() {
    window.removeEventListener('online', this.props.retry);
  }

  render() {
    return _react.default.createElement("div", {
      className: "github-Offline github-Message"
    }, _react.default.createElement("div", {
      className: "github-Message-wrapper"
    }, _react.default.createElement(_octicon.default, {
      className: "github-Offline-logo",
      icon: "alignment-unalign"
    }), _react.default.createElement("h1", {
      className: "github-Message-title"
    }, "Offline"), _react.default.createElement("p", {
      className: "github-Message-description"
    }, "You don't seem to be connected to the Internet. When you're back online, we'll try again."), _react.default.createElement("p", {
      className: "github-Message-action"
    }, _react.default.createElement("button", {
      className: "github-Message-button btn",
      onClick: this.props.retry
    }, "Retry"))));
  }

}

exports.default = OfflineView;

_defineProperty(OfflineView, "propTypes", {
  retry: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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