"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openCommitDetailItem = openCommitDetailItem;
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _atom = require("atom");

var _commitDetailItem = _interopRequireDefault(require("../items/commit-detail-item"));

var _gitShellOutStrategy = require("../git-shell-out-strategy");

var _dialogView = _interopRequireDefault(require("./dialog-view"));

var _tabGroup = _interopRequireDefault(require("../tab-group"));

var _tabbable = require("./tabbable");

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class OpenCommitDialog extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "accept", () => {
      const ref = this.ref.getText();

      if (ref.length === 0) {
        return Promise.resolve();
      }

      return this.props.request.accept(ref);
    });

    _defineProperty(this, "didChangeRef", () => {
      const enabled = !this.ref.isEmpty();

      if (this.state.acceptEnabled !== enabled) {
        this.setState({
          acceptEnabled: enabled
        });
      }
    });

    this.ref = new _atom.TextBuffer();
    this.sub = this.ref.onDidChange(this.didChangeRef);
    this.state = {
      acceptEnabled: false
    };
    this.tabGroup = new _tabGroup.default();
  }

  render() {
    return _react.default.createElement(_dialogView.default, {
      acceptEnabled: this.state.acceptEnabled,
      acceptClassName: "icon icon-commit",
      acceptText: "Open commit",
      accept: this.accept,
      cancel: this.props.request.cancel,
      tabGroup: this.tabGroup,
      inProgress: this.props.inProgress,
      error: this.props.error,
      workspace: this.props.workspace,
      commands: this.props.commands
    }, _react.default.createElement("label", {
      className: "github-DialogLabel github-CommitRef"
    }, "Commit sha or ref:", _react.default.createElement(_tabbable.TabbableTextEditor, {
      tabGroup: this.tabGroup,
      commands: this.props.commands,
      autofocus: true,
      mini: true,
      buffer: this.ref
    })));
  }

  componentDidMount() {
    this.tabGroup.autofocus();
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

}

exports.default = OpenCommitDialog;

_defineProperty(OpenCommitDialog, "propTypes", {
  // Model
  request: _propTypes.default.shape({
    getParams: _propTypes.default.func.isRequired,
    accept: _propTypes.default.func.isRequired,
    cancel: _propTypes.default.func.isRequired
  }).isRequired,
  inProgress: _propTypes.default.bool,
  error: _propTypes.default.instanceOf(Error),
  // Atom environment
  workspace: _propTypes.default.object.isRequired,
  commands: _propTypes.default.object.isRequired
});

async function openCommitDetailItem(ref, {
  workspace,
  repository
}) {
  try {
    await repository.getCommit(ref);
  } catch (error) {
    if (error instanceof _gitShellOutStrategy.GitError && error.code === 128) {
      error.userMessage = 'There is no commit associated with that reference.';
    }

    throw error;
  }

  const item = await workspace.open(_commitDetailItem.default.buildURI(repository.getWorkingDirectoryPath(), ref), {
    searchAllPanes: true
  });
  (0, _reporterProxy.addEvent)('open-commit-in-pane', {
    package: 'github',
    from: OpenCommitDialog.name
  });
  return item;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm9wZW4tY29tbWl0LWRpYWxvZy5qcyJdLCJuYW1lcyI6WyJPcGVuQ29tbWl0RGlhbG9nIiwiUmVhY3QiLCJDb21wb25lbnQiLCJjb25zdHJ1Y3RvciIsInByb3BzIiwicmVmIiwiZ2V0VGV4dCIsImxlbmd0aCIsIlByb21pc2UiLCJyZXNvbHZlIiwicmVxdWVzdCIsImFjY2VwdCIsImVuYWJsZWQiLCJpc0VtcHR5Iiwic3RhdGUiLCJhY2NlcHRFbmFibGVkIiwic2V0U3RhdGUiLCJUZXh0QnVmZmVyIiwic3ViIiwib25EaWRDaGFuZ2UiLCJkaWRDaGFuZ2VSZWYiLCJ0YWJHcm91cCIsIlRhYkdyb3VwIiwicmVuZGVyIiwiY2FuY2VsIiwiaW5Qcm9ncmVzcyIsImVycm9yIiwid29ya3NwYWNlIiwiY29tbWFuZHMiLCJjb21wb25lbnREaWRNb3VudCIsImF1dG9mb2N1cyIsImNvbXBvbmVudFdpbGxVbm1vdW50IiwiZGlzcG9zZSIsIlByb3BUeXBlcyIsInNoYXBlIiwiZ2V0UGFyYW1zIiwiZnVuYyIsImlzUmVxdWlyZWQiLCJib29sIiwiaW5zdGFuY2VPZiIsIkVycm9yIiwib2JqZWN0Iiwib3BlbkNvbW1pdERldGFpbEl0ZW0iLCJyZXBvc2l0b3J5IiwiZ2V0Q29tbWl0IiwiR2l0RXJyb3IiLCJjb2RlIiwidXNlck1lc3NhZ2UiLCJpdGVtIiwib3BlbiIsIkNvbW1pdERldGFpbEl0ZW0iLCJidWlsZFVSSSIsImdldFdvcmtpbmdEaXJlY3RvcnlQYXRoIiwic2VhcmNoQWxsUGFuZXMiLCJwYWNrYWdlIiwiZnJvbSIsIm5hbWUiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7O0FBQUE7O0FBQ0E7O0FBQ0E7O0FBRUE7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7Ozs7OztBQUVlLE1BQU1BLGdCQUFOLFNBQStCQyxlQUFNQyxTQUFyQyxDQUErQztBQWdCNURDLEVBQUFBLFdBQVcsQ0FBQ0MsS0FBRCxFQUFRO0FBQ2pCLFVBQU1BLEtBQU47O0FBRGlCLG9DQWtEVixNQUFNO0FBQ2IsWUFBTUMsR0FBRyxHQUFHLEtBQUtBLEdBQUwsQ0FBU0MsT0FBVCxFQUFaOztBQUNBLFVBQUlELEdBQUcsQ0FBQ0UsTUFBSixLQUFlLENBQW5CLEVBQXNCO0FBQ3BCLGVBQU9DLE9BQU8sQ0FBQ0MsT0FBUixFQUFQO0FBQ0Q7O0FBRUQsYUFBTyxLQUFLTCxLQUFMLENBQVdNLE9BQVgsQ0FBbUJDLE1BQW5CLENBQTBCTixHQUExQixDQUFQO0FBQ0QsS0F6RGtCOztBQUFBLDBDQTJESixNQUFNO0FBQ25CLFlBQU1PLE9BQU8sR0FBRyxDQUFDLEtBQUtQLEdBQUwsQ0FBU1EsT0FBVCxFQUFqQjs7QUFDQSxVQUFJLEtBQUtDLEtBQUwsQ0FBV0MsYUFBWCxLQUE2QkgsT0FBakMsRUFBMEM7QUFDeEMsYUFBS0ksUUFBTCxDQUFjO0FBQUNELFVBQUFBLGFBQWEsRUFBRUg7QUFBaEIsU0FBZDtBQUNEO0FBQ0YsS0FoRWtCOztBQUdqQixTQUFLUCxHQUFMLEdBQVcsSUFBSVksZ0JBQUosRUFBWDtBQUNBLFNBQUtDLEdBQUwsR0FBVyxLQUFLYixHQUFMLENBQVNjLFdBQVQsQ0FBcUIsS0FBS0MsWUFBMUIsQ0FBWDtBQUVBLFNBQUtOLEtBQUwsR0FBYTtBQUNYQyxNQUFBQSxhQUFhLEVBQUU7QUFESixLQUFiO0FBSUEsU0FBS00sUUFBTCxHQUFnQixJQUFJQyxpQkFBSixFQUFoQjtBQUNEOztBQUVEQyxFQUFBQSxNQUFNLEdBQUc7QUFDUCxXQUNFLDZCQUFDLG1CQUFEO0FBQ0UsTUFBQSxhQUFhLEVBQUUsS0FBS1QsS0FBTCxDQUFXQyxhQUQ1QjtBQUVFLE1BQUEsZUFBZSxFQUFDLGtCQUZsQjtBQUdFLE1BQUEsVUFBVSxFQUFDLGFBSGI7QUFJRSxNQUFBLE1BQU0sRUFBRSxLQUFLSixNQUpmO0FBS0UsTUFBQSxNQUFNLEVBQUUsS0FBS1AsS0FBTCxDQUFXTSxPQUFYLENBQW1CYyxNQUw3QjtBQU1FLE1BQUEsUUFBUSxFQUFFLEtBQUtILFFBTmpCO0FBT0UsTUFBQSxVQUFVLEVBQUUsS0FBS2pCLEtBQUwsQ0FBV3FCLFVBUHpCO0FBUUUsTUFBQSxLQUFLLEVBQUUsS0FBS3JCLEtBQUwsQ0FBV3NCLEtBUnBCO0FBU0UsTUFBQSxTQUFTLEVBQUUsS0FBS3RCLEtBQUwsQ0FBV3VCLFNBVHhCO0FBVUUsTUFBQSxRQUFRLEVBQUUsS0FBS3ZCLEtBQUwsQ0FBV3dCO0FBVnZCLE9BWUU7QUFBTyxNQUFBLFNBQVMsRUFBQztBQUFqQiw2QkFFRSw2QkFBQyw0QkFBRDtBQUNFLE1BQUEsUUFBUSxFQUFFLEtBQUtQLFFBRGpCO0FBRUUsTUFBQSxRQUFRLEVBQUUsS0FBS2pCLEtBQUwsQ0FBV3dCLFFBRnZCO0FBR0UsTUFBQSxTQUFTLE1BSFg7QUFJRSxNQUFBLElBQUksTUFKTjtBQUtFLE1BQUEsTUFBTSxFQUFFLEtBQUt2QjtBQUxmLE1BRkYsQ0FaRixDQURGO0FBMEJEOztBQUVEd0IsRUFBQUEsaUJBQWlCLEdBQUc7QUFDbEIsU0FBS1IsUUFBTCxDQUFjUyxTQUFkO0FBQ0Q7O0FBRURDLEVBQUFBLG9CQUFvQixHQUFHO0FBQ3JCLFNBQUtiLEdBQUwsQ0FBU2MsT0FBVDtBQUNEOztBQWhFMkQ7Ozs7Z0JBQXpDaEMsZ0IsZUFDQTtBQUNqQjtBQUNBVSxFQUFBQSxPQUFPLEVBQUV1QixtQkFBVUMsS0FBVixDQUFnQjtBQUN2QkMsSUFBQUEsU0FBUyxFQUFFRixtQkFBVUcsSUFBVixDQUFlQyxVQURIO0FBRXZCMUIsSUFBQUEsTUFBTSxFQUFFc0IsbUJBQVVHLElBQVYsQ0FBZUMsVUFGQTtBQUd2QmIsSUFBQUEsTUFBTSxFQUFFUyxtQkFBVUcsSUFBVixDQUFlQztBQUhBLEdBQWhCLEVBSU5BLFVBTmM7QUFPakJaLEVBQUFBLFVBQVUsRUFBRVEsbUJBQVVLLElBUEw7QUFRakJaLEVBQUFBLEtBQUssRUFBRU8sbUJBQVVNLFVBQVYsQ0FBcUJDLEtBQXJCLENBUlU7QUFVakI7QUFDQWIsRUFBQUEsU0FBUyxFQUFFTSxtQkFBVVEsTUFBVixDQUFpQkosVUFYWDtBQVlqQlQsRUFBQUEsUUFBUSxFQUFFSyxtQkFBVVEsTUFBVixDQUFpQko7QUFaVixDOztBQWtGZCxlQUFlSyxvQkFBZixDQUFvQ3JDLEdBQXBDLEVBQXlDO0FBQUNzQixFQUFBQSxTQUFEO0FBQVlnQixFQUFBQTtBQUFaLENBQXpDLEVBQWtFO0FBQ3ZFLE1BQUk7QUFDRixVQUFNQSxVQUFVLENBQUNDLFNBQVgsQ0FBcUJ2QyxHQUFyQixDQUFOO0FBQ0QsR0FGRCxDQUVFLE9BQU9xQixLQUFQLEVBQWM7QUFDZCxRQUFJQSxLQUFLLFlBQVltQiw2QkFBakIsSUFBNkJuQixLQUFLLENBQUNvQixJQUFOLEtBQWUsR0FBaEQsRUFBcUQ7QUFDbkRwQixNQUFBQSxLQUFLLENBQUNxQixXQUFOLEdBQW9CLG9EQUFwQjtBQUNEOztBQUVELFVBQU1yQixLQUFOO0FBQ0Q7O0FBRUQsUUFBTXNCLElBQUksR0FBRyxNQUFNckIsU0FBUyxDQUFDc0IsSUFBVixDQUNqQkMsMEJBQWlCQyxRQUFqQixDQUEwQlIsVUFBVSxDQUFDUyx1QkFBWCxFQUExQixFQUFnRS9DLEdBQWhFLENBRGlCLEVBRWpCO0FBQUNnRCxJQUFBQSxjQUFjLEVBQUU7QUFBakIsR0FGaUIsQ0FBbkI7QUFJQSwrQkFBUyxxQkFBVCxFQUFnQztBQUFDQyxJQUFBQSxPQUFPLEVBQUUsUUFBVjtBQUFvQkMsSUFBQUEsSUFBSSxFQUFFdkQsZ0JBQWdCLENBQUN3RDtBQUEzQyxHQUFoQztBQUNBLFNBQU9SLElBQVA7QUFDRCIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCB7VGV4dEJ1ZmZlcn0gZnJvbSAnYXRvbSc7XG5cbmltcG9ydCBDb21taXREZXRhaWxJdGVtIGZyb20gJy4uL2l0ZW1zL2NvbW1pdC1kZXRhaWwtaXRlbSc7XG5pbXBvcnQge0dpdEVycm9yfSBmcm9tICcuLi9naXQtc2hlbGwtb3V0LXN0cmF0ZWd5JztcbmltcG9ydCBEaWFsb2dWaWV3IGZyb20gJy4vZGlhbG9nLXZpZXcnO1xuaW1wb3J0IFRhYkdyb3VwIGZyb20gJy4uL3RhYi1ncm91cCc7XG5pbXBvcnQge1RhYmJhYmxlVGV4dEVkaXRvcn0gZnJvbSAnLi90YWJiYWJsZSc7XG5pbXBvcnQge2FkZEV2ZW50fSBmcm9tICcuLi9yZXBvcnRlci1wcm94eSc7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIE9wZW5Db21taXREaWFsb2cgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIC8vIE1vZGVsXG4gICAgcmVxdWVzdDogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgIGdldFBhcmFtczogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICAgIGFjY2VwdDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICAgIGNhbmNlbDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICB9KS5pc1JlcXVpcmVkLFxuICAgIGluUHJvZ3Jlc3M6IFByb3BUeXBlcy5ib29sLFxuICAgIGVycm9yOiBQcm9wVHlwZXMuaW5zdGFuY2VPZihFcnJvciksXG5cbiAgICAvLyBBdG9tIGVudmlyb25tZW50XG4gICAgd29ya3NwYWNlOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG4gICAgY29tbWFuZHM6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuXG4gICAgdGhpcy5yZWYgPSBuZXcgVGV4dEJ1ZmZlcigpO1xuICAgIHRoaXMuc3ViID0gdGhpcy5yZWYub25EaWRDaGFuZ2UodGhpcy5kaWRDaGFuZ2VSZWYpO1xuXG4gICAgdGhpcy5zdGF0ZSA9IHtcbiAgICAgIGFjY2VwdEVuYWJsZWQ6IGZhbHNlLFxuICAgIH07XG5cbiAgICB0aGlzLnRhYkdyb3VwID0gbmV3IFRhYkdyb3VwKCk7XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgcmV0dXJuIChcbiAgICAgIDxEaWFsb2dWaWV3XG4gICAgICAgIGFjY2VwdEVuYWJsZWQ9e3RoaXMuc3RhdGUuYWNjZXB0RW5hYmxlZH1cbiAgICAgICAgYWNjZXB0Q2xhc3NOYW1lPVwiaWNvbiBpY29uLWNvbW1pdFwiXG4gICAgICAgIGFjY2VwdFRleHQ9XCJPcGVuIGNvbW1pdFwiXG4gICAgICAgIGFjY2VwdD17dGhpcy5hY2NlcHR9XG4gICAgICAgIGNhbmNlbD17dGhpcy5wcm9wcy5yZXF1ZXN0LmNhbmNlbH1cbiAgICAgICAgdGFiR3JvdXA9e3RoaXMudGFiR3JvdXB9XG4gICAgICAgIGluUHJvZ3Jlc3M9e3RoaXMucHJvcHMuaW5Qcm9ncmVzc31cbiAgICAgICAgZXJyb3I9e3RoaXMucHJvcHMuZXJyb3J9XG4gICAgICAgIHdvcmtzcGFjZT17dGhpcy5wcm9wcy53b3Jrc3BhY2V9XG4gICAgICAgIGNvbW1hbmRzPXt0aGlzLnByb3BzLmNvbW1hbmRzfT5cblxuICAgICAgICA8bGFiZWwgY2xhc3NOYW1lPVwiZ2l0aHViLURpYWxvZ0xhYmVsIGdpdGh1Yi1Db21taXRSZWZcIj5cbiAgICAgICAgICBDb21taXQgc2hhIG9yIHJlZjpcbiAgICAgICAgICA8VGFiYmFibGVUZXh0RWRpdG9yXG4gICAgICAgICAgICB0YWJHcm91cD17dGhpcy50YWJHcm91cH1cbiAgICAgICAgICAgIGNvbW1hbmRzPXt0aGlzLnByb3BzLmNvbW1hbmRzfVxuICAgICAgICAgICAgYXV0b2ZvY3VzXG4gICAgICAgICAgICBtaW5pXG4gICAgICAgICAgICBidWZmZXI9e3RoaXMucmVmfVxuICAgICAgICAgIC8+XG4gICAgICAgIDwvbGFiZWw+XG5cbiAgICAgIDwvRGlhbG9nVmlldz5cbiAgICApO1xuICB9XG5cbiAgY29tcG9uZW50RGlkTW91bnQoKSB7XG4gICAgdGhpcy50YWJHcm91cC5hdXRvZm9jdXMoKTtcbiAgfVxuXG4gIGNvbXBvbmVudFdpbGxVbm1vdW50KCkge1xuICAgIHRoaXMuc3ViLmRpc3Bvc2UoKTtcbiAgfVxuXG4gIGFjY2VwdCA9ICgpID0+IHtcbiAgICBjb25zdCByZWYgPSB0aGlzLnJlZi5nZXRUZXh0KCk7XG4gICAgaWYgKHJlZi5sZW5ndGggPT09IDApIHtcbiAgICAgIHJldHVybiBQcm9taXNlLnJlc29sdmUoKTtcbiAgICB9XG5cbiAgICByZXR1cm4gdGhpcy5wcm9wcy5yZXF1ZXN0LmFjY2VwdChyZWYpO1xuICB9XG5cbiAgZGlkQ2hhbmdlUmVmID0gKCkgPT4ge1xuICAgIGNvbnN0IGVuYWJsZWQgPSAhdGhpcy5yZWYuaXNFbXB0eSgpO1xuICAgIGlmICh0aGlzLnN0YXRlLmFjY2VwdEVuYWJsZWQgIT09IGVuYWJsZWQpIHtcbiAgICAgIHRoaXMuc2V0U3RhdGUoe2FjY2VwdEVuYWJsZWQ6IGVuYWJsZWR9KTtcbiAgICB9XG4gIH1cbn1cblxuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIG9wZW5Db21taXREZXRhaWxJdGVtKHJlZiwge3dvcmtzcGFjZSwgcmVwb3NpdG9yeX0pIHtcbiAgdHJ5IHtcbiAgICBhd2FpdCByZXBvc2l0b3J5LmdldENvbW1pdChyZWYpO1xuICB9IGNhdGNoIChlcnJvcikge1xuICAgIGlmIChlcnJvciBpbnN0YW5jZW9mIEdpdEVycm9yICYmIGVycm9yLmNvZGUgPT09IDEyOCkge1xuICAgICAgZXJyb3IudXNlck1lc3NhZ2UgPSAnVGhlcmUgaXMgbm8gY29tbWl0IGFzc29jaWF0ZWQgd2l0aCB0aGF0IHJlZmVyZW5jZS4nO1xuICAgIH1cblxuICAgIHRocm93IGVycm9yO1xuICB9XG5cbiAgY29uc3QgaXRlbSA9IGF3YWl0IHdvcmtzcGFjZS5vcGVuKFxuICAgIENvbW1pdERldGFpbEl0ZW0uYnVpbGRVUkkocmVwb3NpdG9yeS5nZXRXb3JraW5nRGlyZWN0b3J5UGF0aCgpLCByZWYpLFxuICAgIHtzZWFyY2hBbGxQYW5lczogdHJ1ZX0sXG4gICk7XG4gIGFkZEV2ZW50KCdvcGVuLWNvbW1pdC1pbi1wYW5lJywge3BhY2thZ2U6ICdnaXRodWInLCBmcm9tOiBPcGVuQ29tbWl0RGlhbG9nLm5hbWV9KTtcbiAgcmV0dXJuIGl0ZW07XG59XG4iXX0=