"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.PrCommitView = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _nodeEmoji = require("node-emoji");

var _moment = _interopRequireDefault(require("moment"));

var _reactRelay = require("react-relay");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const avatarAltText = 'committer avatar';

class PrCommitView extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "openCommitDetailItem", () => this.props.openCommit({
      sha: this.props.item.sha
    }));

    this.state = {
      showMessageBody: false
    };
    (0, _helpers.autobind)(this, 'toggleShowCommitMessageBody', 'humanizeTimeSince');
  }

  toggleShowCommitMessageBody() {
    this.setState({
      showMessageBody: !this.state.showMessageBody
    });
  }

  humanizeTimeSince(date) {
    return (0, _moment.default)(date).fromNow();
  }

  render() {
    const {
      messageHeadline,
      messageBody,
      shortSha,
      url
    } = this.props.item;
    const {
      avatarUrl,
      name,
      date
    } = this.props.item.committer;
    return _react.default.createElement("div", {
      className: "github-PrCommitView-container"
    }, _react.default.createElement("div", {
      className: "github-PrCommitView-commit"
    }, _react.default.createElement("h3", {
      className: "github-PrCommitView-title"
    }, this.props.onBranch ? _react.default.createElement("button", {
      className: "github-PrCommitView-messageHeadline is-button",
      onClick: this.openCommitDetailItem
    }, (0, _nodeEmoji.emojify)(messageHeadline)) : _react.default.createElement("span", {
      className: "github-PrCommitView-messageHeadline"
    }, (0, _nodeEmoji.emojify)(messageHeadline)), messageBody ? _react.default.createElement("button", {
      className: "github-PrCommitView-moreButton",
      onClick: this.toggleShowCommitMessageBody
    }, this.state.showMessageBody ? 'hide' : 'show', " more...") : null), _react.default.createElement("div", {
      className: "github-PrCommitView-meta"
    }, _react.default.createElement("img", {
      className: "github-PrCommitView-avatar",
      src: avatarUrl,
      alt: avatarAltText,
      title: avatarAltText
    }), _react.default.createElement("span", {
      className: "github-PrCommitView-metaText"
    }, name, " committed ", this.humanizeTimeSince(date))), this.state.showMessageBody ? _react.default.createElement("pre", {
      className: "github-PrCommitView-moreText"
    }, (0, _nodeEmoji.emojify)(messageBody)) : null), _react.default.createElement("div", {
      className: "github-PrCommitView-sha"
    }, _react.default.createElement("a", {
      href: url,
      title: `open commit ${shortSha} on GitHub.com`
    }, shortSha)));
  }

}

exports.PrCommitView = PrCommitView;

_defineProperty(PrCommitView, "propTypes", {
  item: _propTypes.default.shape({
    committer: _propTypes.default.shape({
      avatarUrl: _propTypes.default.string.isRequired,
      name: _propTypes.default.string.isRequired,
      date: _propTypes.default.string.isRequired
    }).isRequired,
    messageBody: _propTypes.default.string,
    messageHeadline: _propTypes.default.string.isRequired,
    shortSha: _propTypes.default.string.isRequired,
    sha: _propTypes.default.string.isRequired,
    url: _propTypes.default.string.isRequired
  }).isRequired,
  onBranch: _propTypes.default.bool.isRequired,
  openCommit: _propTypes.default.func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(PrCommitView, {
  item: function () {
    const node = require("./__generated__/prCommitView_item.graphql");

    if (node.hash && node.hash !== "2bd193bec5d758f465d9428ff3cd8a09") {
      console.error("The definition of 'prCommitView_item' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prCommitView_item.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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