"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes2 = require("../prop-types");

var _tooltip = _interopRequireDefault(require("../atom/tooltip"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function getIconClass(icon, animation) {
  return (0, _classnames.default)('github-PushPull-icon', 'icon', `icon-${icon}`, {
    [`animate-${animation}`]: !!animation
  });
}

class PushPullView extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "onClickPush", clickEvent => {
      if (this.props.isSyncing) {
        return;
      }

      this.props.push({
        force: clickEvent.metaKey || clickEvent.ctrlKey,
        setUpstream: !this.props.currentRemote.isPresent()
      });
    });

    _defineProperty(this, "onClickPull", clickEvent => {
      if (this.props.isSyncing) {
        return;
      }

      this.props.pull();
    });

    _defineProperty(this, "onClickPushPull", clickEvent => {
      if (this.props.isSyncing) {
        return;
      }

      if (clickEvent.metaKey || clickEvent.ctrlKey) {
        this.props.push({
          force: true
        });
      } else {
        this.props.pull();
      }
    });

    _defineProperty(this, "onClickPublish", clickEvent => {
      if (this.props.isSyncing) {
        return;
      }

      this.props.push({
        setUpstream: !this.props.currentRemote.isPresent()
      });
    });

    _defineProperty(this, "onClickFetch", clickEvent => {
      if (this.props.isSyncing) {
        return;
      }

      this.props.fetch();
    });

    this.refTileNode = new _refHolder.default();
  }

  getTileStates() {
    const modKey = process.platform === 'darwin' ? 'Cmd' : 'Ctrl';
    return {
      fetching: {
        tooltip: 'Fetching from remote',
        icon: 'sync',
        text: 'Fetching',
        iconAnimation: 'rotate'
      },
      pulling: {
        tooltip: 'Pulling from remote',
        icon: 'arrow-down',
        text: 'Pulling',
        iconAnimation: 'down'
      },
      pushing: {
        tooltip: 'Pushing to remote',
        icon: 'arrow-up',
        text: 'Pushing',
        iconAnimation: 'up'
      },
      ahead: {
        onClick: this.onClickPush,
        tooltip: `Click to push<br />${modKey}-click to force push<br />Right-click for more`,
        icon: 'arrow-up',
        text: `Push ${this.props.aheadCount}`
      },
      behind: {
        onClick: this.onClickPull,
        tooltip: 'Click to pull<br />Right-click for more',
        icon: 'arrow-down',
        text: `Pull ${this.props.behindCount}`
      },
      aheadBehind: {
        onClick: this.onClickPushPull,
        tooltip: `Click to pull<br />${modKey}-click to force push<br />Right-click for more`,
        icon: 'arrow-down',
        text: `Pull ${this.props.behindCount}`,
        secondaryIcon: 'arrow-up',
        secondaryText: `${this.props.aheadCount} `
      },
      published: {
        onClick: this.onClickFetch,
        tooltip: 'Click to fetch<br />Right-click for more',
        icon: 'sync',
        text: 'Fetch'
      },
      unpublished: {
        onClick: this.onClickPublish,
        tooltip: 'Click to set up a remote tracking branch<br />Right-click for more',
        icon: 'cloud-upload',
        text: 'Publish'
      },
      noRemote: {
        tooltip: 'There is no remote named "origin"',
        icon: 'stop',
        text: 'No remote'
      },
      detached: {
        tooltip: 'Create a branch if you wish to push your work anywhere',
        icon: 'stop',
        text: 'Not on branch'
      }
    };
  }

  render() {
    const isAhead = this.props.aheadCount > 0;
    const isBehind = this.props.behindCount > 0;
    const isUnpublished = !this.props.currentRemote.isPresent();
    const isDetached = this.props.currentBranch.isDetached();
    const isFetching = this.props.isFetching;
    const isPulling = this.props.isPulling;
    const isPushing = this.props.isPushing;
    const hasOrigin = !!this.props.originExists;
    const tileStates = this.getTileStates();
    let tileState;

    if (isFetching) {
      tileState = tileStates.fetching;
    } else if (isPulling) {
      tileState = tileStates.pulling;
    } else if (isPushing) {
      tileState = tileStates.pushing;
    } else if (isAhead && !isBehind && !isUnpublished) {
      tileState = tileStates.ahead;
    } else if (isBehind && !isAhead && !isUnpublished) {
      tileState = tileStates.behind;
    } else if (isBehind && isAhead && !isUnpublished) {
      tileState = tileStates.aheadBehind;
    } else if (!isBehind && !isAhead && !isUnpublished && !isDetached) {
      tileState = tileStates.published;
    } else if (isUnpublished && !isDetached && hasOrigin) {
      tileState = tileStates.unpublished;
    } else if (isUnpublished && !isDetached && !hasOrigin) {
      tileState = tileStates.noRemote;
    } else if (isDetached) {
      tileState = tileStates.detached;
    }

    return _react.default.createElement("div", {
      onClick: tileState.onClick,
      ref: this.refTileNode.setter,
      className: (0, _classnames.default)('github-PushPull', 'inline-block', {
        'github-branch-detached': isDetached
      })
    }, tileState && _react.default.createElement(_react.Fragment, null, _react.default.createElement("span", null, tileState.secondaryText && _react.default.createElement("span", {
      className: "secondary"
    }, _react.default.createElement("span", {
      className: getIconClass(tileState.secondaryIcon)
    }), tileState.secondaryText), _react.default.createElement("span", {
      className: getIconClass(tileState.icon, tileState.iconAnimation)
    }), tileState.text), _react.default.createElement(_tooltip.default, {
      key: "tooltip",
      manager: this.props.tooltipManager,
      target: this.refTileNode,
      title: `<div style="text-align: left; line-height: 1.2em;">${tileState.tooltip}</div>`,
      showDelay: atom.tooltips.hoverDefaults.delay.show,
      hideDelay: atom.tooltips.hoverDefaults.delay.hide
    })));
  }

}

exports.default = PushPullView;

_defineProperty(PushPullView, "propTypes", {
  currentBranch: _propTypes2.BranchPropType.isRequired,
  currentRemote: _propTypes2.RemotePropType.isRequired,
  isSyncing: _propTypes.default.bool,
  isFetching: _propTypes.default.bool,
  isPulling: _propTypes.default.bool,
  isPushing: _propTypes.default.bool,
  behindCount: _propTypes.default.number,
  aheadCount: _propTypes.default.number,
  push: _propTypes.default.func.isRequired,
  pull: _propTypes.default.func.isRequired,
  fetch: _propTypes.default.func.isRequired,
  originExists: _propTypes.default.bool,
  tooltipManager: _propTypes.default.object.isRequired
});

_defineProperty(PushPullView, "defaultProps", {
  isSyncing: false,
  isFetching: false,
  isPulling: false,
  isPushing: false,
  behindCount: 0,
  aheadCount: 0
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInB1c2gtcHVsbC12aWV3LmpzIl0sIm5hbWVzIjpbImdldEljb25DbGFzcyIsImljb24iLCJhbmltYXRpb24iLCJQdXNoUHVsbFZpZXciLCJSZWFjdCIsIkNvbXBvbmVudCIsImNvbnN0cnVjdG9yIiwicHJvcHMiLCJjbGlja0V2ZW50IiwiaXNTeW5jaW5nIiwicHVzaCIsImZvcmNlIiwibWV0YUtleSIsImN0cmxLZXkiLCJzZXRVcHN0cmVhbSIsImN1cnJlbnRSZW1vdGUiLCJpc1ByZXNlbnQiLCJwdWxsIiwiZmV0Y2giLCJyZWZUaWxlTm9kZSIsIlJlZkhvbGRlciIsImdldFRpbGVTdGF0ZXMiLCJtb2RLZXkiLCJwcm9jZXNzIiwicGxhdGZvcm0iLCJmZXRjaGluZyIsInRvb2x0aXAiLCJ0ZXh0IiwiaWNvbkFuaW1hdGlvbiIsInB1bGxpbmciLCJwdXNoaW5nIiwiYWhlYWQiLCJvbkNsaWNrIiwib25DbGlja1B1c2giLCJhaGVhZENvdW50IiwiYmVoaW5kIiwib25DbGlja1B1bGwiLCJiZWhpbmRDb3VudCIsImFoZWFkQmVoaW5kIiwib25DbGlja1B1c2hQdWxsIiwic2Vjb25kYXJ5SWNvbiIsInNlY29uZGFyeVRleHQiLCJwdWJsaXNoZWQiLCJvbkNsaWNrRmV0Y2giLCJ1bnB1Ymxpc2hlZCIsIm9uQ2xpY2tQdWJsaXNoIiwibm9SZW1vdGUiLCJkZXRhY2hlZCIsInJlbmRlciIsImlzQWhlYWQiLCJpc0JlaGluZCIsImlzVW5wdWJsaXNoZWQiLCJpc0RldGFjaGVkIiwiY3VycmVudEJyYW5jaCIsImlzRmV0Y2hpbmciLCJpc1B1bGxpbmciLCJpc1B1c2hpbmciLCJoYXNPcmlnaW4iLCJvcmlnaW5FeGlzdHMiLCJ0aWxlU3RhdGVzIiwidGlsZVN0YXRlIiwic2V0dGVyIiwidG9vbHRpcE1hbmFnZXIiLCJhdG9tIiwidG9vbHRpcHMiLCJob3ZlckRlZmF1bHRzIiwiZGVsYXkiLCJzaG93IiwiaGlkZSIsIkJyYW5jaFByb3BUeXBlIiwiaXNSZXF1aXJlZCIsIlJlbW90ZVByb3BUeXBlIiwiUHJvcFR5cGVzIiwiYm9vbCIsIm51bWJlciIsImZ1bmMiLCJvYmplY3QiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFDQTs7QUFDQTs7QUFFQTs7QUFDQTs7QUFDQTs7Ozs7Ozs7QUFFQSxTQUFTQSxZQUFULENBQXNCQyxJQUF0QixFQUE0QkMsU0FBNUIsRUFBdUM7QUFDckMsU0FBTyx5QkFDTCxzQkFESyxFQUVMLE1BRkssRUFHSixRQUFPRCxJQUFLLEVBSFIsRUFJTDtBQUFDLEtBQUUsV0FBVUMsU0FBVSxFQUF0QixHQUEwQixDQUFDLENBQUNBO0FBQTdCLEdBSkssQ0FBUDtBQU1EOztBQUVjLE1BQU1DLFlBQU4sU0FBMkJDLGVBQU1DLFNBQWpDLENBQTJDO0FBMEJ4REMsRUFBQUEsV0FBVyxDQUFDQyxLQUFELEVBQVE7QUFDakIsVUFBTUEsS0FBTjs7QUFEaUIseUNBTUxDLFVBQVUsSUFBSTtBQUMxQixVQUFJLEtBQUtELEtBQUwsQ0FBV0UsU0FBZixFQUEwQjtBQUN4QjtBQUNEOztBQUNELFdBQUtGLEtBQUwsQ0FBV0csSUFBWCxDQUFnQjtBQUNkQyxRQUFBQSxLQUFLLEVBQUVILFVBQVUsQ0FBQ0ksT0FBWCxJQUFzQkosVUFBVSxDQUFDSyxPQUQxQjtBQUVkQyxRQUFBQSxXQUFXLEVBQUUsQ0FBQyxLQUFLUCxLQUFMLENBQVdRLGFBQVgsQ0FBeUJDLFNBQXpCO0FBRkEsT0FBaEI7QUFJRCxLQWRrQjs7QUFBQSx5Q0FnQkxSLFVBQVUsSUFBSTtBQUMxQixVQUFJLEtBQUtELEtBQUwsQ0FBV0UsU0FBZixFQUEwQjtBQUN4QjtBQUNEOztBQUNELFdBQUtGLEtBQUwsQ0FBV1UsSUFBWDtBQUNELEtBckJrQjs7QUFBQSw2Q0F1QkRULFVBQVUsSUFBSTtBQUM5QixVQUFJLEtBQUtELEtBQUwsQ0FBV0UsU0FBZixFQUEwQjtBQUN4QjtBQUNEOztBQUNELFVBQUlELFVBQVUsQ0FBQ0ksT0FBWCxJQUFzQkosVUFBVSxDQUFDSyxPQUFyQyxFQUE4QztBQUM1QyxhQUFLTixLQUFMLENBQVdHLElBQVgsQ0FBZ0I7QUFDZEMsVUFBQUEsS0FBSyxFQUFFO0FBRE8sU0FBaEI7QUFHRCxPQUpELE1BSU87QUFDTCxhQUFLSixLQUFMLENBQVdVLElBQVg7QUFDRDtBQUNGLEtBbENrQjs7QUFBQSw0Q0FvQ0ZULFVBQVUsSUFBSTtBQUM3QixVQUFJLEtBQUtELEtBQUwsQ0FBV0UsU0FBZixFQUEwQjtBQUN4QjtBQUNEOztBQUNELFdBQUtGLEtBQUwsQ0FBV0csSUFBWCxDQUFnQjtBQUNkSSxRQUFBQSxXQUFXLEVBQUUsQ0FBQyxLQUFLUCxLQUFMLENBQVdRLGFBQVgsQ0FBeUJDLFNBQXpCO0FBREEsT0FBaEI7QUFHRCxLQTNDa0I7O0FBQUEsMENBNkNKUixVQUFVLElBQUk7QUFDM0IsVUFBSSxLQUFLRCxLQUFMLENBQVdFLFNBQWYsRUFBMEI7QUFDeEI7QUFDRDs7QUFDRCxXQUFLRixLQUFMLENBQVdXLEtBQVg7QUFDRCxLQWxEa0I7O0FBR2pCLFNBQUtDLFdBQUwsR0FBbUIsSUFBSUMsa0JBQUosRUFBbkI7QUFDRDs7QUFnRERDLEVBQUFBLGFBQWEsR0FBRztBQUNkLFVBQU1DLE1BQU0sR0FBR0MsT0FBTyxDQUFDQyxRQUFSLEtBQXFCLFFBQXJCLEdBQWdDLEtBQWhDLEdBQXdDLE1BQXZEO0FBQ0EsV0FBTztBQUNMQyxNQUFBQSxRQUFRLEVBQUU7QUFDUkMsUUFBQUEsT0FBTyxFQUFFLHNCQUREO0FBRVJ6QixRQUFBQSxJQUFJLEVBQUUsTUFGRTtBQUdSMEIsUUFBQUEsSUFBSSxFQUFFLFVBSEU7QUFJUkMsUUFBQUEsYUFBYSxFQUFFO0FBSlAsT0FETDtBQU9MQyxNQUFBQSxPQUFPLEVBQUU7QUFDUEgsUUFBQUEsT0FBTyxFQUFFLHFCQURGO0FBRVB6QixRQUFBQSxJQUFJLEVBQUUsWUFGQztBQUdQMEIsUUFBQUEsSUFBSSxFQUFFLFNBSEM7QUFJUEMsUUFBQUEsYUFBYSxFQUFFO0FBSlIsT0FQSjtBQWFMRSxNQUFBQSxPQUFPLEVBQUU7QUFDUEosUUFBQUEsT0FBTyxFQUFFLG1CQURGO0FBRVB6QixRQUFBQSxJQUFJLEVBQUUsVUFGQztBQUdQMEIsUUFBQUEsSUFBSSxFQUFFLFNBSEM7QUFJUEMsUUFBQUEsYUFBYSxFQUFFO0FBSlIsT0FiSjtBQW1CTEcsTUFBQUEsS0FBSyxFQUFFO0FBQ0xDLFFBQUFBLE9BQU8sRUFBRSxLQUFLQyxXQURUO0FBRUxQLFFBQUFBLE9BQU8sRUFBRyxzQkFBcUJKLE1BQU8sZ0RBRmpDO0FBR0xyQixRQUFBQSxJQUFJLEVBQUUsVUFIRDtBQUlMMEIsUUFBQUEsSUFBSSxFQUFHLFFBQU8sS0FBS3BCLEtBQUwsQ0FBVzJCLFVBQVc7QUFKL0IsT0FuQkY7QUF5QkxDLE1BQUFBLE1BQU0sRUFBRTtBQUNOSCxRQUFBQSxPQUFPLEVBQUUsS0FBS0ksV0FEUjtBQUVOVixRQUFBQSxPQUFPLEVBQUUseUNBRkg7QUFHTnpCLFFBQUFBLElBQUksRUFBRSxZQUhBO0FBSU4wQixRQUFBQSxJQUFJLEVBQUcsUUFBTyxLQUFLcEIsS0FBTCxDQUFXOEIsV0FBWTtBQUovQixPQXpCSDtBQStCTEMsTUFBQUEsV0FBVyxFQUFFO0FBQ1hOLFFBQUFBLE9BQU8sRUFBRSxLQUFLTyxlQURIO0FBRVhiLFFBQUFBLE9BQU8sRUFBRyxzQkFBcUJKLE1BQU8sZ0RBRjNCO0FBR1hyQixRQUFBQSxJQUFJLEVBQUUsWUFISztBQUlYMEIsUUFBQUEsSUFBSSxFQUFHLFFBQU8sS0FBS3BCLEtBQUwsQ0FBVzhCLFdBQVksRUFKMUI7QUFLWEcsUUFBQUEsYUFBYSxFQUFFLFVBTEo7QUFNWEMsUUFBQUEsYUFBYSxFQUFHLEdBQUUsS0FBS2xDLEtBQUwsQ0FBVzJCLFVBQVc7QUFON0IsT0EvQlI7QUF1Q0xRLE1BQUFBLFNBQVMsRUFBRTtBQUNUVixRQUFBQSxPQUFPLEVBQUUsS0FBS1csWUFETDtBQUVUakIsUUFBQUEsT0FBTyxFQUFFLDBDQUZBO0FBR1R6QixRQUFBQSxJQUFJLEVBQUUsTUFIRztBQUlUMEIsUUFBQUEsSUFBSSxFQUFFO0FBSkcsT0F2Q047QUE2Q0xpQixNQUFBQSxXQUFXLEVBQUU7QUFDWFosUUFBQUEsT0FBTyxFQUFFLEtBQUthLGNBREg7QUFFWG5CLFFBQUFBLE9BQU8sRUFBRSxvRUFGRTtBQUdYekIsUUFBQUEsSUFBSSxFQUFFLGNBSEs7QUFJWDBCLFFBQUFBLElBQUksRUFBRTtBQUpLLE9BN0NSO0FBbURMbUIsTUFBQUEsUUFBUSxFQUFFO0FBQ1JwQixRQUFBQSxPQUFPLEVBQUUsbUNBREQ7QUFFUnpCLFFBQUFBLElBQUksRUFBRSxNQUZFO0FBR1IwQixRQUFBQSxJQUFJLEVBQUU7QUFIRSxPQW5ETDtBQXdETG9CLE1BQUFBLFFBQVEsRUFBRTtBQUNSckIsUUFBQUEsT0FBTyxFQUFFLHdEQUREO0FBRVJ6QixRQUFBQSxJQUFJLEVBQUUsTUFGRTtBQUdSMEIsUUFBQUEsSUFBSSxFQUFFO0FBSEU7QUF4REwsS0FBUDtBQThERDs7QUFFRHFCLEVBQUFBLE1BQU0sR0FBRztBQUNQLFVBQU1DLE9BQU8sR0FBRyxLQUFLMUMsS0FBTCxDQUFXMkIsVUFBWCxHQUF3QixDQUF4QztBQUNBLFVBQU1nQixRQUFRLEdBQUcsS0FBSzNDLEtBQUwsQ0FBVzhCLFdBQVgsR0FBeUIsQ0FBMUM7QUFDQSxVQUFNYyxhQUFhLEdBQUcsQ0FBQyxLQUFLNUMsS0FBTCxDQUFXUSxhQUFYLENBQXlCQyxTQUF6QixFQUF2QjtBQUNBLFVBQU1vQyxVQUFVLEdBQUcsS0FBSzdDLEtBQUwsQ0FBVzhDLGFBQVgsQ0FBeUJELFVBQXpCLEVBQW5CO0FBQ0EsVUFBTUUsVUFBVSxHQUFHLEtBQUsvQyxLQUFMLENBQVcrQyxVQUE5QjtBQUNBLFVBQU1DLFNBQVMsR0FBRyxLQUFLaEQsS0FBTCxDQUFXZ0QsU0FBN0I7QUFDQSxVQUFNQyxTQUFTLEdBQUcsS0FBS2pELEtBQUwsQ0FBV2lELFNBQTdCO0FBQ0EsVUFBTUMsU0FBUyxHQUFHLENBQUMsQ0FBQyxLQUFLbEQsS0FBTCxDQUFXbUQsWUFBL0I7QUFFQSxVQUFNQyxVQUFVLEdBQUcsS0FBS3RDLGFBQUwsRUFBbkI7QUFFQSxRQUFJdUMsU0FBSjs7QUFFQSxRQUFJTixVQUFKLEVBQWdCO0FBQ2RNLE1BQUFBLFNBQVMsR0FBR0QsVUFBVSxDQUFDbEMsUUFBdkI7QUFDRCxLQUZELE1BRU8sSUFBSThCLFNBQUosRUFBZTtBQUNwQkssTUFBQUEsU0FBUyxHQUFHRCxVQUFVLENBQUM5QixPQUF2QjtBQUNELEtBRk0sTUFFQSxJQUFJMkIsU0FBSixFQUFlO0FBQ3BCSSxNQUFBQSxTQUFTLEdBQUdELFVBQVUsQ0FBQzdCLE9BQXZCO0FBQ0QsS0FGTSxNQUVBLElBQUltQixPQUFPLElBQUksQ0FBQ0MsUUFBWixJQUF3QixDQUFDQyxhQUE3QixFQUE0QztBQUNqRFMsTUFBQUEsU0FBUyxHQUFHRCxVQUFVLENBQUM1QixLQUF2QjtBQUNELEtBRk0sTUFFQSxJQUFJbUIsUUFBUSxJQUFJLENBQUNELE9BQWIsSUFBd0IsQ0FBQ0UsYUFBN0IsRUFBNEM7QUFDakRTLE1BQUFBLFNBQVMsR0FBR0QsVUFBVSxDQUFDeEIsTUFBdkI7QUFDRCxLQUZNLE1BRUEsSUFBSWUsUUFBUSxJQUFJRCxPQUFaLElBQXVCLENBQUNFLGFBQTVCLEVBQTJDO0FBQ2hEUyxNQUFBQSxTQUFTLEdBQUdELFVBQVUsQ0FBQ3JCLFdBQXZCO0FBQ0QsS0FGTSxNQUVBLElBQUksQ0FBQ1ksUUFBRCxJQUFhLENBQUNELE9BQWQsSUFBeUIsQ0FBQ0UsYUFBMUIsSUFBMkMsQ0FBQ0MsVUFBaEQsRUFBNEQ7QUFDakVRLE1BQUFBLFNBQVMsR0FBR0QsVUFBVSxDQUFDakIsU0FBdkI7QUFDRCxLQUZNLE1BRUEsSUFBSVMsYUFBYSxJQUFJLENBQUNDLFVBQWxCLElBQWdDSyxTQUFwQyxFQUErQztBQUNwREcsTUFBQUEsU0FBUyxHQUFHRCxVQUFVLENBQUNmLFdBQXZCO0FBQ0QsS0FGTSxNQUVBLElBQUlPLGFBQWEsSUFBSSxDQUFDQyxVQUFsQixJQUFnQyxDQUFDSyxTQUFyQyxFQUFnRDtBQUNyREcsTUFBQUEsU0FBUyxHQUFHRCxVQUFVLENBQUNiLFFBQXZCO0FBQ0QsS0FGTSxNQUVBLElBQUlNLFVBQUosRUFBZ0I7QUFDckJRLE1BQUFBLFNBQVMsR0FBR0QsVUFBVSxDQUFDWixRQUF2QjtBQUNEOztBQUVELFdBQ0U7QUFDRSxNQUFBLE9BQU8sRUFBRWEsU0FBUyxDQUFDNUIsT0FEckI7QUFFRSxNQUFBLEdBQUcsRUFBRSxLQUFLYixXQUFMLENBQWlCMEMsTUFGeEI7QUFHRSxNQUFBLFNBQVMsRUFBRSx5QkFBRyxpQkFBSCxFQUFzQixjQUF0QixFQUFzQztBQUFDLGtDQUEwQlQ7QUFBM0IsT0FBdEM7QUFIYixPQUlHUSxTQUFTLElBQ1IsNkJBQUMsZUFBRCxRQUNFLDJDQUNHQSxTQUFTLENBQUNuQixhQUFWLElBQ0M7QUFBTSxNQUFBLFNBQVMsRUFBQztBQUFoQixPQUNFO0FBQU0sTUFBQSxTQUFTLEVBQUV6QyxZQUFZLENBQUM0RCxTQUFTLENBQUNwQixhQUFYO0FBQTdCLE1BREYsRUFFR29CLFNBQVMsQ0FBQ25CLGFBRmIsQ0FGSixFQU9FO0FBQU0sTUFBQSxTQUFTLEVBQUV6QyxZQUFZLENBQUM0RCxTQUFTLENBQUMzRCxJQUFYLEVBQWlCMkQsU0FBUyxDQUFDaEMsYUFBM0I7QUFBN0IsTUFQRixFQVFHZ0MsU0FBUyxDQUFDakMsSUFSYixDQURGLEVBV0UsNkJBQUMsZ0JBQUQ7QUFDRSxNQUFBLEdBQUcsRUFBQyxTQUROO0FBRUUsTUFBQSxPQUFPLEVBQUUsS0FBS3BCLEtBQUwsQ0FBV3VELGNBRnRCO0FBR0UsTUFBQSxNQUFNLEVBQUUsS0FBSzNDLFdBSGY7QUFJRSxNQUFBLEtBQUssRUFBRyxzREFBcUR5QyxTQUFTLENBQUNsQyxPQUFRLFFBSmpGO0FBS0UsTUFBQSxTQUFTLEVBQUVxQyxJQUFJLENBQUNDLFFBQUwsQ0FBY0MsYUFBZCxDQUE0QkMsS0FBNUIsQ0FBa0NDLElBTC9DO0FBTUUsTUFBQSxTQUFTLEVBQUVKLElBQUksQ0FBQ0MsUUFBTCxDQUFjQyxhQUFkLENBQTRCQyxLQUE1QixDQUFrQ0U7QUFOL0MsTUFYRixDQUxKLENBREY7QUE2QkQ7O0FBak51RDs7OztnQkFBckNqRSxZLGVBQ0E7QUFDakJrRCxFQUFBQSxhQUFhLEVBQUVnQiwyQkFBZUMsVUFEYjtBQUVqQnZELEVBQUFBLGFBQWEsRUFBRXdELDJCQUFlRCxVQUZiO0FBR2pCN0QsRUFBQUEsU0FBUyxFQUFFK0QsbUJBQVVDLElBSEo7QUFJakJuQixFQUFBQSxVQUFVLEVBQUVrQixtQkFBVUMsSUFKTDtBQUtqQmxCLEVBQUFBLFNBQVMsRUFBRWlCLG1CQUFVQyxJQUxKO0FBTWpCakIsRUFBQUEsU0FBUyxFQUFFZ0IsbUJBQVVDLElBTko7QUFPakJwQyxFQUFBQSxXQUFXLEVBQUVtQyxtQkFBVUUsTUFQTjtBQVFqQnhDLEVBQUFBLFVBQVUsRUFBRXNDLG1CQUFVRSxNQVJMO0FBU2pCaEUsRUFBQUEsSUFBSSxFQUFFOEQsbUJBQVVHLElBQVYsQ0FBZUwsVUFUSjtBQVVqQnJELEVBQUFBLElBQUksRUFBRXVELG1CQUFVRyxJQUFWLENBQWVMLFVBVko7QUFXakJwRCxFQUFBQSxLQUFLLEVBQUVzRCxtQkFBVUcsSUFBVixDQUFlTCxVQVhMO0FBWWpCWixFQUFBQSxZQUFZLEVBQUVjLG1CQUFVQyxJQVpQO0FBYWpCWCxFQUFBQSxjQUFjLEVBQUVVLG1CQUFVSSxNQUFWLENBQWlCTjtBQWJoQixDOztnQkFEQW5FLFksa0JBaUJHO0FBQ3BCTSxFQUFBQSxTQUFTLEVBQUUsS0FEUztBQUVwQjZDLEVBQUFBLFVBQVUsRUFBRSxLQUZRO0FBR3BCQyxFQUFBQSxTQUFTLEVBQUUsS0FIUztBQUlwQkMsRUFBQUEsU0FBUyxFQUFFLEtBSlM7QUFLcEJuQixFQUFBQSxXQUFXLEVBQUUsQ0FMTztBQU1wQkgsRUFBQUEsVUFBVSxFQUFFO0FBTlEsQyIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QsIHtGcmFnbWVudH0gZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCBjeCBmcm9tICdjbGFzc25hbWVzJztcblxuaW1wb3J0IHtSZW1vdGVQcm9wVHlwZSwgQnJhbmNoUHJvcFR5cGV9IGZyb20gJy4uL3Byb3AtdHlwZXMnO1xuaW1wb3J0IFRvb2x0aXAgZnJvbSAnLi4vYXRvbS90b29sdGlwJztcbmltcG9ydCBSZWZIb2xkZXIgZnJvbSAnLi4vbW9kZWxzL3JlZi1ob2xkZXInO1xuXG5mdW5jdGlvbiBnZXRJY29uQ2xhc3MoaWNvbiwgYW5pbWF0aW9uKSB7XG4gIHJldHVybiBjeChcbiAgICAnZ2l0aHViLVB1c2hQdWxsLWljb24nLFxuICAgICdpY29uJyxcbiAgICBgaWNvbi0ke2ljb259YCxcbiAgICB7W2BhbmltYXRlLSR7YW5pbWF0aW9ufWBdOiAhIWFuaW1hdGlvbn0sXG4gICk7XG59XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFB1c2hQdWxsVmlldyBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgY3VycmVudEJyYW5jaDogQnJhbmNoUHJvcFR5cGUuaXNSZXF1aXJlZCxcbiAgICBjdXJyZW50UmVtb3RlOiBSZW1vdGVQcm9wVHlwZS5pc1JlcXVpcmVkLFxuICAgIGlzU3luY2luZzogUHJvcFR5cGVzLmJvb2wsXG4gICAgaXNGZXRjaGluZzogUHJvcFR5cGVzLmJvb2wsXG4gICAgaXNQdWxsaW5nOiBQcm9wVHlwZXMuYm9vbCxcbiAgICBpc1B1c2hpbmc6IFByb3BUeXBlcy5ib29sLFxuICAgIGJlaGluZENvdW50OiBQcm9wVHlwZXMubnVtYmVyLFxuICAgIGFoZWFkQ291bnQ6IFByb3BUeXBlcy5udW1iZXIsXG4gICAgcHVzaDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICBwdWxsOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIGZldGNoOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIG9yaWdpbkV4aXN0czogUHJvcFR5cGVzLmJvb2wsXG4gICAgdG9vbHRpcE1hbmFnZXI6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgfVxuXG4gIHN0YXRpYyBkZWZhdWx0UHJvcHMgPSB7XG4gICAgaXNTeW5jaW5nOiBmYWxzZSxcbiAgICBpc0ZldGNoaW5nOiBmYWxzZSxcbiAgICBpc1B1bGxpbmc6IGZhbHNlLFxuICAgIGlzUHVzaGluZzogZmFsc2UsXG4gICAgYmVoaW5kQ291bnQ6IDAsXG4gICAgYWhlYWRDb3VudDogMCxcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuXG4gICAgdGhpcy5yZWZUaWxlTm9kZSA9IG5ldyBSZWZIb2xkZXIoKTtcbiAgfVxuXG4gIG9uQ2xpY2tQdXNoID0gY2xpY2tFdmVudCA9PiB7XG4gICAgaWYgKHRoaXMucHJvcHMuaXNTeW5jaW5nKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuICAgIHRoaXMucHJvcHMucHVzaCh7XG4gICAgICBmb3JjZTogY2xpY2tFdmVudC5tZXRhS2V5IHx8IGNsaWNrRXZlbnQuY3RybEtleSxcbiAgICAgIHNldFVwc3RyZWFtOiAhdGhpcy5wcm9wcy5jdXJyZW50UmVtb3RlLmlzUHJlc2VudCgpLFxuICAgIH0pO1xuICB9XG5cbiAgb25DbGlja1B1bGwgPSBjbGlja0V2ZW50ID0+IHtcbiAgICBpZiAodGhpcy5wcm9wcy5pc1N5bmNpbmcpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG4gICAgdGhpcy5wcm9wcy5wdWxsKCk7XG4gIH1cblxuICBvbkNsaWNrUHVzaFB1bGwgPSBjbGlja0V2ZW50ID0+IHtcbiAgICBpZiAodGhpcy5wcm9wcy5pc1N5bmNpbmcpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG4gICAgaWYgKGNsaWNrRXZlbnQubWV0YUtleSB8fCBjbGlja0V2ZW50LmN0cmxLZXkpIHtcbiAgICAgIHRoaXMucHJvcHMucHVzaCh7XG4gICAgICAgIGZvcmNlOiB0cnVlLFxuICAgICAgfSk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMucHJvcHMucHVsbCgpO1xuICAgIH1cbiAgfVxuXG4gIG9uQ2xpY2tQdWJsaXNoID0gY2xpY2tFdmVudCA9PiB7XG4gICAgaWYgKHRoaXMucHJvcHMuaXNTeW5jaW5nKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuICAgIHRoaXMucHJvcHMucHVzaCh7XG4gICAgICBzZXRVcHN0cmVhbTogIXRoaXMucHJvcHMuY3VycmVudFJlbW90ZS5pc1ByZXNlbnQoKSxcbiAgICB9KTtcbiAgfVxuXG4gIG9uQ2xpY2tGZXRjaCA9IGNsaWNrRXZlbnQgPT4ge1xuICAgIGlmICh0aGlzLnByb3BzLmlzU3luY2luZykge1xuICAgICAgcmV0dXJuO1xuICAgIH1cbiAgICB0aGlzLnByb3BzLmZldGNoKCk7XG4gIH1cblxuICBnZXRUaWxlU3RhdGVzKCkge1xuICAgIGNvbnN0IG1vZEtleSA9IHByb2Nlc3MucGxhdGZvcm0gPT09ICdkYXJ3aW4nID8gJ0NtZCcgOiAnQ3RybCc7XG4gICAgcmV0dXJuIHtcbiAgICAgIGZldGNoaW5nOiB7XG4gICAgICAgIHRvb2x0aXA6ICdGZXRjaGluZyBmcm9tIHJlbW90ZScsXG4gICAgICAgIGljb246ICdzeW5jJyxcbiAgICAgICAgdGV4dDogJ0ZldGNoaW5nJyxcbiAgICAgICAgaWNvbkFuaW1hdGlvbjogJ3JvdGF0ZScsXG4gICAgICB9LFxuICAgICAgcHVsbGluZzoge1xuICAgICAgICB0b29sdGlwOiAnUHVsbGluZyBmcm9tIHJlbW90ZScsXG4gICAgICAgIGljb246ICdhcnJvdy1kb3duJyxcbiAgICAgICAgdGV4dDogJ1B1bGxpbmcnLFxuICAgICAgICBpY29uQW5pbWF0aW9uOiAnZG93bicsXG4gICAgICB9LFxuICAgICAgcHVzaGluZzoge1xuICAgICAgICB0b29sdGlwOiAnUHVzaGluZyB0byByZW1vdGUnLFxuICAgICAgICBpY29uOiAnYXJyb3ctdXAnLFxuICAgICAgICB0ZXh0OiAnUHVzaGluZycsXG4gICAgICAgIGljb25BbmltYXRpb246ICd1cCcsXG4gICAgICB9LFxuICAgICAgYWhlYWQ6IHtcbiAgICAgICAgb25DbGljazogdGhpcy5vbkNsaWNrUHVzaCxcbiAgICAgICAgdG9vbHRpcDogYENsaWNrIHRvIHB1c2g8YnIgLz4ke21vZEtleX0tY2xpY2sgdG8gZm9yY2UgcHVzaDxiciAvPlJpZ2h0LWNsaWNrIGZvciBtb3JlYCxcbiAgICAgICAgaWNvbjogJ2Fycm93LXVwJyxcbiAgICAgICAgdGV4dDogYFB1c2ggJHt0aGlzLnByb3BzLmFoZWFkQ291bnR9YCxcbiAgICAgIH0sXG4gICAgICBiZWhpbmQ6IHtcbiAgICAgICAgb25DbGljazogdGhpcy5vbkNsaWNrUHVsbCxcbiAgICAgICAgdG9vbHRpcDogJ0NsaWNrIHRvIHB1bGw8YnIgLz5SaWdodC1jbGljayBmb3IgbW9yZScsXG4gICAgICAgIGljb246ICdhcnJvdy1kb3duJyxcbiAgICAgICAgdGV4dDogYFB1bGwgJHt0aGlzLnByb3BzLmJlaGluZENvdW50fWAsXG4gICAgICB9LFxuICAgICAgYWhlYWRCZWhpbmQ6IHtcbiAgICAgICAgb25DbGljazogdGhpcy5vbkNsaWNrUHVzaFB1bGwsXG4gICAgICAgIHRvb2x0aXA6IGBDbGljayB0byBwdWxsPGJyIC8+JHttb2RLZXl9LWNsaWNrIHRvIGZvcmNlIHB1c2g8YnIgLz5SaWdodC1jbGljayBmb3IgbW9yZWAsXG4gICAgICAgIGljb246ICdhcnJvdy1kb3duJyxcbiAgICAgICAgdGV4dDogYFB1bGwgJHt0aGlzLnByb3BzLmJlaGluZENvdW50fWAsXG4gICAgICAgIHNlY29uZGFyeUljb246ICdhcnJvdy11cCcsXG4gICAgICAgIHNlY29uZGFyeVRleHQ6IGAke3RoaXMucHJvcHMuYWhlYWRDb3VudH0gYCxcbiAgICAgIH0sXG4gICAgICBwdWJsaXNoZWQ6IHtcbiAgICAgICAgb25DbGljazogdGhpcy5vbkNsaWNrRmV0Y2gsXG4gICAgICAgIHRvb2x0aXA6ICdDbGljayB0byBmZXRjaDxiciAvPlJpZ2h0LWNsaWNrIGZvciBtb3JlJyxcbiAgICAgICAgaWNvbjogJ3N5bmMnLFxuICAgICAgICB0ZXh0OiAnRmV0Y2gnLFxuICAgICAgfSxcbiAgICAgIHVucHVibGlzaGVkOiB7XG4gICAgICAgIG9uQ2xpY2s6IHRoaXMub25DbGlja1B1Ymxpc2gsXG4gICAgICAgIHRvb2x0aXA6ICdDbGljayB0byBzZXQgdXAgYSByZW1vdGUgdHJhY2tpbmcgYnJhbmNoPGJyIC8+UmlnaHQtY2xpY2sgZm9yIG1vcmUnLFxuICAgICAgICBpY29uOiAnY2xvdWQtdXBsb2FkJyxcbiAgICAgICAgdGV4dDogJ1B1Ymxpc2gnLFxuICAgICAgfSxcbiAgICAgIG5vUmVtb3RlOiB7XG4gICAgICAgIHRvb2x0aXA6ICdUaGVyZSBpcyBubyByZW1vdGUgbmFtZWQgXCJvcmlnaW5cIicsXG4gICAgICAgIGljb246ICdzdG9wJyxcbiAgICAgICAgdGV4dDogJ05vIHJlbW90ZScsXG4gICAgICB9LFxuICAgICAgZGV0YWNoZWQ6IHtcbiAgICAgICAgdG9vbHRpcDogJ0NyZWF0ZSBhIGJyYW5jaCBpZiB5b3Ugd2lzaCB0byBwdXNoIHlvdXIgd29yayBhbnl3aGVyZScsXG4gICAgICAgIGljb246ICdzdG9wJyxcbiAgICAgICAgdGV4dDogJ05vdCBvbiBicmFuY2gnLFxuICAgICAgfSxcbiAgICB9O1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIGNvbnN0IGlzQWhlYWQgPSB0aGlzLnByb3BzLmFoZWFkQ291bnQgPiAwO1xuICAgIGNvbnN0IGlzQmVoaW5kID0gdGhpcy5wcm9wcy5iZWhpbmRDb3VudCA+IDA7XG4gICAgY29uc3QgaXNVbnB1Ymxpc2hlZCA9ICF0aGlzLnByb3BzLmN1cnJlbnRSZW1vdGUuaXNQcmVzZW50KCk7XG4gICAgY29uc3QgaXNEZXRhY2hlZCA9IHRoaXMucHJvcHMuY3VycmVudEJyYW5jaC5pc0RldGFjaGVkKCk7XG4gICAgY29uc3QgaXNGZXRjaGluZyA9IHRoaXMucHJvcHMuaXNGZXRjaGluZztcbiAgICBjb25zdCBpc1B1bGxpbmcgPSB0aGlzLnByb3BzLmlzUHVsbGluZztcbiAgICBjb25zdCBpc1B1c2hpbmcgPSB0aGlzLnByb3BzLmlzUHVzaGluZztcbiAgICBjb25zdCBoYXNPcmlnaW4gPSAhIXRoaXMucHJvcHMub3JpZ2luRXhpc3RzO1xuXG4gICAgY29uc3QgdGlsZVN0YXRlcyA9IHRoaXMuZ2V0VGlsZVN0YXRlcygpO1xuXG4gICAgbGV0IHRpbGVTdGF0ZTtcblxuICAgIGlmIChpc0ZldGNoaW5nKSB7XG4gICAgICB0aWxlU3RhdGUgPSB0aWxlU3RhdGVzLmZldGNoaW5nO1xuICAgIH0gZWxzZSBpZiAoaXNQdWxsaW5nKSB7XG4gICAgICB0aWxlU3RhdGUgPSB0aWxlU3RhdGVzLnB1bGxpbmc7XG4gICAgfSBlbHNlIGlmIChpc1B1c2hpbmcpIHtcbiAgICAgIHRpbGVTdGF0ZSA9IHRpbGVTdGF0ZXMucHVzaGluZztcbiAgICB9IGVsc2UgaWYgKGlzQWhlYWQgJiYgIWlzQmVoaW5kICYmICFpc1VucHVibGlzaGVkKSB7XG4gICAgICB0aWxlU3RhdGUgPSB0aWxlU3RhdGVzLmFoZWFkO1xuICAgIH0gZWxzZSBpZiAoaXNCZWhpbmQgJiYgIWlzQWhlYWQgJiYgIWlzVW5wdWJsaXNoZWQpIHtcbiAgICAgIHRpbGVTdGF0ZSA9IHRpbGVTdGF0ZXMuYmVoaW5kO1xuICAgIH0gZWxzZSBpZiAoaXNCZWhpbmQgJiYgaXNBaGVhZCAmJiAhaXNVbnB1Ymxpc2hlZCkge1xuICAgICAgdGlsZVN0YXRlID0gdGlsZVN0YXRlcy5haGVhZEJlaGluZDtcbiAgICB9IGVsc2UgaWYgKCFpc0JlaGluZCAmJiAhaXNBaGVhZCAmJiAhaXNVbnB1Ymxpc2hlZCAmJiAhaXNEZXRhY2hlZCkge1xuICAgICAgdGlsZVN0YXRlID0gdGlsZVN0YXRlcy5wdWJsaXNoZWQ7XG4gICAgfSBlbHNlIGlmIChpc1VucHVibGlzaGVkICYmICFpc0RldGFjaGVkICYmIGhhc09yaWdpbikge1xuICAgICAgdGlsZVN0YXRlID0gdGlsZVN0YXRlcy51bnB1Ymxpc2hlZDtcbiAgICB9IGVsc2UgaWYgKGlzVW5wdWJsaXNoZWQgJiYgIWlzRGV0YWNoZWQgJiYgIWhhc09yaWdpbikge1xuICAgICAgdGlsZVN0YXRlID0gdGlsZVN0YXRlcy5ub1JlbW90ZTtcbiAgICB9IGVsc2UgaWYgKGlzRGV0YWNoZWQpIHtcbiAgICAgIHRpbGVTdGF0ZSA9IHRpbGVTdGF0ZXMuZGV0YWNoZWQ7XG4gICAgfVxuXG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXZcbiAgICAgICAgb25DbGljaz17dGlsZVN0YXRlLm9uQ2xpY2t9XG4gICAgICAgIHJlZj17dGhpcy5yZWZUaWxlTm9kZS5zZXR0ZXJ9XG4gICAgICAgIGNsYXNzTmFtZT17Y3goJ2dpdGh1Yi1QdXNoUHVsbCcsICdpbmxpbmUtYmxvY2snLCB7J2dpdGh1Yi1icmFuY2gtZGV0YWNoZWQnOiBpc0RldGFjaGVkfSl9PlxuICAgICAgICB7dGlsZVN0YXRlICYmIChcbiAgICAgICAgICA8RnJhZ21lbnQ+XG4gICAgICAgICAgICA8c3Bhbj5cbiAgICAgICAgICAgICAge3RpbGVTdGF0ZS5zZWNvbmRhcnlUZXh0ICYmIChcbiAgICAgICAgICAgICAgICA8c3BhbiBjbGFzc05hbWU9XCJzZWNvbmRhcnlcIj5cbiAgICAgICAgICAgICAgICAgIDxzcGFuIGNsYXNzTmFtZT17Z2V0SWNvbkNsYXNzKHRpbGVTdGF0ZS5zZWNvbmRhcnlJY29uKX0gLz5cbiAgICAgICAgICAgICAgICAgIHt0aWxlU3RhdGUuc2Vjb25kYXJ5VGV4dH1cbiAgICAgICAgICAgICAgICA8L3NwYW4+XG4gICAgICAgICAgICAgICl9XG4gICAgICAgICAgICAgIDxzcGFuIGNsYXNzTmFtZT17Z2V0SWNvbkNsYXNzKHRpbGVTdGF0ZS5pY29uLCB0aWxlU3RhdGUuaWNvbkFuaW1hdGlvbil9IC8+XG4gICAgICAgICAgICAgIHt0aWxlU3RhdGUudGV4dH1cbiAgICAgICAgICAgIDwvc3Bhbj5cbiAgICAgICAgICAgIDxUb29sdGlwXG4gICAgICAgICAgICAgIGtleT1cInRvb2x0aXBcIlxuICAgICAgICAgICAgICBtYW5hZ2VyPXt0aGlzLnByb3BzLnRvb2x0aXBNYW5hZ2VyfVxuICAgICAgICAgICAgICB0YXJnZXQ9e3RoaXMucmVmVGlsZU5vZGV9XG4gICAgICAgICAgICAgIHRpdGxlPXtgPGRpdiBzdHlsZT1cInRleHQtYWxpZ246IGxlZnQ7IGxpbmUtaGVpZ2h0OiAxLjJlbTtcIj4ke3RpbGVTdGF0ZS50b29sdGlwfTwvZGl2PmB9XG4gICAgICAgICAgICAgIHNob3dEZWxheT17YXRvbS50b29sdGlwcy5ob3ZlckRlZmF1bHRzLmRlbGF5LnNob3d9XG4gICAgICAgICAgICAgIGhpZGVEZWxheT17YXRvbS50b29sdGlwcy5ob3ZlckRlZmF1bHRzLmRlbGF5LmhpZGV9XG4gICAgICAgICAgICAvPlxuICAgICAgICAgIDwvRnJhZ21lbnQ+XG4gICAgICAgICl9XG4gICAgICA8L2Rpdj5cbiAgICApO1xuICB9XG59XG4iXX0=