"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class QueryErrorTile extends _react.default.Component {
  componentDidMount() {
    // eslint-disable-next-line no-console
    console.error('Error encountered in subquery', this.props.error);
  }

  render() {
    return _react.default.createElement("div", {
      className: "github-QueryErrorTile"
    }, _react.default.createElement("div", {
      className: "github-QueryErrorTile-messages"
    }, this.renderMessages()));
  }

  renderMessages() {
    if (this.props.error.errors) {
      return this.props.error.errors.map((error, index) => {
        return this.renderMessage(error.message, index, 'alert');
      });
    }

    if (this.props.error.response) {
      return this.renderMessage(this.props.error.responseText, '0', 'alert');
    }

    if (this.props.error.network) {
      return this.renderMessage('Offline', '0', 'alignment-unalign');
    }

    return this.renderMessage(this.props.error.toString(), '0', 'alert');
  }

  renderMessage(body, key, icon) {
    return _react.default.createElement("p", {
      key: key,
      className: "github-QueryErrorTile-message"
    }, _react.default.createElement(_octicon.default, {
      icon: icon
    }), body);
  }

}

exports.default = QueryErrorTile;

_defineProperty(QueryErrorTile, "propTypes", {
  error: _propTypes.default.shape({
    response: _propTypes.default.shape({
      status: _propTypes.default.number.isRequired
    }),
    responseText: _propTypes.default.string,
    network: _propTypes.default.bool,
    errors: _propTypes.default.arrayOf(_propTypes.default.shape({
      message: _propTypes.default.string.isRequired
    }))
  }).isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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