"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _tabbable = require("./tabbable");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RemoteConfigurationView extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "handleProtocolChange", event => {
      this.props.didChangeProtocol(event.target.value);
    });
  }

  render() {
    const httpsClassName = (0, _classnames.default)('github-RemoteConfiguration-protocolOption', 'github-RemoteConfiguration-protocolOption--https', 'input-label');
    const sshClassName = (0, _classnames.default)('github-RemoteConfiguration-protocolOption', 'github-RemoteConfiguration-protocolOption--ssh', 'input-label');
    return _react.default.createElement("details", {
      className: "github-RemoteConfiguration-details block"
    }, _react.default.createElement(_tabbable.TabbableSummary, {
      tabGroup: this.props.tabGroup,
      commands: this.props.commands
    }, "Advanced"), _react.default.createElement("main", null, _react.default.createElement("div", {
      className: "github-RemoteConfiguration-protocol block"
    }, _react.default.createElement("span", {
      className: "github-RemoteConfiguration-protocolHeading"
    }, "Protocol:"), _react.default.createElement("label", {
      className: httpsClassName
    }, _react.default.createElement(_tabbable.TabbableInput, {
      tabGroup: this.props.tabGroup,
      commands: this.props.commands,
      className: "input-radio",
      type: "radio",
      name: "protocol",
      value: "https",
      checked: this.props.currentProtocol === 'https',
      onChange: this.handleProtocolChange
    }), "HTTPS"), _react.default.createElement("label", {
      className: sshClassName
    }, _react.default.createElement(_tabbable.TabbableInput, {
      tabGroup: this.props.tabGroup,
      commands: this.props.commands,
      className: "input-radio",
      type: "radio",
      name: "protocol",
      value: "ssh",
      checked: this.props.currentProtocol === 'ssh',
      onChange: this.handleProtocolChange
    }), "SSH")), _react.default.createElement("div", {
      className: "github-RemoteConfiguration-sourceRemote block"
    }, _react.default.createElement("label", {
      className: "input-label"
    }, "Source remote name:", _react.default.createElement(_tabbable.TabbableTextEditor, {
      tabGroup: this.props.tabGroup,
      commands: this.props.commands,
      className: "github-RemoteConfiguration-sourceRemoteName",
      mini: true,
      autoWidth: false,
      buffer: this.props.sourceRemoteBuffer
    })))));
  }

}

exports.default = RemoteConfigurationView;

_defineProperty(RemoteConfigurationView, "propTypes", {
  tabGroup: _propTypes.default.object.isRequired,
  currentProtocol: _propTypes.default.oneOf(['https', 'ssh']),
  sourceRemoteBuffer: _propTypes.default.object.isRequired,
  didChangeProtocol: _propTypes.default.func.isRequired,
  // Atom environment
  commands: _propTypes.default.object.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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