"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RemoteSelectorView extends _react.default.Component {
  render() {
    const {
      remotes,
      currentBranch,
      selectRemote
    } = this.props; // todo: ask Ash how to test this before merging.

    return _react.default.createElement("div", {
      className: "github-RemoteSelector"
    }, _react.default.createElement("div", {
      className: "github-GitHub-LargeIcon icon icon-mirror"
    }), _react.default.createElement("h1", null, "Select a Remote"), _react.default.createElement("div", {
      className: "initialize-repo-description"
    }, _react.default.createElement("span", null, "This repository has multiple remotes hosted at GitHub.com. Select a remote to see pull requests associated with the ", _react.default.createElement("strong", null, currentBranch.getName()), " branch:")), _react.default.createElement("ul", null, Array.from(remotes, remote => _react.default.createElement("li", {
      key: remote.getName()
    }, _react.default.createElement("button", {
      className: "btn btn-primary",
      onClick: e => selectRemote(e, remote)
    }, remote.getName(), " (", remote.getOwner(), "/", remote.getRepo(), ")")))));
  }

}

exports.default = RemoteSelectorView;

_defineProperty(RemoteSelectorView, "propTypes", {
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  currentBranch: _propTypes2.BranchPropType.isRequired,
  selectRemote: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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