"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareRepositoryHomeSelectionView = exports.PAGE_SIZE = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _tabbable = require("./tabbable");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _objectSpread2(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const PAGE_DELAY = 500;
const PAGE_SIZE = 50;
exports.PAGE_SIZE = PAGE_SIZE;

class BareRepositoryHomeSelectionView extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderOwner", owner => _react.default.createElement(_react.Fragment, null, _react.default.createElement("div", {
      className: "github-RepositoryHome-ownerOption"
    }, _react.default.createElement("img", {
      alt: "",
      src: owner.avatarURL,
      className: "github-RepositoryHome-ownerAvatar"
    }), _react.default.createElement("span", {
      className: "github-RepositoryHome-ownerName"
    }, owner.login)), owner.disabled && !owner.placeholder && _react.default.createElement("div", {
      className: "github-RepositoryHome-ownerUnwritable"
    }, "(insufficient permissions)")));

    _defineProperty(this, "didChangeOwner", owner => this.props.didChangeOwnerID(owner.id));

    _defineProperty(this, "loadNextPage", () => {
      /* istanbul ignore if */
      if (this.props.relay.isLoading()) {
        setTimeout(this.loadNextPage, PAGE_DELAY);
        return;
      }

      this.props.relay.loadMore(PAGE_SIZE);
    });
  }

  render() {
    const owners = this.getOwners();
    const currentOwner = owners.find(o => o.id === this.props.selectedOwnerID) || owners[0];
    return _react.default.createElement("div", {
      className: "github-RepositoryHome"
    }, _react.default.createElement(_tabbable.TabbableSelect, {
      tabGroup: this.props.tabGroup,
      commands: this.props.commands,
      autofocus: this.props.autofocusOwner,
      className: "github-RepositoryHome-owner",
      clearable: false,
      disabled: this.props.isLoading,
      options: owners,
      optionRenderer: this.renderOwner,
      value: currentOwner,
      valueRenderer: this.renderOwner,
      onChange: this.didChangeOwner
    }), _react.default.createElement("span", {
      className: "github-RepositoryHome-separator"
    }, "/"), _react.default.createElement(_tabbable.TabbableTextEditor, {
      tabGroup: this.props.tabGroup,
      commands: this.props.commands,
      autofocus: this.props.autofocusName,
      mini: true,
      buffer: this.props.nameBuffer
    }));
  }

  componentDidMount() {
    this.schedulePageLoad();
  }

  componentDidUpdate() {
    this.schedulePageLoad();
  }

  getOwners() {
    if (!this.props.user) {
      return [{
        id: 'loading',
        login: 'loading...',
        avatarURL: '',
        disabled: true,
        placeholder: true
      }];
    }

    const owners = [{
      id: this.props.user.id,
      login: this.props.user.login,
      avatarURL: this.props.user.avatarUrl,
      disabled: false
    }];
    /* istanbul ignore if */

    if (!this.props.user.organizations.edges) {
      return owners;
    }

    for (const {
      node
    } of this.props.user.organizations.edges) {
      /* istanbul ignore if */
      if (!node) {
        continue;
      }

      owners.push({
        id: node.id,
        login: node.login,
        avatarURL: node.avatarUrl,
        disabled: !node.viewerCanCreateRepositories
      });
    }

    if (this.props.relay && this.props.relay.hasMore()) {
      owners.push({
        id: 'loading',
        login: 'loading...',
        avatarURL: '',
        disabled: true,
        placeholder: true
      });
    }

    return owners;
  }

  schedulePageLoad() {
    if (!this.props.relay.hasMore()) {
      return;
    }

    setTimeout(this.loadNextPage, PAGE_DELAY);
  }

}

exports.BareRepositoryHomeSelectionView = BareRepositoryHomeSelectionView;

_defineProperty(BareRepositoryHomeSelectionView, "propTypes", {
  // Relay
  relay: _propTypes.default.shape({
    hasMore: _propTypes.default.func.isRequired,
    isLoading: _propTypes.default.func.isRequired,
    loadMore: _propTypes.default.func.isRequired
  }).isRequired,
  user: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    login: _propTypes.default.string.isRequired,
    avatarUrl: _propTypes.default.string.isRequired,
    organizations: _propTypes.default.shape({
      edges: _propTypes.default.arrayOf(_propTypes.default.shape({
        node: _propTypes.default.shape({
          id: _propTypes.default.string.isRequired,
          login: _propTypes.default.string.isRequired,
          avatarUrl: _propTypes.default.string.isRequired,
          viewerCanCreateRepositories: _propTypes.default.bool.isRequired
        })
      }))
    }).isRequired
  }),
  // Model
  nameBuffer: _propTypes.default.object.isRequired,
  isLoading: _propTypes.default.bool.isRequired,
  selectedOwnerID: _propTypes.default.string.isRequired,
  tabGroup: _propTypes.default.object.isRequired,
  autofocusOwner: _propTypes.default.bool,
  autofocusName: _propTypes.default.bool,
  // Selection callback
  didChangeOwnerID: _propTypes.default.func.isRequired,
  // Atom environment
  commands: _propTypes.default.object.isRequired
});

_defineProperty(BareRepositoryHomeSelectionView, "defaultProps", {
  autofocusOwner: false,
  autofocusName: false
});

var _default = (0, _reactRelay.createPaginationContainer)(BareRepositoryHomeSelectionView, {
  user: function () {
    const node = require("./__generated__/repositoryHomeSelectionView_user.graphql");

    if (node.hash && node.hash !== "11a1f1d0eac32bff0a3371217c0eede3") {
      console.error("The definition of 'repositoryHomeSelectionView_user' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/repositoryHomeSelectionView_user.graphql");
  }
}, {
  direction: 'forward',

  /* istanbul ignore next */
  getConnectionFromProps(props) {
    return props.user && props.user.organizations;
  },

  /* istanbul ignore next */
  getFragmentVariables(prevVars, totalCount) {
    return _objectSpread2({}, prevVars, {
      totalCount
    });
  },

  /* istanbul ignore next */
  getVariables(props, {
    count,
    cursor
  }) {
    return {
      id: props.user.id,
      organizationCount: count,
      organizationCursor: cursor
    };
  },

  query: function () {
    const node = require("./__generated__/repositoryHomeSelectionViewQuery.graphql");

    if (node.hash && node.hash !== "67e7843e3ff792e86e979cc948929ea3") {
      console.error("The definition of 'repositoryHomeSelectionViewQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/repositoryHomeSelectionViewQuery.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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