"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _donutChart = _interopRequireDefault(require("./donut-chart"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class StatusDonutChart extends _react.default.Component {
  render() {
    const slices = ['pending', 'failure', 'success'].reduce((acc, type) => {
      const count = this.props[type];

      if (count > 0) {
        acc.push({
          type,
          className: type,
          count
        });
      }

      return acc;
    }, []);
    return _react.default.createElement(_donutChart.default, _extends({}, (0, _helpers.unusedProps)(this.props, this.constructor.propTypes), {
      slices: slices
    }));
  }

}

exports.default = StatusDonutChart;

_defineProperty(StatusDonutChart, "propTypes", {
  pending: _propTypes.default.number,
  failure: _propTypes.default.number,
  success: _propTypes.default.number
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInN0YXR1cy1kb251dC1jaGFydC5qcyJdLCJuYW1lcyI6WyJTdGF0dXNEb251dENoYXJ0IiwiUmVhY3QiLCJDb21wb25lbnQiLCJyZW5kZXIiLCJzbGljZXMiLCJyZWR1Y2UiLCJhY2MiLCJ0eXBlIiwiY291bnQiLCJwcm9wcyIsInB1c2giLCJjbGFzc05hbWUiLCJjb25zdHJ1Y3RvciIsInByb3BUeXBlcyIsInBlbmRpbmciLCJQcm9wVHlwZXMiLCJudW1iZXIiLCJmYWlsdXJlIiwic3VjY2VzcyJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOztBQUNBOztBQUNBOztBQUVBOzs7Ozs7OztBQUVlLE1BQU1BLGdCQUFOLFNBQStCQyxlQUFNQyxTQUFyQyxDQUErQztBQU81REMsRUFBQUEsTUFBTSxHQUFHO0FBQ1AsVUFBTUMsTUFBTSxHQUFHLENBQUMsU0FBRCxFQUFZLFNBQVosRUFBdUIsU0FBdkIsRUFBa0NDLE1BQWxDLENBQXlDLENBQUNDLEdBQUQsRUFBTUMsSUFBTixLQUFlO0FBQ3JFLFlBQU1DLEtBQUssR0FBRyxLQUFLQyxLQUFMLENBQVdGLElBQVgsQ0FBZDs7QUFDQSxVQUFJQyxLQUFLLEdBQUcsQ0FBWixFQUFlO0FBQ2JGLFFBQUFBLEdBQUcsQ0FBQ0ksSUFBSixDQUFTO0FBQUNILFVBQUFBLElBQUQ7QUFBT0ksVUFBQUEsU0FBUyxFQUFFSixJQUFsQjtBQUF3QkMsVUFBQUE7QUFBeEIsU0FBVDtBQUNEOztBQUNELGFBQU9GLEdBQVA7QUFDRCxLQU5jLEVBTVosRUFOWSxDQUFmO0FBUUEsV0FBTyw2QkFBQyxtQkFBRCxlQUFnQiwwQkFBWSxLQUFLRyxLQUFqQixFQUF3QixLQUFLRyxXQUFMLENBQWlCQyxTQUF6QyxDQUFoQjtBQUFxRSxNQUFBLE1BQU0sRUFBRVQ7QUFBN0UsT0FBUDtBQUNEOztBQWpCMkQ7Ozs7Z0JBQXpDSixnQixlQUNBO0FBQ2pCYyxFQUFBQSxPQUFPLEVBQUVDLG1CQUFVQyxNQURGO0FBRWpCQyxFQUFBQSxPQUFPLEVBQUVGLG1CQUFVQyxNQUZGO0FBR2pCRSxFQUFBQSxPQUFPLEVBQUVILG1CQUFVQztBQUhGLEMiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQgRG9udXRDaGFydCBmcm9tICcuL2RvbnV0LWNoYXJ0JztcblxuaW1wb3J0IHt1bnVzZWRQcm9wc30gZnJvbSAnLi4vaGVscGVycyc7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFN0YXR1c0RvbnV0Q2hhcnQgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIHBlbmRpbmc6IFByb3BUeXBlcy5udW1iZXIsXG4gICAgZmFpbHVyZTogUHJvcFR5cGVzLm51bWJlcixcbiAgICBzdWNjZXNzOiBQcm9wVHlwZXMubnVtYmVyLFxuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIGNvbnN0IHNsaWNlcyA9IFsncGVuZGluZycsICdmYWlsdXJlJywgJ3N1Y2Nlc3MnXS5yZWR1Y2UoKGFjYywgdHlwZSkgPT4ge1xuICAgICAgY29uc3QgY291bnQgPSB0aGlzLnByb3BzW3R5cGVdO1xuICAgICAgaWYgKGNvdW50ID4gMCkge1xuICAgICAgICBhY2MucHVzaCh7dHlwZSwgY2xhc3NOYW1lOiB0eXBlLCBjb3VudH0pO1xuICAgICAgfVxuICAgICAgcmV0dXJuIGFjYztcbiAgICB9LCBbXSk7XG5cbiAgICByZXR1cm4gPERvbnV0Q2hhcnQgey4uLnVudXNlZFByb3BzKHRoaXMucHJvcHMsIHRoaXMuY29uc3RydWN0b3IucHJvcFR5cGVzKX0gc2xpY2VzPXtzbGljZXN9IC8+O1xuICB9XG59XG4iXX0=