"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.makeTabbable = makeTabbable;
exports.TabbableSelect = exports.TabbableTextEditor = exports.TabbableSummary = exports.TabbableButton = exports.TabbableInput = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactSelect = _interopRequireDefault(require("react-select"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _atomTextEditor = _interopRequireDefault(require("../atom/atom-text-editor"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function makeTabbable(Component, options = {}) {
  var _class, _temp;

  return _temp = _class = class extends _react.default.Component {
    constructor(props) {
      super(props);

      _defineProperty(this, "focusNext", e => {
        this.elementRef.map(element => this.props.tabGroup.focusAfter(element));
        e.stopPropagation();
      });

      _defineProperty(this, "focusPrevious", e => {
        this.elementRef.map(element => this.props.tabGroup.focusBefore(element));
        e.stopPropagation();
      });

      this.rootRef = new _refHolder.default();
      this.elementRef = new _refHolder.default();

      if (options.rootRefProp) {
        this.rootRef = new _refHolder.default();
        this.rootRefProps = {
          [options.rootRefProp]: this.rootRef
        };
      } else {
        this.rootRef = this.elementRef;
        this.rootRefProps = {};
      }

      if (options.passCommands) {
        this.commandProps = {
          commands: this.props.commands
        };
      } else {
        this.commandProps = {};
      }
    }

    render() {
      return _react.default.createElement(_react.Fragment, null, _react.default.createElement(_commands.default, {
        registry: this.props.commands,
        target: this.rootRef
      }, _react.default.createElement(_commands.Command, {
        command: "core:focus-next",
        callback: this.focusNext
      }), _react.default.createElement(_commands.Command, {
        command: "core:focus-previous",
        callback: this.focusPrevious
      })), _react.default.createElement(Component, _extends({
        ref: this.elementRef.setter,
        tabIndex: -1
      }, (0, _helpers.unusedProps)(this.props, this.constructor.propTypes), this.rootRefProps, this.commandProps)));
    }

    componentDidMount() {
      this.elementRef.map(element => this.props.tabGroup.appendElement(element, this.props.autofocus));
    }

    componentWillUnmount() {
      this.elementRef.map(element => this.props.tabGroup.removeElement(element));
    }

  }, _defineProperty(_class, "propTypes", {
    tabGroup: _propTypes.default.shape({
      appendElement: _propTypes.default.func.isRequired,
      removeElement: _propTypes.default.func.isRequired,
      focusAfter: _propTypes.default.func.isRequired,
      focusBefore: _propTypes.default.func.isRequired
    }).isRequired,
    autofocus: _propTypes.default.bool,
    commands: _propTypes.default.object.isRequired
  }), _defineProperty(_class, "defaultProps", {
    autofocus: false
  }), _temp;
}

const TabbableInput = makeTabbable('input');
exports.TabbableInput = TabbableInput;
const TabbableButton = makeTabbable('button');
exports.TabbableButton = TabbableButton;
const TabbableSummary = makeTabbable('summary');
exports.TabbableSummary = TabbableSummary;
const TabbableTextEditor = makeTabbable(_atomTextEditor.default, {
  rootRefProp: 'refElement'
}); // CustomEvent is a DOM primitive, which v8 can't access
// so we're essentially lazy loading to keep snapshotting from breaking.

exports.TabbableTextEditor = TabbableTextEditor;
let FakeKeyDownEvent;

class WrapSelect extends _react.default.Component {
  constructor(props) {
    super(props);
    this.refSelect = new _refHolder.default();
  }

  render() {
    return _react.default.createElement("div", {
      className: "github-TabbableWrapper",
      ref: this.props.refElement.setter
    }, _react.default.createElement(_commands.default, {
      registry: this.props.commands,
      target: this.props.refElement
    }, _react.default.createElement(_commands.Command, {
      command: "github:selectbox-down",
      callback: this.proxyKeyCode(40)
    }), _react.default.createElement(_commands.Command, {
      command: "github:selectbox-up",
      callback: this.proxyKeyCode(38)
    }), _react.default.createElement(_commands.Command, {
      command: "github:selectbox-enter",
      callback: this.proxyKeyCode(13)
    }), _react.default.createElement(_commands.Command, {
      command: "github:selectbox-tab",
      callback: this.proxyKeyCode(9)
    }), _react.default.createElement(_commands.Command, {
      command: "github:selectbox-backspace",
      callback: this.proxyKeyCode(8)
    }), _react.default.createElement(_commands.Command, {
      command: "github:selectbox-pageup",
      callback: this.proxyKeyCode(33)
    }), _react.default.createElement(_commands.Command, {
      command: "github:selectbox-pagedown",
      callback: this.proxyKeyCode(34)
    }), _react.default.createElement(_commands.Command, {
      command: "github:selectbox-end",
      callback: this.proxyKeyCode(35)
    }), _react.default.createElement(_commands.Command, {
      command: "github:selectbox-home",
      callback: this.proxyKeyCode(36)
    }), _react.default.createElement(_commands.Command, {
      command: "github:selectbox-delete",
      callback: this.proxyKeyCode(46)
    }), _react.default.createElement(_commands.Command, {
      command: "github:selectbox-escape",
      callback: this.proxyKeyCode(27)
    })), _react.default.createElement(_reactSelect.default, _extends({
      ref: this.refSelect.setter
    }, (0, _helpers.unusedProps)(this.props, this.constructor.propTypes))));
  }

  focus() {
    return this.refSelect.map(select => select.focus());
  }

  proxyKeyCode(keyCode) {
    return e => this.refSelect.map(select => {
      if (!FakeKeyDownEvent) {
        FakeKeyDownEvent = class extends CustomEvent {
          constructor(kCode) {
            super('keydown');
            this.keyCode = kCode;
          }

        };
      }

      const fakeEvent = new FakeKeyDownEvent(keyCode);
      select.handleKeyDown(fakeEvent);
      return null;
    });
  }

}

_defineProperty(WrapSelect, "propTypes", {
  refElement: _propTypes2.RefHolderPropType.isRequired,
  commands: _propTypes.default.object.isRequired
});

const TabbableSelect = makeTabbable(WrapSelect, {
  rootRefProp: 'refElement',
  passCommands: true
});
exports.TabbableSelect = TabbableSelect;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInRhYmJhYmxlLmpzIl0sIm5hbWVzIjpbIm1ha2VUYWJiYWJsZSIsIkNvbXBvbmVudCIsIm9wdGlvbnMiLCJSZWFjdCIsImNvbnN0cnVjdG9yIiwicHJvcHMiLCJlIiwiZWxlbWVudFJlZiIsIm1hcCIsImVsZW1lbnQiLCJ0YWJHcm91cCIsImZvY3VzQWZ0ZXIiLCJzdG9wUHJvcGFnYXRpb24iLCJmb2N1c0JlZm9yZSIsInJvb3RSZWYiLCJSZWZIb2xkZXIiLCJyb290UmVmUHJvcCIsInJvb3RSZWZQcm9wcyIsInBhc3NDb21tYW5kcyIsImNvbW1hbmRQcm9wcyIsImNvbW1hbmRzIiwicmVuZGVyIiwiZm9jdXNOZXh0IiwiZm9jdXNQcmV2aW91cyIsInNldHRlciIsInByb3BUeXBlcyIsImNvbXBvbmVudERpZE1vdW50IiwiYXBwZW5kRWxlbWVudCIsImF1dG9mb2N1cyIsImNvbXBvbmVudFdpbGxVbm1vdW50IiwicmVtb3ZlRWxlbWVudCIsIlByb3BUeXBlcyIsInNoYXBlIiwiZnVuYyIsImlzUmVxdWlyZWQiLCJib29sIiwib2JqZWN0IiwiVGFiYmFibGVJbnB1dCIsIlRhYmJhYmxlQnV0dG9uIiwiVGFiYmFibGVTdW1tYXJ5IiwiVGFiYmFibGVUZXh0RWRpdG9yIiwiQXRvbVRleHRFZGl0b3IiLCJGYWtlS2V5RG93bkV2ZW50IiwiV3JhcFNlbGVjdCIsInJlZlNlbGVjdCIsInJlZkVsZW1lbnQiLCJwcm94eUtleUNvZGUiLCJmb2N1cyIsInNlbGVjdCIsImtleUNvZGUiLCJDdXN0b21FdmVudCIsImtDb2RlIiwiZmFrZUV2ZW50IiwiaGFuZGxlS2V5RG93biIsIlJlZkhvbGRlclByb3BUeXBlIiwiVGFiYmFibGVTZWxlY3QiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7O0FBQUE7O0FBQ0E7O0FBQ0E7O0FBRUE7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7Ozs7Ozs7Ozs7QUFFTyxTQUFTQSxZQUFULENBQXNCQyxTQUF0QixFQUFpQ0MsT0FBTyxHQUFHLEVBQTNDLEVBQStDO0FBQUE7O0FBQ3BELDBCQUFPLGNBQWNDLGVBQU1GLFNBQXBCLENBQThCO0FBaUJuQ0csSUFBQUEsV0FBVyxDQUFDQyxLQUFELEVBQVE7QUFDakIsWUFBTUEsS0FBTjs7QUFEaUIseUNBK0NQQyxDQUFDLElBQUk7QUFDZixhQUFLQyxVQUFMLENBQWdCQyxHQUFoQixDQUFvQkMsT0FBTyxJQUFJLEtBQUtKLEtBQUwsQ0FBV0ssUUFBWCxDQUFvQkMsVUFBcEIsQ0FBK0JGLE9BQS9CLENBQS9CO0FBQ0FILFFBQUFBLENBQUMsQ0FBQ00sZUFBRjtBQUNELE9BbERrQjs7QUFBQSw2Q0FvREhOLENBQUMsSUFBSTtBQUNuQixhQUFLQyxVQUFMLENBQWdCQyxHQUFoQixDQUFvQkMsT0FBTyxJQUFJLEtBQUtKLEtBQUwsQ0FBV0ssUUFBWCxDQUFvQkcsV0FBcEIsQ0FBZ0NKLE9BQWhDLENBQS9CO0FBQ0FILFFBQUFBLENBQUMsQ0FBQ00sZUFBRjtBQUNELE9BdkRrQjs7QUFHakIsV0FBS0UsT0FBTCxHQUFlLElBQUlDLGtCQUFKLEVBQWY7QUFDQSxXQUFLUixVQUFMLEdBQWtCLElBQUlRLGtCQUFKLEVBQWxCOztBQUVBLFVBQUliLE9BQU8sQ0FBQ2MsV0FBWixFQUF5QjtBQUN2QixhQUFLRixPQUFMLEdBQWUsSUFBSUMsa0JBQUosRUFBZjtBQUNBLGFBQUtFLFlBQUwsR0FBb0I7QUFBQyxXQUFDZixPQUFPLENBQUNjLFdBQVQsR0FBdUIsS0FBS0Y7QUFBN0IsU0FBcEI7QUFDRCxPQUhELE1BR087QUFDTCxhQUFLQSxPQUFMLEdBQWUsS0FBS1AsVUFBcEI7QUFDQSxhQUFLVSxZQUFMLEdBQW9CLEVBQXBCO0FBQ0Q7O0FBRUQsVUFBSWYsT0FBTyxDQUFDZ0IsWUFBWixFQUEwQjtBQUN4QixhQUFLQyxZQUFMLEdBQW9CO0FBQUNDLFVBQUFBLFFBQVEsRUFBRSxLQUFLZixLQUFMLENBQVdlO0FBQXRCLFNBQXBCO0FBQ0QsT0FGRCxNQUVPO0FBQ0wsYUFBS0QsWUFBTCxHQUFvQixFQUFwQjtBQUNEO0FBQ0Y7O0FBRURFLElBQUFBLE1BQU0sR0FBRztBQUNQLGFBQ0UsNkJBQUMsZUFBRCxRQUNFLDZCQUFDLGlCQUFEO0FBQVUsUUFBQSxRQUFRLEVBQUUsS0FBS2hCLEtBQUwsQ0FBV2UsUUFBL0I7QUFBeUMsUUFBQSxNQUFNLEVBQUUsS0FBS047QUFBdEQsU0FDRSw2QkFBQyxpQkFBRDtBQUFTLFFBQUEsT0FBTyxFQUFDLGlCQUFqQjtBQUFtQyxRQUFBLFFBQVEsRUFBRSxLQUFLUTtBQUFsRCxRQURGLEVBRUUsNkJBQUMsaUJBQUQ7QUFBUyxRQUFBLE9BQU8sRUFBQyxxQkFBakI7QUFBdUMsUUFBQSxRQUFRLEVBQUUsS0FBS0M7QUFBdEQsUUFGRixDQURGLEVBS0UsNkJBQUMsU0FBRDtBQUNFLFFBQUEsR0FBRyxFQUFFLEtBQUtoQixVQUFMLENBQWdCaUIsTUFEdkI7QUFFRSxRQUFBLFFBQVEsRUFBRSxDQUFDO0FBRmIsU0FHTSwwQkFBWSxLQUFLbkIsS0FBakIsRUFBd0IsS0FBS0QsV0FBTCxDQUFpQnFCLFNBQXpDLENBSE4sRUFJTSxLQUFLUixZQUpYLEVBS00sS0FBS0UsWUFMWCxFQUxGLENBREY7QUFlRDs7QUFFRE8sSUFBQUEsaUJBQWlCLEdBQUc7QUFDbEIsV0FBS25CLFVBQUwsQ0FBZ0JDLEdBQWhCLENBQW9CQyxPQUFPLElBQUksS0FBS0osS0FBTCxDQUFXSyxRQUFYLENBQW9CaUIsYUFBcEIsQ0FBa0NsQixPQUFsQyxFQUEyQyxLQUFLSixLQUFMLENBQVd1QixTQUF0RCxDQUEvQjtBQUNEOztBQUVEQyxJQUFBQSxvQkFBb0IsR0FBRztBQUNyQixXQUFLdEIsVUFBTCxDQUFnQkMsR0FBaEIsQ0FBb0JDLE9BQU8sSUFBSSxLQUFLSixLQUFMLENBQVdLLFFBQVgsQ0FBb0JvQixhQUFwQixDQUFrQ3JCLE9BQWxDLENBQS9CO0FBQ0Q7O0FBOURrQyxHQUFyQyx1Q0FDcUI7QUFDakJDLElBQUFBLFFBQVEsRUFBRXFCLG1CQUFVQyxLQUFWLENBQWdCO0FBQ3hCTCxNQUFBQSxhQUFhLEVBQUVJLG1CQUFVRSxJQUFWLENBQWVDLFVBRE47QUFFeEJKLE1BQUFBLGFBQWEsRUFBRUMsbUJBQVVFLElBQVYsQ0FBZUMsVUFGTjtBQUd4QnZCLE1BQUFBLFVBQVUsRUFBRW9CLG1CQUFVRSxJQUFWLENBQWVDLFVBSEg7QUFJeEJyQixNQUFBQSxXQUFXLEVBQUVrQixtQkFBVUUsSUFBVixDQUFlQztBQUpKLEtBQWhCLEVBS1BBLFVBTmM7QUFPakJOLElBQUFBLFNBQVMsRUFBRUcsbUJBQVVJLElBUEo7QUFTakJmLElBQUFBLFFBQVEsRUFBRVcsbUJBQVVLLE1BQVYsQ0FBaUJGO0FBVFYsR0FEckIsMkNBYXdCO0FBQ3BCTixJQUFBQSxTQUFTLEVBQUU7QUFEUyxHQWJ4QjtBQTBFRDs7QUFFTSxNQUFNUyxhQUFhLEdBQUdyQyxZQUFZLENBQUMsT0FBRCxDQUFsQzs7QUFFQSxNQUFNc0MsY0FBYyxHQUFHdEMsWUFBWSxDQUFDLFFBQUQsQ0FBbkM7O0FBRUEsTUFBTXVDLGVBQWUsR0FBR3ZDLFlBQVksQ0FBQyxTQUFELENBQXBDOztBQUVBLE1BQU13QyxrQkFBa0IsR0FBR3hDLFlBQVksQ0FBQ3lDLHVCQUFELEVBQWlCO0FBQUN6QixFQUFBQSxXQUFXLEVBQUU7QUFBZCxDQUFqQixDQUF2QyxDLENBRVA7QUFDQTs7O0FBQ0EsSUFBSTBCLGdCQUFKOztBQUVBLE1BQU1DLFVBQU4sU0FBeUJ4QyxlQUFNRixTQUEvQixDQUF5QztBQU12Q0csRUFBQUEsV0FBVyxDQUFDQyxLQUFELEVBQVE7QUFDakIsVUFBTUEsS0FBTjtBQUVBLFNBQUt1QyxTQUFMLEdBQWlCLElBQUk3QixrQkFBSixFQUFqQjtBQUNEOztBQUVETSxFQUFBQSxNQUFNLEdBQUc7QUFDUCxXQUNFO0FBQUssTUFBQSxTQUFTLEVBQUMsd0JBQWY7QUFBd0MsTUFBQSxHQUFHLEVBQUUsS0FBS2hCLEtBQUwsQ0FBV3dDLFVBQVgsQ0FBc0JyQjtBQUFuRSxPQUNFLDZCQUFDLGlCQUFEO0FBQVUsTUFBQSxRQUFRLEVBQUUsS0FBS25CLEtBQUwsQ0FBV2UsUUFBL0I7QUFBeUMsTUFBQSxNQUFNLEVBQUUsS0FBS2YsS0FBTCxDQUFXd0M7QUFBNUQsT0FDRSw2QkFBQyxpQkFBRDtBQUFTLE1BQUEsT0FBTyxFQUFDLHVCQUFqQjtBQUF5QyxNQUFBLFFBQVEsRUFBRSxLQUFLQyxZQUFMLENBQWtCLEVBQWxCO0FBQW5ELE1BREYsRUFFRSw2QkFBQyxpQkFBRDtBQUFTLE1BQUEsT0FBTyxFQUFDLHFCQUFqQjtBQUF1QyxNQUFBLFFBQVEsRUFBRSxLQUFLQSxZQUFMLENBQWtCLEVBQWxCO0FBQWpELE1BRkYsRUFHRSw2QkFBQyxpQkFBRDtBQUFTLE1BQUEsT0FBTyxFQUFDLHdCQUFqQjtBQUEwQyxNQUFBLFFBQVEsRUFBRSxLQUFLQSxZQUFMLENBQWtCLEVBQWxCO0FBQXBELE1BSEYsRUFJRSw2QkFBQyxpQkFBRDtBQUFTLE1BQUEsT0FBTyxFQUFDLHNCQUFqQjtBQUF3QyxNQUFBLFFBQVEsRUFBRSxLQUFLQSxZQUFMLENBQWtCLENBQWxCO0FBQWxELE1BSkYsRUFLRSw2QkFBQyxpQkFBRDtBQUFTLE1BQUEsT0FBTyxFQUFDLDRCQUFqQjtBQUE4QyxNQUFBLFFBQVEsRUFBRSxLQUFLQSxZQUFMLENBQWtCLENBQWxCO0FBQXhELE1BTEYsRUFNRSw2QkFBQyxpQkFBRDtBQUFTLE1BQUEsT0FBTyxFQUFDLHlCQUFqQjtBQUEyQyxNQUFBLFFBQVEsRUFBRSxLQUFLQSxZQUFMLENBQWtCLEVBQWxCO0FBQXJELE1BTkYsRUFPRSw2QkFBQyxpQkFBRDtBQUFTLE1BQUEsT0FBTyxFQUFDLDJCQUFqQjtBQUE2QyxNQUFBLFFBQVEsRUFBRSxLQUFLQSxZQUFMLENBQWtCLEVBQWxCO0FBQXZELE1BUEYsRUFRRSw2QkFBQyxpQkFBRDtBQUFTLE1BQUEsT0FBTyxFQUFDLHNCQUFqQjtBQUF3QyxNQUFBLFFBQVEsRUFBRSxLQUFLQSxZQUFMLENBQWtCLEVBQWxCO0FBQWxELE1BUkYsRUFTRSw2QkFBQyxpQkFBRDtBQUFTLE1BQUEsT0FBTyxFQUFDLHVCQUFqQjtBQUF5QyxNQUFBLFFBQVEsRUFBRSxLQUFLQSxZQUFMLENBQWtCLEVBQWxCO0FBQW5ELE1BVEYsRUFVRSw2QkFBQyxpQkFBRDtBQUFTLE1BQUEsT0FBTyxFQUFDLHlCQUFqQjtBQUEyQyxNQUFBLFFBQVEsRUFBRSxLQUFLQSxZQUFMLENBQWtCLEVBQWxCO0FBQXJELE1BVkYsRUFXRSw2QkFBQyxpQkFBRDtBQUFTLE1BQUEsT0FBTyxFQUFDLHlCQUFqQjtBQUEyQyxNQUFBLFFBQVEsRUFBRSxLQUFLQSxZQUFMLENBQWtCLEVBQWxCO0FBQXJELE1BWEYsQ0FERixFQWNFLDZCQUFDLG9CQUFEO0FBQ0UsTUFBQSxHQUFHLEVBQUUsS0FBS0YsU0FBTCxDQUFlcEI7QUFEdEIsT0FFTSwwQkFBWSxLQUFLbkIsS0FBakIsRUFBd0IsS0FBS0QsV0FBTCxDQUFpQnFCLFNBQXpDLENBRk4sRUFkRixDQURGO0FBcUJEOztBQUVEc0IsRUFBQUEsS0FBSyxHQUFHO0FBQ04sV0FBTyxLQUFLSCxTQUFMLENBQWVwQyxHQUFmLENBQW1Cd0MsTUFBTSxJQUFJQSxNQUFNLENBQUNELEtBQVAsRUFBN0IsQ0FBUDtBQUNEOztBQUVERCxFQUFBQSxZQUFZLENBQUNHLE9BQUQsRUFBVTtBQUNwQixXQUFPM0MsQ0FBQyxJQUFJLEtBQUtzQyxTQUFMLENBQWVwQyxHQUFmLENBQW1Cd0MsTUFBTSxJQUFJO0FBQ3ZDLFVBQUksQ0FBQ04sZ0JBQUwsRUFBdUI7QUFDckJBLFFBQUFBLGdCQUFnQixHQUFHLGNBQWNRLFdBQWQsQ0FBMEI7QUFDM0M5QyxVQUFBQSxXQUFXLENBQUMrQyxLQUFELEVBQVE7QUFDakIsa0JBQU0sU0FBTjtBQUNBLGlCQUFLRixPQUFMLEdBQWVFLEtBQWY7QUFDRDs7QUFKMEMsU0FBN0M7QUFNRDs7QUFFRCxZQUFNQyxTQUFTLEdBQUcsSUFBSVYsZ0JBQUosQ0FBcUJPLE9BQXJCLENBQWxCO0FBQ0FELE1BQUFBLE1BQU0sQ0FBQ0ssYUFBUCxDQUFxQkQsU0FBckI7QUFDQSxhQUFPLElBQVA7QUFDRCxLQWJXLENBQVo7QUFjRDs7QUF2RHNDOztnQkFBbkNULFUsZUFDZTtBQUNqQkUsRUFBQUEsVUFBVSxFQUFFUyw4QkFBa0JwQixVQURiO0FBRWpCZCxFQUFBQSxRQUFRLEVBQUVXLG1CQUFVSyxNQUFWLENBQWlCRjtBQUZWLEM7O0FBeURkLE1BQU1xQixjQUFjLEdBQUd2RCxZQUFZLENBQUMyQyxVQUFELEVBQWE7QUFBQzNCLEVBQUFBLFdBQVcsRUFBRSxZQUFkO0FBQTRCRSxFQUFBQSxZQUFZLEVBQUU7QUFBMUMsQ0FBYixDQUFuQyIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QsIHtGcmFnbWVudH0gZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCBTZWxlY3QgZnJvbSAncmVhY3Qtc2VsZWN0JztcblxuaW1wb3J0IENvbW1hbmRzLCB7Q29tbWFuZH0gZnJvbSAnLi4vYXRvbS9jb21tYW5kcyc7XG5pbXBvcnQgQXRvbVRleHRFZGl0b3IgZnJvbSAnLi4vYXRvbS9hdG9tLXRleHQtZWRpdG9yJztcbmltcG9ydCBSZWZIb2xkZXIgZnJvbSAnLi4vbW9kZWxzL3JlZi1ob2xkZXInO1xuaW1wb3J0IHtSZWZIb2xkZXJQcm9wVHlwZX0gZnJvbSAnLi4vcHJvcC10eXBlcyc7XG5pbXBvcnQge3VudXNlZFByb3BzfSBmcm9tICcuLi9oZWxwZXJzJztcblxuZXhwb3J0IGZ1bmN0aW9uIG1ha2VUYWJiYWJsZShDb21wb25lbnQsIG9wdGlvbnMgPSB7fSkge1xuICByZXR1cm4gY2xhc3MgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICAgIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgICB0YWJHcm91cDogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgICAgYXBwZW5kRWxlbWVudDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICAgICAgcmVtb3ZlRWxlbWVudDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICAgICAgZm9jdXNBZnRlcjogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgICAgICAgZm9jdXNCZWZvcmU6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgICB9KS5pc1JlcXVpcmVkLFxuICAgICAgYXV0b2ZvY3VzOiBQcm9wVHlwZXMuYm9vbCxcblxuICAgICAgY29tbWFuZHM6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICB9XG5cbiAgICBzdGF0aWMgZGVmYXVsdFByb3BzID0ge1xuICAgICAgYXV0b2ZvY3VzOiBmYWxzZSxcbiAgICB9XG5cbiAgICBjb25zdHJ1Y3Rvcihwcm9wcykge1xuICAgICAgc3VwZXIocHJvcHMpO1xuXG4gICAgICB0aGlzLnJvb3RSZWYgPSBuZXcgUmVmSG9sZGVyKCk7XG4gICAgICB0aGlzLmVsZW1lbnRSZWYgPSBuZXcgUmVmSG9sZGVyKCk7XG5cbiAgICAgIGlmIChvcHRpb25zLnJvb3RSZWZQcm9wKSB7XG4gICAgICAgIHRoaXMucm9vdFJlZiA9IG5ldyBSZWZIb2xkZXIoKTtcbiAgICAgICAgdGhpcy5yb290UmVmUHJvcHMgPSB7W29wdGlvbnMucm9vdFJlZlByb3BdOiB0aGlzLnJvb3RSZWZ9O1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgdGhpcy5yb290UmVmID0gdGhpcy5lbGVtZW50UmVmO1xuICAgICAgICB0aGlzLnJvb3RSZWZQcm9wcyA9IHt9O1xuICAgICAgfVxuXG4gICAgICBpZiAob3B0aW9ucy5wYXNzQ29tbWFuZHMpIHtcbiAgICAgICAgdGhpcy5jb21tYW5kUHJvcHMgPSB7Y29tbWFuZHM6IHRoaXMucHJvcHMuY29tbWFuZHN9O1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgdGhpcy5jb21tYW5kUHJvcHMgPSB7fTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICByZW5kZXIoKSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8RnJhZ21lbnQ+XG4gICAgICAgICAgPENvbW1hbmRzIHJlZ2lzdHJ5PXt0aGlzLnByb3BzLmNvbW1hbmRzfSB0YXJnZXQ9e3RoaXMucm9vdFJlZn0+XG4gICAgICAgICAgICA8Q29tbWFuZCBjb21tYW5kPVwiY29yZTpmb2N1cy1uZXh0XCIgY2FsbGJhY2s9e3RoaXMuZm9jdXNOZXh0fSAvPlxuICAgICAgICAgICAgPENvbW1hbmQgY29tbWFuZD1cImNvcmU6Zm9jdXMtcHJldmlvdXNcIiBjYWxsYmFjaz17dGhpcy5mb2N1c1ByZXZpb3VzfSAvPlxuICAgICAgICAgIDwvQ29tbWFuZHM+XG4gICAgICAgICAgPENvbXBvbmVudFxuICAgICAgICAgICAgcmVmPXt0aGlzLmVsZW1lbnRSZWYuc2V0dGVyfVxuICAgICAgICAgICAgdGFiSW5kZXg9ey0xfVxuICAgICAgICAgICAgey4uLnVudXNlZFByb3BzKHRoaXMucHJvcHMsIHRoaXMuY29uc3RydWN0b3IucHJvcFR5cGVzKX1cbiAgICAgICAgICAgIHsuLi50aGlzLnJvb3RSZWZQcm9wc31cbiAgICAgICAgICAgIHsuLi50aGlzLmNvbW1hbmRQcm9wc31cbiAgICAgICAgICAvPlxuICAgICAgICA8L0ZyYWdtZW50PlxuICAgICAgKTtcbiAgICB9XG5cbiAgICBjb21wb25lbnREaWRNb3VudCgpIHtcbiAgICAgIHRoaXMuZWxlbWVudFJlZi5tYXAoZWxlbWVudCA9PiB0aGlzLnByb3BzLnRhYkdyb3VwLmFwcGVuZEVsZW1lbnQoZWxlbWVudCwgdGhpcy5wcm9wcy5hdXRvZm9jdXMpKTtcbiAgICB9XG5cbiAgICBjb21wb25lbnRXaWxsVW5tb3VudCgpIHtcbiAgICAgIHRoaXMuZWxlbWVudFJlZi5tYXAoZWxlbWVudCA9PiB0aGlzLnByb3BzLnRhYkdyb3VwLnJlbW92ZUVsZW1lbnQoZWxlbWVudCkpO1xuICAgIH1cblxuICAgIGZvY3VzTmV4dCA9IGUgPT4ge1xuICAgICAgdGhpcy5lbGVtZW50UmVmLm1hcChlbGVtZW50ID0+IHRoaXMucHJvcHMudGFiR3JvdXAuZm9jdXNBZnRlcihlbGVtZW50KSk7XG4gICAgICBlLnN0b3BQcm9wYWdhdGlvbigpO1xuICAgIH1cblxuICAgIGZvY3VzUHJldmlvdXMgPSBlID0+IHtcbiAgICAgIHRoaXMuZWxlbWVudFJlZi5tYXAoZWxlbWVudCA9PiB0aGlzLnByb3BzLnRhYkdyb3VwLmZvY3VzQmVmb3JlKGVsZW1lbnQpKTtcbiAgICAgIGUuc3RvcFByb3BhZ2F0aW9uKCk7XG4gICAgfVxuICB9O1xufVxuXG5leHBvcnQgY29uc3QgVGFiYmFibGVJbnB1dCA9IG1ha2VUYWJiYWJsZSgnaW5wdXQnKTtcblxuZXhwb3J0IGNvbnN0IFRhYmJhYmxlQnV0dG9uID0gbWFrZVRhYmJhYmxlKCdidXR0b24nKTtcblxuZXhwb3J0IGNvbnN0IFRhYmJhYmxlU3VtbWFyeSA9IG1ha2VUYWJiYWJsZSgnc3VtbWFyeScpO1xuXG5leHBvcnQgY29uc3QgVGFiYmFibGVUZXh0RWRpdG9yID0gbWFrZVRhYmJhYmxlKEF0b21UZXh0RWRpdG9yLCB7cm9vdFJlZlByb3A6ICdyZWZFbGVtZW50J30pO1xuXG4vLyBDdXN0b21FdmVudCBpcyBhIERPTSBwcmltaXRpdmUsIHdoaWNoIHY4IGNhbid0IGFjY2Vzc1xuLy8gc28gd2UncmUgZXNzZW50aWFsbHkgbGF6eSBsb2FkaW5nIHRvIGtlZXAgc25hcHNob3R0aW5nIGZyb20gYnJlYWtpbmcuXG5sZXQgRmFrZUtleURvd25FdmVudDtcblxuY2xhc3MgV3JhcFNlbGVjdCBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgcmVmRWxlbWVudDogUmVmSG9sZGVyUHJvcFR5cGUuaXNSZXF1aXJlZCxcbiAgICBjb21tYW5kczogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICB9XG5cbiAgY29uc3RydWN0b3IocHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG5cbiAgICB0aGlzLnJlZlNlbGVjdCA9IG5ldyBSZWZIb2xkZXIoKTtcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPGRpdiBjbGFzc05hbWU9XCJnaXRodWItVGFiYmFibGVXcmFwcGVyXCIgcmVmPXt0aGlzLnByb3BzLnJlZkVsZW1lbnQuc2V0dGVyfT5cbiAgICAgICAgPENvbW1hbmRzIHJlZ2lzdHJ5PXt0aGlzLnByb3BzLmNvbW1hbmRzfSB0YXJnZXQ9e3RoaXMucHJvcHMucmVmRWxlbWVudH0+XG4gICAgICAgICAgPENvbW1hbmQgY29tbWFuZD1cImdpdGh1YjpzZWxlY3Rib3gtZG93blwiIGNhbGxiYWNrPXt0aGlzLnByb3h5S2V5Q29kZSg0MCl9IC8+XG4gICAgICAgICAgPENvbW1hbmQgY29tbWFuZD1cImdpdGh1YjpzZWxlY3Rib3gtdXBcIiBjYWxsYmFjaz17dGhpcy5wcm94eUtleUNvZGUoMzgpfSAvPlxuICAgICAgICAgIDxDb21tYW5kIGNvbW1hbmQ9XCJnaXRodWI6c2VsZWN0Ym94LWVudGVyXCIgY2FsbGJhY2s9e3RoaXMucHJveHlLZXlDb2RlKDEzKX0gLz5cbiAgICAgICAgICA8Q29tbWFuZCBjb21tYW5kPVwiZ2l0aHViOnNlbGVjdGJveC10YWJcIiBjYWxsYmFjaz17dGhpcy5wcm94eUtleUNvZGUoOSl9IC8+XG4gICAgICAgICAgPENvbW1hbmQgY29tbWFuZD1cImdpdGh1YjpzZWxlY3Rib3gtYmFja3NwYWNlXCIgY2FsbGJhY2s9e3RoaXMucHJveHlLZXlDb2RlKDgpfSAvPlxuICAgICAgICAgIDxDb21tYW5kIGNvbW1hbmQ9XCJnaXRodWI6c2VsZWN0Ym94LXBhZ2V1cFwiIGNhbGxiYWNrPXt0aGlzLnByb3h5S2V5Q29kZSgzMyl9IC8+XG4gICAgICAgICAgPENvbW1hbmQgY29tbWFuZD1cImdpdGh1YjpzZWxlY3Rib3gtcGFnZWRvd25cIiBjYWxsYmFjaz17dGhpcy5wcm94eUtleUNvZGUoMzQpfSAvPlxuICAgICAgICAgIDxDb21tYW5kIGNvbW1hbmQ9XCJnaXRodWI6c2VsZWN0Ym94LWVuZFwiIGNhbGxiYWNrPXt0aGlzLnByb3h5S2V5Q29kZSgzNSl9IC8+XG4gICAgICAgICAgPENvbW1hbmQgY29tbWFuZD1cImdpdGh1YjpzZWxlY3Rib3gtaG9tZVwiIGNhbGxiYWNrPXt0aGlzLnByb3h5S2V5Q29kZSgzNil9IC8+XG4gICAgICAgICAgPENvbW1hbmQgY29tbWFuZD1cImdpdGh1YjpzZWxlY3Rib3gtZGVsZXRlXCIgY2FsbGJhY2s9e3RoaXMucHJveHlLZXlDb2RlKDQ2KX0gLz5cbiAgICAgICAgICA8Q29tbWFuZCBjb21tYW5kPVwiZ2l0aHViOnNlbGVjdGJveC1lc2NhcGVcIiBjYWxsYmFjaz17dGhpcy5wcm94eUtleUNvZGUoMjcpfSAvPlxuICAgICAgICA8L0NvbW1hbmRzPlxuICAgICAgICA8U2VsZWN0XG4gICAgICAgICAgcmVmPXt0aGlzLnJlZlNlbGVjdC5zZXR0ZXJ9XG4gICAgICAgICAgey4uLnVudXNlZFByb3BzKHRoaXMucHJvcHMsIHRoaXMuY29uc3RydWN0b3IucHJvcFR5cGVzKX1cbiAgICAgICAgLz5cbiAgICAgIDwvZGl2PlxuICAgICk7XG4gIH1cblxuICBmb2N1cygpIHtcbiAgICByZXR1cm4gdGhpcy5yZWZTZWxlY3QubWFwKHNlbGVjdCA9PiBzZWxlY3QuZm9jdXMoKSk7XG4gIH1cblxuICBwcm94eUtleUNvZGUoa2V5Q29kZSkge1xuICAgIHJldHVybiBlID0+IHRoaXMucmVmU2VsZWN0Lm1hcChzZWxlY3QgPT4ge1xuICAgICAgaWYgKCFGYWtlS2V5RG93bkV2ZW50KSB7XG4gICAgICAgIEZha2VLZXlEb3duRXZlbnQgPSBjbGFzcyBleHRlbmRzIEN1c3RvbUV2ZW50IHtcbiAgICAgICAgICBjb25zdHJ1Y3RvcihrQ29kZSkge1xuICAgICAgICAgICAgc3VwZXIoJ2tleWRvd24nKTtcbiAgICAgICAgICAgIHRoaXMua2V5Q29kZSA9IGtDb2RlO1xuICAgICAgICAgIH1cbiAgICAgICAgfTtcbiAgICAgIH1cblxuICAgICAgY29uc3QgZmFrZUV2ZW50ID0gbmV3IEZha2VLZXlEb3duRXZlbnQoa2V5Q29kZSk7XG4gICAgICBzZWxlY3QuaGFuZGxlS2V5RG93bihmYWtlRXZlbnQpO1xuICAgICAgcmV0dXJuIG51bGw7XG4gICAgfSk7XG4gIH1cbn1cblxuZXhwb3J0IGNvbnN0IFRhYmJhYmxlU2VsZWN0ID0gbWFrZVRhYmJhYmxlKFdyYXBTZWxlY3QsIHtyb290UmVmUHJvcDogJ3JlZkVsZW1lbnQnLCBwYXNzQ29tbWFuZHM6IHRydWV9KTtcbiJdfQ==