"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareCommitView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCommitView extends _react.default.Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "openCommitDetailItem", () => this.props.openCommit({
      sha: this.props.commit.sha
    }));
  }

  authoredByCommitter(commit) {
    if (commit.authoredByCommitter) {
      return true;
    } // If you commit on GitHub online the committer details would be:
    //
    //    name: "GitHub"
    //    email: "noreply@github.com"
    //    user: null
    //


    if (commit.committer.email === 'noreply@github.com') {
      return true;
    }

    if (commit.committer.name === 'GitHub' && commit.committer.user === null) {
      return true;
    }

    return false;
  }

  renderCommitter(commit) {
    if (!this.authoredByCommitter(commit)) {
      return _react.default.createElement("img", {
        className: "author-avatar",
        alt: "author's avatar",
        src: commit.committer.avatarUrl,
        title: commit.committer.user ? commit.committer.user.login : commit.committer.name
      });
    } else {
      return null;
    }
  }

  render() {
    const commit = this.props.commit;
    return _react.default.createElement("div", {
      className: "commit"
    }, _react.default.createElement(_octicon.default, {
      className: "pre-timeline-item-icon",
      icon: "git-commit"
    }), _react.default.createElement("span", {
      className: "commit-author"
    }, _react.default.createElement("img", {
      className: "author-avatar",
      alt: "author's avatar",
      src: commit.author.avatarUrl,
      title: commit.author.user ? commit.author.user.login : commit.author.name
    }), this.renderCommitter(commit)), _react.default.createElement("p", {
      className: "commit-message-headline"
    }, this.props.onBranch ? _react.default.createElement("button", {
      className: "open-commit-detail-button",
      title: commit.message,
      dangerouslySetInnerHTML: {
        __html: commit.messageHeadlineHTML
      },
      onClick: this.openCommitDetailItem
    }) : _react.default.createElement("span", {
      title: commit.message,
      dangerouslySetInnerHTML: {
        __html: commit.messageHeadlineHTML
      }
    })), _react.default.createElement("a", {
      className: "commit-sha",
      href: commit.commitUrl
    }, commit.sha.slice(0, 8)));
  }

}

exports.BareCommitView = BareCommitView;

_defineProperty(BareCommitView, "propTypes", {
  commit: _propTypes.default.object.isRequired,
  onBranch: _propTypes.default.bool.isRequired,
  openCommit: _propTypes.default.func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCommitView, {
  commit: function () {
    const node = require("./__generated__/commitView_commit.graphql");

    if (node.hash && node.hash !== "9d2823ee95f39173f656043ddfc8d47c") {
      console.error("The definition of 'commitView_commit' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/commitView_commit.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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