"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareCrossReferencedEventView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

var _issueishBadge = _interopRequireDefault(require("../../views/issueish-badge"));

var _issueishLink = _interopRequireDefault(require("../../views/issueish-link"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCrossReferencedEventView extends _react.default.Component {
  render() {
    const xref = this.props.item;
    const repo = xref.source.repository;
    const repoLabel = `${repo.owner.login}/${repo.name}`;
    return _react.default.createElement("div", {
      className: "cross-referenced-event"
    }, _react.default.createElement("div", {
      className: "cross-referenced-event-label"
    }, _react.default.createElement("span", {
      className: "cross-referenced-event-label-title"
    }, xref.source.title), _react.default.createElement(_issueishLink.default, {
      url: xref.source.url,
      className: "cross-referenced-event-label-number"
    }, this.getIssueishNumberDisplay(xref))), repo.isPrivate ? _react.default.createElement("div", {
      className: "cross-referenced-event-private"
    }, _react.default.createElement(_octicon.default, {
      icon: "lock",
      title: `Only people who can see ${repoLabel} will see this reference.`
    })) : '', _react.default.createElement("div", {
      className: "cross-referenced-event-state"
    }, _react.default.createElement(_issueishBadge.default, {
      type: xref.source.__typename,
      state: xref.source.issueState || xref.source.prState
    })));
  }

  getIssueishNumberDisplay(xref) {
    const {
      source
    } = xref;

    if (!xref.isCrossRepository) {
      return `#${source.number}`;
    } else {
      const {
        repository
      } = source;
      return `${repository.owner.login}/${repository.name}#${source.number}`;
    }
  }

}

exports.BareCrossReferencedEventView = BareCrossReferencedEventView;

_defineProperty(BareCrossReferencedEventView, "propTypes", {
  item: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    isCrossRepository: _propTypes.default.bool.isRequired,
    source: _propTypes.default.shape({
      __typename: _propTypes.default.oneOf(['Issue', 'PullRequest']).isRequired,
      number: _propTypes.default.number.isRequired,
      title: _propTypes.default.string.isRequired,
      url: _propTypes.default.string.isRequired,
      issueState: _propTypes.default.oneOf(['OPEN', 'CLOSED']),
      prState: _propTypes.default.oneOf(['OPEN', 'CLOSED', 'MERGED']),
      repository: _propTypes.default.shape({
        name: _propTypes.default.string.isRequired,
        isPrivate: _propTypes.default.bool.isRequired,
        owner: _propTypes.default.shape({
          login: _propTypes.default.string.isRequired
        }).isRequired
      }).isRequired
    }).isRequired
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCrossReferencedEventView, {
  item: function () {
    const node = require("./__generated__/crossReferencedEventView_item.graphql");

    if (node.hash && node.hash !== "b90b8c9f0acee56516e7413263cf7f51") {
      console.error("The definition of 'crossReferencedEventView_item' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/crossReferencedEventView_item.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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