"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.BareMergedEventView = void 0;

var _react = _interopRequireWildcard(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

var _timeago = _interopRequireDefault(require("../../views/timeago"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareMergedEventView extends _react.default.Component {
  render() {
    const {
      actor,
      mergeRefName,
      createdAt
    } = this.props.item;
    return _react.default.createElement("div", {
      className: "merged-event"
    }, _react.default.createElement(_octicon.default, {
      className: "pre-timeline-item-icon",
      icon: "git-merge"
    }), actor && _react.default.createElement("img", {
      className: "author-avatar",
      src: actor.avatarUrl,
      alt: actor.login,
      title: actor.login
    }), _react.default.createElement("span", {
      className: "merged-event-header"
    }, _react.default.createElement("span", {
      className: "username"
    }, actor ? actor.login : 'someone'), " merged", ' ', this.renderCommit(), " into", ' ', _react.default.createElement("span", {
      className: "merge-ref"
    }, mergeRefName), " on ", _react.default.createElement(_timeago.default, {
      time: createdAt
    })));
  }

  renderCommit() {
    const {
      commit
    } = this.props.item;

    if (!commit) {
      return 'a commit';
    }

    return _react.default.createElement(_react.Fragment, null, "commit ", _react.default.createElement("span", {
      className: "sha"
    }, commit.oid.slice(0, 8)));
  }

}

exports.BareMergedEventView = BareMergedEventView;

_defineProperty(BareMergedEventView, "propTypes", {
  item: _propTypes.default.shape({
    actor: _propTypes.default.shape({
      avatarUrl: _propTypes.default.string.isRequired,
      login: _propTypes.default.string.isRequired
    }),
    commit: _propTypes.default.shape({
      oid: _propTypes.default.string.isRequired
    }),
    mergeRefName: _propTypes.default.string.isRequired,
    createdAt: _propTypes.default.string.isRequired
  }).isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareMergedEventView, {
  item: function () {
    const node = require("./__generated__/mergedEventView_item.graphql");

    if (node.hash && node.hash !== "d265decf08c14d96c2ec47fd5852a956") {
      console.error("The definition of 'mergedEventView_item' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/mergedEventView_item.graphql");
  }
});

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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