Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _atom = require('atom');

var _main = require('./main');

'use babel';

var Selector = (function () {

  // Make a selector object (should be called once)

  function Selector(selectorItems) {
    var _this = this;

    _classCallCheck(this, Selector);

    // Defining a SelectListView with methods - https://github.com/atom/atom-select-list
    this.lineEndingListView = new _atomSelectList2['default']({
      // an array containing the objects you want to show in the select list
      items: selectorItems,

      // called whenever an item needs to be displayed.
      elementForItem: function elementForItem(lineEnding) {
        var element = document.createElement('li');
        element.textContent = lineEnding.name;
        return element;
      },

      // called to retrieve a string property on each item and that will be used to filter them.
      filterKeyForItem: function filterKeyForItem(lineEnding) {
        return lineEnding.name;
      },

      // called when the user clicks or presses Enter on an item. // use `=>` for `this`
      didConfirmSelection: function didConfirmSelection(lineEnding) {
        var editor = atom.workspace.getActiveTextEditor();
        if (editor instanceof _atom.TextEditor) {
          (0, _main.setLineEnding)(editor, lineEnding.value);
        }
        _this.hide();
      },

      // called when the user presses Esc or the list loses focus. // use `=>` for `this`
      didCancelSelection: function didCancelSelection() {
        _this.hide();
      }
    });

    // Adding SelectListView to panel
    this.modalPanel = atom.workspace.addModalPanel({
      item: this.lineEndingListView
    });
  }

  // Show a selector object

  _createClass(Selector, [{
    key: 'show',
    value: function show() {
      this.previousActivePane = atom.workspace.getActivePane();

      // Show selector
      this.lineEndingListView.reset();
      this.modalPanel.show();
      this.lineEndingListView.focus();
    }

    // Hide a selector
  }, {
    key: 'hide',
    value: function hide() {
      // hide modal panel
      this.modalPanel.hide();
      // focus on the previous active pane
      this.previousActivePane.activate();
    }

    // Dispose selector
  }, {
    key: 'dispose',
    value: function dispose() {
      this.lineEndingListView.destroy();
      this.modalPanel.destroy();
      this.modalPanel = null;
    }
  }]);

  return Selector;
})();

exports.Selector = Selector;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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