Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _electron = require('electron');

var _electron2 = _interopRequireDefault(_electron);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _hostedGitInfo = require('hosted-git-info');

var _hostedGitInfo2 = _interopRequireDefault(_hostedGitInfo);

var _atom = require('atom');

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var _errorView = require('./error-view');

var _errorView2 = _interopRequireDefault(_errorView);

var PackageNameRegex = /config\/install\/(package|theme):([a-z0-9-_]+)/i;

var InstallPanel = (function () {
  function InstallPanel(settingsView, packageManager) {
    var _this = this;

    _classCallCheck(this, InstallPanel);

    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.disposables = new _atom.CompositeDisposable();
    this.client = this.packageManager.getClient();
    this.atomIoURL = 'https://atom.io/packages';

    _etch2['default'].initialize(this);

    this.refs.searchMessage.style.display = 'none';

    this.refs.searchEditor.setPlaceholderText('Search packages');
    this.searchType = 'packages';
    this.disposables.add(this.packageManager.on('package-install-failed', function (_ref) {
      var pack = _ref.pack;
      var error = _ref.error;

      _this.refs.searchErrors.appendChild(new _errorView2['default'](_this.packageManager, error).element);
    }));
    this.disposables.add(this.packageManager.on('package-installed theme-installed', function (_ref2) {
      var pack = _ref2.pack;

      var gitUrlInfo = _this.currentGitPackageCard && _this.currentGitPackageCard.pack && _this.currentGitPackageCard.pack.gitUrlInfo ? _this.currentGitPackageCard.pack.gitUrlInfo : null;

      if (gitUrlInfo && gitUrlInfo === pack.gitUrlInfo) {
        _this.updateGitPackageCard(pack);
      }
    }));
    this.disposables.add(this.refs.searchEditor.onDidStopChanging(function () {
      _this.performSearch();
    }));
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.loadFeaturedPackages();
  }

  _createClass(InstallPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'focus',
    value: function focus() {
      this.refs.searchEditor.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'section packages' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom(
              'h1',
              { ref: 'installHeading', className: 'section-heading icon icon-plus' },
              'Install Packages'
            ),
            _etch2['default'].dom(
              'div',
              { className: 'text native-key-bindings', tabIndex: '-1' },
              _etch2['default'].dom('span', { className: 'icon icon-question' }),
              _etch2['default'].dom(
                'span',
                { ref: 'publishedToText' },
                'Packages are published to '
              ),
              _etch2['default'].dom(
                'a',
                { className: 'link', onclick: this.didClickOpenAtomIo.bind(this) },
                'atom.io'
              ),
              _etch2['default'].dom(
                'span',
                null,
                ' and are installed to ',
                _path2['default'].join(process.env.ATOM_HOME, 'packages')
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'search-container clearfix' },
              _etch2['default'].dom(
                'div',
                { className: 'editor-container' },
                _etch2['default'].dom(_atom.TextEditor, { mini: true, ref: 'searchEditor' })
              ),
              _etch2['default'].dom(
                'div',
                { className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { ref: 'searchPackagesButton', className: 'btn btn-default selected', onclick: this.didClickSearchPackagesButton.bind(this) },
                  'Packages'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'searchThemesButton', className: 'btn btn-default', onclick: this.didClickSearchThemesButton.bind(this) },
                  'Themes'
                )
              )
            ),
            _etch2['default'].dom('div', { ref: 'searchErrors' }),
            _etch2['default'].dom('div', { ref: 'searchMessage', className: 'alert alert-info search-message icon icon-search' }),
            _etch2['default'].dom('div', { ref: 'resultsContainer', className: 'container package-container' })
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'section packages' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom('div', { ref: 'featuredHeading', className: 'section-heading icon icon-star' }),
            _etch2['default'].dom('div', { ref: 'featuredErrors' }),
            _etch2['default'].dom('div', { ref: 'loadingMessage', className: 'alert alert-info icon icon-hourglass' }),
            _etch2['default'].dom('div', { ref: 'featuredContainer', className: 'container package-container' })
          )
        )
      );
    }
  }, {
    key: 'setSearchType',
    value: function setSearchType(searchType) {
      if (searchType === 'theme') {
        this.searchType = 'themes';
        this.refs.searchThemesButton.classList.add('selected');
        this.refs.searchPackagesButton.classList.remove('selected');
        this.refs.searchEditor.setPlaceholderText('Search themes');
        this.refs.publishedToText.textContent = 'Themes are published to ';
        this.atomIoURL = 'https://atom.io/themes';
        this.loadFeaturedPackages(true);
      } else if (searchType === 'package') {
        this.searchType = 'packages';
        this.refs.searchPackagesButton.classList.add('selected');
        this.refs.searchThemesButton.classList.remove('selected');
        this.refs.searchEditor.setPlaceholderText('Search packages');
        this.refs.publishedToText.textContent = 'Packages are published to ';
        this.atomIoURL = 'https://atom.io/packages';
        this.loadFeaturedPackages();
      }
    }
  }, {
    key: 'beforeShow',
    value: function beforeShow(options) {
      if (options && options.uri) {
        var query = this.extractQueryFromURI(options.uri);
        if (query != null) {
          var searchType = query.searchType;
          var packageName = query.packageName;

          this.setSearchType(searchType);
          this.refs.searchEditor.setText(packageName);
          this.performSearch();
        }
      }
    }
  }, {
    key: 'extractQueryFromURI',
    value: function extractQueryFromURI(uri) {
      var matches = PackageNameRegex.exec(uri);
      if (matches) {
        var _Array$from = Array.from(matches);

        var _Array$from2 = _slicedToArray(_Array$from, 3);

        var searchType = _Array$from2[1];
        var packageName = _Array$from2[2];

        return { searchType: searchType, packageName: packageName };
      } else {
        return null;
      }
    }
  }, {
    key: 'performSearch',
    value: function performSearch() {
      var query = this.refs.searchEditor.getText().trim().toLowerCase();
      if (query) {
        this.performSearchForQuery(query);
      }
    }
  }, {
    key: 'performSearchForQuery',
    value: function performSearchForQuery(query) {
      var gitUrlInfo = _hostedGitInfo2['default'].fromUrl(query);
      if (gitUrlInfo) {
        var type = gitUrlInfo['default'];
        if (type === 'sshurl' || type === 'https' || type === 'shortcut') {
          this.showGitInstallPackageCard({ name: query, gitUrlInfo: gitUrlInfo });
        }
      } else {
        this.search(query);
      }
    }
  }, {
    key: 'showGitInstallPackageCard',
    value: function showGitInstallPackageCard(pack) {
      if (this.currentGitPackageCard) {
        this.currentGitPackageCard.destroy();
      }

      this.currentGitPackageCard = this.getPackageCardView(pack);
      this.currentGitPackageCard.displayGitPackageInstallInformation();
      this.replaceCurrentGitPackageCardView();
    }
  }, {
    key: 'updateGitPackageCard',
    value: function updateGitPackageCard(pack) {
      if (this.currentGitPackageCard) {
        this.currentGitPackageCard.destroy();
      }

      this.currentGitPackageCard = this.getPackageCardView(pack);
      this.replaceCurrentGitPackageCardView();
    }
  }, {
    key: 'replaceCurrentGitPackageCardView',
    value: function replaceCurrentGitPackageCardView() {
      this.refs.resultsContainer.innerHTML = '';
      this.addPackageCardView(this.refs.resultsContainer, this.currentGitPackageCard);
    }
  }, {
    key: 'search',
    value: _asyncToGenerator(function* (query) {
      this.refs.resultsContainer.innerHTML = '';
      this.refs.searchMessage.textContent = 'Searching ' + this.searchType + ' for “' + query + '”…';
      this.refs.searchMessage.style.display = '';

      var options = {};
      options[this.searchType] = true;

      try {
        var packages = (yield this.client.search(query, options)) || [];
        this.refs.resultsContainer.innerHTML = '';
        this.refs.searchMessage.style.display = 'none';
        if (packages.length === 0) {
          this.refs.searchMessage.textContent = 'No ' + this.searchType.replace(/s$/, '') + ' results for “' + query + '”';
          this.refs.searchMessage.style.display = '';
        }

        this.addPackageViews(this.refs.resultsContainer, packages);
      } catch (error) {
        this.refs.searchMessage.style.display = 'none';
        this.refs.searchErrors.appendChild(new _errorView2['default'](this.packageManager, error).element);
      }
    })
  }, {
    key: 'addPackageViews',
    value: function addPackageViews(container, packages) {
      for (var pack of packages) {
        this.addPackageCardView(container, this.getPackageCardView(pack));
      }
    }
  }, {
    key: 'addPackageCardView',
    value: function addPackageCardView(container, packageCard) {
      var packageRow = document.createElement('div');
      packageRow.classList.add('row');
      packageRow.appendChild(packageCard.element);
      container.appendChild(packageRow);
    }
  }, {
    key: 'getPackageCardView',
    value: function getPackageCardView(pack) {
      return new _packageCard2['default'](pack, this.settingsView, this.packageManager, { back: 'Install' });
    }
  }, {
    key: 'filterPackages',
    value: function filterPackages(packages, themes) {
      return packages.filter(function (_ref3) {
        var theme = _ref3.theme;
        return themes ? theme : !theme;
      });
    }

    // Load and display the featured packages that are available to install.
  }, {
    key: 'loadFeaturedPackages',
    value: function loadFeaturedPackages(loadThemes) {
      var _this2 = this;

      if (loadThemes == null) {
        loadThemes = false;
      }
      this.refs.featuredContainer.innerHTML = '';

      if (loadThemes) {
        this.refs.installHeading.textContent = 'Install Themes';
        this.refs.featuredHeading.textContent = 'Featured Themes';
        this.refs.loadingMessage.textContent = 'Loading featured themes…';
      } else {
        this.refs.installHeading.textContent = 'Install Packages';
        this.refs.featuredHeading.textContent = 'Featured Packages';
        this.refs.loadingMessage.textContent = 'Loading featured packages…';
      }

      this.refs.loadingMessage.style.display = '';

      var handle = function handle(error) {
        _this2.refs.loadingMessage.style.display = 'none';
        _this2.refs.featuredErrors.appendChild(new _errorView2['default'](_this2.packageManager, error).element);
      };

      if (loadThemes) {
        this.client.featuredThemes(function (error, themes) {
          if (error) {
            handle(error);
          } else {
            _this2.refs.loadingMessage.style.display = 'none';
            _this2.refs.featuredHeading.textContent = 'Featured Themes';
            _this2.addPackageViews(_this2.refs.featuredContainer, themes);
          }
        });
      } else {
        this.client.featuredPackages(function (error, packages) {
          if (error) {
            handle(error);
          } else {
            _this2.refs.loadingMessage.style.display = 'none';
            _this2.refs.featuredHeading.textContent = 'Featured Packages';
            _this2.addPackageViews(_this2.refs.featuredContainer, packages);
          }
        });
      }
    }
  }, {
    key: 'didClickOpenAtomIo',
    value: function didClickOpenAtomIo(event) {
      event.preventDefault();
      _electron2['default'].shell.openExternal(this.atomIoURL);
    }
  }, {
    key: 'didClickSearchPackagesButton',
    value: function didClickSearchPackagesButton() {
      if (!this.refs.searchPackagesButton.classList.contains('selected')) {
        this.setSearchType('package');
      }

      this.performSearch();
    }
  }, {
    key: 'didClickSearchThemesButton',
    value: function didClickSearchThemesButton() {
      if (!this.refs.searchThemesButton.classList.contains('selected')) {
        this.setSearchType('theme');
      }

      this.performSearch();
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return InstallPanel;
})();

exports['default'] = InstallPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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