Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _electron = require('electron');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _utils = require('./utils');

var marked = null;

var PackageCard = (function () {
  function PackageCard(pack, settingsView, packageManager) {
    var options = arguments.length <= 3 || arguments[3] === undefined ? {} : arguments[3];

    _classCallCheck(this, PackageCard);

    this.pack = pack;
    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.disposables = new _atom.CompositeDisposable();

    // It might be useful to either wrap this.pack in a class that has a
    // ::validate method, or add a method here. At the moment I think all cases
    // of malformed package metadata are handled here and in ::content but belt
    // and suspenders, you know
    this.client = this.packageManager.getClient();
    this.type = this.pack.theme ? 'theme' : 'package';
    this.name = this.pack.name;
    this.onSettingsView = options.onSettingsView;

    if (this.pack.latestVersion !== this.pack.version) {
      this.newVersion = this.pack.latestVersion;
    }

    if (this.pack.apmInstallSource && this.pack.apmInstallSource.type === 'git') {
      if (this.pack.apmInstallSource.sha !== this.pack.latestSha) {
        this.newSha = this.pack.latestSha;
      }
    }

    // Default to displaying the download count
    if (!options.stats) {
      options.stats = { downloads: true };
    }

    _etch2['default'].initialize(this);

    this.displayStats(options);
    this.handlePackageEvents();
    this.handleButtonEvents(options);
    this.loadCachedMetadata();

    // themes have no status and cannot be dis/enabled
    if (this.type === 'theme') {
      this.refs.statusIndicator.remove();
      this.refs.enablementButton.remove();
    }

    if (atom.packages.isBundledPackage(this.pack.name)) {
      this.refs.installButtonGroup.remove();
      this.refs.uninstallButton.remove();
    }

    if (!this.newVersion && !this.newSha) {
      this.refs.updateButtonGroup.style.display = 'none';
    }

    this.hasCompatibleVersion = true;
    this.updateInterfaceState();
  }

  _createClass(PackageCard, [{
    key: 'render',
    value: function render() {
      var displayName = (this.pack.gitUrlInfo ? this.pack.gitUrlInfo.project : this.pack.name) || '';
      var owner = (0, _utils.ownerFromRepository)(this.pack.repository);
      var description = this.pack.description || '';

      return _etch2['default'].dom(
        'div',
        { className: 'package-card col-lg-8' },
        _etch2['default'].dom(
          'div',
          { ref: 'statsContainer', className: 'stats pull-right' },
          _etch2['default'].dom(
            'span',
            { ref: 'packageStars', className: 'stats-item' },
            _etch2['default'].dom('span', { ref: 'stargazerIcon', className: 'icon icon-star' }),
            _etch2['default'].dom('span', { ref: 'stargazerCount', className: 'value' })
          ),
          _etch2['default'].dom(
            'span',
            { ref: 'packageDownloads', className: 'stats-item' },
            _etch2['default'].dom('span', { ref: 'downloadIcon', className: 'icon icon-cloud-download' }),
            _etch2['default'].dom('span', { ref: 'downloadCount', className: 'value' })
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'body' },
          _etch2['default'].dom(
            'h4',
            { className: 'card-name' },
            _etch2['default'].dom(
              'a',
              { className: 'package-name', ref: 'packageName' },
              displayName
            ),
            _etch2['default'].dom(
              'span',
              { className: 'package-version' },
              _etch2['default'].dom(
                'span',
                { ref: 'versionValue', className: 'value' },
                String(this.pack.version)
              )
            ),
            _etch2['default'].dom(
              'span',
              { className: 'deprecation-badge highlight-warning inline-block' },
              'Deprecated'
            )
          ),
          _etch2['default'].dom(
            'span',
            { ref: 'packageDescription', className: 'package-description' },
            description
          ),
          _etch2['default'].dom('div', { ref: 'packageMessage', className: 'package-message' })
        ),
        _etch2['default'].dom(
          'div',
          { className: 'meta' },
          _etch2['default'].dom(
            'div',
            { ref: 'metaUserContainer', className: 'meta-user' },
            _etch2['default'].dom(
              'a',
              { ref: 'avatarLink', href: 'https://atom.io/users/' + owner },
              _etch2['default'].dom('img', { ref: 'avatar', className: 'avatar', src: 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7' })
            ),
            _etch2['default'].dom(
              'a',
              { ref: 'loginLink', className: 'author', href: 'https://atom.io/users/' + owner },
              owner
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'meta-controls' },
            _etch2['default'].dom(
              'div',
              { className: 'btn-toolbar' },
              _etch2['default'].dom(
                'div',
                { ref: 'updateButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn btn-info icon icon-cloud-download install-button', ref: 'updateButton' },
                  'Update'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'installAlternativeButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn btn-info icon icon-cloud-download install-button', ref: 'installAlternativeButton' },
                  'Install Alternative'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'installButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn btn-info icon icon-cloud-download install-button', ref: 'installButton' },
                  'Install'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'packageActionButtonGroup', className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn icon icon-gear settings', ref: 'settingsButton' },
                  'Settings'
                ),
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn icon icon-trashcan uninstall-button', ref: 'uninstallButton' },
                  'Uninstall'
                ),
                _etch2['default'].dom(
                  'button',
                  { type: 'button', className: 'btn icon icon-playback-pause enablement', ref: 'enablementButton' },
                  _etch2['default'].dom(
                    'span',
                    { className: 'disable-text' },
                    'Disable'
                  )
                ),
                _etch2['default'].dom('button', { type: 'button', className: 'btn status-indicator', tabIndex: '-1', ref: 'statusIndicator' })
              )
            )
          )
        )
      );
    }
  }, {
    key: 'locateCompatiblePackageVersion',
    value: function locateCompatiblePackageVersion(callback) {
      var _this = this;

      this.packageManager.loadCompatiblePackageVersion(this.pack.name, function (err, pack) {
        if (err != null) {
          console.error(err);
        }

        var packageVersion = pack.version;

        // A compatible version exist, we activate the install button and
        // set this.installablePack so that the install action installs the
        // compatible version of the package.
        if (packageVersion) {
          _this.refs.versionValue.textContent = packageVersion;
          if (packageVersion !== _this.pack.version) {
            _this.refs.versionValue.classList.add('text-warning');
            _this.refs.packageMessage.classList.add('text-warning');
            _this.refs.packageMessage.textContent = 'Version ' + packageVersion + ' is not the latest version available for this package, but it\'s the latest that is compatible with your version of Atom.';
          }

          _this.installablePack = pack;
          _this.hasCompatibleVersion = true;
        } else {
          _this.hasCompatibleVersion = false;
          _this.refs.versionValue.classList.add('text-error');
          _this.refs.packageMessage.classList.add('text-error');
          _this.refs.packageMessage.insertAdjacentText('beforeend', 'There\'s no version of this package that is compatible with your Atom version. The version must satisfy ' + _this.pack.engines.atom + '.');
          console.error('No available version compatible with the installed Atom version: ' + atom.getVersion());
        }

        callback();
      });
    }
  }, {
    key: 'handleButtonEvents',
    value: function handleButtonEvents(options) {
      var _this2 = this;

      if (options && options.onSettingsView) {
        this.refs.settingsButton.style.display = 'none';
      } else {
        (function () {
          var clickHandler = function clickHandler(event) {
            event.stopPropagation();
            _this2.settingsView.showPanel(_this2.pack.name, { back: options ? options.back : null, pack: _this2.pack });
          };

          _this2.element.addEventListener('click', clickHandler);
          _this2.disposables.add(new _atom.Disposable(function () {
            _this2.element.removeEventListener('click', clickHandler);
          }));

          _this2.refs.settingsButton.addEventListener('click', clickHandler);
          _this2.disposables.add(new _atom.Disposable(function () {
            _this2.refs.settingsButton.removeEventListener('click', clickHandler);
          }));
        })();
      }

      var installButtonClickHandler = function installButtonClickHandler(event) {
        event.stopPropagation();
        _this2.install();
      };
      this.refs.installButton.addEventListener('click', installButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.installButton.removeEventListener('click', installButtonClickHandler);
      }));

      var uninstallButtonClickHandler = function uninstallButtonClickHandler(event) {
        event.stopPropagation();
        _this2.uninstall();
      };
      this.refs.uninstallButton.addEventListener('click', uninstallButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.uninstallButton.removeEventListener('click', uninstallButtonClickHandler);
      }));

      var installAlternativeButtonClickHandler = function installAlternativeButtonClickHandler(event) {
        event.stopPropagation();
        _this2.installAlternative();
      };
      this.refs.installAlternativeButton.addEventListener('click', installAlternativeButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.installAlternativeButton.removeEventListener('click', installAlternativeButtonClickHandler);
      }));

      var updateButtonClickHandler = function updateButtonClickHandler(event) {
        event.stopPropagation();
        _this2.update().then(function () {
          var oldVersion = '';
          var newVersion = '';

          if (_this2.pack.apmInstallSource && _this2.pack.apmInstallSource.type === 'git') {
            oldVersion = _this2.pack.apmInstallSource.sha.substr(0, 8);
            newVersion = '' + _this2.pack.latestSha.substr(0, 8);
          } else if (_this2.pack.version && _this2.pack.latestVersion) {
            oldVersion = _this2.pack.version;
            newVersion = _this2.pack.latestVersion;
          }

          var detail = '';
          if (oldVersion && newVersion) {
            detail = oldVersion + ' -> ' + newVersion;
          }

          var notification = atom.notifications.addSuccess('Restart Atom to complete the update of `' + _this2.pack.name + '`.', {
            dismissable: true,
            buttons: [{
              text: 'Restart now',
              onDidClick: function onDidClick() {
                return atom.restartApplication();
              }
            }, {
              text: 'I\'ll do it later',
              onDidClick: function onDidClick() {
                notification.dismiss();
              }
            }],
            detail: detail
          });
        });
      };
      this.refs.updateButton.addEventListener('click', updateButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.updateButton.removeEventListener('click', updateButtonClickHandler);
      }));

      var packageNameClickHandler = function packageNameClickHandler(event) {
        event.stopPropagation();
        var packageType = _this2.pack.theme ? 'themes' : 'packages';
        _electron.shell.openExternal('https://atom.io/' + packageType + '/' + _this2.pack.name);
      };
      this.refs.packageName.addEventListener('click', packageNameClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.packageName.removeEventListener('click', packageNameClickHandler);
      }));

      var enablementButtonClickHandler = function enablementButtonClickHandler(event) {
        event.stopPropagation();
        event.preventDefault();
        if (_this2.isDisabled()) {
          atom.packages.enablePackage(_this2.pack.name);
        } else {
          atom.packages.disablePackage(_this2.pack.name);
        }
      };
      this.refs.enablementButton.addEventListener('click', enablementButtonClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.enablementButton.removeEventListener('click', enablementButtonClickHandler);
      }));

      var packageMessageClickHandler = function packageMessageClickHandler(event) {
        var target = event.target.closest('a');
        if (target) {
          event.stopPropagation();
          event.preventDefault();
          if (target.href && target.href.startsWith('atom:')) {
            atom.workspace.open(target.href);
          }
        }
      };
      this.refs.packageMessage.addEventListener('click', packageMessageClickHandler);
      this.disposables.add(new _atom.Disposable(function () {
        _this2.refs.packageMessage.removeEventListener('click', packageMessageClickHandler);
      }));
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'loadCachedMetadata',
    value: function loadCachedMetadata() {
      var _this3 = this;

      this.client.avatar((0, _utils.ownerFromRepository)(this.pack.repository), function (err, avatarPath) {
        if (!err && avatarPath) {
          _this3.refs.avatar.src = 'file://' + avatarPath;
        }
      });

      this.client['package'](this.pack.name, function (err, data) {
        // We don't need to actually handle the error here, we can just skip
        // showing the download count if there's a problem.
        if (!err) {
          if (data == null) {
            data = {};
          }

          if (_this3.pack.apmInstallSource && _this3.pack.apmInstallSource.type === 'git') {
            _this3.refs.downloadIcon.classList.remove('icon-cloud-download');
            _this3.refs.downloadIcon.classList.add('icon-git-branch');
            _this3.refs.downloadCount.textContent = _this3.pack.apmInstallSource.sha.substr(0, 8);
          } else {
            _this3.refs.stargazerCount.textContent = data.stargazers_count ? data.stargazers_count.toLocaleString() : '';
            _this3.refs.downloadCount.textContent = data.downloads ? data.downloads.toLocaleString() : '';
          }
        }
      });
    }
  }, {
    key: 'updateInterfaceState',
    value: function updateInterfaceState() {
      this.refs.versionValue.textContent = (this.installablePack ? this.installablePack.version : null) || this.pack.version;
      if (this.pack.apmInstallSource && this.pack.apmInstallSource.type === 'git') {
        this.refs.downloadCount.textContent = this.pack.apmInstallSource.sha.substr(0, 8);
      }

      this.updateSettingsState();
      this.updateInstalledState();
      this.updateDisabledState();
      this.updateDeprecatedState();
    }
  }, {
    key: 'updateSettingsState',
    value: function updateSettingsState() {
      if (this.hasSettings() && !this.onSettingsView) {
        this.refs.settingsButton.style.display = '';
      } else {
        this.refs.settingsButton.style.display = 'none';
      }
    }

    // Section: disabled state updates

  }, {
    key: 'updateDisabledState',
    value: function updateDisabledState() {
      if (this.isDisabled()) {
        this.displayDisabledState();
      } else if (this.element.classList.contains('disabled')) {
        this.displayEnabledState();
      }
    }
  }, {
    key: 'displayEnabledState',
    value: function displayEnabledState() {
      this.element.classList.remove('disabled');
      if (this.type === 'theme') {
        this.refs.enablementButton.style.display = 'none';
      }
      this.refs.enablementButton.querySelector('.disable-text').textContent = 'Disable';
      this.refs.enablementButton.classList.add('icon-playback-pause');
      this.refs.enablementButton.classList.remove('icon-playback-play');
      this.refs.statusIndicator.classList.remove('is-disabled');
    }
  }, {
    key: 'displayDisabledState',
    value: function displayDisabledState() {
      this.element.classList.add('disabled');
      this.refs.enablementButton.querySelector('.disable-text').textContent = 'Enable';
      this.refs.enablementButton.classList.add('icon-playback-play');
      this.refs.enablementButton.classList.remove('icon-playback-pause');
      this.refs.statusIndicator.classList.add('is-disabled');
      if (this.isDeprecated()) {
        this.refs.enablementButton.disabled = true;
      } else {
        this.refs.enablementButton.disabled = false;
      }
    }

    // Section: installed state updates

  }, {
    key: 'updateInstalledState',
    value: function updateInstalledState() {
      if (this.isInstalled()) {
        this.displayInstalledState();
      } else {
        this.displayNotInstalledState();
      }
    }
  }, {
    key: 'displayInstalledState',
    value: function displayInstalledState() {
      if (this.newVersion || this.newSha) {
        this.refs.updateButtonGroup.style.display = '';
        if (this.newVersion) {
          this.refs.updateButton.textContent = 'Update to ' + this.newVersion;
        } else if (this.newSha) {
          this.refs.updateButton.textContent = 'Update to ' + this.newSha.substr(0, 8);
        }
      } else {
        this.refs.updateButtonGroup.style.display = 'none';
      }

      this.refs.installButtonGroup.style.display = 'none';
      this.refs.installAlternativeButtonGroup.style.display = 'none';
      this.refs.packageActionButtonGroup.style.display = '';
      this.refs.uninstallButton.style.display = '';
    }
  }, {
    key: 'displayNotInstalledState',
    value: function displayNotInstalledState() {
      var _this4 = this;

      this.refs.uninstallButton.style.display = 'none';
      var atomVersion = this.packageManager.normalizeVersion(atom.getVersion());
      if (!this.packageManager.satisfiesVersion(atomVersion, this.pack)) {
        this.hasCompatibleVersion = false;
        this.setNotInstalledStateButtons();
        this.locateCompatiblePackageVersion(function () {
          _this4.setNotInstalledStateButtons();
        });
      } else {
        this.setNotInstalledStateButtons();
      }
    }
  }, {
    key: 'setNotInstalledStateButtons',
    value: function setNotInstalledStateButtons() {
      if (!this.hasCompatibleVersion) {
        this.refs.installButtonGroup.style.display = 'none';
        this.refs.updateButtonGroup.style.display = 'none';
      } else if (this.newVersion || this.newSha) {
        this.refs.updateButtonGroup.style.display = '';
        this.refs.installButtonGroup.style.display = 'none';
      } else {
        this.refs.updateButtonGroup.style.display = 'none';
        this.refs.installButtonGroup.style.display = '';
      }
      this.refs.installAlternativeButtonGroup.style.display = 'none';
      this.refs.packageActionButtonGroup.style.display = 'none';
    }

    // Section: deprecated state updates

  }, {
    key: 'updateDeprecatedState',
    value: function updateDeprecatedState() {
      if (this.isDeprecated()) {
        this.displayDeprecatedState();
      } else if (this.element.classList.contains('deprecated')) {
        this.displayUndeprecatedState();
      }
    }
  }, {
    key: 'displayStats',
    value: function displayStats(options) {
      if (options && options.stats && options.stats.downloads) {
        this.refs.packageDownloads.style.display = '';
      } else {
        this.refs.packageDownloads.style.display = 'none';
      }

      if (options && options.stats && options.stats.stars) {
        this.refs.packageStars.style.display = '';
      } else {
        this.refs.packageStars.style.display = 'none';
      }
    }
  }, {
    key: 'displayUndeprecatedState',
    value: function displayUndeprecatedState() {
      this.element.classList.remove('deprecated');
      this.refs.packageMessage.classList.remove('text-warning');
      this.refs.packageMessage.textContent = '';
    }
  }, {
    key: 'displayDeprecatedState',
    value: function displayDeprecatedState() {
      this.element.classList.add('deprecated');
      this.refs.settingsButton.disabled = true;

      var info = this.getDeprecatedPackageMetadata();
      this.refs.packageMessage.classList.add('text-warning');

      var message = null;
      if (info && info.hasDeprecations) {
        message = this.getDeprecationMessage(this.newVersion);
      } else if (info && info.hasAlternative && info.alternative === 'core') {
        message = info.message != null ? info.message : 'The features in `' + this.pack.name + '` have been added to core.';
        message += ' Please uninstall this package.';
        this.refs.settingsButton.remove();
        this.refs.enablementButton.remove();
      } else if (info && info.hasAlternative && info.alternative) {
        var alt = info.alternative;
        var isInstalled = this.isInstalled();
        if (isInstalled && this.packageManager.isPackageInstalled(alt)) {
          message = '`' + this.pack.name + '` has been replaced by `' + alt + '` which is already installed. Please uninstall this package.';
          this.refs.settingsButton.remove();
          this.refs.enablementButton.remove();
        } else if (isInstalled) {
          message = '`' + this.pack.name + '` has been replaced by [`' + alt + '`](atom://config/install/package:' + alt + ').';
          this.refs.installAlternativeButton.textContent = 'Install ' + alt;
          this.refs.installAlternativeButtonGroup.style.display = '';
          this.refs.packageActionButtonGroup.style.display = '';
          this.refs.settingsButton.remove();
          this.refs.enablementButton.remove();
        } else {
          message = '`' + this.pack.name + '` has been replaced by [`' + alt + '`](atom://config/install/package:' + alt + ').';
          this.refs.installButtonGroup.style.display = 'none';
          this.refs.installAlternativeButtonGroup.style.display = 'none';
          this.refs.packageActionButtonGroup.style.display = 'none';
        }
      }

      if (message != null) {
        if (marked == null) {
          marked = require('marked');
        }

        this.refs.packageMessage.innerHTML = marked(message, { breaks: true });
      }
    }
  }, {
    key: 'displayGitPackageInstallInformation',
    value: function displayGitPackageInstallInformation() {
      this.refs.metaUserContainer.remove();
      this.refs.statsContainer.remove();
      var gitUrlInfo = this.pack.gitUrlInfo;

      if (gitUrlInfo['default'] === 'shortcut') {
        this.refs.packageDescription.textContent = gitUrlInfo.https();
      } else {
        this.refs.packageDescription.textContent = gitUrlInfo.toString();
      }
      this.refs.installButton.classList.remove('icon-cloud-download');
      this.refs.installButton.classList.add('icon-git-commit');
      this.refs.updateButton.classList.remove('icon-cloud-download');
      this.refs.updateButton.classList.add('icon-git-commit');
    }
  }, {
    key: 'displayAvailableUpdate',
    value: function displayAvailableUpdate(newVersion) {
      this.newVersion = newVersion;
      this.updateInterfaceState();
    }
  }, {
    key: 'getDeprecationMessage',
    value: function getDeprecationMessage(newVersion) {
      var info = this.getDeprecatedPackageMetadata();
      if (!info || !info.hasDeprecations) {
        return;
      }

      if (newVersion) {
        if (this.isDeprecated(newVersion)) {
          return 'An update to `v' + newVersion + '` is available but still contains deprecations.';
        } else {
          return 'An update to `v' + newVersion + '` is available without deprecations.';
        }
      } else {
        if (this.isInstalled()) {
          return info.message != null ? info.message : 'This package has not been loaded due to using deprecated APIs. There is no update available.';
        } else {
          return 'This package has deprecations and is not installable.';
        }
      }
    }
  }, {
    key: 'handlePackageEvents',
    value: function handlePackageEvents() {
      var _this5 = this;

      this.disposables.add(atom.packages.onDidDeactivatePackage(function (pack) {
        if (pack.name === _this5.pack.name) {
          _this5.updateDisabledState();
        }
      }));

      this.disposables.add(atom.packages.onDidActivatePackage(function (pack) {
        if (pack.name === _this5.pack.name) {
          _this5.updateDisabledState();
        }
      }));

      this.disposables.add(atom.config.onDidChange('core.disabledPackages', function () {
        _this5.updateDisabledState();
      }));

      this.subscribeToPackageEvent('package-installing theme-installing', function () {
        _this5.updateInterfaceState();
        _this5.refs.installButton.disabled = true;
        _this5.refs.installButton.classList.add('is-installing');
      });

      this.subscribeToPackageEvent('package-updating theme-updating', function () {
        _this5.updateInterfaceState();
        _this5.refs.updateButton.disabled = true;
        _this5.refs.updateButton.classList.add('is-installing');
      });

      this.subscribeToPackageEvent('package-installing-alternative', function () {
        _this5.updateInterfaceState();
        _this5.refs.installAlternativeButton.disabled = true;
        _this5.refs.installAlternativeButton.classList.add('is-installing');
      });

      this.subscribeToPackageEvent('package-uninstalling theme-uninstalling', function () {
        _this5.updateInterfaceState();
        _this5.refs.enablementButton.disabled = true;
        _this5.refs.uninstallButton.disabled = true;
        _this5.refs.uninstallButton.classList.add('is-uninstalling');
      });

      this.subscribeToPackageEvent('package-installed package-install-failed theme-installed theme-install-failed', function () {
        var loadedPack = atom.packages.getLoadedPackage(_this5.pack.name);
        var version = loadedPack && loadedPack.metadata ? loadedPack.metadata.version : null;
        if (version) {
          _this5.pack.version = version;
        }
        _this5.refs.installButton.disabled = false;
        _this5.refs.installButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-updated theme-updated', function () {
        var loadedPack = atom.packages.getLoadedPackage(_this5.pack.name);
        var metadata = loadedPack ? loadedPack.metadata : null;
        if (metadata && metadata.version) {
          _this5.pack.version = metadata.version;
        }

        if (metadata && metadata.apmInstallSource) {
          _this5.pack.apmInstallSource = metadata.apmInstallSource;
        }

        _this5.newVersion = null;
        _this5.newSha = null;
        _this5.refs.updateButton.disabled = false;
        _this5.refs.updateButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-update-failed theme-update-failed', function () {
        _this5.refs.updateButton.disabled = false;
        _this5.refs.updateButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-uninstalled package-uninstall-failed theme-uninstalled theme-uninstall-failed', function () {
        _this5.newVersion = null;
        _this5.newSha = null;
        _this5.refs.enablementButton.disabled = false;
        _this5.refs.uninstallButton.disabled = false;
        _this5.refs.uninstallButton.classList.remove('is-uninstalling');
        _this5.updateInterfaceState();
      });

      this.subscribeToPackageEvent('package-installed-alternative package-install-alternative-failed', function () {
        _this5.refs.installAlternativeButton.disabled = false;
        _this5.refs.installAlternativeButton.classList.remove('is-installing');
        _this5.updateInterfaceState();
      });
    }
  }, {
    key: 'isInstalled',
    value: function isInstalled() {
      return this.packageManager.isPackageInstalled(this.pack.name);
    }
  }, {
    key: 'isDisabled',
    value: function isDisabled() {
      return atom.packages.isPackageDisabled(this.pack.name);
    }
  }, {
    key: 'isDeprecated',
    value: function isDeprecated(version) {
      var packVersion = version != null ? version : this.pack.version;
      return atom.packages.isDeprecatedPackage(this.pack.name, packVersion);
    }
  }, {
    key: 'getDeprecatedPackageMetadata',
    value: function getDeprecatedPackageMetadata() {
      return atom.packages.getDeprecatedPackageMetadata(this.pack.name);
    }
  }, {
    key: 'hasSettings',
    value: function hasSettings() {
      return this.packageManager.packageHasSettings(this.pack.name);
    }
  }, {
    key: 'subscribeToPackageEvent',
    value: function subscribeToPackageEvent(event, callback) {
      var _this6 = this;

      this.disposables.add(this.packageManager.on(event, function (_ref) {
        var pack = _ref.pack;
        var error = _ref.error;

        if (pack.pack != null) {
          pack = pack.pack;
        }

        var packageName = pack.name;
        if (packageName === _this6.pack.name) {
          callback(pack, error);
        }
      }));
    }

    /*
    Section: Methods that should be on a Package model
    */

  }, {
    key: 'install',
    value: function install() {
      var _this7 = this;

      this.packageManager.install(this.installablePack != null ? this.installablePack : this.pack, function (error) {
        if (error != null) {
          console.error('Installing ' + _this7.type + ' ' + _this7.pack.name + ' failed', error.stack != null ? error.stack : error, error.stderr);
        } else {
          // if a package was disabled before installing it, re-enable it
          if (_this7.isDisabled()) {
            atom.packages.enablePackage(_this7.pack.name);
          }
        }
      });
    }
  }, {
    key: 'update',
    value: function update() {
      var _this8 = this;

      if (!this.newVersion && !this.newSha) {
        return Promise.resolve();
      }

      var pack = this.installablePack != null ? this.installablePack : this.pack;
      var version = this.newVersion ? 'v' + this.newVersion : '#' + this.newSha.substr(0, 8);
      return new Promise(function (resolve, reject) {
        _this8.packageManager.update(pack, _this8.newVersion, function (error) {
          if (error != null) {
            atom.assert(false, 'Package update failed', function (assertionError) {
              assertionError.metadata = {
                type: _this8.type,
                name: pack.name,
                version: version,
                errorMessage: error.message,
                errorStack: error.stack,
                errorStderr: error.stderr
              };
            });
            console.error('Updating ' + _this8.type + ' ' + pack.name + ' to ' + version + ' failed:\n', error, error.stderr != null ? error.stderr : '');
            reject(error);
          } else {
            resolve();
          }
        });
      });
    }
  }, {
    key: 'uninstall',
    value: function uninstall() {
      var _this9 = this;

      this.packageManager.uninstall(this.pack, function (error) {
        if (error != null) {
          console.error('Uninstalling ' + _this9.type + ' ' + _this9.pack.name + ' failed', error.stack != null ? error.stack : error, error.stderr);
        }
      });
    }
  }, {
    key: 'installAlternative',
    value: function installAlternative() {
      var _this10 = this;

      var metadata = this.getDeprecatedPackageMetadata();
      var loadedPack = atom.packages.getLoadedPackage(metadata ? metadata.alternative : null);
      if (!metadata || !metadata.hasAlternative || metadata.alternative === 'core' || loadedPack) {
        return;
      }

      this.packageManager.installAlternative(this.pack, metadata.alternative, function (error, _ref2) {
        var pack = _ref2.pack;
        var alternative = _ref2.alternative;

        if (error != null) {
          console.error('Installing alternative `' + alternative + '` ' + _this10.type + ' for ' + _this10.pack.name + ' failed', error.stack != null ? error.stack : error, error.stderr);
        }
      });
    }
  }]);

  return PackageCard;
})();

exports['default'] = PackageCard;
module.exports = exports['default'];
/* A transparent gif so there is no "broken border" */
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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