Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _url = require('url');

var _url2 = _interopRequireDefault(_url);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _electron = require('electron');

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var _packageGrammarsView = require('./package-grammars-view');

var _packageGrammarsView2 = _interopRequireDefault(_packageGrammarsView);

var _packageKeymapView = require('./package-keymap-view');

var _packageKeymapView2 = _interopRequireDefault(_packageKeymapView);

var _packageReadmeView = require('./package-readme-view');

var _packageReadmeView2 = _interopRequireDefault(_packageReadmeView);

var _packageSnippetsView = require('./package-snippets-view');

var _packageSnippetsView2 = _interopRequireDefault(_packageSnippetsView);

var _settingsPanel = require('./settings-panel');

var _settingsPanel2 = _interopRequireDefault(_settingsPanel);

var NORMALIZE_PACKAGE_DATA_README_ERROR = 'ERROR: No README data found!';

var PackageDetailView = (function () {
  function PackageDetailView(pack, settingsView, packageManager, snippetsProvider) {
    var _this = this;

    _classCallCheck(this, PackageDetailView);

    this.pack = pack;
    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.snippetsProvider = snippetsProvider;
    this.disposables = new _atom.CompositeDisposable();
    _etch2['default'].initialize(this);
    this.loadPackage();

    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    var packageRepoClickHandler = function packageRepoClickHandler(event) {
      event.preventDefault();
      var repoUrl = _this.packageManager.getRepositoryUrl(_this.pack);
      if (typeof repoUrl === 'string') {
        if (_url2['default'].parse(repoUrl).pathname === '/atom/atom') {
          _electron.shell.openExternal(repoUrl + '/tree/master/packages/' + _this.pack.name);
        } else {
          _electron.shell.openExternal(repoUrl);
        }
      }
    };
    this.refs.packageRepo.addEventListener('click', packageRepoClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.packageRepo.removeEventListener('click', packageRepoClickHandler);
    }));

    var issueButtonClickHandler = function issueButtonClickHandler(event) {
      event.preventDefault();
      var bugUri = _this.packageManager.getRepositoryBugUri(_this.pack);
      if (bugUri) {
        _electron.shell.openExternal(bugUri);
      }
    };
    this.refs.issueButton.addEventListener('click', issueButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.issueButton.removeEventListener('click', issueButtonClickHandler);
    }));

    var changelogButtonClickHandler = function changelogButtonClickHandler(event) {
      event.preventDefault();
      if (_this.changelogPath) {
        _this.openMarkdownFile(_this.changelogPath);
      }
    };
    this.refs.changelogButton.addEventListener('click', changelogButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.changelogButton.removeEventListener('click', changelogButtonClickHandler);
    }));

    var licenseButtonClickHandler = function licenseButtonClickHandler(event) {
      event.preventDefault();
      if (_this.licensePath) {
        _this.openMarkdownFile(_this.licensePath);
      }
    };
    this.refs.licenseButton.addEventListener('click', licenseButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.licenseButton.removeEventListener('click', licenseButtonClickHandler);
    }));

    var openButtonClickHandler = function openButtonClickHandler(event) {
      event.preventDefault();
      if (_fsPlus2['default'].existsSync(_this.pack.path)) {
        atom.open({ pathsToOpen: [_this.pack.path] });
      }
    };
    this.refs.openButton.addEventListener('click', openButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.openButton.removeEventListener('click', openButtonClickHandler);
    }));

    var learnMoreButtonClickHandler = function learnMoreButtonClickHandler(event) {
      event.preventDefault();
      _electron.shell.openExternal('https://atom.io/packages/' + _this.pack.name);
    };
    this.refs.learnMoreButton.addEventListener('click', learnMoreButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.learnMoreButton.removeEventListener('click', learnMoreButtonClickHandler);
    }));

    var breadcrumbClickHandler = function breadcrumbClickHandler(event) {
      event.preventDefault();
      _this.settingsView.showPanel(_this.breadcrumbBackPanel);
    };
    this.refs.breadcrumb.addEventListener('click', breadcrumbClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.breadcrumb.removeEventListener('click', breadcrumbClickHandler);
    }));
  }

  _createClass(PackageDetailView, [{
    key: 'completeInitialization',
    value: function completeInitialization() {
      if (this.refs.packageCard) {
        this.packageCard = this.refs.packageCard.packageCard;
      } else if (!this.packageCard) {
        // Had to load this from the network
        this.packageCard = new _packageCard2['default'](this.pack.metadata, this.settingsView, this.packageManager, { onSettingsView: true });
        this.refs.packageCardParent.replaceChild(this.packageCard.element, this.refs.loadingMessage);
      }

      this.refs.packageRepo.classList.remove('hidden');
      this.refs.startupTime.classList.remove('hidden');
      this.refs.buttons.classList.remove('hidden');
      this.activateConfig();
      this.populate();
      this.updateFileButtons();
      this.subscribeToPackageManager();
      this.renderReadme();
    }
  }, {
    key: 'loadPackage',
    value: function loadPackage() {
      var loadedPackage = atom.packages.getLoadedPackage(this.pack.name);
      if (loadedPackage) {
        this.pack = loadedPackage;
        this.completeInitialization();
      } else {
        // If the package metadata in `@pack` isn't complete, hit the network.
        if (!this.pack.metadata || !this.pack.metadata.owner) {
          this.fetchPackage();
        } else {
          this.completeInitialization();
        }
      }
    }
  }, {
    key: 'fetchPackage',
    value: function fetchPackage() {
      var _this2 = this;

      this.showLoadingMessage();
      this.packageManager.getClient()['package'](this.pack.name, function (err, packageData) {
        if (err || !packageData || !packageData.name) {
          _this2.hideLoadingMessage();
          _this2.showErrorMessage();
        } else {
          _this2.pack = packageData;
          // TODO: this should match Package.loadMetadata from core, but this is
          // an acceptable hacky workaround
          _this2.pack.metadata = _underscorePlus2['default'].extend(_this2.pack.metadata != null ? _this2.pack.metadata : {}, _this2.pack);
          _this2.completeInitialization();
        }
      });
    }
  }, {
    key: 'showLoadingMessage',
    value: function showLoadingMessage() {
      this.refs.loadingMessage.classList.remove('hidden');
    }
  }, {
    key: 'hideLoadingMessage',
    value: function hideLoadingMessage() {
      this.refs.loadingMessage.classList.add('hidden');
    }
  }, {
    key: 'showErrorMessage',
    value: function showErrorMessage() {
      this.refs.errorMessage.classList.remove('hidden');
    }
  }, {
    key: 'hideErrorMessage',
    value: function hideErrorMessage() {
      this.refs.errorMessage.classList.add('hidden');
    }
  }, {
    key: 'activateConfig',
    value: function activateConfig() {
      // Package.activateConfig() is part of the Private package API and should not be used outside of core.
      if (atom.packages.isPackageLoaded(this.pack.name) && !atom.packages.isPackageActive(this.pack.name)) {
        this.pack.activateConfig();
      }
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      if (this.settingsPanel) {
        this.settingsPanel.destroy();
        this.settingsPanel = null;
      }

      if (this.keymapView) {
        this.keymapView.destroy();
        this.keymapView = null;
      }

      if (this.grammarsView) {
        this.grammarsView.destroy();
        this.grammarsView = null;
      }

      if (this.snippetsView) {
        this.snippetsView.destroy();
        this.snippetsView = null;
      }

      if (this.readmeView) {
        this.readmeView.destroy();
        this.readmeView = null;
      }

      if (this.packageCard) {
        this.packageCard.destroy();
        this.packageCard = null;
      }

      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'beforeShow',
    value: function beforeShow(opts) {
      if (opts.back == null) {
        opts.back = 'Install';
      }

      this.breadcrumbBackPanel = opts.back;
      this.refs.breadcrumb.textContent = this.breadcrumbBackPanel;
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'render',
    value: function render() {
      var packageCardView = undefined;
      if (this.pack && this.pack.metadata && this.pack.metadata.owner) {
        packageCardView = _etch2['default'].dom(
          'div',
          { ref: 'packageCardParent', className: 'row' },
          _etch2['default'].dom(PackageCardComponent, {
            ref: 'packageCard',
            settingsView: this.settingsView,
            packageManager: this.packageManager,
            metadata: this.pack.metadata,
            options: { onSettingsView: true } })
        );
      } else {
        packageCardView = _etch2['default'].dom(
          'div',
          { ref: 'packageCardParent', className: 'row' },
          _etch2['default'].dom(
            'div',
            { ref: 'loadingMessage', className: 'alert alert-info icon icon-hourglass' },
            'Loading ' + this.pack.name + '…'
          ),
          _etch2['default'].dom(
            'div',
            { ref: 'errorMessage', className: 'alert alert-danger icon icon-hourglass hidden' },
            'Failed to load ',
            this.pack.name,
            ' - try again later.'
          )
        );
      }
      return _etch2['default'].dom(
        'div',
        { tabIndex: '0', className: 'package-detail' },
        _etch2['default'].dom(
          'ol',
          { ref: 'breadcrumbContainer', className: 'native-key-bindings breadcrumb', tabIndex: '-1' },
          _etch2['default'].dom(
            'li',
            null,
            _etch2['default'].dom('a', { ref: 'breadcrumb' })
          ),
          _etch2['default'].dom(
            'li',
            { className: 'active' },
            _etch2['default'].dom('a', { ref: 'title' })
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'panels-item' },
          _etch2['default'].dom(
            'section',
            { className: 'section' },
            _etch2['default'].dom(
              'form',
              { className: 'section-container package-detail-view' },
              _etch2['default'].dom(
                'div',
                { className: 'container package-container' },
                packageCardView
              ),
              _etch2['default'].dom('p', { ref: 'packageRepo', className: 'link icon icon-repo repo-link hidden' }),
              _etch2['default'].dom('p', { ref: 'startupTime', className: 'text icon icon-dashboard hidden', tabIndex: '-1' }),
              _etch2['default'].dom(
                'div',
                { ref: 'buttons', className: 'btn-wrap-group hidden' },
                _etch2['default'].dom(
                  'button',
                  { ref: 'learnMoreButton', className: 'btn btn-default icon icon-link' },
                  'View on Atom.io'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'issueButton', className: 'btn btn-default icon icon-bug' },
                  'Report Issue'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'changelogButton', className: 'btn btn-default icon icon-squirrel' },
                  'CHANGELOG'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'licenseButton', className: 'btn btn-default icon icon-law' },
                  'LICENSE'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'openButton', className: 'btn btn-default icon icon-link-external' },
                  'View Code'
                )
              ),
              _etch2['default'].dom('div', { ref: 'errors' })
            )
          ),
          _etch2['default'].dom('div', { ref: 'sections' })
        )
      );
    }
  }, {
    key: 'populate',
    value: function populate() {
      this.refs.title.textContent = '' + _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(this.pack.name));
      this.type = this.pack.metadata.theme ? 'theme' : 'package';

      var repoUrl = this.packageManager.getRepositoryUrl(this.pack);
      if (repoUrl) {
        var repoName = _url2['default'].parse(repoUrl).pathname;
        this.refs.packageRepo.textContent = repoName.substring(1);
        this.refs.packageRepo.style.display = '';
      } else {
        this.refs.packageRepo.style.display = 'none';
      }

      this.updateInstalledState();
    }
  }, {
    key: 'updateInstalledState',
    value: function updateInstalledState() {
      if (this.settingsPanel) {
        this.settingsPanel.destroy();
        this.settingsPanel = null;
      }

      if (this.keymapView) {
        this.keymapView.destroy();
        this.keymapView = null;
      }

      if (this.grammarsView) {
        this.grammarsView.destroy();
        this.grammarsView = null;
      }

      if (this.snippetsView) {
        this.snippetsView.destroy();
        this.snippetsView = null;
      }

      if (this.readmeView) {
        this.readmeView.destroy();
        this.readmeView = null;
      }

      this.updateFileButtons();
      this.activateConfig();
      this.refs.startupTime.style.display = 'none';

      if (atom.packages.isPackageLoaded(this.pack.name)) {
        if (!atom.packages.isPackageDisabled(this.pack.name)) {
          this.settingsPanel = new _settingsPanel2['default']({ namespace: this.pack.name, includeTitle: false });
          this.keymapView = new _packageKeymapView2['default'](this.pack);
          this.refs.sections.appendChild(this.settingsPanel.element);
          this.refs.sections.appendChild(this.keymapView.element);

          if (this.pack.path) {
            this.grammarsView = new _packageGrammarsView2['default'](this.pack.path);
            this.snippetsView = new _packageSnippetsView2['default'](this.pack, this.snippetsProvider);
            this.refs.sections.appendChild(this.grammarsView.element);
            this.refs.sections.appendChild(this.snippetsView.element);
          }

          this.refs.startupTime.innerHTML = 'This ' + this.type + ' added <span class=\'highlight\'>' + this.getStartupTime() + 'ms</span> to startup time.';
          this.refs.startupTime.style.display = '';
        }
      }

      var sourceIsAvailable = this.packageManager.isPackageInstalled(this.pack.name) && !atom.packages.isBundledPackage(this.pack.name);
      if (sourceIsAvailable) {
        this.refs.openButton.style.display = '';
      } else {
        this.refs.openButton.style.display = 'none';
      }

      this.renderReadme();
    }
  }, {
    key: 'renderReadme',
    value: function renderReadme() {
      var readme = undefined;
      if (this.pack.metadata.readme && this.pack.metadata.readme.trim() !== NORMALIZE_PACKAGE_DATA_README_ERROR) {
        readme = this.pack.metadata.readme;
      } else {
        readme = null;
      }

      if (this.readmePath && _fsPlus2['default'].statSync(this.readmePath).isFile() && !readme) {
        readme = _fsPlus2['default'].readFileSync(this.readmePath, { encoding: 'utf8' });
      }

      var readmeSrc = undefined;

      if (this.pack.path) {
        // If package is installed, use installed path
        readmeSrc = this.pack.path;
      } else {
        // If package isn't installed, use url path
        var repoUrl = this.packageManager.getRepositoryUrl(this.pack);

        // Check if URL is undefined (i.e. package is unpublished)
        if (repoUrl) {
          readmeSrc = repoUrl + '/blob/master/';
        }
      }

      var readmeView = new _packageReadmeView2['default'](readme, readmeSrc);
      if (this.readmeView) {
        this.readmeView.element.parentElement.replaceChild(readmeView.element, this.readmeView.element);
        this.readmeView.destroy();
      } else {
        this.refs.sections.appendChild(readmeView.element);
      }
      this.readmeView = readmeView;
    }
  }, {
    key: 'subscribeToPackageManager',
    value: function subscribeToPackageManager() {
      var _this3 = this;

      this.disposables.add(this.packageManager.on('theme-installed package-installed', function (_ref) {
        var pack = _ref.pack;

        if (_this3.pack.name === pack.name) {
          _this3.loadPackage();
          _this3.updateInstalledState();
        }
      }));

      this.disposables.add(this.packageManager.on('theme-uninstalled package-uninstalled', function (_ref2) {
        var pack = _ref2.pack;

        if (_this3.pack.name === pack.name) {
          return _this3.updateInstalledState();
        }
      }));

      this.disposables.add(this.packageManager.on('theme-updated package-updated', function (_ref3) {
        var pack = _ref3.pack;

        if (_this3.pack.name === pack.name) {
          _this3.loadPackage();
          _this3.updateFileButtons();
          _this3.populate();
        }
      }));
    }
  }, {
    key: 'openMarkdownFile',
    value: function openMarkdownFile(path) {
      if (atom.packages.isPackageActive('markdown-preview')) {
        atom.workspace.open(encodeURI('markdown-preview://' + path));
      } else {
        atom.workspace.open(path);
      }
    }
  }, {
    key: 'updateFileButtons',
    value: function updateFileButtons() {
      this.changelogPath = null;
      this.licensePath = null;
      this.readmePath = null;

      var packagePath = this.pack.path != null ? this.pack.path : atom.packages.resolvePackagePath(this.pack.name);
      for (var child of _fsPlus2['default'].listSync(packagePath)) {
        switch (_path2['default'].basename(child, _path2['default'].extname(child)).toLowerCase()) {
          case 'changelog':
          case 'history':
            this.changelogPath = child;
            break;
          case 'license':
          case 'licence':
            this.licensePath = child;
            break;
          case 'readme':
            this.readmePath = child;
            break;
        }

        if (this.readmePath && this.changelogPath && this.licensePath) {
          break;
        }
      }

      if (this.changelogPath) {
        this.refs.changelogButton.style.display = '';
      } else {
        this.refs.changelogButton.style.display = 'none';
      }

      if (this.licensePath) {
        this.refs.licenseButton.style.display = '';
      } else {
        this.refs.licenseButton.style.display = 'none';
      }
    }
  }, {
    key: 'getStartupTime',
    value: function getStartupTime() {
      var loadTime = this.pack.loadTime != null ? this.pack.loadTime : 0;
      var activateTime = this.pack.activateTime != null ? this.pack.activateTime : 0;
      return loadTime + activateTime;
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return PackageDetailView;
})();

exports['default'] = PackageDetailView;

var PackageCardComponent = (function () {
  function PackageCardComponent(props) {
    _classCallCheck(this, PackageCardComponent);

    this.packageCard = new _packageCard2['default'](props.metadata, props.settingsView, props.packageManager, props.options);
    this.element = this.packageCard.element;
  }

  _createClass(PackageCardComponent, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {}
  }]);

  return PackageCardComponent;
})();

module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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