Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _keybindingsPanel = require('./keybindings-panel');

var _keybindingsPanel2 = _interopRequireDefault(_keybindingsPanel);

// Displays the keybindings for a package namespace

var PackageKeymapView = (function () {
  function PackageKeymapView(pack) {
    var _this = this;

    _classCallCheck(this, PackageKeymapView);

    this.pack = pack;
    this.otherPlatformPattern = new RegExp('\\.platform-(?!' + _underscorePlus2['default'].escapeRegExp(process.platform) + '\\b)');
    this.namespace = this.pack.name;
    this.disposables = new _atom.CompositeDisposable();
    _etch2['default'].initialize(this);

    var packagesWithKeymapsDisabled = atom.config.get('core.packagesWithKeymapsDisabled') || [];
    this.refs.keybindingToggle.checked = !packagesWithKeymapsDisabled.includes(this.namespace);

    var changeHandler = function changeHandler(event) {
      event.stopPropagation();
      var value = _this.refs.keybindingToggle.checked;
      if (value) {
        atom.config.removeAtKeyPath('core.packagesWithKeymapsDisabled', _this.namespace);
      } else {
        atom.config.pushAtKeyPath('core.packagesWithKeymapsDisabled', _this.namespace);
      }

      _this.updateKeyBindingView();
    };
    this.refs.keybindingToggle.addEventListener('change', changeHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.keybindingToggle.removeEventListener('change', changeHandler);
    }));

    var copyIconClickHandler = function copyIconClickHandler(event) {
      var target = event.target.closest('.copy-icon');
      if (target) {
        event.preventDefault();
        event.stopPropagation();
        _this.writeKeyBindingToClipboard(target.closest('tr').dataset);
      }
    };
    this.element.addEventListener('click', copyIconClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.element.removeEventListener('click', copyIconClickHandler);
    }));

    this.updateKeyBindingView();

    var hasKeymaps = false;
    // eslint-disable-next-line no-unused-vars
    for (var _ref3 of atom.packages.getLoadedPackage(this.namespace).keymaps) {
      var _ref2 = _slicedToArray(_ref3, 2);

      var packageKeymapsPath = _ref2[0];
      var keymap = _ref2[1];

      if (keymap.length > 0) {
        hasKeymaps = true;
        break;
      }
    }

    if (this.refs.keybindingItems.children.length === 0 && !hasKeymaps) {
      this.element.style.display = 'none';
    }
  }

  _createClass(PackageKeymapView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'section',
        { className: 'section' },
        _etch2['default'].dom(
          'div',
          { className: 'section-heading icon icon-keyboard' },
          'Keybindings'
        ),
        _etch2['default'].dom(
          'div',
          { className: 'checkbox' },
          _etch2['default'].dom(
            'label',
            { 'for': 'toggleKeybindings' },
            _etch2['default'].dom('input', { id: 'toggleKeybindings', className: 'input-checkbox', type: 'checkbox', ref: 'keybindingToggle' }),
            _etch2['default'].dom(
              'div',
              { className: 'setting-title' },
              'Enable'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'setting-description' },
            "Disable this if you want to bind your own keystrokes for this package's commands in your keymap."
          )
        ),
        _etch2['default'].dom(
          'table',
          { className: 'package-keymap-table table native-key-bindings text', tabIndex: '-1' },
          _etch2['default'].dom(
            'thead',
            null,
            _etch2['default'].dom(
              'tr',
              null,
              _etch2['default'].dom(
                'th',
                null,
                'Keystroke'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Command'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Selector'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Source'
              )
            )
          ),
          _etch2['default'].dom('tbody', { ref: 'keybindingItems' })
        )
      );
    }
  }, {
    key: 'updateKeyBindingView',
    value: function updateKeyBindingView() {
      this.refs.keybindingItems.innerHTML = '';

      var packagesWithKeymapsDisabled = atom.config.get('core.packagesWithKeymapsDisabled') || [];
      var keybindingsDisabled = packagesWithKeymapsDisabled.includes(this.namespace);
      if (keybindingsDisabled) {
        this.refs.keybindingItems.classList.add('text-subtle');
      } else {
        this.refs.keybindingItems.classList.remove('text-subtle');
      }

      var keyBindings = [];
      if (atom.keymaps.build) {
        // eslint-disable-next-line no-unused-vars
        for (var _ref43 of atom.packages.getLoadedPackage(this.namespace).keymaps) {
          var _ref42 = _slicedToArray(_ref43, 2);

          var keymapPath = _ref42[0];
          var keymap = _ref42[1];

          keyBindings.push.apply(keyBindings, _toConsumableArray(atom.keymaps.build(this.namespace, keymap, 0, false)));
        }
      } else {
        // Backwards compatibility for Atom <= 1.19
        for (var keyBinding of atom.keymaps.getKeyBindings()) {
          var command = keyBinding.command;

          if (command && command.indexOf && command.indexOf(this.namespace + ':') === 0) {
            keyBindings.push(keyBinding);
          }
        }
      }

      for (var keyBinding of keyBindings) {
        var command = keyBinding.command;
        var keystrokes = keyBinding.keystrokes;
        var selector = keyBinding.selector;
        var source = keyBinding.source;

        if (!command) {
          continue;
        }

        if (this.otherPlatformPattern.test(selector)) {
          continue;
        }

        var keyBindingRow = document.createElement('tr');
        keyBindingRow.dataset.selector = selector;
        keyBindingRow.dataset.keystrokes = keystrokes;
        keyBindingRow.dataset.command = command;

        var keystrokesTd = document.createElement('td');

        var copyIconSpan = document.createElement('span');
        copyIconSpan.classList.add('icon', 'icon-clippy', 'copy-icon');
        keystrokesTd.appendChild(copyIconSpan);

        var keystrokesSpan = document.createElement('span');
        keystrokesSpan.textContent = keystrokes;
        keystrokesTd.appendChild(keystrokesSpan);

        keyBindingRow.appendChild(keystrokesTd);

        var commandTd = document.createElement('td');
        commandTd.textContent = command;
        keyBindingRow.appendChild(commandTd);

        var selectorTd = document.createElement('td');
        selectorTd.textContent = selector;
        keyBindingRow.appendChild(selectorTd);

        var sourceTd = document.createElement('td');
        sourceTd.textContent = _keybindingsPanel2['default'].determineSource(source);
        keyBindingRow.appendChild(sourceTd);

        this.refs.keybindingItems.appendChild(keyBindingRow);
      }
    }
  }, {
    key: 'writeKeyBindingToClipboard',
    value: function writeKeyBindingToClipboard(_ref5) {
      var selector = _ref5.selector;
      var keystrokes = _ref5.keystrokes;
      var command = _ref5.command;

      var content = undefined;
      var keymapExtension = _path2['default'].extname(atom.keymaps.getUserKeymapPath());
      if (keymapExtension === '.cson') {
        content = '\'' + selector + '\':\n  \'' + keystrokes + '\': \'' + command + '\'';
      } else {
        content = '"' + selector + '": {\n  "' + keystrokes + '": "' + command + '"\n}';
      }

      atom.clipboard.write(content);
    }
  }]);

  return PackageKeymapView;
})();

exports['default'] = PackageKeymapView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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