Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _marked = require('marked');

var _marked2 = _interopRequireDefault(_marked);

var _dompurify = require('dompurify');

var _dompurify2 = _interopRequireDefault(_dompurify);

function sanitize(html, readmeSrc) {
  var temporaryContainer = document.createElement('div');
  temporaryContainer.innerHTML = html;

  for (var checkbox of temporaryContainer.querySelectorAll('input[type="checkbox"]')) {
    checkbox.setAttribute('disabled', '');
  }

  var path = require('path');

  for (var image of temporaryContainer.querySelectorAll('img')) {
    var imageSrc = image.getAttribute('src');

    var changeImageSrc = true;

    // If src contains a protocol then it must be absolute
    if (/^(?:[a-z]+:)?\/\//i.test(imageSrc)) {
      changeImageSrc = false;
    }

    // If src contains a base64 encoded image it must be left unchanged
    if (/^data:image\/.*;base64/i.test(imageSrc)) {
      changeImageSrc = false;
    }

    // If path is absolute on file system it must be a local file, e.g. emoji
    if (path.isAbsolute(imageSrc)) {
      changeImageSrc = false;
    }

    // If imageSrc needs changing and readmeSrc isn't undefined (i.e. if package was unpublished)
    if (changeImageSrc && readmeSrc) {
      if (path.isAbsolute(readmeSrc)) {
        // If repoUrl is a local path (i.e. package is installed)
        image.setAttribute('src', path.join(readmeSrc, imageSrc));
      } else {
        // If repoUrl is a URL (i.e. package isn't installed)
        image.setAttribute('src', new URL(imageSrc, readmeSrc));
      }
    }
  }

  return (0, _dompurify2['default'])().sanitize(temporaryContainer.innerHTML);
}

// Displays the readme for a package, if it has one
// TODO Decide to keep this or current button-to-new-tab view

var PackageReadmeView = (function () {
  function PackageReadmeView(readme, readmeSrc) {
    var _this = this;

    _classCallCheck(this, PackageReadmeView);

    this.element = document.createElement('section');
    this.element.classList.add('section');

    var container = document.createElement('div');
    container.classList.add('section-container');

    var heading = document.createElement('div');
    heading.classList.add('section-heading', 'icon', 'icon-book');
    heading.textContent = 'README';
    container.appendChild(heading);

    this.packageReadme = document.createElement('div');
    this.packageReadme.classList.add('package-readme', 'native-key-bindings');
    this.packageReadme.tabIndex = -1;
    container.appendChild(this.packageReadme);
    this.element.appendChild(container);

    (0, _marked2['default'])(readme || '### No README.', { breaks: false }, function (err, content) {
      if (err) {
        _this.packageReadme.innerHTML = '<h3>Error parsing README</h3>';
      } else {
        _this.packageReadme.innerHTML = sanitize(content, readmeSrc);
      }
    });
  }

  _createClass(PackageReadmeView, [{
    key: 'destroy',
    value: function destroy() {
      this.element.remove();
    }
  }]);

  return PackageReadmeView;
})();

exports['default'] = PackageReadmeView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL3NldHRpbmdzLXZpZXcvbGliL3BhY2thZ2UtcmVhZG1lLXZpZXcuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7O3NCQUVtQixRQUFROzs7O3lCQUNDLFdBQVc7Ozs7QUFFdkMsU0FBUyxRQUFRLENBQUUsSUFBSSxFQUFFLFNBQVMsRUFBRTtBQUNsQyxNQUFNLGtCQUFrQixHQUFHLFFBQVEsQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLENBQUE7QUFDeEQsb0JBQWtCLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQTs7QUFFbkMsT0FBSyxJQUFNLFFBQVEsSUFBSSxrQkFBa0IsQ0FBQyxnQkFBZ0IsQ0FBQyx3QkFBd0IsQ0FBQyxFQUFFO0FBQ3BGLFlBQVEsQ0FBQyxZQUFZLENBQUMsVUFBVSxFQUFFLEVBQUUsQ0FBQyxDQUFBO0dBQ3RDOztBQUVELE1BQUksSUFBSSxHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQTs7QUFFMUIsT0FBSyxJQUFNLEtBQUssSUFBSSxrQkFBa0IsQ0FBQyxnQkFBZ0IsQ0FBQyxLQUFLLENBQUMsRUFBRTtBQUM5RCxRQUFJLFFBQVEsR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxDQUFBOztBQUV4QyxRQUFJLGNBQWMsR0FBRyxJQUFJLENBQUE7OztBQUd6QixRQUFJLG9CQUFvQixDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsRUFBRTtBQUN2QyxvQkFBYyxHQUFHLEtBQUssQ0FBQTtLQUN2Qjs7O0FBR0QsUUFBSSx5QkFBeUIsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLEVBQUU7QUFDNUMsb0JBQWMsR0FBRyxLQUFLLENBQUE7S0FDdkI7OztBQUdELFFBQUksSUFBSSxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsRUFBRTtBQUM3QixvQkFBYyxHQUFHLEtBQUssQ0FBQTtLQUN2Qjs7O0FBR0QsUUFBSSxjQUFjLElBQUksU0FBUyxFQUFFO0FBQy9CLFVBQUksSUFBSSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsRUFBRTs7QUFFOUIsYUFBSyxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsUUFBUSxDQUFDLENBQUMsQ0FBQTtPQUMxRCxNQUFNOztBQUVMLGFBQUssQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLElBQUksR0FBRyxDQUFDLFFBQVEsRUFBRSxTQUFTLENBQUMsQ0FBQyxDQUFBO09BQ3hEO0tBQ0Y7R0FDRjs7QUFFRCxTQUFPLDZCQUFpQixDQUFDLFFBQVEsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQTtDQUNoRTs7Ozs7SUFJb0IsaUJBQWlCO0FBQ3hCLFdBRE8saUJBQWlCLENBQ3ZCLE1BQU0sRUFBRSxTQUFTLEVBQUU7OzswQkFEYixpQkFBaUI7O0FBRWxDLFFBQUksQ0FBQyxPQUFPLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxTQUFTLENBQUMsQ0FBQTtBQUNoRCxRQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsU0FBUyxDQUFDLENBQUE7O0FBRXJDLFFBQU0sU0FBUyxHQUFHLFFBQVEsQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLENBQUE7QUFDL0MsYUFBUyxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsbUJBQW1CLENBQUMsQ0FBQTs7QUFFNUMsUUFBTSxPQUFPLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQTtBQUM3QyxXQUFPLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxNQUFNLEVBQUUsV0FBVyxDQUFDLENBQUE7QUFDN0QsV0FBTyxDQUFDLFdBQVcsR0FBRyxRQUFRLENBQUE7QUFDOUIsYUFBUyxDQUFDLFdBQVcsQ0FBQyxPQUFPLENBQUMsQ0FBQTs7QUFFOUIsUUFBSSxDQUFDLGFBQWEsR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFBO0FBQ2xELFFBQUksQ0FBQyxhQUFhLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxnQkFBZ0IsRUFBRSxxQkFBcUIsQ0FBQyxDQUFBO0FBQ3pFLFFBQUksQ0FBQyxhQUFhLENBQUMsUUFBUSxHQUFHLENBQUMsQ0FBQyxDQUFBO0FBQ2hDLGFBQVMsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFBO0FBQ3pDLFFBQUksQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLFNBQVMsQ0FBQyxDQUFBOztBQUVuQyw2QkFBTyxNQUFNLElBQUksZ0JBQWdCLEVBQUUsRUFBQyxNQUFNLEVBQUUsS0FBSyxFQUFDLEVBQUUsVUFBQyxHQUFHLEVBQUUsT0FBTyxFQUFLO0FBQ3BFLFVBQUksR0FBRyxFQUFFO0FBQ1AsY0FBSyxhQUFhLENBQUMsU0FBUyxHQUFHLCtCQUErQixDQUFBO09BQy9ELE1BQU07QUFDTCxjQUFLLGFBQWEsQ0FBQyxTQUFTLEdBQUcsUUFBUSxDQUFDLE9BQU8sRUFBRSxTQUFTLENBQUMsQ0FBQTtPQUM1RDtLQUNGLENBQUMsQ0FBQTtHQUNIOztlQTFCa0IsaUJBQWlCOztXQTRCNUIsbUJBQUc7QUFDVCxVQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sRUFBRSxDQUFBO0tBQ3RCOzs7U0E5QmtCLGlCQUFpQjs7O3FCQUFqQixpQkFBaUIiLCJmaWxlIjoiL2J1aWxkL2F0b20vc3JjL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvc2V0dGluZ3Mtdmlldy9saWIvcGFja2FnZS1yZWFkbWUtdmlldy5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qKiBAYmFiZWwgKi9cblxuaW1wb3J0IG1hcmtlZCBmcm9tICdtYXJrZWQnXG5pbXBvcnQgY3JlYXRlRE9NUHVyaWZ5IGZyb20gJ2RvbXB1cmlmeSdcblxuZnVuY3Rpb24gc2FuaXRpemUgKGh0bWwsIHJlYWRtZVNyYykge1xuICBjb25zdCB0ZW1wb3JhcnlDb250YWluZXIgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKVxuICB0ZW1wb3JhcnlDb250YWluZXIuaW5uZXJIVE1MID0gaHRtbFxuXG4gIGZvciAoY29uc3QgY2hlY2tib3ggb2YgdGVtcG9yYXJ5Q29udGFpbmVyLnF1ZXJ5U2VsZWN0b3JBbGwoJ2lucHV0W3R5cGU9XCJjaGVja2JveFwiXScpKSB7XG4gICAgY2hlY2tib3guc2V0QXR0cmlidXRlKCdkaXNhYmxlZCcsICcnKVxuICB9XG5cbiAgbGV0IHBhdGggPSByZXF1aXJlKCdwYXRoJylcblxuICBmb3IgKGNvbnN0IGltYWdlIG9mIHRlbXBvcmFyeUNvbnRhaW5lci5xdWVyeVNlbGVjdG9yQWxsKCdpbWcnKSkge1xuICAgIGxldCBpbWFnZVNyYyA9IGltYWdlLmdldEF0dHJpYnV0ZSgnc3JjJylcblxuICAgIGxldCBjaGFuZ2VJbWFnZVNyYyA9IHRydWVcblxuICAgIC8vIElmIHNyYyBjb250YWlucyBhIHByb3RvY29sIHRoZW4gaXQgbXVzdCBiZSBhYnNvbHV0ZVxuICAgIGlmICgvXig/OlthLXpdKzopP1xcL1xcLy9pLnRlc3QoaW1hZ2VTcmMpKSB7XG4gICAgICBjaGFuZ2VJbWFnZVNyYyA9IGZhbHNlXG4gICAgfVxuXG4gICAgLy8gSWYgc3JjIGNvbnRhaW5zIGEgYmFzZTY0IGVuY29kZWQgaW1hZ2UgaXQgbXVzdCBiZSBsZWZ0IHVuY2hhbmdlZFxuICAgIGlmICgvXmRhdGE6aW1hZ2VcXC8uKjtiYXNlNjQvaS50ZXN0KGltYWdlU3JjKSkge1xuICAgICAgY2hhbmdlSW1hZ2VTcmMgPSBmYWxzZVxuICAgIH1cblxuICAgIC8vIElmIHBhdGggaXMgYWJzb2x1dGUgb24gZmlsZSBzeXN0ZW0gaXQgbXVzdCBiZSBhIGxvY2FsIGZpbGUsIGUuZy4gZW1vamlcbiAgICBpZiAocGF0aC5pc0Fic29sdXRlKGltYWdlU3JjKSkge1xuICAgICAgY2hhbmdlSW1hZ2VTcmMgPSBmYWxzZVxuICAgIH1cblxuICAgIC8vIElmIGltYWdlU3JjIG5lZWRzIGNoYW5naW5nIGFuZCByZWFkbWVTcmMgaXNuJ3QgdW5kZWZpbmVkIChpLmUuIGlmIHBhY2thZ2Ugd2FzIHVucHVibGlzaGVkKVxuICAgIGlmIChjaGFuZ2VJbWFnZVNyYyAmJiByZWFkbWVTcmMpIHtcbiAgICAgIGlmIChwYXRoLmlzQWJzb2x1dGUocmVhZG1lU3JjKSkge1xuICAgICAgICAvLyBJZiByZXBvVXJsIGlzIGEgbG9jYWwgcGF0aCAoaS5lLiBwYWNrYWdlIGlzIGluc3RhbGxlZClcbiAgICAgICAgaW1hZ2Uuc2V0QXR0cmlidXRlKCdzcmMnLCBwYXRoLmpvaW4ocmVhZG1lU3JjLCBpbWFnZVNyYykpXG4gICAgICB9IGVsc2Uge1xuICAgICAgICAvLyBJZiByZXBvVXJsIGlzIGEgVVJMIChpLmUuIHBhY2thZ2UgaXNuJ3QgaW5zdGFsbGVkKVxuICAgICAgICBpbWFnZS5zZXRBdHRyaWJ1dGUoJ3NyYycsIG5ldyBVUkwoaW1hZ2VTcmMsIHJlYWRtZVNyYykpXG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIGNyZWF0ZURPTVB1cmlmeSgpLnNhbml0aXplKHRlbXBvcmFyeUNvbnRhaW5lci5pbm5lckhUTUwpXG59XG5cbi8vIERpc3BsYXlzIHRoZSByZWFkbWUgZm9yIGEgcGFja2FnZSwgaWYgaXQgaGFzIG9uZVxuLy8gVE9ETyBEZWNpZGUgdG8ga2VlcCB0aGlzIG9yIGN1cnJlbnQgYnV0dG9uLXRvLW5ldy10YWIgdmlld1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgUGFja2FnZVJlYWRtZVZpZXcge1xuICBjb25zdHJ1Y3RvciAocmVhZG1lLCByZWFkbWVTcmMpIHtcbiAgICB0aGlzLmVsZW1lbnQgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdzZWN0aW9uJylcbiAgICB0aGlzLmVsZW1lbnQuY2xhc3NMaXN0LmFkZCgnc2VjdGlvbicpXG5cbiAgICBjb25zdCBjb250YWluZXIgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKVxuICAgIGNvbnRhaW5lci5jbGFzc0xpc3QuYWRkKCdzZWN0aW9uLWNvbnRhaW5lcicpXG5cbiAgICBjb25zdCBoZWFkaW5nID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnZGl2JylcbiAgICBoZWFkaW5nLmNsYXNzTGlzdC5hZGQoJ3NlY3Rpb24taGVhZGluZycsICdpY29uJywgJ2ljb24tYm9vaycpXG4gICAgaGVhZGluZy50ZXh0Q29udGVudCA9ICdSRUFETUUnXG4gICAgY29udGFpbmVyLmFwcGVuZENoaWxkKGhlYWRpbmcpXG5cbiAgICB0aGlzLnBhY2thZ2VSZWFkbWUgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKVxuICAgIHRoaXMucGFja2FnZVJlYWRtZS5jbGFzc0xpc3QuYWRkKCdwYWNrYWdlLXJlYWRtZScsICduYXRpdmUta2V5LWJpbmRpbmdzJylcbiAgICB0aGlzLnBhY2thZ2VSZWFkbWUudGFiSW5kZXggPSAtMVxuICAgIGNvbnRhaW5lci5hcHBlbmRDaGlsZCh0aGlzLnBhY2thZ2VSZWFkbWUpXG4gICAgdGhpcy5lbGVtZW50LmFwcGVuZENoaWxkKGNvbnRhaW5lcilcblxuICAgIG1hcmtlZChyZWFkbWUgfHwgJyMjIyBObyBSRUFETUUuJywge2JyZWFrczogZmFsc2V9LCAoZXJyLCBjb250ZW50KSA9PiB7XG4gICAgICBpZiAoZXJyKSB7XG4gICAgICAgIHRoaXMucGFja2FnZVJlYWRtZS5pbm5lckhUTUwgPSAnPGgzPkVycm9yIHBhcnNpbmcgUkVBRE1FPC9oMz4nXG4gICAgICB9IGVsc2Uge1xuICAgICAgICB0aGlzLnBhY2thZ2VSZWFkbWUuaW5uZXJIVE1MID0gc2FuaXRpemUoY29udGVudCwgcmVhZG1lU3JjKVxuICAgICAgfVxuICAgIH0pXG4gIH1cblxuICBkZXN0cm95ICgpIHtcbiAgICB0aGlzLmVsZW1lbnQucmVtb3ZlKClcbiAgfVxufVxuIl19