Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _asyncQueue = require('async/queue');

var _asyncQueue2 = _interopRequireDefault(_asyncQueue);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _errorView = require('./error-view');

var _errorView2 = _interopRequireDefault(_errorView);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var UpdatesPanel = (function () {
  function UpdatesPanel(settingsView, packageManager) {
    var _this = this;

    _classCallCheck(this, UpdatesPanel);

    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.disposables = new _atom.CompositeDisposable();
    this.updatingPackages = [];
    this.packageCards = [];

    _etch2['default'].initialize(this);

    this.refs.updateAllButton.style.display = 'none';
    this.checkForUpdates();

    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.disposables.add(this.packageManager.on('package-updating theme-updating', function (_ref) {
      var pack = _ref.pack;
      var error = _ref.error;

      _this.refs.checkButton.disabled = true;
      _this.updatingPackages.push(pack);
    }));

    this.disposables.add(this.packageManager.on('package-updated theme-updated package-update-failed theme-update-failed', function (_ref2) {
      var pack = _ref2.pack;
      var error = _ref2.error;

      if (error != null) {
        _this.refs.updateErrors.appendChild(new _errorView2['default'](_this.packageManager, error).element);
      }

      for (var i = 0; i < _this.updatingPackages.length; i++) {
        var update = _this.updatingPackages[i];
        if (update.name === pack.name) {
          _this.updatingPackages.splice(i, 1);
        }
      }

      if (!_this.updatingPackages.length) {
        _this.refs.checkButton.disabled = false;
      }
    }));
  }

  _createClass(UpdatesPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.clearPackageCards();
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      return _etch2['default'].dom(
        'div',
        { tabIndex: '0', className: 'panels-item' },
        _etch2['default'].dom(
          'section',
          { className: 'section packages' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container updates-container' },
            _etch2['default'].dom(
              'div',
              { className: 'updates-heading-container' },
              _etch2['default'].dom(
                'h1',
                { className: 'section-heading icon icon-cloud-download' },
                'Available Updates'
              ),
              _etch2['default'].dom(
                'div',
                { className: 'section-heading updates-btn-group' },
                _etch2['default'].dom(
                  'button',
                  {
                    ref: 'checkButton',
                    className: 'update-all-button btn',
                    onclick: function () {
                      _this2.checkForUpdates(true);
                    } },
                  'Check for Updates'
                ),
                _etch2['default'].dom(
                  'button',
                  {
                    ref: 'updateAllButton',
                    className: 'update-all-button btn btn-primary',
                    onclick: function () {
                      _this2.updateAll();
                    } },
                  'Update All'
                )
              )
            ),
            _etch2['default'].dom(
              'div',
              { ref: 'versionPinnedPackagesMessage', className: 'alert alert-warning icon icon-alert' },
              'The following packages are pinned to their current version and are not being checked for updates: ',
              _etch2['default'].dom(
                'strong',
                null,
                this.packageManager.getVersionPinnedPackages().join(', ')
              )
            ),
            _etch2['default'].dom('div', { ref: 'updateErrors' }),
            _etch2['default'].dom(
              'div',
              { ref: 'checkingMessage', className: 'alert alert-info icon icon-hourglass' },
              'Checking for updates…'
            ),
            _etch2['default'].dom(
              'div',
              { ref: 'noUpdatesMessage', className: 'alert alert-info icon icon-heart' },
              'All of your installed packages are up to date!'
            ),
            _etch2['default'].dom('div', { ref: 'updatesContainer', className: 'container package-container' })
          )
        )
      );
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'beforeShow',
    value: function beforeShow(opts) {
      var _this3 = this;

      if (opts && opts.back) {
        this.refs.breadcrumb.textContent = opts.back;
        this.refs.breadcrumb.onclick = function () {
          _this3.settingsView.showPanel(opts.back);
        };
      }

      if (opts && opts.updates) {
        this.availableUpdates = opts.updates;
        this.addUpdateViews();
      } else {
        this.availableUpdates = [];
        this.clearPackageCards();
        this.checkForUpdates();
      }

      if (this.packageManager.getVersionPinnedPackages().length === 0) {
        this.refs.versionPinnedPackagesMessage.style.display = 'none';
      }
    }

    // Check for updates and display them
  }, {
    key: 'checkForUpdates',
    value: _asyncToGenerator(function* (clearCache) {
      this.refs.noUpdatesMessage.style.display = 'none';
      this.refs.updateAllButton.disabled = true;
      this.refs.checkButton.disabled = true;
      this.refs.checkingMessage.style.display = '';

      try {
        this.availableUpdates = yield this.packageManager.getOutdated(clearCache);
        this.refs.checkButton.disabled = false;
        this.addUpdateViews();
      } catch (error) {
        this.refs.checkButton.disabled = false;
        this.refs.checkingMessage.style.display = 'none';
        this.refs.updateErrors.appendChild(new _errorView2['default'](this.packageManager, error).element);
      }
    })
  }, {
    key: 'addUpdateViews',
    value: function addUpdateViews() {
      if (this.availableUpdates.length > 0) {
        this.refs.updateAllButton.style.display = '';
        this.refs.updateAllButton.disabled = false;
      }
      this.refs.checkingMessage.style.display = 'none';
      this.clearPackageCards();
      if (this.availableUpdates.length === 0) {
        this.refs.noUpdatesMessage.style.display = '';
      }

      for (var pack of this.availableUpdates) {
        var packageCard = new _packageCard2['default'](pack, this.settingsView, this.packageManager, { back: 'Updates' });
        this.refs.updatesContainer.appendChild(packageCard.element);
        this.packageCards.push(packageCard);
      }
    }
  }, {
    key: 'updateAll',
    value: _asyncToGenerator(function* () {
      var _this4 = this;

      this.refs.checkButton.disabled = true;
      this.refs.updateAllButton.disabled = true;

      var updatingPackages = this.updatingPackages;
      var successfulUpdatesCount = 0;
      var failedUpdatesCount = 0;

      var concurrency = atom.config.get('settings-view.packageUpdateConcurrency') > 0 ? atom.config.get('settings-view.packageUpdateConcurrency') : Number.POSITIVE_INFINITY;

      var queue = (0, _asyncQueue2['default'])(function (packageCard, callback) {
        var onUpdateCompleted = function onUpdateCompleted(err) {
          err == null ? successfulUpdatesCount++ : failedUpdatesCount++;
        };

        if (updatingPackages.includes(packageCard.pack)) {
          callback();
        } else {
          packageCard.update().then(onUpdateCompleted, onUpdateCompleted).then(callback);
        }
      }, concurrency);

      queue.push(this.packageCards);

      yield queue.drain();

      if (successfulUpdatesCount > 0) {
        (function () {
          var message = 'Restart Atom to complete the update of ' + successfulUpdatesCount + ' ' + pluralize('package', successfulUpdatesCount) + ':';
          var detail = '';
          _this4.packageCards.forEach(function (card) {
            var oldVersion = '';
            var newVersion = '';

            if (card.pack.apmInstallSource && card.pack.apmInstallSource.type === 'git') {
              oldVersion = card.pack.apmInstallSource.sha.substr(0, 8);
              newVersion = '' + card.pack.latestSha.substr(0, 8);
            } else if (card.pack.version && card.pack.latestVersion) {
              oldVersion = card.pack.version;
              newVersion = card.pack.latestVersion;
            }

            if (oldVersion && newVersion) {
              detail += card.pack.name + '@' + oldVersion + ' -> ' + newVersion + '\n';
            }
          });
          detail = detail.trim();

          var notification = atom.notifications.addSuccess(message, {
            dismissable: true,
            buttons: [{
              text: 'Restart now',
              onDidClick: function onDidClick() {
                return atom.restartApplication();
              }
            }, {
              text: 'I\'ll do it later',
              onDidClick: function onDidClick() {
                notification.dismiss();
              }
            }],
            detail: detail
          });
        })();
      }

      if (failedUpdatesCount === 0) {
        this.refs.checkButton.disabled = false;
        this.refs.updateAllButton.style.display = 'none';
      } else {
        this.refs.checkButton.disabled = false;
        this.refs.updateAllButton.disabled = false;
      }
    })
  }, {
    key: 'clearPackageCards',
    value: function clearPackageCards() {
      while (this.packageCards.length) {
        this.packageCards.pop().destroy();
      }
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return UpdatesPanel;
})();

exports['default'] = UpdatesPanel;

function pluralize(word, count) {
  return count > 1 ? word + 's' : word;
}
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL3NldHRpbmdzLXZpZXcvbGliL3VwZGF0ZXMtcGFuZWwuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7O29CQUdrQyxNQUFNOzswQkFDakIsYUFBYTs7OztvQkFDbkIsTUFBTTs7Ozt5QkFFRCxjQUFjOzs7OzJCQUNaLGdCQUFnQjs7OztJQUVuQixZQUFZO0FBQ25CLFdBRE8sWUFBWSxDQUNsQixZQUFZLEVBQUUsY0FBYyxFQUFFOzs7MEJBRHhCLFlBQVk7O0FBRTdCLFFBQUksQ0FBQyxZQUFZLEdBQUcsWUFBWSxDQUFBO0FBQ2hDLFFBQUksQ0FBQyxjQUFjLEdBQUcsY0FBYyxDQUFBO0FBQ3BDLFFBQUksQ0FBQyxXQUFXLEdBQUcsK0JBQXlCLENBQUE7QUFDNUMsUUFBSSxDQUFDLGdCQUFnQixHQUFHLEVBQUUsQ0FBQTtBQUMxQixRQUFJLENBQUMsWUFBWSxHQUFHLEVBQUUsQ0FBQTs7QUFFdEIsc0JBQUssVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFBOztBQUVyQixRQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQTtBQUNoRCxRQUFJLENBQUMsZUFBZSxFQUFFLENBQUE7O0FBRXRCLFFBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUU7QUFDbkQsb0JBQWMsRUFBRSxzQkFBTTtBQUFFLGNBQUssUUFBUSxFQUFFLENBQUE7T0FBRTtBQUN6QyxzQkFBZ0IsRUFBRSx3QkFBTTtBQUFFLGNBQUssVUFBVSxFQUFFLENBQUE7T0FBRTtBQUM3QyxvQkFBYyxFQUFFLHNCQUFNO0FBQUUsY0FBSyxNQUFNLEVBQUUsQ0FBQTtPQUFFO0FBQ3ZDLHNCQUFnQixFQUFFLHdCQUFNO0FBQUUsY0FBSyxRQUFRLEVBQUUsQ0FBQTtPQUFFO0FBQzNDLHdCQUFrQixFQUFFLHlCQUFNO0FBQUUsY0FBSyxXQUFXLEVBQUUsQ0FBQTtPQUFFO0FBQ2hELDJCQUFxQixFQUFFLDRCQUFNO0FBQUUsY0FBSyxjQUFjLEVBQUUsQ0FBQTtPQUFFO0tBQ3ZELENBQUMsQ0FBQyxDQUFBOztBQUVILFFBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsRUFBRSxDQUFDLGlDQUFpQyxFQUFFLFVBQUMsSUFBYSxFQUFLO1VBQWpCLElBQUksR0FBTCxJQUFhLENBQVosSUFBSTtVQUFFLEtBQUssR0FBWixJQUFhLENBQU4sS0FBSzs7QUFDMUYsWUFBSyxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUE7QUFDckMsWUFBSyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUE7S0FDakMsQ0FBQyxDQUFDLENBQUE7O0FBRUgsUUFBSSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQ2xCLElBQUksQ0FBQyxjQUFjLENBQUMsRUFBRSxDQUFDLHlFQUF5RSxFQUFFLFVBQUMsS0FBYSxFQUFLO1VBQWpCLElBQUksR0FBTCxLQUFhLENBQVosSUFBSTtVQUFFLEtBQUssR0FBWixLQUFhLENBQU4sS0FBSzs7QUFDN0csVUFBSSxLQUFLLElBQUksSUFBSSxFQUFFO0FBQ2pCLGNBQUssSUFBSSxDQUFDLFlBQVksQ0FBQyxXQUFXLENBQUMsMkJBQWMsTUFBSyxjQUFjLEVBQUUsS0FBSyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUE7T0FDdEY7O0FBRUQsV0FBSyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLE1BQUssZ0JBQWdCLENBQUMsTUFBTSxFQUFFLENBQUMsRUFBRSxFQUFFO0FBQ3JELFlBQU0sTUFBTSxHQUFHLE1BQUssZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLENBQUE7QUFDdkMsWUFBSSxNQUFNLENBQUMsSUFBSSxLQUFLLElBQUksQ0FBQyxJQUFJLEVBQUU7QUFDN0IsZ0JBQUssZ0JBQWdCLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQTtTQUNuQztPQUNGOztBQUVELFVBQUksQ0FBQyxNQUFLLGdCQUFnQixDQUFDLE1BQU0sRUFBRTtBQUNqQyxjQUFLLElBQUksQ0FBQyxXQUFXLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQTtPQUN2QztLQUNGLENBQUMsQ0FDSCxDQUFBO0dBQ0Y7O2VBN0NrQixZQUFZOztXQStDdkIsbUJBQUc7QUFDVCxVQUFJLENBQUMsaUJBQWlCLEVBQUUsQ0FBQTtBQUN4QixVQUFJLENBQUMsV0FBVyxDQUFDLE9BQU8sRUFBRSxDQUFBO0FBQzFCLGFBQU8sa0JBQUssT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFBO0tBQzFCOzs7V0FFTSxrQkFBRyxFQUFFOzs7V0FFTCxrQkFBRzs7O0FBQ1IsYUFDRTs7VUFBSyxRQUFRLEVBQUMsR0FBRyxFQUFDLFNBQVMsRUFBQyxhQUFhO1FBQ3ZDOztZQUFTLFNBQVMsRUFBQyxrQkFBa0I7VUFDbkM7O2NBQUssU0FBUyxFQUFDLHFDQUFxQztZQUNsRDs7Z0JBQUssU0FBUyxFQUFDLDJCQUEyQjtjQUN4Qzs7a0JBQUksU0FBUyxFQUFDLDBDQUEwQzs7ZUFBdUI7Y0FDL0U7O2tCQUFLLFNBQVMsRUFBQyxtQ0FBbUM7Z0JBQ2hEOzs7QUFDRSx1QkFBRyxFQUFDLGFBQWE7QUFDakIsNkJBQVMsRUFBQyx1QkFBdUI7QUFDakMsMkJBQU8sRUFBRSxZQUFNO0FBQUUsNkJBQUssZUFBZSxDQUFDLElBQUksQ0FBQyxDQUFBO3FCQUFFLEFBQUM7O2lCQUEyQjtnQkFDM0U7OztBQUNFLHVCQUFHLEVBQUMsaUJBQWlCO0FBQ3JCLDZCQUFTLEVBQUMsbUNBQW1DO0FBQzdDLDJCQUFPLEVBQUUsWUFBTTtBQUFFLDZCQUFLLFNBQVMsRUFBRSxDQUFBO3FCQUFFLEFBQUM7O2lCQUFvQjtlQUN0RDthQUNGO1lBRU47O2dCQUFLLEdBQUcsRUFBQyw4QkFBOEIsRUFBQyxTQUFTLEVBQUMscUNBQXFDOztjQUFtRzs7O2dCQUFVLElBQUksQ0FBQyxjQUFjLENBQUMsd0JBQXdCLEVBQUUsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO2VBQVc7YUFBTTtZQUM5USwrQkFBSyxHQUFHLEVBQUMsY0FBYyxHQUFHO1lBQzFCOztnQkFBSyxHQUFHLEVBQUMsaUJBQWlCLEVBQUMsU0FBUyxFQUFDLHNDQUFzQzs7YUFBcUM7WUFDaEg7O2dCQUFLLEdBQUcsRUFBQyxrQkFBa0IsRUFBQyxTQUFTLEVBQUMsa0NBQWtDOzthQUFxRDtZQUM3SCwrQkFBSyxHQUFHLEVBQUMsa0JBQWtCLEVBQUMsU0FBUyxFQUFDLDZCQUE2QixHQUFHO1dBQ2xFO1NBQ0U7T0FDTixDQUNQO0tBQ0Y7OztXQUVLLGlCQUFHO0FBQ1AsVUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsQ0FBQTtLQUNyQjs7O1dBRUksZ0JBQUc7QUFDTixVQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFBO0tBQ2hDOzs7V0FFVSxvQkFBQyxJQUFJLEVBQUU7OztBQUNoQixVQUFJLElBQUksSUFBSSxJQUFJLENBQUMsSUFBSSxFQUFFO0FBQ3JCLFlBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFBO0FBQzVDLFlBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sR0FBRyxZQUFNO0FBQUUsaUJBQUssWUFBWSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUE7U0FBRSxDQUFBO09BQ2hGOztBQUVELFVBQUksSUFBSSxJQUFJLElBQUksQ0FBQyxPQUFPLEVBQUU7QUFDeEIsWUFBSSxDQUFDLGdCQUFnQixHQUFHLElBQUksQ0FBQyxPQUFPLENBQUE7QUFDcEMsWUFBSSxDQUFDLGNBQWMsRUFBRSxDQUFBO09BQ3RCLE1BQU07QUFDTCxZQUFJLENBQUMsZ0JBQWdCLEdBQUcsRUFBRSxDQUFBO0FBQzFCLFlBQUksQ0FBQyxpQkFBaUIsRUFBRSxDQUFBO0FBQ3hCLFlBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQTtPQUN2Qjs7QUFFRCxVQUFJLElBQUksQ0FBQyxjQUFjLENBQUMsd0JBQXdCLEVBQUUsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO0FBQy9ELFlBQUksQ0FBQyxJQUFJLENBQUMsNEJBQTRCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7T0FDOUQ7S0FDRjs7Ozs7NkJBR3FCLFdBQUMsVUFBVSxFQUFFO0FBQ2pDLFVBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7QUFDakQsVUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQTtBQUN6QyxVQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFBO0FBQ3JDLFVBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFBOztBQUU1QyxVQUFJO0FBQ0YsWUFBSSxDQUFDLGdCQUFnQixHQUFHLE1BQU0sSUFBSSxDQUFDLGNBQWMsQ0FBQyxXQUFXLENBQUMsVUFBVSxDQUFDLENBQUE7QUFDekUsWUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQTtBQUN0QyxZQUFJLENBQUMsY0FBYyxFQUFFLENBQUE7T0FDdEIsQ0FBQyxPQUFPLEtBQUssRUFBRTtBQUNkLFlBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUE7QUFDdEMsWUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7QUFDaEQsWUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsV0FBVyxDQUFDLDJCQUFjLElBQUksQ0FBQyxjQUFjLEVBQUUsS0FBSyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUE7T0FDdEY7S0FDRjs7O1dBRWMsMEJBQUc7QUFDaEIsVUFBSSxJQUFJLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtBQUNwQyxZQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQTtBQUM1QyxZQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFBO09BQzNDO0FBQ0QsVUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7QUFDaEQsVUFBSSxDQUFDLGlCQUFpQixFQUFFLENBQUE7QUFDeEIsVUFBSSxJQUFJLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtBQUN0QyxZQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFBO09BQzlDOztBQUVELFdBQUssSUFBTSxJQUFJLElBQUksSUFBSSxDQUFDLGdCQUFnQixFQUFFO0FBQ3hDLFlBQU0sV0FBVyxHQUFHLDZCQUFnQixJQUFJLEVBQUUsSUFBSSxDQUFDLFlBQVksRUFBRSxJQUFJLENBQUMsY0FBYyxFQUFFLEVBQUMsSUFBSSxFQUFFLFNBQVMsRUFBQyxDQUFDLENBQUE7QUFDcEcsWUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFXLENBQUMsV0FBVyxDQUFDLE9BQU8sQ0FBQyxDQUFBO0FBQzNELFlBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFBO09BQ3BDO0tBQ0Y7Ozs2QkFFZSxhQUFHOzs7QUFDakIsVUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQTtBQUNyQyxVQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFBOztBQUV6QyxVQUFJLGdCQUFnQixHQUFHLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQTtBQUM1QyxVQUFJLHNCQUFzQixHQUFHLENBQUMsQ0FBQTtBQUM5QixVQUFJLGtCQUFrQixHQUFHLENBQUMsQ0FBQTs7QUFFMUIsVUFBTSxXQUFXLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsd0NBQXdDLENBQUMsR0FBRyxDQUFDLEdBQzdFLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLHdDQUF3QyxDQUFDLEdBQ3pELE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQTs7QUFFNUIsVUFBTSxLQUFLLEdBQUcsNkJBQVcsVUFBVSxXQUFXLEVBQUUsUUFBUSxFQUFFO0FBQ3hELFlBQU0saUJBQWlCLEdBQUcsU0FBcEIsaUJBQWlCLENBQWEsR0FBRyxFQUFFO0FBQ3ZDLGFBQUcsSUFBSSxJQUFJLEdBQUcsc0JBQXNCLEVBQUUsR0FBRyxrQkFBa0IsRUFBRSxDQUFBO1NBQzlELENBQUE7O0FBRUQsWUFBSSxnQkFBZ0IsQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxFQUFFO0FBQy9DLGtCQUFRLEVBQUUsQ0FBQTtTQUNYLE1BQU07QUFDTCxxQkFBVyxDQUFDLE1BQU0sRUFBRSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQTtTQUMvRTtPQUNGLEVBQUUsV0FBVyxDQUFDLENBQUE7O0FBRWYsV0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUE7O0FBRTdCLFlBQU0sS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFBOztBQUVuQixVQUFJLHNCQUFzQixHQUFHLENBQUMsRUFBRTs7QUFDOUIsY0FBTSxPQUFPLCtDQUE2QyxzQkFBc0IsU0FBSSxTQUFTLENBQUMsU0FBUyxFQUFFLHNCQUFzQixDQUFDLE1BQUcsQ0FBQTtBQUNuSSxjQUFJLE1BQU0sR0FBRyxFQUFFLENBQUE7QUFDZixpQkFBSyxZQUFZLENBQUMsT0FBTyxDQUFDLFVBQUMsSUFBSSxFQUFLO0FBQ2xDLGdCQUFJLFVBQVUsR0FBRyxFQUFFLENBQUE7QUFDbkIsZ0JBQUksVUFBVSxHQUFHLEVBQUUsQ0FBQTs7QUFFbkIsZ0JBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksS0FBSyxLQUFLLEVBQUU7QUFDM0Usd0JBQVUsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFBO0FBQ3hELHdCQUFVLFFBQU0sSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQUFBRSxDQUFBO2FBQ25ELE1BQU0sSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsRUFBRTtBQUN2RCx3QkFBVSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFBO0FBQzlCLHdCQUFVLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUE7YUFDckM7O0FBRUQsZ0JBQUksVUFBVSxJQUFJLFVBQVUsRUFBRTtBQUM1QixvQkFBTSxJQUFPLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxTQUFJLFVBQVUsWUFBTyxVQUFVLE9BQUksQ0FBQTthQUMvRDtXQUNGLENBQUMsQ0FBQTtBQUNGLGdCQUFNLEdBQUcsTUFBTSxDQUFDLElBQUksRUFBRSxDQUFBOztBQUV0QixjQUFNLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLFVBQVUsQ0FBQyxPQUFPLEVBQUU7QUFDMUQsdUJBQVcsRUFBRSxJQUFJO0FBQ2pCLG1CQUFPLEVBQUUsQ0FBQztBQUNSLGtCQUFJLEVBQUUsYUFBYTtBQUNuQix3QkFBVSxFQUFDLHNCQUFHO0FBQUUsdUJBQU8sSUFBSSxDQUFDLGtCQUFrQixFQUFFLENBQUE7ZUFBRTthQUNuRCxFQUNEO0FBQ0Usa0JBQUksRUFBRSxtQkFBbUI7QUFDekIsd0JBQVUsRUFBQyxzQkFBRztBQUFFLDRCQUFZLENBQUMsT0FBTyxFQUFFLENBQUE7ZUFBRTthQUN6QyxDQUFDO0FBQ0Ysa0JBQU0sRUFBTixNQUFNO1dBQ1AsQ0FBQyxDQUFBOztPQUNIOztBQUVELFVBQUksa0JBQWtCLEtBQUssQ0FBQyxFQUFFO0FBQzVCLFlBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUE7QUFDdEMsWUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7T0FDakQsTUFBTTtBQUNMLFlBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUE7QUFDdEMsWUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQTtPQUMzQztLQUNGOzs7V0FFaUIsNkJBQUc7QUFDbkIsYUFBTyxJQUFJLENBQUMsWUFBWSxDQUFDLE1BQU0sRUFBRTtBQUMvQixZQUFJLENBQUMsWUFBWSxDQUFDLEdBQUcsRUFBRSxDQUFDLE9BQU8sRUFBRSxDQUFBO09BQ2xDO0tBQ0Y7OztXQUVRLG9CQUFHO0FBQ1YsVUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLElBQUksUUFBUSxDQUFDLElBQUksQ0FBQyxZQUFZLEdBQUcsRUFBRSxDQUFBO0tBQzFEOzs7V0FFVSxzQkFBRztBQUNaLFVBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxJQUFJLFFBQVEsQ0FBQyxJQUFJLENBQUMsWUFBWSxHQUFHLEVBQUUsQ0FBQTtLQUMxRDs7O1dBRU0sa0JBQUc7QUFDUixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQTtLQUNwRDs7O1dBRVEsb0JBQUc7QUFDVixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQTtLQUNwRDs7O1dBRVcsdUJBQUc7QUFDYixVQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsR0FBRyxDQUFDLENBQUE7S0FDM0I7OztXQUVjLDBCQUFHO0FBQ2hCLFVBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFBO0tBQ25EOzs7U0F6UGtCLFlBQVk7OztxQkFBWixZQUFZOztBQTRQakMsU0FBUyxTQUFTLENBQUUsSUFBSSxFQUFFLEtBQUssRUFBRTtBQUMvQixTQUFPLEFBQUMsS0FBSyxHQUFHLENBQUMsR0FBTyxJQUFJLFNBQU0sSUFBSSxDQUFBO0NBQ3ZDIiwiZmlsZSI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL3NldHRpbmdzLXZpZXcvbGliL3VwZGF0ZXMtcGFuZWwuanMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiogQGJhYmVsICovXG4vKiogQGpzeCBldGNoLmRvbSAqL1xuXG5pbXBvcnQge0NvbXBvc2l0ZURpc3Bvc2FibGV9IGZyb20gJ2F0b20nXG5pbXBvcnQgYXN5bmNRdWV1ZSBmcm9tICdhc3luYy9xdWV1ZSdcbmltcG9ydCBldGNoIGZyb20gJ2V0Y2gnXG5cbmltcG9ydCBFcnJvclZpZXcgZnJvbSAnLi9lcnJvci12aWV3J1xuaW1wb3J0IFBhY2thZ2VDYXJkIGZyb20gJy4vcGFja2FnZS1jYXJkJ1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBVcGRhdGVzUGFuZWwge1xuICBjb25zdHJ1Y3RvciAoc2V0dGluZ3NWaWV3LCBwYWNrYWdlTWFuYWdlcikge1xuICAgIHRoaXMuc2V0dGluZ3NWaWV3ID0gc2V0dGluZ3NWaWV3XG4gICAgdGhpcy5wYWNrYWdlTWFuYWdlciA9IHBhY2thZ2VNYW5hZ2VyXG4gICAgdGhpcy5kaXNwb3NhYmxlcyA9IG5ldyBDb21wb3NpdGVEaXNwb3NhYmxlKClcbiAgICB0aGlzLnVwZGF0aW5nUGFja2FnZXMgPSBbXVxuICAgIHRoaXMucGFja2FnZUNhcmRzID0gW11cblxuICAgIGV0Y2guaW5pdGlhbGl6ZSh0aGlzKVxuXG4gICAgdGhpcy5yZWZzLnVwZGF0ZUFsbEJ1dHRvbi5zdHlsZS5kaXNwbGF5ID0gJ25vbmUnXG4gICAgdGhpcy5jaGVja0ZvclVwZGF0ZXMoKVxuXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQoYXRvbS5jb21tYW5kcy5hZGQodGhpcy5lbGVtZW50LCB7XG4gICAgICAnY29yZTptb3ZlLXVwJzogKCkgPT4geyB0aGlzLnNjcm9sbFVwKCkgfSxcbiAgICAgICdjb3JlOm1vdmUtZG93bic6ICgpID0+IHsgdGhpcy5zY3JvbGxEb3duKCkgfSxcbiAgICAgICdjb3JlOnBhZ2UtdXAnOiAoKSA9PiB7IHRoaXMucGFnZVVwKCkgfSxcbiAgICAgICdjb3JlOnBhZ2UtZG93bic6ICgpID0+IHsgdGhpcy5wYWdlRG93bigpIH0sXG4gICAgICAnY29yZTptb3ZlLXRvLXRvcCc6ICgpID0+IHsgdGhpcy5zY3JvbGxUb1RvcCgpIH0sXG4gICAgICAnY29yZTptb3ZlLXRvLWJvdHRvbSc6ICgpID0+IHsgdGhpcy5zY3JvbGxUb0JvdHRvbSgpIH1cbiAgICB9KSlcblxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKHRoaXMucGFja2FnZU1hbmFnZXIub24oJ3BhY2thZ2UtdXBkYXRpbmcgdGhlbWUtdXBkYXRpbmcnLCAoe3BhY2ssIGVycm9yfSkgPT4ge1xuICAgICAgdGhpcy5yZWZzLmNoZWNrQnV0dG9uLmRpc2FibGVkID0gdHJ1ZVxuICAgICAgdGhpcy51cGRhdGluZ1BhY2thZ2VzLnB1c2gocGFjaylcbiAgICB9KSlcblxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKFxuICAgICAgdGhpcy5wYWNrYWdlTWFuYWdlci5vbigncGFja2FnZS11cGRhdGVkIHRoZW1lLXVwZGF0ZWQgcGFja2FnZS11cGRhdGUtZmFpbGVkIHRoZW1lLXVwZGF0ZS1mYWlsZWQnLCAoe3BhY2ssIGVycm9yfSkgPT4ge1xuICAgICAgICBpZiAoZXJyb3IgIT0gbnVsbCkge1xuICAgICAgICAgIHRoaXMucmVmcy51cGRhdGVFcnJvcnMuYXBwZW5kQ2hpbGQobmV3IEVycm9yVmlldyh0aGlzLnBhY2thZ2VNYW5hZ2VyLCBlcnJvcikuZWxlbWVudClcbiAgICAgICAgfVxuXG4gICAgICAgIGZvciAobGV0IGkgPSAwOyBpIDwgdGhpcy51cGRhdGluZ1BhY2thZ2VzLmxlbmd0aDsgaSsrKSB7XG4gICAgICAgICAgY29uc3QgdXBkYXRlID0gdGhpcy51cGRhdGluZ1BhY2thZ2VzW2ldXG4gICAgICAgICAgaWYgKHVwZGF0ZS5uYW1lID09PSBwYWNrLm5hbWUpIHtcbiAgICAgICAgICAgIHRoaXMudXBkYXRpbmdQYWNrYWdlcy5zcGxpY2UoaSwgMSlcbiAgICAgICAgICB9XG4gICAgICAgIH1cblxuICAgICAgICBpZiAoIXRoaXMudXBkYXRpbmdQYWNrYWdlcy5sZW5ndGgpIHtcbiAgICAgICAgICB0aGlzLnJlZnMuY2hlY2tCdXR0b24uZGlzYWJsZWQgPSBmYWxzZVxuICAgICAgICB9XG4gICAgICB9KVxuICAgIClcbiAgfVxuXG4gIGRlc3Ryb3kgKCkge1xuICAgIHRoaXMuY2xlYXJQYWNrYWdlQ2FyZHMoKVxuICAgIHRoaXMuZGlzcG9zYWJsZXMuZGlzcG9zZSgpXG4gICAgcmV0dXJuIGV0Y2guZGVzdHJveSh0aGlzKVxuICB9XG5cbiAgdXBkYXRlICgpIHt9XG5cbiAgcmVuZGVyICgpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPGRpdiB0YWJJbmRleD0nMCcgY2xhc3NOYW1lPSdwYW5lbHMtaXRlbSc+XG4gICAgICAgIDxzZWN0aW9uIGNsYXNzTmFtZT0nc2VjdGlvbiBwYWNrYWdlcyc+XG4gICAgICAgICAgPGRpdiBjbGFzc05hbWU9J3NlY3Rpb24tY29udGFpbmVyIHVwZGF0ZXMtY29udGFpbmVyJz5cbiAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSd1cGRhdGVzLWhlYWRpbmctY29udGFpbmVyJz5cbiAgICAgICAgICAgICAgPGgxIGNsYXNzTmFtZT0nc2VjdGlvbi1oZWFkaW5nIGljb24gaWNvbi1jbG91ZC1kb3dubG9hZCc+QXZhaWxhYmxlIFVwZGF0ZXM8L2gxPlxuICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0nc2VjdGlvbi1oZWFkaW5nIHVwZGF0ZXMtYnRuLWdyb3VwJz5cbiAgICAgICAgICAgICAgICA8YnV0dG9uXG4gICAgICAgICAgICAgICAgICByZWY9J2NoZWNrQnV0dG9uJ1xuICAgICAgICAgICAgICAgICAgY2xhc3NOYW1lPSd1cGRhdGUtYWxsLWJ1dHRvbiBidG4nXG4gICAgICAgICAgICAgICAgICBvbmNsaWNrPXsoKSA9PiB7IHRoaXMuY2hlY2tGb3JVcGRhdGVzKHRydWUpIH19PkNoZWNrIGZvciBVcGRhdGVzPC9idXR0b24+XG4gICAgICAgICAgICAgICAgPGJ1dHRvblxuICAgICAgICAgICAgICAgICAgcmVmPSd1cGRhdGVBbGxCdXR0b24nXG4gICAgICAgICAgICAgICAgICBjbGFzc05hbWU9J3VwZGF0ZS1hbGwtYnV0dG9uIGJ0biBidG4tcHJpbWFyeSdcbiAgICAgICAgICAgICAgICAgIG9uY2xpY2s9eygpID0+IHsgdGhpcy51cGRhdGVBbGwoKSB9fT5VcGRhdGUgQWxsPC9idXR0b24+XG4gICAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgPC9kaXY+XG5cbiAgICAgICAgICAgIDxkaXYgcmVmPSd2ZXJzaW9uUGlubmVkUGFja2FnZXNNZXNzYWdlJyBjbGFzc05hbWU9J2FsZXJ0IGFsZXJ0LXdhcm5pbmcgaWNvbiBpY29uLWFsZXJ0Jz5UaGUgZm9sbG93aW5nIHBhY2thZ2VzIGFyZSBwaW5uZWQgdG8gdGhlaXIgY3VycmVudCB2ZXJzaW9uIGFuZCBhcmUgbm90IGJlaW5nIGNoZWNrZWQgZm9yIHVwZGF0ZXM6IDxzdHJvbmc+eyB0aGlzLnBhY2thZ2VNYW5hZ2VyLmdldFZlcnNpb25QaW5uZWRQYWNrYWdlcygpLmpvaW4oJywgJykgfTwvc3Ryb25nPjwvZGl2PlxuICAgICAgICAgICAgPGRpdiByZWY9J3VwZGF0ZUVycm9ycycgLz5cbiAgICAgICAgICAgIDxkaXYgcmVmPSdjaGVja2luZ01lc3NhZ2UnIGNsYXNzTmFtZT0nYWxlcnQgYWxlcnQtaW5mbyBpY29uIGljb24taG91cmdsYXNzJz57YENoZWNraW5nIGZvciB1cGRhdGVzXFx1MjAyNmB9PC9kaXY+XG4gICAgICAgICAgICA8ZGl2IHJlZj0nbm9VcGRhdGVzTWVzc2FnZScgY2xhc3NOYW1lPSdhbGVydCBhbGVydC1pbmZvIGljb24gaWNvbi1oZWFydCc+QWxsIG9mIHlvdXIgaW5zdGFsbGVkIHBhY2thZ2VzIGFyZSB1cCB0byBkYXRlITwvZGl2PlxuICAgICAgICAgICAgPGRpdiByZWY9J3VwZGF0ZXNDb250YWluZXInIGNsYXNzTmFtZT0nY29udGFpbmVyIHBhY2thZ2UtY29udGFpbmVyJyAvPlxuICAgICAgICAgIDwvZGl2PlxuICAgICAgICA8L3NlY3Rpb24+XG4gICAgICA8L2Rpdj5cbiAgICApXG4gIH1cblxuICBmb2N1cyAoKSB7XG4gICAgdGhpcy5lbGVtZW50LmZvY3VzKClcbiAgfVxuXG4gIHNob3cgKCkge1xuICAgIHRoaXMuZWxlbWVudC5zdHlsZS5kaXNwbGF5ID0gJydcbiAgfVxuXG4gIGJlZm9yZVNob3cgKG9wdHMpIHtcbiAgICBpZiAob3B0cyAmJiBvcHRzLmJhY2spIHtcbiAgICAgIHRoaXMucmVmcy5icmVhZGNydW1iLnRleHRDb250ZW50ID0gb3B0cy5iYWNrXG4gICAgICB0aGlzLnJlZnMuYnJlYWRjcnVtYi5vbmNsaWNrID0gKCkgPT4geyB0aGlzLnNldHRpbmdzVmlldy5zaG93UGFuZWwob3B0cy5iYWNrKSB9XG4gICAgfVxuXG4gICAgaWYgKG9wdHMgJiYgb3B0cy51cGRhdGVzKSB7XG4gICAgICB0aGlzLmF2YWlsYWJsZVVwZGF0ZXMgPSBvcHRzLnVwZGF0ZXNcbiAgICAgIHRoaXMuYWRkVXBkYXRlVmlld3MoKVxuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLmF2YWlsYWJsZVVwZGF0ZXMgPSBbXVxuICAgICAgdGhpcy5jbGVhclBhY2thZ2VDYXJkcygpXG4gICAgICB0aGlzLmNoZWNrRm9yVXBkYXRlcygpXG4gICAgfVxuXG4gICAgaWYgKHRoaXMucGFja2FnZU1hbmFnZXIuZ2V0VmVyc2lvblBpbm5lZFBhY2thZ2VzKCkubGVuZ3RoID09PSAwKSB7XG4gICAgICB0aGlzLnJlZnMudmVyc2lvblBpbm5lZFBhY2thZ2VzTWVzc2FnZS5zdHlsZS5kaXNwbGF5ID0gJ25vbmUnXG4gICAgfVxuICB9XG5cbiAgLy8gQ2hlY2sgZm9yIHVwZGF0ZXMgYW5kIGRpc3BsYXkgdGhlbVxuICBhc3luYyBjaGVja0ZvclVwZGF0ZXMgKGNsZWFyQ2FjaGUpIHtcbiAgICB0aGlzLnJlZnMubm9VcGRhdGVzTWVzc2FnZS5zdHlsZS5kaXNwbGF5ID0gJ25vbmUnXG4gICAgdGhpcy5yZWZzLnVwZGF0ZUFsbEJ1dHRvbi5kaXNhYmxlZCA9IHRydWVcbiAgICB0aGlzLnJlZnMuY2hlY2tCdXR0b24uZGlzYWJsZWQgPSB0cnVlXG4gICAgdGhpcy5yZWZzLmNoZWNraW5nTWVzc2FnZS5zdHlsZS5kaXNwbGF5ID0gJydcblxuICAgIHRyeSB7XG4gICAgICB0aGlzLmF2YWlsYWJsZVVwZGF0ZXMgPSBhd2FpdCB0aGlzLnBhY2thZ2VNYW5hZ2VyLmdldE91dGRhdGVkKGNsZWFyQ2FjaGUpXG4gICAgICB0aGlzLnJlZnMuY2hlY2tCdXR0b24uZGlzYWJsZWQgPSBmYWxzZVxuICAgICAgdGhpcy5hZGRVcGRhdGVWaWV3cygpXG4gICAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICAgIHRoaXMucmVmcy5jaGVja0J1dHRvbi5kaXNhYmxlZCA9IGZhbHNlXG4gICAgICB0aGlzLnJlZnMuY2hlY2tpbmdNZXNzYWdlLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgICAgIHRoaXMucmVmcy51cGRhdGVFcnJvcnMuYXBwZW5kQ2hpbGQobmV3IEVycm9yVmlldyh0aGlzLnBhY2thZ2VNYW5hZ2VyLCBlcnJvcikuZWxlbWVudClcbiAgICB9XG4gIH1cblxuICBhZGRVcGRhdGVWaWV3cyAoKSB7XG4gICAgaWYgKHRoaXMuYXZhaWxhYmxlVXBkYXRlcy5sZW5ndGggPiAwKSB7XG4gICAgICB0aGlzLnJlZnMudXBkYXRlQWxsQnV0dG9uLnN0eWxlLmRpc3BsYXkgPSAnJ1xuICAgICAgdGhpcy5yZWZzLnVwZGF0ZUFsbEJ1dHRvbi5kaXNhYmxlZCA9IGZhbHNlXG4gICAgfVxuICAgIHRoaXMucmVmcy5jaGVja2luZ01lc3NhZ2Uuc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgIHRoaXMuY2xlYXJQYWNrYWdlQ2FyZHMoKVxuICAgIGlmICh0aGlzLmF2YWlsYWJsZVVwZGF0ZXMubGVuZ3RoID09PSAwKSB7XG4gICAgICB0aGlzLnJlZnMubm9VcGRhdGVzTWVzc2FnZS5zdHlsZS5kaXNwbGF5ID0gJydcbiAgICB9XG5cbiAgICBmb3IgKGNvbnN0IHBhY2sgb2YgdGhpcy5hdmFpbGFibGVVcGRhdGVzKSB7XG4gICAgICBjb25zdCBwYWNrYWdlQ2FyZCA9IG5ldyBQYWNrYWdlQ2FyZChwYWNrLCB0aGlzLnNldHRpbmdzVmlldywgdGhpcy5wYWNrYWdlTWFuYWdlciwge2JhY2s6ICdVcGRhdGVzJ30pXG4gICAgICB0aGlzLnJlZnMudXBkYXRlc0NvbnRhaW5lci5hcHBlbmRDaGlsZChwYWNrYWdlQ2FyZC5lbGVtZW50KVxuICAgICAgdGhpcy5wYWNrYWdlQ2FyZHMucHVzaChwYWNrYWdlQ2FyZClcbiAgICB9XG4gIH1cblxuICBhc3luYyB1cGRhdGVBbGwgKCkge1xuICAgIHRoaXMucmVmcy5jaGVja0J1dHRvbi5kaXNhYmxlZCA9IHRydWVcbiAgICB0aGlzLnJlZnMudXBkYXRlQWxsQnV0dG9uLmRpc2FibGVkID0gdHJ1ZVxuXG4gICAgbGV0IHVwZGF0aW5nUGFja2FnZXMgPSB0aGlzLnVwZGF0aW5nUGFja2FnZXNcbiAgICBsZXQgc3VjY2Vzc2Z1bFVwZGF0ZXNDb3VudCA9IDBcbiAgICBsZXQgZmFpbGVkVXBkYXRlc0NvdW50ID0gMFxuXG4gICAgY29uc3QgY29uY3VycmVuY3kgPSBhdG9tLmNvbmZpZy5nZXQoJ3NldHRpbmdzLXZpZXcucGFja2FnZVVwZGF0ZUNvbmN1cnJlbmN5JykgPiAwXG4gICAgICA/IGF0b20uY29uZmlnLmdldCgnc2V0dGluZ3Mtdmlldy5wYWNrYWdlVXBkYXRlQ29uY3VycmVuY3knKVxuICAgICAgOiBOdW1iZXIuUE9TSVRJVkVfSU5GSU5JVFlcblxuICAgIGNvbnN0IHF1ZXVlID0gYXN5bmNRdWV1ZShmdW5jdGlvbiAocGFja2FnZUNhcmQsIGNhbGxiYWNrKSB7XG4gICAgICBjb25zdCBvblVwZGF0ZUNvbXBsZXRlZCA9IGZ1bmN0aW9uIChlcnIpIHtcbiAgICAgICAgZXJyID09IG51bGwgPyBzdWNjZXNzZnVsVXBkYXRlc0NvdW50KysgOiBmYWlsZWRVcGRhdGVzQ291bnQrK1xuICAgICAgfVxuXG4gICAgICBpZiAodXBkYXRpbmdQYWNrYWdlcy5pbmNsdWRlcyhwYWNrYWdlQ2FyZC5wYWNrKSkge1xuICAgICAgICBjYWxsYmFjaygpXG4gICAgICB9IGVsc2Uge1xuICAgICAgICBwYWNrYWdlQ2FyZC51cGRhdGUoKS50aGVuKG9uVXBkYXRlQ29tcGxldGVkLCBvblVwZGF0ZUNvbXBsZXRlZCkudGhlbihjYWxsYmFjaylcbiAgICAgIH1cbiAgICB9LCBjb25jdXJyZW5jeSlcblxuICAgIHF1ZXVlLnB1c2godGhpcy5wYWNrYWdlQ2FyZHMpXG5cbiAgICBhd2FpdCBxdWV1ZS5kcmFpbigpXG5cbiAgICBpZiAoc3VjY2Vzc2Z1bFVwZGF0ZXNDb3VudCA+IDApIHtcbiAgICAgIGNvbnN0IG1lc3NhZ2UgPSBgUmVzdGFydCBBdG9tIHRvIGNvbXBsZXRlIHRoZSB1cGRhdGUgb2YgJHtzdWNjZXNzZnVsVXBkYXRlc0NvdW50fSAke3BsdXJhbGl6ZSgncGFja2FnZScsIHN1Y2Nlc3NmdWxVcGRhdGVzQ291bnQpfTpgXG4gICAgICBsZXQgZGV0YWlsID0gJydcbiAgICAgIHRoaXMucGFja2FnZUNhcmRzLmZvckVhY2goKGNhcmQpID0+IHtcbiAgICAgICAgbGV0IG9sZFZlcnNpb24gPSAnJ1xuICAgICAgICBsZXQgbmV3VmVyc2lvbiA9ICcnXG5cbiAgICAgICAgaWYgKGNhcmQucGFjay5hcG1JbnN0YWxsU291cmNlICYmIGNhcmQucGFjay5hcG1JbnN0YWxsU291cmNlLnR5cGUgPT09ICdnaXQnKSB7XG4gICAgICAgICAgb2xkVmVyc2lvbiA9IGNhcmQucGFjay5hcG1JbnN0YWxsU291cmNlLnNoYS5zdWJzdHIoMCwgOClcbiAgICAgICAgICBuZXdWZXJzaW9uID0gYCR7Y2FyZC5wYWNrLmxhdGVzdFNoYS5zdWJzdHIoMCwgOCl9YFxuICAgICAgICB9IGVsc2UgaWYgKGNhcmQucGFjay52ZXJzaW9uICYmIGNhcmQucGFjay5sYXRlc3RWZXJzaW9uKSB7XG4gICAgICAgICAgb2xkVmVyc2lvbiA9IGNhcmQucGFjay52ZXJzaW9uXG4gICAgICAgICAgbmV3VmVyc2lvbiA9IGNhcmQucGFjay5sYXRlc3RWZXJzaW9uXG4gICAgICAgIH1cblxuICAgICAgICBpZiAob2xkVmVyc2lvbiAmJiBuZXdWZXJzaW9uKSB7XG4gICAgICAgICAgZGV0YWlsICs9IGAke2NhcmQucGFjay5uYW1lfUAke29sZFZlcnNpb259IC0+ICR7bmV3VmVyc2lvbn1cXG5gXG4gICAgICAgIH1cbiAgICAgIH0pXG4gICAgICBkZXRhaWwgPSBkZXRhaWwudHJpbSgpXG5cbiAgICAgIGNvbnN0IG5vdGlmaWNhdGlvbiA9IGF0b20ubm90aWZpY2F0aW9ucy5hZGRTdWNjZXNzKG1lc3NhZ2UsIHtcbiAgICAgICAgZGlzbWlzc2FibGU6IHRydWUsXG4gICAgICAgIGJ1dHRvbnM6IFt7XG4gICAgICAgICAgdGV4dDogJ1Jlc3RhcnQgbm93JyxcbiAgICAgICAgICBvbkRpZENsaWNrICgpIHsgcmV0dXJuIGF0b20ucmVzdGFydEFwcGxpY2F0aW9uKCkgfVxuICAgICAgICB9LFxuICAgICAgICB7XG4gICAgICAgICAgdGV4dDogJ0lcXCdsbCBkbyBpdCBsYXRlcicsXG4gICAgICAgICAgb25EaWRDbGljayAoKSB7IG5vdGlmaWNhdGlvbi5kaXNtaXNzKCkgfVxuICAgICAgICB9XSxcbiAgICAgICAgZGV0YWlsXG4gICAgICB9KVxuICAgIH1cblxuICAgIGlmIChmYWlsZWRVcGRhdGVzQ291bnQgPT09IDApIHtcbiAgICAgIHRoaXMucmVmcy5jaGVja0J1dHRvbi5kaXNhYmxlZCA9IGZhbHNlXG4gICAgICB0aGlzLnJlZnMudXBkYXRlQWxsQnV0dG9uLnN0eWxlLmRpc3BsYXkgPSAnbm9uZSdcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5yZWZzLmNoZWNrQnV0dG9uLmRpc2FibGVkID0gZmFsc2VcbiAgICAgIHRoaXMucmVmcy51cGRhdGVBbGxCdXR0b24uZGlzYWJsZWQgPSBmYWxzZVxuICAgIH1cbiAgfVxuXG4gIGNsZWFyUGFja2FnZUNhcmRzICgpIHtcbiAgICB3aGlsZSAodGhpcy5wYWNrYWdlQ2FyZHMubGVuZ3RoKSB7XG4gICAgICB0aGlzLnBhY2thZ2VDYXJkcy5wb3AoKS5kZXN0cm95KClcbiAgICB9XG4gIH1cblxuICBzY3JvbGxVcCAoKSB7XG4gICAgdGhpcy5lbGVtZW50LnNjcm9sbFRvcCAtPSBkb2N1bWVudC5ib2R5Lm9mZnNldEhlaWdodCAvIDIwXG4gIH1cblxuICBzY3JvbGxEb3duICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wICs9IGRvY3VtZW50LmJvZHkub2Zmc2V0SGVpZ2h0IC8gMjBcbiAgfVxuXG4gIHBhZ2VVcCAoKSB7XG4gICAgdGhpcy5lbGVtZW50LnNjcm9sbFRvcCAtPSB0aGlzLmVsZW1lbnQub2Zmc2V0SGVpZ2h0XG4gIH1cblxuICBwYWdlRG93biAoKSB7XG4gICAgdGhpcy5lbGVtZW50LnNjcm9sbFRvcCArPSB0aGlzLmVsZW1lbnQub2Zmc2V0SGVpZ2h0XG4gIH1cblxuICBzY3JvbGxUb1RvcCAoKSB7XG4gICAgdGhpcy5lbGVtZW50LnNjcm9sbFRvcCA9IDBcbiAgfVxuXG4gIHNjcm9sbFRvQm90dG9tICgpIHtcbiAgICB0aGlzLmVsZW1lbnQuc2Nyb2xsVG9wID0gdGhpcy5lbGVtZW50LnNjcm9sbEhlaWdodFxuICB9XG59XG5cbmZ1bmN0aW9uIHBsdXJhbGl6ZSAod29yZCwgY291bnQpIHtcbiAgcmV0dXJuIChjb3VudCA+IDEpID8gYCR7d29yZH1zYCA6IHdvcmRcbn1cbiJdfQ==