Object.defineProperty(exports, '__esModule', {
    value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var CorrectionsView = (function () {
    function CorrectionsView(editor, corrections, marker, updateTarget, updateCallback) {
        var _this = this;

        _classCallCheck(this, CorrectionsView);

        this.editor = editor;
        this.corrections = corrections;
        this.marker = marker;
        this.updateTarget = updateTarget;
        this.updateCallback = updateCallback;
        this.selectListView = new _atomSelectList2['default']({
            emptyMessage: 'No corrections',
            items: this.corrections,
            filterKeyForItem: function filterKeyForItem(item) {
                return item.label;
            },
            elementForItem: function elementForItem(item) {
                var element = document.createElement('li');
                if (item.isSuggestion) {
                    // This is a word replacement suggestion.
                    element.textContent = item.label;
                } else {
                    // This is an operation such as add word.
                    var em = document.createElement('em');
                    em.textContent = item.label;
                    element.appendChild(em);
                }
                return element;
            },
            didConfirmSelection: function didConfirmSelection(item) {
                _this.editor.transact(function () {
                    if (item.isSuggestion) {
                        // Update the buffer with the correction.
                        _this.editor.setSelectedBufferRange(_this.marker.getBufferRange());
                        _this.editor.insertText(item.suggestion);
                    } else {
                        // Build up the arguments object for this buffer and text.
                        var projectPath = null;
                        var relativePath = null;
                        if (_this.editor && _this.editor.buffer && _this.editor.buffer.file && _this.editor.buffer.file.path) {
                            var _atom$project$relativizePath = atom.project.relativizePath(_this.editor.buffer.file.path);

                            var _atom$project$relativizePath2 = _slicedToArray(_atom$project$relativizePath, 2);

                            projectPath = _atom$project$relativizePath2[0];
                            relativePath = _atom$project$relativizePath2[1];
                        }

                        var args = { id: _this.id, projectPath: projectPath, relativePath: relativePath };
                        // Send the "add" request to the plugin.
                        item.plugin.add(args, item);
                        // Update the buffer to handle the corrections.
                        _this.updateCallback.bind(_this.updateTarget)();
                    }
                });
                _this.destroy();
            },
            didConfirmEmptySelection: function didConfirmEmptySelection() {
                _this.destroy();
            },
            didCancelSelection: function didCancelSelection() {
                _this.destroy();
            }
        });
        this.selectListView.element.classList.add('spell-check-corrections', 'corrections', 'popover-list');
    }

    _createClass(CorrectionsView, [{
        key: 'attach',
        value: function attach() {
            var _this2 = this;

            this.previouslyFocusedElement = document.activeElement;
            this.overlayDecoration = this.editor.decorateMarker(this.marker, {
                type: 'overlay',
                item: this.selectListView
            });
            process.nextTick(function () {
                atom.views.readDocument(function () {
                    _this2.selectListView.focus();
                });
            });
        }
    }, {
        key: 'destroy',
        value: _asyncToGenerator(function* () {
            if (!this.destroyed) {
                this.destroyed = true;
                this.overlayDecoration.destroy();
                yield this.selectListView.destroy();
                if (this.previouslyFocusedElement) {
                    this.previouslyFocusedElement.focus();
                    this.previouslyFocusedElement = null;
                }
            }
        })
    }]);

    return CorrectionsView;
})();

exports['default'] = CorrectionsView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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