"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const TokenCheckStatus_1 = require("./TokenCheckStatus");
/**
 * Defines the common functionality for the various spelling managers.
 */
class SpellingManager {
    /**
     * Adds a word to the spelling manager.
     */
    add(token) {
        // We don't have default functionality for adding.
    }
    /**
     * Check to see if a token is correct.
     */
    isCorrect(token) {
        return this.check(token) === TokenCheckStatus_1.TokenCheckStatus.Correct;
    }
    /**
     * Checks the token to determine if it is correct or incorrect.
     */
    check(token) {
        return TokenCheckStatus_1.TokenCheckStatus.Unknown;
    }
    /**
     * Gives a suggestion for a token, sorted by likelyhood with the first item
     * in the resulting array being the most likely.
     */
    suggest(token) {
        return [];
    }
}
exports.SpellingManager = SpellingManager;
//# sourceMappingURL=SpellingManager.js.map