Object.defineProperty(exports, '__esModule', {
  value: true
});
/** @babel */

exports['default'] = {
  activate: function activate() {
    var _this = this;

    this.stack = [];

    this.workspaceSubscription = atom.commands.add('atom-workspace', {
      'symbols-view:toggle-project-symbols': function symbolsViewToggleProjectSymbols() {
        _this.createProjectView().toggle();
      }
    });

    this.editorSubscription = atom.commands.add('atom-text-editor', {
      'symbols-view:toggle-file-symbols': function symbolsViewToggleFileSymbols() {
        _this.createFileView().toggle();
      },
      'symbols-view:go-to-declaration': function symbolsViewGoToDeclaration() {
        _this.createGoToView().toggle();
      },
      'symbols-view:return-from-declaration': function symbolsViewReturnFromDeclaration() {
        _this.createGoBackView().toggle();
      }
    });
  },

  deactivate: function deactivate() {
    if (this.fileView != null) {
      this.fileView.destroy();
      this.fileView = null;
    }

    if (this.projectView != null) {
      this.projectView.destroy();
      this.projectView = null;
    }

    if (this.goToView != null) {
      this.goToView.destroy();
      this.goToView = null;
    }

    if (this.goBackView != null) {
      this.goBackView.destroy();
      this.goBackView = null;
    }

    if (this.workspaceSubscription != null) {
      this.workspaceSubscription.dispose();
      this.workspaceSubscription = null;
    }

    if (this.editorSubscription != null) {
      this.editorSubscription.dispose();
      this.editorSubscription = null;
    }
  },

  createFileView: function createFileView() {
    if (this.fileView) {
      return this.fileView;
    }
    var FileView = require('./file-view');
    this.fileView = new FileView(this.stack);
    return this.fileView;
  },

  createProjectView: function createProjectView() {
    if (this.projectView) {
      return this.projectView;
    }
    var ProjectView = require('./project-view');
    this.projectView = new ProjectView(this.stack);
    return this.projectView;
  },

  createGoToView: function createGoToView() {
    if (this.goToView) {
      return this.goToView;
    }
    var GoToView = require('./go-to-view');
    this.goToView = new GoToView(this.stack);
    return this.goToView;
  },

  createGoBackView: function createGoBackView() {
    if (this.goBackView) {
      return this.goBackView;
    }
    var GoBackView = require('./go-back-view');
    this.goBackView = new GoBackView(this.stack);
    return this.goBackView;
  }
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL3N5bWJvbHMtdmlldy9saWIvbWFpbi5qcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztxQkFFZTtBQUNiLFVBQVEsRUFBQSxvQkFBRzs7O0FBQ1QsUUFBSSxDQUFDLEtBQUssR0FBRyxFQUFFLENBQUM7O0FBRWhCLFFBQUksQ0FBQyxxQkFBcUIsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxnQkFBZ0IsRUFBRTtBQUMvRCwyQ0FBcUMsRUFBRSwyQ0FBTTtBQUMzQyxjQUFLLGlCQUFpQixFQUFFLENBQUMsTUFBTSxFQUFFLENBQUM7T0FDbkM7S0FDRixDQUFDLENBQUM7O0FBRUgsUUFBSSxDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLGtCQUFrQixFQUFFO0FBQzlELHdDQUFrQyxFQUFFLHdDQUFNO0FBQ3hDLGNBQUssY0FBYyxFQUFFLENBQUMsTUFBTSxFQUFFLENBQUM7T0FDaEM7QUFDRCxzQ0FBZ0MsRUFBRSxzQ0FBTTtBQUN0QyxjQUFLLGNBQWMsRUFBRSxDQUFDLE1BQU0sRUFBRSxDQUFDO09BQ2hDO0FBQ0QsNENBQXNDLEVBQUUsNENBQU07QUFDNUMsY0FBSyxnQkFBZ0IsRUFBRSxDQUFDLE1BQU0sRUFBRSxDQUFDO09BQ2xDO0tBQ0YsQ0FBQyxDQUFDO0dBQ0o7O0FBRUQsWUFBVSxFQUFBLHNCQUFHO0FBQ1gsUUFBSSxJQUFJLENBQUMsUUFBUSxJQUFJLElBQUksRUFBRTtBQUN6QixVQUFJLENBQUMsUUFBUSxDQUFDLE9BQU8sRUFBRSxDQUFDO0FBQ3hCLFVBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDO0tBQ3RCOztBQUVELFFBQUksSUFBSSxDQUFDLFdBQVcsSUFBSSxJQUFJLEVBQUU7QUFDNUIsVUFBSSxDQUFDLFdBQVcsQ0FBQyxPQUFPLEVBQUUsQ0FBQztBQUMzQixVQUFJLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQztLQUN6Qjs7QUFFRCxRQUFJLElBQUksQ0FBQyxRQUFRLElBQUksSUFBSSxFQUFFO0FBQ3pCLFVBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxFQUFFLENBQUM7QUFDeEIsVUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7S0FDdEI7O0FBRUQsUUFBSSxJQUFJLENBQUMsVUFBVSxJQUFJLElBQUksRUFBRTtBQUMzQixVQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sRUFBRSxDQUFDO0FBQzFCLFVBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO0tBQ3hCOztBQUVELFFBQUksSUFBSSxDQUFDLHFCQUFxQixJQUFJLElBQUksRUFBRTtBQUN0QyxVQUFJLENBQUMscUJBQXFCLENBQUMsT0FBTyxFQUFFLENBQUM7QUFDckMsVUFBSSxDQUFDLHFCQUFxQixHQUFHLElBQUksQ0FBQztLQUNuQzs7QUFFRCxRQUFJLElBQUksQ0FBQyxrQkFBa0IsSUFBSSxJQUFJLEVBQUU7QUFDbkMsVUFBSSxDQUFDLGtCQUFrQixDQUFDLE9BQU8sRUFBRSxDQUFDO0FBQ2xDLFVBQUksQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUM7S0FDaEM7R0FDRjs7QUFFRCxnQkFBYyxFQUFBLDBCQUFHO0FBQ2YsUUFBSSxJQUFJLENBQUMsUUFBUSxFQUFFO0FBQ2pCLGFBQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztLQUN0QjtBQUNELFFBQU0sUUFBUSxHQUFJLE9BQU8sQ0FBQyxhQUFhLENBQUMsQ0FBQztBQUN6QyxRQUFJLENBQUMsUUFBUSxHQUFHLElBQUksUUFBUSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztBQUN6QyxXQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7R0FDdEI7O0FBRUQsbUJBQWlCLEVBQUEsNkJBQUc7QUFDbEIsUUFBSSxJQUFJLENBQUMsV0FBVyxFQUFFO0FBQ3BCLGFBQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztLQUN6QjtBQUNELFFBQU0sV0FBVyxHQUFJLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0FBQy9DLFFBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSxXQUFXLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO0FBQy9DLFdBQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztHQUN6Qjs7QUFFRCxnQkFBYyxFQUFBLDBCQUFHO0FBQ2YsUUFBSSxJQUFJLENBQUMsUUFBUSxFQUFFO0FBQ2pCLGFBQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztLQUN0QjtBQUNELFFBQU0sUUFBUSxHQUFHLE9BQU8sQ0FBQyxjQUFjLENBQUMsQ0FBQztBQUN6QyxRQUFJLENBQUMsUUFBUSxHQUFHLElBQUksUUFBUSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztBQUN6QyxXQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7R0FDdEI7O0FBRUQsa0JBQWdCLEVBQUEsNEJBQUc7QUFDakIsUUFBSSxJQUFJLENBQUMsVUFBVSxFQUFFO0FBQ25CLGFBQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQztLQUN4QjtBQUNELFFBQU0sVUFBVSxHQUFHLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0FBQzdDLFFBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxVQUFVLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO0FBQzdDLFdBQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQztHQUN4QjtDQUNGIiwiZmlsZSI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL3N5bWJvbHMtdmlldy9saWIvbWFpbi5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qKiBAYmFiZWwgKi9cblxuZXhwb3J0IGRlZmF1bHQge1xuICBhY3RpdmF0ZSgpIHtcbiAgICB0aGlzLnN0YWNrID0gW107XG5cbiAgICB0aGlzLndvcmtzcGFjZVN1YnNjcmlwdGlvbiA9IGF0b20uY29tbWFuZHMuYWRkKCdhdG9tLXdvcmtzcGFjZScsIHtcbiAgICAgICdzeW1ib2xzLXZpZXc6dG9nZ2xlLXByb2plY3Qtc3ltYm9scyc6ICgpID0+IHtcbiAgICAgICAgdGhpcy5jcmVhdGVQcm9qZWN0VmlldygpLnRvZ2dsZSgpO1xuICAgICAgfSxcbiAgICB9KTtcblxuICAgIHRoaXMuZWRpdG9yU3Vic2NyaXB0aW9uID0gYXRvbS5jb21tYW5kcy5hZGQoJ2F0b20tdGV4dC1lZGl0b3InLCB7XG4gICAgICAnc3ltYm9scy12aWV3OnRvZ2dsZS1maWxlLXN5bWJvbHMnOiAoKSA9PiB7XG4gICAgICAgIHRoaXMuY3JlYXRlRmlsZVZpZXcoKS50b2dnbGUoKTtcbiAgICAgIH0sXG4gICAgICAnc3ltYm9scy12aWV3OmdvLXRvLWRlY2xhcmF0aW9uJzogKCkgPT4ge1xuICAgICAgICB0aGlzLmNyZWF0ZUdvVG9WaWV3KCkudG9nZ2xlKCk7XG4gICAgICB9LFxuICAgICAgJ3N5bWJvbHMtdmlldzpyZXR1cm4tZnJvbS1kZWNsYXJhdGlvbic6ICgpID0+IHtcbiAgICAgICAgdGhpcy5jcmVhdGVHb0JhY2tWaWV3KCkudG9nZ2xlKCk7XG4gICAgICB9LFxuICAgIH0pO1xuICB9LFxuXG4gIGRlYWN0aXZhdGUoKSB7XG4gICAgaWYgKHRoaXMuZmlsZVZpZXcgIT0gbnVsbCkge1xuICAgICAgdGhpcy5maWxlVmlldy5kZXN0cm95KCk7XG4gICAgICB0aGlzLmZpbGVWaWV3ID0gbnVsbDtcbiAgICB9XG5cbiAgICBpZiAodGhpcy5wcm9qZWN0VmlldyAhPSBudWxsKSB7XG4gICAgICB0aGlzLnByb2plY3RWaWV3LmRlc3Ryb3koKTtcbiAgICAgIHRoaXMucHJvamVjdFZpZXcgPSBudWxsO1xuICAgIH1cblxuICAgIGlmICh0aGlzLmdvVG9WaWV3ICE9IG51bGwpIHtcbiAgICAgIHRoaXMuZ29Ub1ZpZXcuZGVzdHJveSgpO1xuICAgICAgdGhpcy5nb1RvVmlldyA9IG51bGw7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMuZ29CYWNrVmlldyAhPSBudWxsKSB7XG4gICAgICB0aGlzLmdvQmFja1ZpZXcuZGVzdHJveSgpO1xuICAgICAgdGhpcy5nb0JhY2tWaWV3ID0gbnVsbDtcbiAgICB9XG5cbiAgICBpZiAodGhpcy53b3Jrc3BhY2VTdWJzY3JpcHRpb24gIT0gbnVsbCkge1xuICAgICAgdGhpcy53b3Jrc3BhY2VTdWJzY3JpcHRpb24uZGlzcG9zZSgpO1xuICAgICAgdGhpcy53b3Jrc3BhY2VTdWJzY3JpcHRpb24gPSBudWxsO1xuICAgIH1cblxuICAgIGlmICh0aGlzLmVkaXRvclN1YnNjcmlwdGlvbiAhPSBudWxsKSB7XG4gICAgICB0aGlzLmVkaXRvclN1YnNjcmlwdGlvbi5kaXNwb3NlKCk7XG4gICAgICB0aGlzLmVkaXRvclN1YnNjcmlwdGlvbiA9IG51bGw7XG4gICAgfVxuICB9LFxuXG4gIGNyZWF0ZUZpbGVWaWV3KCkge1xuICAgIGlmICh0aGlzLmZpbGVWaWV3KSB7XG4gICAgICByZXR1cm4gdGhpcy5maWxlVmlldztcbiAgICB9XG4gICAgY29uc3QgRmlsZVZpZXcgID0gcmVxdWlyZSgnLi9maWxlLXZpZXcnKTtcbiAgICB0aGlzLmZpbGVWaWV3ID0gbmV3IEZpbGVWaWV3KHRoaXMuc3RhY2spO1xuICAgIHJldHVybiB0aGlzLmZpbGVWaWV3O1xuICB9LFxuXG4gIGNyZWF0ZVByb2plY3RWaWV3KCkge1xuICAgIGlmICh0aGlzLnByb2plY3RWaWV3KSB7XG4gICAgICByZXR1cm4gdGhpcy5wcm9qZWN0VmlldztcbiAgICB9XG4gICAgY29uc3QgUHJvamVjdFZpZXcgID0gcmVxdWlyZSgnLi9wcm9qZWN0LXZpZXcnKTtcbiAgICB0aGlzLnByb2plY3RWaWV3ID0gbmV3IFByb2plY3RWaWV3KHRoaXMuc3RhY2spO1xuICAgIHJldHVybiB0aGlzLnByb2plY3RWaWV3O1xuICB9LFxuXG4gIGNyZWF0ZUdvVG9WaWV3KCkge1xuICAgIGlmICh0aGlzLmdvVG9WaWV3KSB7XG4gICAgICByZXR1cm4gdGhpcy5nb1RvVmlldztcbiAgICB9XG4gICAgY29uc3QgR29Ub1ZpZXcgPSByZXF1aXJlKCcuL2dvLXRvLXZpZXcnKTtcbiAgICB0aGlzLmdvVG9WaWV3ID0gbmV3IEdvVG9WaWV3KHRoaXMuc3RhY2spO1xuICAgIHJldHVybiB0aGlzLmdvVG9WaWV3O1xuICB9LFxuXG4gIGNyZWF0ZUdvQmFja1ZpZXcoKSB7XG4gICAgaWYgKHRoaXMuZ29CYWNrVmlldykge1xuICAgICAgcmV0dXJuIHRoaXMuZ29CYWNrVmlldztcbiAgICB9XG4gICAgY29uc3QgR29CYWNrVmlldyA9IHJlcXVpcmUoJy4vZ28tYmFjay12aWV3Jyk7XG4gICAgdGhpcy5nb0JhY2tWaWV3ID0gbmV3IEdvQmFja1ZpZXcodGhpcy5zdGFjayk7XG4gICAgcmV0dXJuIHRoaXMuZ29CYWNrVmlldztcbiAgfSxcbn07XG4iXX0=