Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var CachePanelView = (function () {
  function CachePanelView() {
    _classCallCheck(this, CachePanelView);

    _etch2['default'].initialize(this);
  }

  _createClass(CachePanelView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'tool-panel padded package-panel' },
        _etch2['default'].dom(
          'div',
          { className: 'inset-panel' },
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            'Compile Cache'
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-body padded' },
            _etch2['default'].dom(
              'div',
              { className: 'timing' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'CoffeeScript files compiled'
              ),
              _etch2['default'].dom(
                'span',
                { className: 'inline-block', ref: 'coffeeCompileCount' },
                'Loading…'
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'timing' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'Babel files compiled'
              ),
              _etch2['default'].dom(
                'span',
                { className: 'inline-block', ref: 'babelCompileCount' },
                'Loading…'
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'timing' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'Typescript files compiled'
              ),
              _etch2['default'].dom(
                'span',
                { className: 'inline-block', ref: 'typescriptCompileCount' },
                'Loading…'
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'timing' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'CSON files compiled'
              ),
              _etch2['default'].dom(
                'span',
                { className: 'inline-block', ref: 'csonCompileCount' },
                'Loading…'
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'timing' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'Less files compiled'
              ),
              _etch2['default'].dom(
                'span',
                { className: 'inline-block', ref: 'lessCompileCount' },
                'Loading…'
              )
            )
          )
        )
      );
    }
  }, {
    key: 'populate',
    value: function populate() {
      var compileCacheStats = this.getCompileCacheStats();
      if (compileCacheStats) {
        this.refs.coffeeCompileCount.classList.add('highlight-info');
        this.refs.coffeeCompileCount.textContent = compileCacheStats['.coffee'].misses;
        this.refs.babelCompileCount.classList.add('highlight-info');
        this.refs.babelCompileCount.textContent = compileCacheStats['.js'].misses;
        this.refs.typescriptCompileCount.classList.add('highlight-info');
        this.refs.typescriptCompileCount.textContent = compileCacheStats['.ts'].misses;
      }

      this.refs.csonCompileCount.classList.add('highlight-info');
      this.refs.csonCompileCount.textContent = this.getCsonCompiles();
      this.refs.lessCompileCount.classList.add('highlight-info');
      this.refs.lessCompileCount.textContent = this.getLessCompiles();
    }
  }, {
    key: 'getCompileCacheStats',
    value: function getCompileCacheStats() {
      try {
        return require(_path2['default'].join(atom.getLoadSettings().resourcePath, 'src', 'compile-cache')).getCacheStats();
      } catch (error) {
        return null;
      }
    }
  }, {
    key: 'getCsonCompiles',
    value: function getCsonCompiles() {
      try {
        var CSON = require(_path2['default'].join(atom.getLoadSettings().resourcePath, 'node_modules', 'season'));
        if (CSON.getCacheMisses) {
          return CSON.getCacheMisses() || 0;
        } else {
          return 0;
        }
      } catch (error) {
        return 0;
      }
    }
  }, {
    key: 'getLessCompiles',
    value: function getLessCompiles() {
      var lessCache = atom.themes.lessCache;
      if (lessCache && lessCache.cache && lessCache.cache.stats && lessCache.cache.stats.misses) {
        return lessCache.cache.stats.misses || 0;
      } else {
        return 0;
      }
    }
  }]);

  return CachePanelView;
})();

exports['default'] = CachePanelView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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