Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var WindowPanelView = (function () {
  function WindowPanelView() {
    _classCallCheck(this, WindowPanelView);

    _etch2['default'].initialize(this);

    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.tooltips.add(this.refs.shellTiming, { title: 'The time taken to launch the app' }));
    this.disposables.add(atom.tooltips.add(this.refs.windowTiming, { title: 'The time taken to load this window' }));
    this.disposables.add(atom.tooltips.add(this.refs.projectTiming, { title: 'The time taken to rebuild the previously opened buffers' }));
    this.disposables.add(atom.tooltips.add(this.refs.workspaceTiming, { title: 'The time taken to rebuild the previously opened editors' }));
  }

  _createClass(WindowPanelView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'tool-panel padded package-panel' },
        _etch2['default'].dom(
          'div',
          { className: 'inset-panel' },
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            'Startup Time'
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-body padded' },
            _etch2['default'].dom(
              'div',
              { className: 'timing', ref: 'shellTiming' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'Shell load time'
              ),
              _etch2['default'].dom(
                'span',
                { className: 'inline-block', ref: 'shellLoadTime' },
                'Loading…'
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'timing', ref: 'windowTiming' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'Window load time'
              ),
              _etch2['default'].dom(
                'span',
                { className: 'inline-block', ref: 'windowLoadTime' },
                'Loading…'
              )
            ),
            _etch2['default'].dom(
              'div',
              { ref: 'deserializeTimings' },
              _etch2['default'].dom(
                'div',
                { className: 'timing', ref: 'projectTiming' },
                _etch2['default'].dom(
                  'span',
                  { className: 'inline-block' },
                  'Project load time'
                ),
                _etch2['default'].dom(
                  'span',
                  { className: 'inline-block', ref: 'projectLoadTime' },
                  'Loading…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { className: 'timing', ref: 'workspaceTiming' },
                _etch2['default'].dom(
                  'span',
                  { className: 'inline-block' },
                  'Workspace load time'
                ),
                _etch2['default'].dom(
                  'span',
                  { className: 'inline-block', ref: 'workspaceLoadTime' },
                  'Loading…'
                )
              )
            )
          )
        )
      );
    }
  }, {
    key: 'populate',
    value: function populate() {
      var time = atom.getWindowLoadTime();
      this.refs.windowLoadTime.classList.add(this.getHighlightClass(time));
      this.refs.windowLoadTime.textContent = time + 'ms';

      var _atom$getLoadSettings = atom.getLoadSettings();

      var shellLoadTime = _atom$getLoadSettings.shellLoadTime;

      if (shellLoadTime != null) {
        this.refs.shellLoadTime.classList.add(this.getHighlightClass(shellLoadTime));
        this.refs.shellLoadTime.textContent = shellLoadTime + 'ms';
      } else {
        this.refs.shellTiming.style.display = 'none';
      }

      if (atom.deserializeTimings.project != null) {
        // Project and workspace timings only exist if the current project was previously opened
        this.refs.projectLoadTime.classList.add(this.getHighlightClass(atom.deserializeTimings.project));
        this.refs.projectLoadTime.textContent = atom.deserializeTimings.project + 'ms';
        this.refs.workspaceLoadTime.classList.add(this.getHighlightClass(atom.deserializeTimings.workspace));
        this.refs.workspaceLoadTime.textContent = atom.deserializeTimings.workspace + 'ms';
      } else {
        this.refs.deserializeTimings.style.display = 'none';
      }
    }
  }, {
    key: 'getHighlightClass',
    value: function getHighlightClass(time) {
      if (time > 1000) {
        return 'highlight-error';
      } else if (time > 800) {
        return 'highlight-warning';
      } else {
        return 'highlight-info';
      }
    }
  }]);

  return WindowPanelView;
})();

exports['default'] = WindowPanelView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL3RpbWVjb3AvbGliL3dpbmRvdy1wYW5lbC12aWV3LmpzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7b0JBR2tDLE1BQU07O29CQUN2QixNQUFNOzs7O0lBRUYsZUFBZTtBQUN0QixXQURPLGVBQWUsR0FDbkI7MEJBREksZUFBZTs7QUFFaEMsc0JBQUssVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFBOztBQUVyQixRQUFJLENBQUMsV0FBVyxHQUFHLCtCQUF5QixDQUFBO0FBQzVDLFFBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxFQUFFLEVBQUMsS0FBSyxFQUFFLGtDQUFrQyxFQUFDLENBQUMsQ0FBQyxDQUFBO0FBQzNHLFFBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxFQUFFLEVBQUMsS0FBSyxFQUFFLG9DQUFvQyxFQUFDLENBQUMsQ0FBQyxDQUFBO0FBQzlHLFFBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsYUFBYSxFQUFFLEVBQUMsS0FBSyxFQUFFLHlEQUF5RCxFQUFDLENBQUMsQ0FBQyxDQUFBO0FBQ3BJLFFBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxFQUFFLEVBQUMsS0FBSyxFQUFFLHlEQUF5RCxFQUFDLENBQUMsQ0FBQyxDQUFBO0dBQ3ZJOztlQVRrQixlQUFlOztXQVczQixrQkFBRyxFQUFFOzs7V0FFSixtQkFBRztBQUNULFVBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxFQUFFLENBQUE7QUFDMUIsYUFBTyxrQkFBSyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUE7S0FDMUI7OztXQUVNLGtCQUFHO0FBQ1IsYUFDRTs7VUFBSyxTQUFTLEVBQUMsaUNBQWlDO1FBQzlDOztZQUFLLFNBQVMsRUFBQyxhQUFhO1VBQzFCOztjQUFLLFNBQVMsRUFBQyxlQUFlOztXQUFtQjtVQUNqRDs7Y0FBSyxTQUFTLEVBQUMsbUJBQW1CO1lBQ2hDOztnQkFBSyxTQUFTLEVBQUMsUUFBUSxFQUFDLEdBQUcsRUFBQyxhQUFhO2NBQ3ZDOztrQkFBTSxTQUFTLEVBQUMsY0FBYzs7ZUFBdUI7Y0FDckQ7O2tCQUFNLFNBQVMsRUFBQyxjQUFjLEVBQUMsR0FBRyxFQUFDLGVBQWU7O2VBQWdCO2FBQzlEO1lBRU47O2dCQUFLLFNBQVMsRUFBQyxRQUFRLEVBQUMsR0FBRyxFQUFDLGNBQWM7Y0FDeEM7O2tCQUFNLFNBQVMsRUFBQyxjQUFjOztlQUF3QjtjQUN0RDs7a0JBQU0sU0FBUyxFQUFDLGNBQWMsRUFBQyxHQUFHLEVBQUMsZ0JBQWdCOztlQUFnQjthQUMvRDtZQUVOOztnQkFBSyxHQUFHLEVBQUMsb0JBQW9CO2NBQzNCOztrQkFBSyxTQUFTLEVBQUMsUUFBUSxFQUFDLEdBQUcsRUFBQyxlQUFlO2dCQUN6Qzs7b0JBQU0sU0FBUyxFQUFDLGNBQWM7O2lCQUF5QjtnQkFDdkQ7O29CQUFNLFNBQVMsRUFBQyxjQUFjLEVBQUMsR0FBRyxFQUFDLGlCQUFpQjs7aUJBQWdCO2VBQ2hFO2NBRU47O2tCQUFLLFNBQVMsRUFBQyxRQUFRLEVBQUMsR0FBRyxFQUFDLGlCQUFpQjtnQkFDM0M7O29CQUFNLFNBQVMsRUFBQyxjQUFjOztpQkFBMkI7Z0JBQ3pEOztvQkFBTSxTQUFTLEVBQUMsY0FBYyxFQUFDLEdBQUcsRUFBQyxtQkFBbUI7O2lCQUFnQjtlQUNsRTthQUNGO1dBQ0Y7U0FDRjtPQUNGLENBQ1A7S0FDRjs7O1dBRVEsb0JBQUc7QUFDVixVQUFNLElBQUksR0FBRyxJQUFJLENBQUMsaUJBQWlCLEVBQUUsQ0FBQTtBQUNyQyxVQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFBO0FBQ3BFLFVBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLFdBQVcsR0FBTSxJQUFJLE9BQUksQ0FBQTs7a0NBRTFCLElBQUksQ0FBQyxlQUFlLEVBQUU7O1VBQXZDLGFBQWEseUJBQWIsYUFBYTs7QUFDcEIsVUFBSSxhQUFhLElBQUksSUFBSSxFQUFFO0FBQ3pCLFlBQUksQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUE7QUFDNUUsWUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsV0FBVyxHQUFNLGFBQWEsT0FBSSxDQUFBO09BQzNELE1BQU07QUFDTCxZQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQTtPQUM3Qzs7QUFFRCxVQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxPQUFPLElBQUksSUFBSSxFQUFFOztBQUUzQyxZQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQTtBQUNoRyxZQUFJLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxXQUFXLEdBQU0sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE9BQU8sT0FBSSxDQUFBO0FBQzlFLFlBQUksQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUE7QUFDcEcsWUFBSSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEdBQU0sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFNBQVMsT0FBSSxDQUFBO09BQ25GLE1BQU07QUFDTCxZQUFJLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFBO09BQ3BEO0tBQ0Y7OztXQUVpQiwyQkFBQyxJQUFJLEVBQUU7QUFDdkIsVUFBSSxJQUFJLEdBQUcsSUFBSSxFQUFFO0FBQ2YsZUFBTyxpQkFBaUIsQ0FBQTtPQUN6QixNQUFNLElBQUksSUFBSSxHQUFHLEdBQUcsRUFBRTtBQUNyQixlQUFPLG1CQUFtQixDQUFBO09BQzNCLE1BQU07QUFDTCxlQUFPLGdCQUFnQixDQUFBO09BQ3hCO0tBQ0Y7OztTQW5Ga0IsZUFBZTs7O3FCQUFmLGVBQWUiLCJmaWxlIjoiL2J1aWxkL2F0b20vc3JjL2F0b20vb3V0L2FwcC9ub2RlX21vZHVsZXMvdGltZWNvcC9saWIvd2luZG93LXBhbmVsLXZpZXcuanMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiogQGJhYmVsICovXG4vKiogQGpzeCBldGNoLmRvbSAqL1xuXG5pbXBvcnQge0NvbXBvc2l0ZURpc3Bvc2FibGV9IGZyb20gJ2F0b20nXG5pbXBvcnQgZXRjaCBmcm9tICdldGNoJ1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBXaW5kb3dQYW5lbFZpZXcge1xuICBjb25zdHJ1Y3RvciAoKSB7XG4gICAgZXRjaC5pbml0aWFsaXplKHRoaXMpXG5cbiAgICB0aGlzLmRpc3Bvc2FibGVzID0gbmV3IENvbXBvc2l0ZURpc3Bvc2FibGUoKVxuICAgIHRoaXMuZGlzcG9zYWJsZXMuYWRkKGF0b20udG9vbHRpcHMuYWRkKHRoaXMucmVmcy5zaGVsbFRpbWluZywge3RpdGxlOiAnVGhlIHRpbWUgdGFrZW4gdG8gbGF1bmNoIHRoZSBhcHAnfSkpXG4gICAgdGhpcy5kaXNwb3NhYmxlcy5hZGQoYXRvbS50b29sdGlwcy5hZGQodGhpcy5yZWZzLndpbmRvd1RpbWluZywge3RpdGxlOiAnVGhlIHRpbWUgdGFrZW4gdG8gbG9hZCB0aGlzIHdpbmRvdyd9KSlcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChhdG9tLnRvb2x0aXBzLmFkZCh0aGlzLnJlZnMucHJvamVjdFRpbWluZywge3RpdGxlOiAnVGhlIHRpbWUgdGFrZW4gdG8gcmVidWlsZCB0aGUgcHJldmlvdXNseSBvcGVuZWQgYnVmZmVycyd9KSlcbiAgICB0aGlzLmRpc3Bvc2FibGVzLmFkZChhdG9tLnRvb2x0aXBzLmFkZCh0aGlzLnJlZnMud29ya3NwYWNlVGltaW5nLCB7dGl0bGU6ICdUaGUgdGltZSB0YWtlbiB0byByZWJ1aWxkIHRoZSBwcmV2aW91c2x5IG9wZW5lZCBlZGl0b3JzJ30pKVxuICB9XG5cbiAgdXBkYXRlICgpIHt9XG5cbiAgZGVzdHJveSAoKSB7XG4gICAgdGhpcy5kaXNwb3NhYmxlcy5kaXNwb3NlKClcbiAgICByZXR1cm4gZXRjaC5kZXN0cm95KHRoaXMpXG4gIH1cblxuICByZW5kZXIgKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT0ndG9vbC1wYW5lbCBwYWRkZWQgcGFja2FnZS1wYW5lbCc+XG4gICAgICAgIDxkaXYgY2xhc3NOYW1lPSdpbnNldC1wYW5lbCc+XG4gICAgICAgICAgPGRpdiBjbGFzc05hbWU9J3BhbmVsLWhlYWRpbmcnPlN0YXJ0dXAgVGltZTwvZGl2PlxuICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPSdwYW5lbC1ib2R5IHBhZGRlZCc+XG4gICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0ndGltaW5nJyByZWY9J3NoZWxsVGltaW5nJz5cbiAgICAgICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPSdpbmxpbmUtYmxvY2snPlNoZWxsIGxvYWQgdGltZTwvc3Bhbj5cbiAgICAgICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPSdpbmxpbmUtYmxvY2snIHJlZj0nc2hlbGxMb2FkVGltZSc+TG9hZGluZ+KApjwvc3Bhbj5cbiAgICAgICAgICAgIDwvZGl2PlxuXG4gICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0ndGltaW5nJyByZWY9J3dpbmRvd1RpbWluZyc+XG4gICAgICAgICAgICAgIDxzcGFuIGNsYXNzTmFtZT0naW5saW5lLWJsb2NrJz5XaW5kb3cgbG9hZCB0aW1lPC9zcGFuPlxuICAgICAgICAgICAgICA8c3BhbiBjbGFzc05hbWU9J2lubGluZS1ibG9jaycgcmVmPSd3aW5kb3dMb2FkVGltZSc+TG9hZGluZ+KApjwvc3Bhbj5cbiAgICAgICAgICAgIDwvZGl2PlxuXG4gICAgICAgICAgICA8ZGl2IHJlZj0nZGVzZXJpYWxpemVUaW1pbmdzJz5cbiAgICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9J3RpbWluZycgcmVmPSdwcm9qZWN0VGltaW5nJz5cbiAgICAgICAgICAgICAgICA8c3BhbiBjbGFzc05hbWU9J2lubGluZS1ibG9jayc+UHJvamVjdCBsb2FkIHRpbWU8L3NwYW4+XG4gICAgICAgICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPSdpbmxpbmUtYmxvY2snIHJlZj0ncHJvamVjdExvYWRUaW1lJz5Mb2FkaW5n4oCmPC9zcGFuPlxuICAgICAgICAgICAgICA8L2Rpdj5cblxuICAgICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT0ndGltaW5nJyByZWY9J3dvcmtzcGFjZVRpbWluZyc+XG4gICAgICAgICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPSdpbmxpbmUtYmxvY2snPldvcmtzcGFjZSBsb2FkIHRpbWU8L3NwYW4+XG4gICAgICAgICAgICAgICAgPHNwYW4gY2xhc3NOYW1lPSdpbmxpbmUtYmxvY2snIHJlZj0nd29ya3NwYWNlTG9hZFRpbWUnPkxvYWRpbmfigKY8L3NwYW4+XG4gICAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgIDwvZGl2PlxuICAgICAgPC9kaXY+XG4gICAgKVxuICB9XG5cbiAgcG9wdWxhdGUgKCkge1xuICAgIGNvbnN0IHRpbWUgPSBhdG9tLmdldFdpbmRvd0xvYWRUaW1lKClcbiAgICB0aGlzLnJlZnMud2luZG93TG9hZFRpbWUuY2xhc3NMaXN0LmFkZCh0aGlzLmdldEhpZ2hsaWdodENsYXNzKHRpbWUpKVxuICAgIHRoaXMucmVmcy53aW5kb3dMb2FkVGltZS50ZXh0Q29udGVudCA9IGAke3RpbWV9bXNgXG5cbiAgICBjb25zdCB7c2hlbGxMb2FkVGltZX0gPSBhdG9tLmdldExvYWRTZXR0aW5ncygpXG4gICAgaWYgKHNoZWxsTG9hZFRpbWUgIT0gbnVsbCkge1xuICAgICAgdGhpcy5yZWZzLnNoZWxsTG9hZFRpbWUuY2xhc3NMaXN0LmFkZCh0aGlzLmdldEhpZ2hsaWdodENsYXNzKHNoZWxsTG9hZFRpbWUpKVxuICAgICAgdGhpcy5yZWZzLnNoZWxsTG9hZFRpbWUudGV4dENvbnRlbnQgPSBgJHtzaGVsbExvYWRUaW1lfW1zYFxuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLnJlZnMuc2hlbGxUaW1pbmcuc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgIH1cblxuICAgIGlmIChhdG9tLmRlc2VyaWFsaXplVGltaW5ncy5wcm9qZWN0ICE9IG51bGwpIHtcbiAgICAgIC8vIFByb2plY3QgYW5kIHdvcmtzcGFjZSB0aW1pbmdzIG9ubHkgZXhpc3QgaWYgdGhlIGN1cnJlbnQgcHJvamVjdCB3YXMgcHJldmlvdXNseSBvcGVuZWRcbiAgICAgIHRoaXMucmVmcy5wcm9qZWN0TG9hZFRpbWUuY2xhc3NMaXN0LmFkZCh0aGlzLmdldEhpZ2hsaWdodENsYXNzKGF0b20uZGVzZXJpYWxpemVUaW1pbmdzLnByb2plY3QpKVxuICAgICAgdGhpcy5yZWZzLnByb2plY3RMb2FkVGltZS50ZXh0Q29udGVudCA9IGAke2F0b20uZGVzZXJpYWxpemVUaW1pbmdzLnByb2plY3R9bXNgXG4gICAgICB0aGlzLnJlZnMud29ya3NwYWNlTG9hZFRpbWUuY2xhc3NMaXN0LmFkZCh0aGlzLmdldEhpZ2hsaWdodENsYXNzKGF0b20uZGVzZXJpYWxpemVUaW1pbmdzLndvcmtzcGFjZSkpXG4gICAgICB0aGlzLnJlZnMud29ya3NwYWNlTG9hZFRpbWUudGV4dENvbnRlbnQgPSBgJHthdG9tLmRlc2VyaWFsaXplVGltaW5ncy53b3Jrc3BhY2V9bXNgXG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMucmVmcy5kZXNlcmlhbGl6ZVRpbWluZ3Muc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgIH1cbiAgfVxuXG4gIGdldEhpZ2hsaWdodENsYXNzICh0aW1lKSB7XG4gICAgaWYgKHRpbWUgPiAxMDAwKSB7XG4gICAgICByZXR1cm4gJ2hpZ2hsaWdodC1lcnJvcidcbiAgICB9IGVsc2UgaWYgKHRpbWUgPiA4MDApIHtcbiAgICAgIHJldHVybiAnaGlnaGxpZ2h0LXdhcm5pbmcnXG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiAnaGlnaGxpZ2h0LWluZm8nXG4gICAgfVxuICB9XG59XG4iXX0=