Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/** @babel */
/** @jsx etch.dom **/

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var GuideView = (function () {
  function GuideView(props) {
    _classCallCheck(this, GuideView);

    this.props = props;
    this.didClickProjectButton = this.didClickProjectButton.bind(this);
    this.didClickGitButton = this.didClickGitButton.bind(this);
    this.didClickGitHubButton = this.didClickGitHubButton.bind(this);
    this.didClickTeletypeButton = this.didClickTeletypeButton.bind(this);
    this.didClickPackagesButton = this.didClickPackagesButton.bind(this);
    this.didClickThemesButton = this.didClickThemesButton.bind(this);
    this.didClickStylingButton = this.didClickStylingButton.bind(this);
    this.didClickInitScriptButton = this.didClickInitScriptButton.bind(this);
    this.didClickSnippetsButton = this.didClickSnippetsButton.bind(this);
    this.didExpandOrCollapseSection = this.didExpandOrCollapseSection.bind(this);
    _etch2["default"].initialize(this);
  }

  _createClass(GuideView, [{
    key: "update",
    value: function update() {}
  }, {
    key: "render",
    value: function render() {
      return _etch2["default"].dom(
        "div",
        { className: "welcome is-guide" },
        _etch2["default"].dom(
          "div",
          { className: "welcome-container" },
          _etch2["default"].dom(
            "section",
            { className: "welcome-panel" },
            _etch2["default"].dom(
              "h1",
              { className: "welcome-title" },
              "Get to know Atom!"
            ),
            _etch2["default"].dom(
              "details",
              _extends({
                className: "welcome-card"
              }, this.getSectionProps('project')),
              _etch2["default"].dom(
                "summary",
                { className: "welcome-summary icon icon-repo" },
                "Open a ",
                _etch2["default"].dom(
                  "span",
                  { className: "welcome-highlight" },
                  "Project"
                )
              ),
              _etch2["default"].dom(
                "div",
                { className: "welcome-detail" },
                _etch2["default"].dom(
                  "p",
                  null,
                  _etch2["default"].dom("img", {
                    className: "welcome-img",
                    src: "atom://welcome/assets/project.svg"
                  })
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  "In Atom you can open individual files or a whole folder as a project. Opening a folder will add a tree view to the editor where you can browse all the files."
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  _etch2["default"].dom(
                    "button",
                    {
                      ref: "projectButton",
                      onclick: this.didClickProjectButton,
                      className: "btn btn-primary"
                    },
                    "Open a Project"
                  )
                ),
                _etch2["default"].dom(
                  "p",
                  { className: "welcome-note" },
                  _etch2["default"].dom(
                    "strong",
                    null,
                    "Next time:"
                  ),
                  " You can also open projects from the menu, keyboard shortcut or by dragging a folder onto the Atom dock icon."
                )
              )
            ),
            _etch2["default"].dom(
              "details",
              _extends({ className: "welcome-card" }, this.getSectionProps('git')),
              _etch2["default"].dom(
                "summary",
                { className: "welcome-summary icon icon-mark-github" },
                "Version control with",
                ' ',
                _etch2["default"].dom(
                  "span",
                  { "class": "welcome-highlight" },
                  "Git and GitHub"
                )
              ),
              _etch2["default"].dom(
                "div",
                { className: "welcome-detail" },
                _etch2["default"].dom(
                  "p",
                  null,
                  _etch2["default"].dom("img", {
                    className: "welcome-img",
                    src: "atom://welcome/assets/package.svg"
                  })
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  "Track changes to your code as you work. Branch, commit, push, and pull without leaving the comfort of your editor. Collaborate with other developers on GitHub."
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  _etch2["default"].dom(
                    "button",
                    {
                      onclick: this.didClickGitButton,
                      className: "btn btn-primary inline-block"
                    },
                    "Open the Git panel"
                  ),
                  _etch2["default"].dom(
                    "button",
                    {
                      onclick: this.didClickGitHubButton,
                      className: "btn btn-primary inline-block"
                    },
                    "Open the GitHub panel"
                  )
                ),
                _etch2["default"].dom(
                  "p",
                  { className: "welcome-note" },
                  _etch2["default"].dom(
                    "strong",
                    null,
                    "Next time:"
                  ),
                  " You can toggle the Git tab by clicking on the",
                  _etch2["default"].dom("span", { className: "icon icon-diff" }),
                  " button in your status bar."
                )
              )
            ),
            _etch2["default"].dom(
              "details",
              _extends({
                className: "welcome-card"
              }, this.getSectionProps('teletype')),
              _etch2["default"].dom(
                "summary",
                { className: "welcome-summary icon icon-radio-tower" },
                "Collaborate in real time with",
                ' ',
                _etch2["default"].dom(
                  "span",
                  { "class": "welcome-highlight" },
                  "Teletype"
                )
              ),
              _etch2["default"].dom(
                "div",
                { className: "welcome-detail" },
                _etch2["default"].dom(
                  "p",
                  null,
                  _etch2["default"].dom("img", {
                    className: "welcome-img",
                    src: "atom://welcome/assets/code.svg"
                  })
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  "Share your workspace with team members and collaborate on code in real time."
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  _etch2["default"].dom(
                    "button",
                    {
                      onclick: this.didClickTeletypeButton,
                      className: "btn btn-primary inline-block"
                    },
                    "Install Teletype for Atom"
                  )
                )
              )
            ),
            _etch2["default"].dom(
              "details",
              _extends({
                className: "welcome-card"
              }, this.getSectionProps('packages')),
              _etch2["default"].dom(
                "summary",
                { className: "welcome-summary icon icon-package" },
                "Install a ",
                _etch2["default"].dom(
                  "span",
                  { className: "welcome-highlight" },
                  "Package"
                )
              ),
              _etch2["default"].dom(
                "div",
                { className: "welcome-detail" },
                _etch2["default"].dom(
                  "p",
                  null,
                  _etch2["default"].dom("img", {
                    className: "welcome-img",
                    src: "atom://welcome/assets/package.svg"
                  })
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  "One of the best things about Atom is the package ecosystem. Installing packages adds new features and functionality you can use to make the editor suit your needs. Let's install one."
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  _etch2["default"].dom(
                    "button",
                    {
                      ref: "packagesButton",
                      onclick: this.didClickPackagesButton,
                      className: "btn btn-primary"
                    },
                    "Open Installer"
                  )
                ),
                _etch2["default"].dom(
                  "p",
                  { className: "welcome-note" },
                  _etch2["default"].dom(
                    "strong",
                    null,
                    "Next time:"
                  ),
                  " You can install new packages from the settings."
                )
              )
            ),
            _etch2["default"].dom(
              "details",
              _extends({
                className: "welcome-card"
              }, this.getSectionProps('themes')),
              _etch2["default"].dom(
                "summary",
                { className: "welcome-summary icon icon-paintcan" },
                "Choose a ",
                _etch2["default"].dom(
                  "span",
                  { "class": "welcome-highlight" },
                  "Theme"
                )
              ),
              _etch2["default"].dom(
                "div",
                { className: "welcome-detail" },
                _etch2["default"].dom(
                  "p",
                  null,
                  _etch2["default"].dom("img", {
                    className: "welcome-img",
                    src: "atom://welcome/assets/theme.svg"
                  })
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  "Atom comes with preinstalled themes. Let's try a few."
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  _etch2["default"].dom(
                    "button",
                    {
                      ref: "themesButton",
                      onclick: this.didClickThemesButton,
                      className: "btn btn-primary"
                    },
                    "Open the theme picker"
                  )
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  "You can also install themes created by the Atom community. To install new themes, click on \"+ Install\" and switch the toggle to \"themes\"."
                ),
                _etch2["default"].dom(
                  "p",
                  { className: "welcome-note" },
                  _etch2["default"].dom(
                    "strong",
                    null,
                    "Next time:"
                  ),
                  " You can switch themes from the settings."
                )
              )
            ),
            _etch2["default"].dom(
              "details",
              _extends({
                className: "welcome-card"
              }, this.getSectionProps('styling')),
              _etch2["default"].dom(
                "summary",
                { className: "welcome-summary icon icon-paintcan" },
                "Customize the ",
                _etch2["default"].dom(
                  "span",
                  { "class": "welcome-highlight" },
                  "Styling"
                )
              ),
              _etch2["default"].dom(
                "div",
                { className: "welcome-detail" },
                _etch2["default"].dom(
                  "p",
                  null,
                  _etch2["default"].dom("img", {
                    className: "welcome-img",
                    src: "atom://welcome/assets/code.svg"
                  })
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  "You can customize almost anything by adding your own CSS/LESS."
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  _etch2["default"].dom(
                    "button",
                    {
                      ref: "stylingButton",
                      onclick: this.didClickStylingButton,
                      className: "btn btn-primary"
                    },
                    "Open your Stylesheet"
                  )
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  "Now uncomment some of the examples or try your own"
                ),
                _etch2["default"].dom(
                  "p",
                  { className: "welcome-note" },
                  _etch2["default"].dom(
                    "strong",
                    null,
                    "Next time:"
                  ),
                  " You can open your stylesheet from Menu ",
                  this.getApplicationMenuName(),
                  "."
                )
              )
            ),
            _etch2["default"].dom(
              "details",
              _extends({
                className: "welcome-card"
              }, this.getSectionProps('init-script')),
              _etch2["default"].dom(
                "summary",
                { className: "welcome-summary icon icon-code" },
                "Hack on the ",
                _etch2["default"].dom(
                  "span",
                  { "class": "welcome-highlight" },
                  "Init Script"
                )
              ),
              _etch2["default"].dom(
                "div",
                { className: "welcome-detail" },
                _etch2["default"].dom(
                  "p",
                  null,
                  _etch2["default"].dom("img", {
                    className: "welcome-img",
                    src: "atom://welcome/assets/code.svg"
                  })
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  "The init script is a bit of JavaScript or CoffeeScript run at startup. You can use it to quickly change the behaviour of Atom."
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  _etch2["default"].dom(
                    "button",
                    {
                      ref: "initScriptButton",
                      onclick: this.didClickInitScriptButton,
                      className: "btn btn-primary"
                    },
                    "Open your Init Script"
                  )
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  "Uncomment some of the examples or try out your own."
                ),
                _etch2["default"].dom(
                  "p",
                  { className: "welcome-note" },
                  _etch2["default"].dom(
                    "strong",
                    null,
                    "Next time:"
                  ),
                  " You can open your init script from Menu > ",
                  this.getApplicationMenuName(),
                  "."
                )
              )
            ),
            _etch2["default"].dom(
              "details",
              _extends({
                className: "welcome-card"
              }, this.getSectionProps('snippets')),
              _etch2["default"].dom(
                "summary",
                { className: "welcome-summary icon icon-code" },
                "Add a ",
                _etch2["default"].dom(
                  "span",
                  { "class": "welcome-highlight" },
                  "Snippet"
                )
              ),
              _etch2["default"].dom(
                "div",
                { className: "welcome-detail" },
                _etch2["default"].dom(
                  "p",
                  null,
                  _etch2["default"].dom("img", {
                    className: "welcome-img",
                    src: "atom://welcome/assets/code.svg"
                  })
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  "Atom snippets allow you to enter a simple prefix in the editor and hit tab to expand the prefix into a larger code block with templated values."
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  _etch2["default"].dom(
                    "button",
                    {
                      ref: "snippetsButton",
                      onclick: this.didClickSnippetsButton,
                      className: "btn btn-primary"
                    },
                    "Open your Snippets"
                  )
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  "In your snippets file, type ",
                  _etch2["default"].dom(
                    "code",
                    null,
                    "snip"
                  ),
                  " then hit",
                  ' ',
                  _etch2["default"].dom(
                    "code",
                    null,
                    "tab"
                  ),
                  ". The ",
                  _etch2["default"].dom(
                    "code",
                    null,
                    "snip"
                  ),
                  " snippet will expand to create a snippet!"
                ),
                _etch2["default"].dom(
                  "p",
                  { className: "welcome-note" },
                  _etch2["default"].dom(
                    "strong",
                    null,
                    "Next time:"
                  ),
                  " You can open your snippets in Menu > ",
                  this.getApplicationMenuName(),
                  "."
                )
              )
            ),
            _etch2["default"].dom(
              "details",
              _extends({
                className: "welcome-card"
              }, this.getSectionProps('shortcuts')),
              _etch2["default"].dom(
                "summary",
                { className: "welcome-summary icon icon-keyboard" },
                "Learn ",
                _etch2["default"].dom(
                  "span",
                  { "class": "welcome-highlight" },
                  "Keyboard Shortcuts"
                )
              ),
              _etch2["default"].dom(
                "div",
                { className: "welcome-detail" },
                _etch2["default"].dom(
                  "p",
                  null,
                  _etch2["default"].dom("img", {
                    className: "welcome-img",
                    src: "atom://welcome/assets/shortcut.svg"
                  })
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  "If you only remember one keyboard shortcut make it",
                  ' ',
                  _etch2["default"].dom(
                    "kbd",
                    { className: "welcome-key" },
                    this.getCommandPaletteKeyBinding()
                  ),
                  ". This keystroke toggles the command palette, which lists every Atom command. It's a good way to learn more shortcuts. Yes, you can try it now!"
                ),
                _etch2["default"].dom(
                  "p",
                  null,
                  "If you want to use these guides again use the command palette",
                  ' ',
                  _etch2["default"].dom(
                    "kbd",
                    { className: "welcome-key" },
                    this.getCommandPaletteKeyBinding()
                  ),
                  ' ',
                  "and search for ",
                  _etch2["default"].dom(
                    "span",
                    { className: "text-highlight" },
                    "Welcome"
                  ),
                  "."
                )
              )
            )
          )
        )
      );
    }
  }, {
    key: "getSectionProps",
    value: function getSectionProps(sectionName) {
      var props = {
        dataset: { section: sectionName },
        onclick: this.didExpandOrCollapseSection
      };
      if (this.props.openSections && this.props.openSections.indexOf(sectionName) !== -1) {
        props.open = true;
      }
      return props;
    }
  }, {
    key: "getCommandPaletteKeyBinding",
    value: function getCommandPaletteKeyBinding() {
      if (process.platform === 'darwin') {
        return 'cmd-shift-p';
      } else {
        return 'ctrl-shift-p';
      }
    }
  }, {
    key: "getApplicationMenuName",
    value: function getApplicationMenuName() {
      if (process.platform === 'darwin') {
        return 'Atom';
      } else if (process.platform === 'linux') {
        return 'Edit';
      } else {
        return 'File';
      }
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return {
        deserializer: this.constructor.name,
        openSections: this.getOpenSections(),
        uri: this.getURI()
      };
    }
  }, {
    key: "getURI",
    value: function getURI() {
      return this.props.uri;
    }
  }, {
    key: "getTitle",
    value: function getTitle() {
      return 'Welcome Guide';
    }
  }, {
    key: "isEqual",
    value: function isEqual(other) {
      return other instanceof GuideView;
    }
  }, {
    key: "getOpenSections",
    value: function getOpenSections() {
      return Array.from(this.element.querySelectorAll('details[open]')).map(function (sectionElement) {
        return sectionElement.dataset.section;
      });
    }
  }, {
    key: "didClickProjectButton",
    value: function didClickProjectButton() {
      this.props.reporterProxy.sendEvent('clicked-project-cta');
      atom.commands.dispatch(atom.views.getView(atom.workspace), 'application:open');
    }
  }, {
    key: "didClickGitButton",
    value: function didClickGitButton() {
      this.props.reporterProxy.sendEvent('clicked-git-cta');
      atom.commands.dispatch(atom.views.getView(atom.workspace), 'github:toggle-git-tab');
    }
  }, {
    key: "didClickGitHubButton",
    value: function didClickGitHubButton() {
      this.props.reporterProxy.sendEvent('clicked-github-cta');
      atom.commands.dispatch(atom.views.getView(atom.workspace), 'github:toggle-github-tab');
    }
  }, {
    key: "didClickPackagesButton",
    value: function didClickPackagesButton() {
      this.props.reporterProxy.sendEvent('clicked-packages-cta');
      atom.workspace.open('atom://config/install', { split: 'left' });
    }
  }, {
    key: "didClickThemesButton",
    value: function didClickThemesButton() {
      this.props.reporterProxy.sendEvent('clicked-themes-cta');
      atom.workspace.open('atom://config/themes', { split: 'left' });
    }
  }, {
    key: "didClickStylingButton",
    value: function didClickStylingButton() {
      this.props.reporterProxy.sendEvent('clicked-styling-cta');
      atom.workspace.open('atom://.atom/stylesheet', { split: 'left' });
    }
  }, {
    key: "didClickInitScriptButton",
    value: function didClickInitScriptButton() {
      this.props.reporterProxy.sendEvent('clicked-init-script-cta');
      atom.workspace.open('atom://.atom/init-script', { split: 'left' });
    }
  }, {
    key: "didClickSnippetsButton",
    value: function didClickSnippetsButton() {
      this.props.reporterProxy.sendEvent('clicked-snippets-cta');
      atom.workspace.open('atom://.atom/snippets', { split: 'left' });
    }
  }, {
    key: "didClickTeletypeButton",
    value: function didClickTeletypeButton() {
      this.props.reporterProxy.sendEvent('clicked-teletype-cta');
      atom.workspace.open('atom://config/packages/teletype', { split: 'left' });
    }
  }, {
    key: "didExpandOrCollapseSection",
    value: function didExpandOrCollapseSection(event) {
      var sectionName = event.currentTarget.closest('details').dataset.section;
      var action = event.currentTarget.hasAttribute('open') ? 'collapse' : 'expand';
      this.props.reporterProxy.sendEvent(action + "-" + sectionName + "-section");
    }
  }]);

  return GuideView;
})();

exports["default"] = GuideView;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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