(function() {
  var Grim, asyncifyJasmineFn, buildReporter, buildTerminalReporter, disableFocusMethods, fs, ipcRenderer, path, requireSpecs, setSpecDirectory, setSpecField, setSpecType, temp, waitsForPromise,
    slice = [].slice;

  Grim = require('grim');

  fs = require('fs-plus');

  temp = require('temp');

  path = require('path');

  ipcRenderer = require('electron').ipcRenderer;

  temp.track();

  module.exports = function(arg) {
    var ApplicationDelegate, JasmineJUnitReporter, applicationDelegate, atomHome, buildAtomEnvironment, documentTitle, fileBase, headless, i, j, jasmineContent, jasmineEnv, key, len, len1, loadablePack, logFile, outputDir, packName, promise, ref, resolveWithExitCode, testPackages, testPath, testPaths, userHome, userPack, value;
    logFile = arg.logFile, headless = arg.headless, testPaths = arg.testPaths, buildAtomEnvironment = arg.buildAtomEnvironment;
    ref = require('../vendor/jasmine');
    for (key in ref) {
      value = ref[key];
      window[key] = value;
    }
    require('jasmine-tagged');
    global.it = asyncifyJasmineFn(global.it, 1);
    global.fit = asyncifyJasmineFn(global.fit, 1);
    global.ffit = asyncifyJasmineFn(global.ffit, 1);
    global.fffit = asyncifyJasmineFn(global.fffit, 1);
    global.beforeEach = asyncifyJasmineFn(global.beforeEach, 0);
    global.afterEach = asyncifyJasmineFn(global.afterEach, 0);
    documentTitle = null;
    Object.defineProperty(document, 'title', {
      get: function() {
        return documentTitle;
      },
      set: function(title) {
        return documentTitle = title;
      }
    });
    userHome = process.env.ATOM_HOME || path.join(fs.getHomeDirectory(), '.atom');
    atomHome = temp.mkdirSync({
      prefix: 'atom-test-home-'
    });
    if (process.env.APM_TEST_PACKAGES) {
      testPackages = process.env.APM_TEST_PACKAGES.split(/\s+/);
      fs.makeTreeSync(path.join(atomHome, 'packages'));
      for (i = 0, len = testPackages.length; i < len; i++) {
        packName = testPackages[i];
        userPack = path.join(userHome, 'packages', packName);
        loadablePack = path.join(atomHome, 'packages', packName);
        try {
          fs.symlinkSync(userPack, loadablePack, 'dir');
        } catch (error1) {
          fs.copySync(userPack, loadablePack);
        }
      }
    }
    ApplicationDelegate = require('../src/application-delegate');
    applicationDelegate = new ApplicationDelegate();
    applicationDelegate.setRepresentedFilename = function() {};
    applicationDelegate.setWindowDocumentEdited = function() {};
    window.atom = buildAtomEnvironment({
      applicationDelegate: applicationDelegate,
      window: window,
      document: document,
      configDirPath: atomHome,
      enablePersistence: false
    });
    require('./spec-helper');
    if (process.env.JANKY_SHA1 || process.env.CI) {
      disableFocusMethods();
    }
    for (j = 0, len1 = testPaths.length; j < len1; j++) {
      testPath = testPaths[j];
      requireSpecs(testPath);
    }
    setSpecType('user');
    resolveWithExitCode = null;
    promise = new Promise(function(resolve, reject) {
      return resolveWithExitCode = resolve;
    });
    jasmineEnv = jasmine.getEnv();
    jasmineEnv.addReporter(buildReporter({
      logFile: logFile,
      headless: headless,
      resolveWithExitCode: resolveWithExitCode
    }));
    if (process.env.TEST_JUNIT_XML_PATH) {
      JasmineJUnitReporter = require('./jasmine-junit-reporter').JasmineJUnitReporter;
      process.stdout.write("Outputting JUnit XML to <" + process.env.TEST_JUNIT_XML_PATH + ">\n");
      outputDir = path.dirname(process.env.TEST_JUNIT_XML_PATH);
      fileBase = path.basename(process.env.TEST_JUNIT_XML_PATH, '.xml');
      jasmineEnv.addReporter(new JasmineJUnitReporter(outputDir, true, false, fileBase, true));
    }
    jasmineEnv.setIncludedTags([process.platform]);
    jasmineContent = document.createElement('div');
    jasmineContent.setAttribute('id', 'jasmine-content');
    document.body.appendChild(jasmineContent);
    jasmineEnv.execute();
    return promise;
  };

  asyncifyJasmineFn = function(fn, callbackPosition) {
    return function() {
      var args, callback;
      args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
      if (typeof args[callbackPosition] === 'function') {
        callback = args[callbackPosition];
        args[callbackPosition] = function() {
          var args, result;
          args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
          result = callback.apply(this, args);
          if (result instanceof Promise) {
            return waitsForPromise(function() {
              return result;
            });
          }
        };
      }
      return fn.apply(this, args);
    };
  };

  waitsForPromise = function(fn) {
    var promise;
    promise = fn();
    return global.waitsFor('spec promise to resolve', function(done) {
      return promise.then(done, function(error) {
        jasmine.getEnv().currentSpec.fail(error);
        return done();
      });
    });
  };

  disableFocusMethods = function() {
    return ['fdescribe', 'ffdescribe', 'fffdescribe', 'fit', 'ffit', 'fffit'].forEach(function(methodName) {
      var focusMethod;
      focusMethod = window[methodName];
      return window[methodName] = function(description) {
        var error;
        error = new Error('Focused spec is running on CI');
        return focusMethod(description, function() {
          throw error;
        });
      };
    });
  };

  requireSpecs = function(testPath, specType) {
    var i, len, ref, results, testFilePath;
    if (fs.isDirectorySync(testPath)) {
      ref = fs.listTreeSync(testPath);
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        testFilePath = ref[i];
        if (!(/-spec\.(coffee|js)$/.test(testFilePath))) {
          continue;
        }
        require(testFilePath);
        results.push(setSpecDirectory(testPath));
      }
      return results;
    } else {
      require(testPath);
      return setSpecDirectory(path.dirname(testPath));
    }
  };

  setSpecField = function(name, value) {
    var i, index, ref, results, specs;
    specs = jasmine.getEnv().currentRunner().specs();
    if (specs.length === 0) {
      return;
    }
    results = [];
    for (index = i = ref = specs.length - 1; ref <= 0 ? i <= 0 : i >= 0; index = ref <= 0 ? ++i : --i) {
      if (specs[index][name] != null) {
        break;
      }
      results.push(specs[index][name] = value);
    }
    return results;
  };

  setSpecType = function(specType) {
    return setSpecField('specType', specType);
  };

  setSpecDirectory = function(specDirectory) {
    return setSpecField('specDirectory', specDirectory);
  };

  buildReporter = function(arg) {
    var AtomReporter, headless, logFile, reporter, resolveWithExitCode;
    logFile = arg.logFile, headless = arg.headless, resolveWithExitCode = arg.resolveWithExitCode;
    if (headless) {
      return buildTerminalReporter(logFile, resolveWithExitCode);
    } else {
      AtomReporter = require('./atom-reporter');
      return reporter = new AtomReporter();
    }
  };

  buildTerminalReporter = function(logFile, resolveWithExitCode) {
    var JasmineListReporter, TerminalReporter, log, logStream, options;
    if (logFile != null) {
      logStream = fs.openSync(logFile, 'w');
    }
    log = function(str) {
      if (logStream != null) {
        return fs.writeSync(logStream, str);
      } else {
        return ipcRenderer.send('write-to-stderr', str);
      }
    };
    options = {
      print: function(str) {
        return log(str);
      },
      onComplete: function(runner) {
        if (logStream != null) {
          fs.closeSync(logStream);
        }
        if (Grim.getDeprecationsLength() > 0) {
          Grim.logDeprecations();
          resolveWithExitCode(1);
          return;
        }
        if (runner.results().failedCount > 0) {
          return resolveWithExitCode(1);
        } else {
          return resolveWithExitCode(0);
        }
      }
    };
    if (process.env.ATOM_JASMINE_REPORTER === 'list') {
      JasmineListReporter = require('./jasmine-list-reporter').JasmineListReporter;
      return new JasmineListReporter(options);
    } else {
      TerminalReporter = require('jasmine-tagged').TerminalReporter;
      return new TerminalReporter(options);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
