(function() {
  var CompositeDisposable, FindParentDir, Grim, TextEditor, TextEditorElement, TextMateLanguageMode, TreeSitterLanguageMode, _, addCustomMatchers, clipboard, emitObject, ensureNoDeprecatedFunctionCalls, ensureNoDeprecatedStylesheets, fixturePackagesPath, fs, grimDeprecationsSnapshot, jasmineStyle, packageMetadata, path, pathwatcher, specDirectory, specPackageName, specPackagePath, specProjectPath, stylesDeprecationsSnapshot, testPaths, warnIfLeakingPathSubscriptions,
    slice = [].slice;

  require('jasmine-json');

  require('../src/window');

  require('../vendor/jasmine-jquery');

  path = require('path');

  _ = require('underscore-plus');

  fs = require('fs-plus');

  Grim = require('grim');

  pathwatcher = require('pathwatcher');

  FindParentDir = require('find-parent-dir');

  CompositeDisposable = require('event-kit').CompositeDisposable;

  TextEditor = require('../src/text-editor');

  TextEditorElement = require('../src/text-editor-element');

  TextMateLanguageMode = require('../src/text-mate-language-mode');

  TreeSitterLanguageMode = require('../src/tree-sitter-language-mode');

  clipboard = require('electron').clipboard;

  jasmineStyle = document.createElement('style');

  jasmineStyle.textContent = atom.themes.loadStylesheet(atom.themes.resolveStylesheet('../static/jasmine'));

  document.head.appendChild(jasmineStyle);

  fixturePackagesPath = path.resolve(__dirname, './fixtures/packages');

  atom.packages.packageDirPaths.unshift(fixturePackagesPath);

  document.querySelector('html').style.overflow = 'auto';

  document.body.style.overflow = 'auto';

  Set.prototype.jasmineToString = function() {
    var first, result;
    result = "Set {";
    first = true;
    this.forEach(function(element) {
      if (!first) {
        result += ", ";
      }
      return result += element.toString();
    });
    first = false;
    return result + "}";
  };

  Set.prototype.isEqual = function(other) {
    var next, values;
    if (other instanceof Set) {
      if (this.size !== other.size) {
        return false;
      }
      values = this.values();
      while (!(next = values.next()).done) {
        if (!other.has(next.value)) {
          return false;
        }
      }
      return true;
    } else {
      return false;
    }
  };

  jasmine.getEnv().addEqualityTester(function(a, b) {
    if ((a != null ? a.jasmineMatches : void 0) != null) {
      return a.jasmineMatches(b);
    }
    if ((b != null ? b.jasmineMatches : void 0) != null) {
      return b.jasmineMatches(a);
    }
    return _.isEqual(a, b);
  });

  if (process.env.CI) {
    jasmine.getEnv().defaultTimeoutInterval = 120000;
  } else {
    jasmine.getEnv().defaultTimeoutInterval = 5000;
  }

  testPaths = atom.getLoadSettings().testPaths;

  if (specPackagePath = FindParentDir.sync(testPaths[0], 'package.json')) {
    packageMetadata = require(path.join(specPackagePath, 'package.json'));
    specPackageName = packageMetadata.name;
  }

  if (specDirectory = FindParentDir.sync(testPaths[0], 'fixtures')) {
    specProjectPath = path.join(specDirectory, 'fixtures');
  } else {
    specProjectPath = require('os').tmpdir();
  }

  beforeEach(function() {
    var clipboardContent, resolvePackagePath, spy;
    spyOn(Object.getPrototypeOf(atom.history), 'saveState').andReturn(Promise.resolve());
    atom.project.setPaths([specProjectPath]);
    window.resetTimeouts();
    spyOn(_._, "now").andCallFake(function() {
      return window.now;
    });
    spyOn(Date, 'now').andCallFake(function() {
      return window.now;
    });
    spyOn(window, "setTimeout").andCallFake(window.fakeSetTimeout);
    spyOn(window, "clearTimeout").andCallFake(window.fakeClearTimeout);
    spy = spyOn(atom.packages, 'resolvePackagePath').andCallFake(function(packageName) {
      if (specPackageName && packageName === specPackageName) {
        return resolvePackagePath(specPackagePath);
      } else {
        return resolvePackagePath(packageName);
      }
    });
    resolvePackagePath = _.bind(spy.originalValue, atom.packages);
    spyOn(atom.menu, 'sendToBrowserProcess');
    atom.config.set("core.destroyEmptyPanes", false);
    atom.config.set("editor.fontFamily", "Courier");
    atom.config.set("editor.fontSize", 16);
    atom.config.set("editor.autoIndent", false);
    atom.config.set("core.disabledPackages", ["package-that-throws-an-exception", "package-with-broken-package-json", "package-with-broken-keymap"]);
    advanceClock(1000);
    window.setTimeout.reset();
    TextEditorElement.prototype.setUpdatedSynchronously(true);
    spyOn(pathwatcher.File.prototype, "detectResurrectionAfterDelay").andCallFake(function() {
      return this.detectResurrection();
    });
    spyOn(TextEditor.prototype, "shouldPromptToSave").andReturn(false);
    TextMateLanguageMode.prototype.chunkSize = 2e308;
    TreeSitterLanguageMode.prototype.syncTimeoutMicros = 2e308;
    spyOn(TextMateLanguageMode.prototype, "tokenizeInBackground").andCallFake(function() {
      return this.tokenizeNextChunk();
    });
    spyOn(TextEditor.prototype, "onDidTokenize").andCallFake(function(callback) {
      return new CompositeDisposable(this.emitter.on("did-tokenize", callback), this.onDidChangeGrammar((function(_this) {
        return function() {
          var languageMode, ref;
          languageMode = _this.buffer.getLanguageMode();
          if ((ref = languageMode.tokenizeInBackground) != null ? ref.originalValue : void 0) {
            return callback();
          }
        };
      })(this)));
    });
    clipboardContent = 'initial clipboard content';
    spyOn(clipboard, 'writeText').andCallFake(function(text) {
      return clipboardContent = text;
    });
    spyOn(clipboard, 'readText').andCallFake(function() {
      return clipboardContent;
    });
    return addCustomMatchers(this);
  });

  afterEach(function() {
    ensureNoDeprecatedFunctionCalls();
    ensureNoDeprecatedStylesheets();
    waitsForPromise(function() {
      return atom.reset();
    });
    return runs(function() {
      if (!window.debugContent) {
        document.getElementById('jasmine-content').innerHTML = '';
      }
      warnIfLeakingPathSubscriptions();
      return waits(0);
    });
  });

  warnIfLeakingPathSubscriptions = function() {
    var watchedPaths;
    watchedPaths = pathwatcher.getWatchedPaths();
    if (watchedPaths.length > 0) {
      console.error("WARNING: Leaking subscriptions for paths: " + watchedPaths.join(", "));
    }
    return pathwatcher.closeAllWatchers();
  };

  ensureNoDeprecatedFunctionCalls = function() {
    var deprecations, error, originalPrepareStackTrace;
    deprecations = _.clone(Grim.getDeprecations());
    Grim.clearDeprecations();
    if (deprecations.length > 0) {
      originalPrepareStackTrace = Error.prepareStackTrace;
      Error.prepareStackTrace = function(error, stack) {
        var deprecation, functionName, i, j, k, len, len1, len2, location, output, ref, ref1;
        output = [];
        for (i = 0, len = deprecations.length; i < len; i++) {
          deprecation = deprecations[i];
          output.push(deprecation.originName + " is deprecated. " + deprecation.message);
          output.push(_.multiplyString("-", output[output.length - 1].length));
          ref = deprecation.getStacks();
          for (j = 0, len1 = ref.length; j < len1; j++) {
            stack = ref[j];
            for (k = 0, len2 = stack.length; k < len2; k++) {
              ref1 = stack[k], functionName = ref1.functionName, location = ref1.location;
              output.push(functionName + " -- " + location);
            }
          }
          output.push("");
        }
        return output.join("\n");
      };
      error = new Error("Deprecated function(s) " + (deprecations.map(function(arg) {
        var originName;
        originName = arg.originName;
        return originName;
      }).join(', ')) + ") were called.");
      error.stack;
      Error.prepareStackTrace = originalPrepareStackTrace;
      throw error;
    }
  };

  ensureNoDeprecatedStylesheets = function() {
    var deprecation, deprecations, results, sourcePath, title;
    deprecations = _.clone(atom.styles.getDeprecations());
    atom.styles.clearDeprecations();
    results = [];
    for (sourcePath in deprecations) {
      deprecation = deprecations[sourcePath];
      title = sourcePath !== 'undefined' ? "Deprecated stylesheet at '" + sourcePath + "':" : "Deprecated stylesheet:";
      throw new Error(title + "\n" + deprecation.message);
    }
    return results;
  };

  emitObject = jasmine.StringPrettyPrinter.prototype.emitObject;

  jasmine.StringPrettyPrinter.prototype.emitObject = function(obj) {
    if (obj.inspect) {
      return this.append(obj.inspect());
    } else {
      return emitObject.call(this, obj);
    }
  };

  jasmine.unspy = function(object, methodName) {
    if (!object[methodName].hasOwnProperty('originalValue')) {
      throw new Error("Not a spy");
    }
    return object[methodName] = object[methodName].originalValue;
  };

  jasmine.attachToDOM = function(element) {
    var jasmineContent;
    jasmineContent = document.querySelector('#jasmine-content');
    if (!jasmineContent.contains(element)) {
      return jasmineContent.appendChild(element);
    }
  };

  grimDeprecationsSnapshot = null;

  stylesDeprecationsSnapshot = null;

  jasmine.snapshotDeprecations = function() {
    grimDeprecationsSnapshot = _.clone(Grim.deprecations);
    return stylesDeprecationsSnapshot = _.clone(atom.styles.deprecationsBySourcePath);
  };

  jasmine.restoreDeprecationsSnapshot = function() {
    Grim.deprecations = grimDeprecationsSnapshot;
    return atom.styles.deprecationsBySourcePath = stylesDeprecationsSnapshot;
  };

  jasmine.useRealClock = function() {
    jasmine.unspy(window, 'setTimeout');
    jasmine.unspy(window, 'clearTimeout');
    jasmine.unspy(_._, 'now');
    return jasmine.unspy(Date, 'now');
  };

  jasmine.useMockClock = function() {
    spyOn(window, 'setInterval').andCallFake(fakeSetInterval);
    return spyOn(window, 'clearInterval').andCallFake(fakeClearInterval);
  };

  addCustomMatchers = function(spec) {
    return spec.addMatchers({
      toBeInstanceOf: function(expected) {
        var beOrNotBe;
        beOrNotBe = this.isNot ? "not be" : "be";
        this.message = (function(_this) {
          return function() {
            return "Expected " + (jasmine.pp(_this.actual)) + " to " + beOrNotBe + " instance of " + expected.name + " class";
          };
        })(this);
        return this.actual instanceof expected;
      },
      toHaveLength: function(expected) {
        var haveOrNotHave;
        if (this.actual == null) {
          this.message = (function(_this) {
            return function() {
              return "Expected object " + _this.actual + " has no length method";
            };
          })(this);
          return false;
        } else {
          haveOrNotHave = this.isNot ? "not have" : "have";
          this.message = (function(_this) {
            return function() {
              return "Expected object with length " + _this.actual.length + " to " + haveOrNotHave + " length " + expected;
            };
          })(this);
          return this.actual.length === expected;
        }
      },
      toExistOnDisk: function(expected) {
        var toOrNotTo;
        toOrNotTo = this.isNot && "not to" || "to";
        this.message = function() {
          return "Expected path '" + this.actual + "' " + toOrNotTo + " exist.";
        };
        return fs.existsSync(this.actual);
      },
      toHaveFocus: function() {
        var element, toOrNotTo;
        toOrNotTo = this.isNot && "not to" || "to";
        if (!document.hasFocus()) {
          console.error("Specs will fail because the Dev Tools have focus. To fix this close the Dev Tools or click the spec runner.");
        }
        this.message = function() {
          return "Expected element '" + this.actual + "' or its descendants " + toOrNotTo + " have focus.";
        };
        element = this.actual;
        if (element.jquery) {
          element = element.get(0);
        }
        return element === document.activeElement || element.contains(document.activeElement);
      },
      toShow: function() {
        var element, ref, toOrNotTo;
        toOrNotTo = this.isNot && "not to" || "to";
        element = this.actual;
        if (element.jquery) {
          element = element.get(0);
        }
        this.message = function() {
          return "Expected element '" + element + "' or its descendants " + toOrNotTo + " show.";
        };
        return (ref = element.style.display) === 'block' || ref === 'inline-block' || ref === 'static' || ref === 'fixed';
      },
      toEqualPath: function(expected) {
        var actualPath, expectedPath;
        actualPath = path.normalize(this.actual);
        expectedPath = path.normalize(expected);
        this.message = function() {
          return "Expected path '" + actualPath + "' to be equal to '" + expectedPath + "'.";
        };
        return actualPath === expectedPath;
      },
      toBeNear: function(expected, acceptedError, actual) {
        if (acceptedError == null) {
          acceptedError = 1;
        }
        return (typeof expected === 'number') && (typeof acceptedError === 'number') && (typeof this.actual === 'number') && (expected - acceptedError <= this.actual) && (this.actual <= expected + acceptedError);
      },
      toHaveNearPixels: function(expected, acceptedError, actual) {
        var actualNumber, expectedNumber;
        if (acceptedError == null) {
          acceptedError = 1;
        }
        expectedNumber = parseFloat(expected);
        actualNumber = parseFloat(this.actual);
        return (typeof expected === 'string') && (typeof acceptedError === 'number') && (typeof this.actual === 'string') && (expected.indexOf('px') >= 1) && (this.actual.indexOf('px') >= 1) && (expectedNumber - acceptedError <= actualNumber) && (actualNumber <= expectedNumber + acceptedError);
      }
    });
  };

  window.waitsForPromise = function() {
    var args, fn, label, ref, shouldReject, timeout;
    args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
    label = null;
    if (args.length > 1) {
      ref = args[0], shouldReject = ref.shouldReject, timeout = ref.timeout, label = ref.label;
    } else {
      shouldReject = false;
    }
    if (label == null) {
      label = 'promise to be resolved or rejected';
    }
    fn = _.last(args);
    return window.waitsFor(label, timeout, function(moveOn) {
      var promise;
      promise = fn();
      if (shouldReject) {
        promise["catch"].call(promise, moveOn);
        return promise.then(function() {
          jasmine.getEnv().currentSpec.fail("Expected promise to be rejected, but it was resolved");
          return moveOn();
        });
      } else {
        promise.then(moveOn);
        return promise["catch"].call(promise, function(error) {
          jasmine.getEnv().currentSpec.fail("Expected promise to be resolved, but it was rejected with: " + (error != null ? error.message : void 0) + " " + (jasmine.pp(error)));
          return moveOn();
        });
      }
    });
  };

  window.resetTimeouts = function() {
    window.now = 0;
    window.timeoutCount = 0;
    window.intervalCount = 0;
    window.timeouts = [];
    return window.intervalTimeouts = {};
  };

  window.fakeSetTimeout = function(callback, ms) {
    var id;
    if (ms == null) {
      ms = 0;
    }
    id = ++window.timeoutCount;
    window.timeouts.push([id, window.now + ms, callback]);
    return id;
  };

  window.fakeClearTimeout = function(idToClear) {
    return window.timeouts = window.timeouts.filter(function(arg) {
      var id;
      id = arg[0];
      return id !== idToClear;
    });
  };

  window.fakeSetInterval = function(callback, ms) {
    var action, id;
    id = ++window.intervalCount;
    action = function() {
      callback();
      return window.intervalTimeouts[id] = window.fakeSetTimeout(action, ms);
    };
    window.intervalTimeouts[id] = window.fakeSetTimeout(action, ms);
    return id;
  };

  window.fakeClearInterval = function(idToClear) {
    return window.fakeClearTimeout(this.intervalTimeouts[idToClear]);
  };

  window.advanceClock = function(delta) {
    var callback, callbacks, i, len, results;
    if (delta == null) {
      delta = 1;
    }
    window.now += delta;
    callbacks = [];
    window.timeouts = window.timeouts.filter(function(arg) {
      var callback, id, strikeTime;
      id = arg[0], strikeTime = arg[1], callback = arg[2];
      if (strikeTime <= window.now) {
        callbacks.push(callback);
        return false;
      } else {
        return true;
      }
    });
    results = [];
    for (i = 0, len = callbacks.length; i < len; i++) {
      callback = callbacks[i];
      results.push(callback());
    }
    return results;
  };

  exports.mockLocalStorage = function() {
    var items;
    items = {};
    spyOn(global.localStorage, 'setItem').andCallFake(function(key, item) {
      items[key] = item.toString();
      return void 0;
    });
    spyOn(global.localStorage, 'getItem').andCallFake(function(key) {
      var ref;
      return (ref = items[key]) != null ? ref : null;
    });
    return spyOn(global.localStorage, 'removeItem').andCallFake(function(key) {
      delete items[key];
      return void 0;
    });
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
