(function() {
  var LessCache, LessCompileCache, path;

  path = require('path');

  LessCache = require('less-cache');

  module.exports = LessCompileCache = (function() {
    function LessCompileCache(arg) {
      var cacheDir, importPaths, importedFilePathsByRelativeImportPath, lessSourcesByRelativeFilePath, resourcePath;
      resourcePath = arg.resourcePath, importPaths = arg.importPaths, lessSourcesByRelativeFilePath = arg.lessSourcesByRelativeFilePath, importedFilePathsByRelativeImportPath = arg.importedFilePathsByRelativeImportPath;
      cacheDir = path.join(process.env.ATOM_HOME, 'compile-cache', 'less');
      this.lessSearchPaths = [path.join(resourcePath, 'static', 'variables'), path.join(resourcePath, 'static')];
      if (importPaths != null) {
        importPaths = importPaths.concat(this.lessSearchPaths);
      } else {
        importPaths = this.lessSearchPaths;
      }
      this.cache = new LessCache({
        importPaths: importPaths,
        resourcePath: resourcePath,
        lessSourcesByRelativeFilePath: lessSourcesByRelativeFilePath,
        importedFilePathsByRelativeImportPath: importedFilePathsByRelativeImportPath,
        cacheDir: cacheDir,
        fallbackDir: path.join(resourcePath, 'less-compile-cache')
      });
    }

    LessCompileCache.prototype.setImportPaths = function(importPaths) {
      if (importPaths == null) {
        importPaths = [];
      }
      return this.cache.setImportPaths(importPaths.concat(this.lessSearchPaths));
    };

    LessCompileCache.prototype.read = function(stylesheetPath) {
      return this.cache.readFileSync(stylesheetPath);
    };

    LessCompileCache.prototype.cssForFile = function(stylesheetPath, lessContent, digest) {
      return this.cache.cssForFile(stylesheetPath, lessContent, digest);
    };

    return LessCompileCache;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
