(function() {
  var ChildProcess, Emitter, Grim, Task, _,
    slice = [].slice;

  _ = require('underscore-plus');

  ChildProcess = require('child_process');

  Emitter = require('event-kit').Emitter;

  Grim = require('grim');

  module.exports = Task = (function() {
    Task.once = function() {
      var args, task, taskPath;
      taskPath = arguments[0], args = 2 <= arguments.length ? slice.call(arguments, 1) : [];
      task = new Task(taskPath);
      task.once('task:completed', function() {
        return task.terminate();
      });
      task.start.apply(task, args);
      return task;
    };

    Task.prototype.callback = null;

    function Task(taskPath) {
      var compileCachePath, env;
      this.emitter = new Emitter;
      compileCachePath = require('./compile-cache').getCacheDirectory();
      taskPath = require.resolve(taskPath);
      env = Object.assign({}, process.env, {
        userAgent: navigator.userAgent
      });
      this.childProcess = ChildProcess.fork(require.resolve('./task-bootstrap'), [compileCachePath, taskPath], {
        env: env,
        silent: true
      });
      this.on("task:log", function() {
        return console.log.apply(console, arguments);
      });
      this.on("task:warn", function() {
        return console.warn.apply(console, arguments);
      });
      this.on("task:error", function() {
        return console.error.apply(console, arguments);
      });
      this.on("task:deprecations", function(deprecations) {
        var deprecation, i, len;
        for (i = 0, len = deprecations.length; i < len; i++) {
          deprecation = deprecations[i];
          Grim.addSerializedDeprecation(deprecation);
        }
      });
      this.on("task:completed", (function(_this) {
        return function() {
          var args;
          args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
          return typeof _this.callback === "function" ? _this.callback.apply(_this, args) : void 0;
        };
      })(this));
      this.handleEvents();
    }

    Task.prototype.handleEvents = function() {
      this.childProcess.removeAllListeners();
      this.childProcess.on('message', (function(_this) {
        return function(arg) {
          var args, event;
          event = arg.event, args = arg.args;
          if (_this.childProcess != null) {
            return _this.emitter.emit(event, args);
          }
        };
      })(this));
      if (this.childProcess.stdout != null) {
        this.childProcess.stdout.removeAllListeners();
        this.childProcess.stdout.on('data', function(data) {
          return console.log(data.toString());
        });
      }
      if (this.childProcess.stderr != null) {
        this.childProcess.stderr.removeAllListeners();
        return this.childProcess.stderr.on('data', function(data) {
          return console.error(data.toString());
        });
      }
    };

    Task.prototype.start = function() {
      var args, callback, i;
      args = 2 <= arguments.length ? slice.call(arguments, 0, i = arguments.length - 1) : (i = 0, []), callback = arguments[i++];
      if (this.childProcess == null) {
        throw new Error('Cannot start terminated process');
      }
      this.handleEvents();
      if (_.isFunction(callback)) {
        this.callback = callback;
      } else {
        args.push(callback);
      }
      this.send({
        event: 'start',
        args: args
      });
      return void 0;
    };

    Task.prototype.send = function(message) {
      if (this.childProcess != null) {
        this.childProcess.send(message);
      } else {
        throw new Error('Cannot send message to terminated process');
      }
      return void 0;
    };

    Task.prototype.on = function(eventName, callback) {
      return this.emitter.on(eventName, function(args) {
        return callback.apply(null, args);
      });
    };

    Task.prototype.once = function(eventName, callback) {
      var disposable;
      return disposable = this.on(eventName, function() {
        var args;
        args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
        disposable.dispose();
        return callback.apply(null, args);
      });
    };

    Task.prototype.terminate = function() {
      var ref, ref1;
      if (this.childProcess == null) {
        return false;
      }
      this.childProcess.removeAllListeners();
      if ((ref = this.childProcess.stdout) != null) {
        ref.removeAllListeners();
      }
      if ((ref1 = this.childProcess.stderr) != null) {
        ref1.removeAllListeners();
      }
      this.childProcess.kill();
      this.childProcess = null;
      return true;
    };

    Task.prototype.cancel = function() {
      var didForcefullyTerminate;
      didForcefullyTerminate = this.terminate();
      if (didForcefullyTerminate) {
        this.emitter.emit('task:cancelled');
      }
      return didForcefullyTerminate;
    };

    return Task;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
