/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.StaticImports;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

@BugPattern(name="BadImport", summary="Importing nested classes/static methods/static fields with commonly-used names can make code harder to read, because it may not be clear from the context exactly which type is being referred to. Qualifying the name with that of the containing class can make the code clearer.", severity=BugPattern.SeverityLevel.WARNING)
public class BadImport
extends BugChecker
implements BugChecker.ImportTreeMatcher {
    static final ImmutableSet<String> BAD_NESTED_CLASSES = ImmutableSet.of((Object)"Builder", (Object)"Callback", (Object)"Class", (Object)"Entry", (Object)"Enum", (Object)"Factory", (Object[])new String[]{"Type", "Key", "Id", "Provider"});
    private static final ImmutableSet<String> BAD_STATIC_IDENTIFIERS = ImmutableSet.of((Object)"builder", (Object)"create", (Object)"copyOf", (Object)"from", (Object)"getDefaultInstance", (Object)"INSTANCE", (Object[])new String[]{"newBuilder", "of", "valueOf"});
    private static final MultiMatcher<Tree, AnnotationTree> HAS_TYPE_USE_ANNOTATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher & Serializable)(t, state) -> BadImport.isTypeAnnotation(t));

    public Description matchImport(ImportTree tree, VisitorState state) {
        ImmutableSet<Symbol> symbols;
        Symbol symbol;
        if (!tree.isStatic()) {
            symbol = ASTHelpers.getSymbol((Tree)tree.getQualifiedIdentifier());
            if (symbol == null || BadImport.isAcceptableImport(symbol, BAD_NESTED_CLASSES)) {
                return Description.NO_MATCH;
            }
            symbols = ImmutableSet.of((Object)symbol);
        } else {
            StaticImports.StaticImportInfo staticImportInfo = StaticImports.tryCreate(tree, state);
            if (staticImportInfo == null || staticImportInfo.members().isEmpty()) {
                return Description.NO_MATCH;
            }
            symbols = staticImportInfo.members();
            symbol = (Symbol)symbols.iterator().next();
            if (BadImport.isAcceptableImport(symbol, BAD_STATIC_IDENTIFIERS)) {
                return Description.NO_MATCH;
            }
        }
        if (symbol.getEnclosingElement() instanceof Symbol.PackageSymbol) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder builder = SuggestedFix.builder().removeImport(symbol.getQualifiedName().toString());
        String replacement = SuggestedFixes.qualifyType((VisitorState)BadImport.getCheckState(state), (SuggestedFix.Builder)builder, (Symbol)symbol.getEnclosingElement()) + ".";
        return this.buildDescription(builder, (Set<Symbol>)symbols, replacement, state);
    }

    private static VisitorState getCheckState(VisitorState state) {
        CompilationUnitTree compilationUnit = state.getPath().getCompilationUnit();
        if (compilationUnit.getTypeDecls().isEmpty()) {
            return state;
        }
        Tree tree = compilationUnit.getTypeDecls().get(0);
        if (!(tree instanceof ClassTree) || ((ClassTree)tree).getMembers().isEmpty()) {
            return state;
        }
        return state.withPath(TreePath.getPath(compilationUnit, ((ClassTree)tree).getMembers().get(0)));
    }

    private static boolean isAcceptableImport(Symbol symbol, Set<String> badNames) {
        Name simpleName = symbol.getSimpleName();
        return badNames.stream().noneMatch(simpleName::contentEquals);
    }

    private Description buildDescription(final SuggestedFix.Builder builder, final Set<Symbol> symbols, final String enclosingReplacement, final VisitorState state) {
        CompilationUnitTree compilationUnit = state.getPath().getCompilationUnit();
        TreePath path = TreePath.getPath(compilationUnit, (Tree)compilationUnit);
        IdentifierTree firstFound = (IdentifierTree)new BugChecker.SuppressibleTreePathScanner<IdentifierTree, Void>(){

            public IdentifierTree reduce(IdentifierTree r1, IdentifierTree r2) {
                return r2 != null ? r2 : r1;
            }

            public IdentifierTree visitIdentifier(IdentifierTree node, Void unused) {
                Symbol nodeSymbol = ASTHelpers.getSymbol((Tree)node);
                if (symbols.contains(nodeSymbol) && !BadImport.this.isSuppressed(node) && this.getCurrentPath().getParentPath().getLeaf().getKind() != Tree.Kind.CASE) {
                    builder.prefixWith((Tree)node, enclosingReplacement);
                    this.moveTypeAnnotations(node);
                    return node;
                }
                return (IdentifierTree)super.visitIdentifier(node, (Object)unused);
            }

            private void moveTypeAnnotations(IdentifierTree node) {
                Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                switch (parent.getKind()) {
                    case METHOD: 
                    case VARIABLE: 
                    case ANNOTATED_TYPE: {
                        this.moveTypeAnnotations(node, parent, state, builder);
                        break;
                    }
                    case PARAMETERIZED_TYPE: {
                        Tree grandParent = this.getCurrentPath().getParentPath().getParentPath().getLeaf();
                        if (grandParent.getKind() != Tree.Kind.VARIABLE && grandParent.getKind() != Tree.Kind.METHOD) break;
                        this.moveTypeAnnotations(node, grandParent, state, builder);
                        break;
                    }
                }
            }

            private void moveTypeAnnotations(IdentifierTree node, Tree annotationHolder, VisitorState state2, SuggestedFix.Builder builder2) {
                for (AnnotationTree annotation : HAS_TYPE_USE_ANNOTATION.multiMatchResult(annotationHolder, state2).matchingNodes()) {
                    builder2.delete((Tree)annotation);
                    builder2.prefixWith((Tree)node, state2.getSourceForNode((Tree)annotation) + " ");
                }
            }
        }.scan(path, null);
        if (firstFound == null) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(firstFound, (Fix)builder.build());
    }

    private static boolean isTypeAnnotation(AnnotationTree t) {
        Symbol annotationSymbol = ASTHelpers.getSymbol((Tree)t.getAnnotationType());
        if (annotationSymbol == null) {
            return false;
        }
        Target target = annotationSymbol.getAnnotation(Target.class);
        if (target == null) {
            return false;
        }
        List<ElementType> value = Arrays.asList(target.value());
        return value.contains((Object)ElementType.TYPE_USE) || value.contains((Object)ElementType.TYPE_PARAMETER);
    }
}

