"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Store = require("electron-store");
const electron_util_1 = require("electron-util");
const schema = {
    theme: {
        type: 'string',
        enum: ['system', 'light', 'dark'],
        default: 'system'
    },
    privateMode: {
        type: 'boolean',
        default: false
    },
    showPrivateModePrompt: {
        type: 'boolean',
        default: true
    },
    vibrancy: {
        type: 'string',
        enum: ['none', 'sidebar', 'full'],
        // TODO: Change the default to 'sidebar' when the vibrancy issue in Electron is fixed.
        // See https://github.com/electron/electron/issues/10420
        default: 'none'
    },
    zoomFactor: {
        type: 'number',
        default: 1
    },
    lastWindowState: {
        type: 'object',
        properties: {
            x: {
                type: 'number'
            },
            y: {
                type: 'number'
            },
            width: {
                type: 'number'
            },
            height: {
                type: 'number'
            },
            isMaximized: {
                type: 'boolean'
            }
        },
        default: {
            x: undefined,
            y: undefined,
            width: 800,
            height: 600,
            isMaximized: false
        }
    },
    menuBarMode: {
        type: 'boolean',
        default: false
    },
    showDockIcon: {
        type: 'boolean',
        default: true
    },
    showTrayIcon: {
        type: 'boolean',
        default: true
    },
    alwaysOnTop: {
        type: 'boolean',
        default: false
    },
    showAlwaysOnTopPrompt: {
        type: 'boolean',
        default: true
    },
    bounceDockOnMessage: {
        type: 'boolean',
        default: false
    },
    showUnreadBadge: {
        type: 'boolean',
        default: true
    },
    showMessageButtons: {
        type: 'boolean',
        default: true
    },
    launchMinimized: {
        type: 'boolean',
        default: false
    },
    flashWindowOnMessage: {
        type: 'boolean',
        default: true
    },
    notificationMessagePreview: {
        type: 'boolean',
        default: true
    },
    block: {
        type: 'object',
        properties: {
            chatSeen: {
                type: 'boolean'
            },
            typingIndicator: {
                type: 'boolean'
            },
            deliveryReceipt: {
                type: 'boolean'
            }
        },
        default: {
            chatSeen: false,
            typingIndicator: false,
            deliveryReceipt: false
        }
    },
    emojiStyle: {
        type: 'string',
        enum: ['native', 'facebook-3-0', 'messenger-1-0', 'facebook-2-2'],
        default: 'facebook-3-0'
    },
    useWorkChat: {
        type: 'boolean',
        default: false
    },
    sidebar: {
        type: 'string',
        enum: ['default', 'hidden', 'narrow', 'wide'],
        default: 'default'
    },
    autoHideMenuBar: {
        type: 'boolean',
        default: false
    },
    notificationsMuted: {
        type: 'boolean',
        default: false
    },
    callRingtoneMuted: {
        type: 'boolean',
        default: false
    },
    hardwareAcceleration: {
        type: 'boolean',
        default: true
    },
    quitOnWindowClose: {
        type: 'boolean',
        default: false
    },
    keepMeSignedIn: {
        type: 'boolean',
        default: true
    },
    autoplayVideos: {
        type: 'boolean',
        default: true
    },
    isSpellCheckerEnabled: {
        type: 'boolean',
        default: true
    },
    spellCheckerLanguages: {
        type: 'array',
        items: {
            type: 'string'
        },
        default: []
    }
};
function updateVibrancySetting(store) {
    const vibrancy = store.get('vibrancy');
    if (!electron_util_1.is.macos || !vibrancy) {
        store.set('vibrancy', 'none');
        // @ts-expect-error
    }
    else if (vibrancy === true) {
        store.set('vibrancy', 'full');
        // @ts-expect-error
    }
    else if (vibrancy === false) {
        store.set('vibrancy', 'sidebar');
    }
}
function updateSidebarSetting(store) {
    if (store.get('sidebarHidden')) {
        store.set('sidebar', 'hidden');
        // @ts-expect-error
        store.delete('sidebarHidden');
    }
    else if (!store.has('sidebar')) {
        store.set('sidebar', 'default');
    }
}
function updateThemeSetting(store) {
    const darkMode = store.get('darkMode');
    const followSystemAppearance = store.get('followSystemAppearance');
    if (electron_util_1.is.macos && followSystemAppearance) {
        store.set('theme', 'system');
    }
    else if (typeof darkMode !== 'undefined') {
        store.set('theme', darkMode ? 'dark' : 'light');
    }
    else if (!store.has('theme')) {
        store.set('theme', 'system');
    }
    if (typeof darkMode !== 'undefined') {
        // @ts-expect-error
        store.delete('darkMode');
    }
    if (typeof followSystemAppearance !== 'undefined') {
        // @ts-expect-error
        store.delete('followSystemAppearance');
    }
}
function migrate(store) {
    updateVibrancySetting(store);
    updateSidebarSetting(store);
    updateThemeSetting(store);
}
const store = new Store({ schema });
migrate(store);
exports.default = store;
