"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const electron_1 = require("electron");
const is_online_1 = require("is-online");
const p_wait_for_1 = require("p-wait-for");
function showWaitDialog() {
    const buttonIndex = electron_1.dialog.showMessageBoxSync({
        message: 'You appear to be offline. Caprine requires a working internet connection.',
        detail: 'Do you want to wait?',
        buttons: [
            'Wait',
            'Quit'
        ],
        defaultId: 0,
        cancelId: 1
    });
    if (buttonIndex === 1) {
        electron_1.app.quit();
    }
}
exports.default = async () => {
    if (!(await (0, is_online_1.default)())) {
        const connectivityTimeout = setTimeout(showWaitDialog, 15000);
        await (0, p_wait_for_1.default)(is_online_1.default, { interval: 1000 });
        clearTimeout(connectivityTimeout);
    }
};
