"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toggleLaunchMinimized = exports.toggleTrayIcon = exports.stripTrackingFromUrl = exports.messengerDomain = exports.showRestartDialog = exports.sendBackgroundAction = exports.sendAction = exports.getWindow = void 0;
const electron_1 = require("electron");
const electron_better_ipc_1 = require("electron-better-ipc");
const electron_util_1 = require("electron-util");
const config_1 = require("./config");
const tray_1 = require("./tray");
electron_1.app.allowRendererProcessReuse = true;
function getWindow() {
    const [win] = electron_1.BrowserWindow.getAllWindows();
    return win;
}
exports.getWindow = getWindow;
function sendAction(action, args) {
    const win = getWindow();
    if (electron_util_1.is.macos) {
        win.restore();
    }
    electron_better_ipc_1.ipcMain.callRenderer(win, action, args);
}
exports.sendAction = sendAction;
async function sendBackgroundAction(action, args) {
    return electron_better_ipc_1.ipcMain.callRenderer(getWindow(), action, args);
}
exports.sendBackgroundAction = sendBackgroundAction;
function showRestartDialog(message) {
    const buttonIndex = electron_1.dialog.showMessageBoxSync(getWindow(), {
        message,
        detail: 'Do you want to restart the app now?',
        buttons: [
            'Restart',
            'Ignore'
        ],
        defaultId: 0,
        cancelId: 1
    });
    if (buttonIndex === 0) {
        electron_1.app.relaunch();
        electron_1.app.quit();
    }
}
exports.showRestartDialog = showRestartDialog;
exports.messengerDomain = config_1.default.get('useWorkChat') ? 'facebook.com' : 'messenger.com';
function stripTrackingFromUrl(url) {
    const trackingUrlPrefix = `https://l.${exports.messengerDomain}/l.php`;
    if (url.startsWith(trackingUrlPrefix)) {
        url = new URL(url).searchParams.get('u');
    }
    return url;
}
exports.stripTrackingFromUrl = stripTrackingFromUrl;
const toggleTrayIcon = () => {
    const showTrayIconState = config_1.default.get('showTrayIcon');
    config_1.default.set('showTrayIcon', !showTrayIconState);
    if (showTrayIconState) {
        tray_1.default.destroy();
    }
    else {
        tray_1.default.create(getWindow());
    }
};
exports.toggleTrayIcon = toggleTrayIcon;
const toggleLaunchMinimized = (menu) => {
    config_1.default.set('launchMinimized', !config_1.default.get('launchMinimized'));
    const showTrayIconItem = menu.getMenuItemById('showTrayIcon');
    if (config_1.default.get('launchMinimized')) {
        if (!config_1.default.get('showTrayIcon')) {
            (0, exports.toggleTrayIcon)();
        }
        disableMenuItem(showTrayIconItem, true);
        electron_1.dialog.showMessageBox({
            type: 'info',
            message: 'The “Show Tray Icon” setting is force-enabled while the “Launch Minimized” setting is enabled.',
            buttons: ['OK']
        });
    }
    else {
        showTrayIconItem.enabled = true;
    }
};
exports.toggleLaunchMinimized = toggleLaunchMinimized;
const disableMenuItem = (menuItem, checked) => {
    menuItem.enabled = false;
    menuItem.checked = checked;
};
