#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 clash-ghc
version:              1.4.3
visibility:           public
id:                   clash-ghc-1.4.3-2bP0Ro9kBES8oCpEhhBTeL
key:                  clash-ghc-1.4.3-2bP0Ro9kBES8oCpEhhBTeL
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2017, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - GHC frontend

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * Clash Compiler binary using GHC/Haskell as a frontend


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  896ce4d014d81c9c2ad376db55fa1dc6
exposed:              True
exposed-modules:
    Clash.GHC.Evaluator Clash.GHC.Evaluator.Primitive
    Clash.GHC.GenerateBindings Clash.GHC.LoadModules
    Clash.GHC.NetlistTypes Clash.GHC.PartialEval
    Clash.GHC.PartialEval.Eval Clash.GHC.PartialEval.Primitive
    Clash.GHC.PartialEval.Quote Clash.GHCi.Common Clash.Main

hidden-modules:
    Clash.GHCi.UI Clash.GHCi.UI.Info Clash.GHCi.UI.Monad
    Clash.GHCi.UI.Tags Clash.GHC.ClashFlags Clash.GHC.GHC2Core
    Clash.GHC.LoadInterfaceFiles Clash.GHC.Util Paths_clash_ghc
    Clash.GHCi.Leak Clash.GHCi.Util

import-dirs:          /usr/lib/ghc-9.0.1/site-local/clash-ghc-1.4.3
library-dirs:         /usr/lib/ghc-9.0.1/site-local/clash-ghc-1.4.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/clash-ghc-1.4.3
hs-libraries:         HSclash-ghc-1.4.3-2bP0Ro9kBES8oCpEhhBTeL
depends:
    Cabal-3.4.0.0 array-0.5.4.0 base-4.15.0.0
    bifunctors-5.5.11-3MgHowlkzBNDa84Pzdaw4w bytestring-0.10.12.1
    clash-lib-1.4.3-25zgD1vp6KG34swJ7ISD64
    clash-prelude-1.4.3-Ab2RByk2je67BhP58PU6Zy
    concurrent-supply-0.1.8-2iy6ZkAlOvLJsfDE5ZGiOJ containers-0.6.4.1
    deepseq-1.4.5.0 directory-1.3.6.1 exceptions-0.10.4
    extra-1.7.10-32H3SA4Yf8dI1sU3NgBQjm filepath-1.4.2.1 ghc-9.0.1
    ghc-bignum-1.0 ghc-boot-9.0.1 ghc-prim-0.7.0
    ghc-typelits-extra-0.4.3-6nYo8xBOFPO1WRumGXicto
    ghc-typelits-knownnat-0.7.6-JCXLiekWZO1GO4MCi4cayR
    ghc-typelits-natnormalise-0.7.6-CX5GdXkZxBv6P4PbepuCpT ghci-9.0.1
    hashable-1.3.4.0-6dnecuFViZBGFpHQwXe7GH haskeline-0.8.1.0
    lens-5.0.1-8m6Wsht5i4xJUQOyMfVULO mtl-2.2.2
    primitive-0.7.2.0-LNBP19Yyt8R6V7t6f1oEAz process-1.6.11.0
    reflection-2.1.6-6u7lgYKOoJRIaoCwDQXeMZ
    split-0.2.3.4-DqRCEXcI8QnJvOh9Kk2yn3 template-haskell-2.17.0.0
    text-1.2.4.1 time-1.9.3 transformers-0.5.6.2
    uniplate-1.6.13-KUT1WtoOy8j9HS4rdFCD1G unix-2.7.2.2
    unordered-containers-0.2.14.0-FVdmWuNRiZiBPBGw5WvZRu
    utf8-string-1.0.2-FSV4F6pxd5y7PjtRkbEpDf
    vector-0.12.3.1-41pb7QyPIvSGm54QlMLBN3

haddock-interfaces:   /usr/share/doc/clash-ghc/html/clash-ghc.haddock
haddock-html:         /usr/share/doc/clash-ghc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

