/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.NameEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.namespace.INameHelper;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;

class RenameInNameSpaceRecord
extends SimpleRecord {
    private DesignElement element = null;
    private String oldName = null;
    private String newName = null;
    private int nameSpaceID;
    private INameHelper nameHelper = null;

    RenameInNameSpaceRecord(Module module, DesignElement element, String oldName, String newName) {
        this.element = element;
        this.oldName = oldName;
        this.newName = newName;
        NameExecutor executor = new NameExecutor(module, element);
        this.nameHelper = executor.getNameHelper();
        this.nameSpaceID = executor.getNameSpaceId();
    }

    @Override
    protected void perform(boolean undo) {
        NameSpace ns = this.nameHelper.getNameSpace(this.nameSpaceID);
        if (undo) {
            ns.rename(this.element, this.newName, this.oldName);
        } else {
            ns.rename(this.element, this.oldName, this.newName);
        }
    }

    @Override
    public DesignElement getTarget() {
        return this.nameHelper.getElement();
    }

    @Override
    public NotificationEvent getEvent() {
        return new NameEvent(this.element, this.oldName, this.newName);
    }
}

