/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.expertsystem;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisResultGlobalMemoryEfficiency;
import com.nvidia.viper.analysis.AnalysisResultKernelPriority;
import com.nvidia.viper.analysis.AnalysisResultSharedMemoryEfficiency;
import com.nvidia.viper.analysis.AnalysisResultWarpExecutionEfficiency;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.expertsystem.BaseStage;
import com.nvidia.viper.expertsystem.ExpertSystemStageKind;
import com.nvidia.viper.expertsystem.ExpertSystemStepAction;
import com.nvidia.viper.expertsystem.IExpertSystemStage;
import com.nvidia.viper.expertsystem.KernelInstanceStage;
import com.nvidia.viper.model.ExpertSystem;

public class KernelsStage
extends BaseStage
implements IExpertSystemStage {
    public KernelsStage(ExpertSystem expertSystem) {
        super(expertSystem);
    }

    @Override
    public ExpertSystemStageKind getStageKind() {
        return ExpertSystemStageKind.KERNELS;
    }

    @Override
    public String getTitle(ResultOutput otpt) {
        return ViperMessages.ExpertSystem_Kernels_Title;
    }

    @Override
    public String getDescription(ResultOutput otpt) {
        return ViperMessages.ExpertSystem_Kernels_Desc;
    }

    @Override
    public ExpertSystemStepAction update() {
        return new ExpertSystemStepAction(new ExpertSystemStepAction(false, AnalysisStage.KERNELS), new ExpertSystemStepAction(AnalysisStage.KERNELS, AnalysisResultKernelPriority.class));
    }

    @Override
    public int getNumSteps() {
        return 2;
    }

    @Override
    public String getStepTitle(int stepIdx) {
        switch (stepIdx) {
            case 0: {
                return ViperMessages.ExpertSystem_Kernels_Step0_Title;
            }
            case 1: {
                return ViperMessages.ExpertSystem_Kernels_Step1_Title;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public String getStepDescription(int stepIdx) throws IndexOutOfBoundsException {
        switch (stepIdx) {
            case 0: {
                return ViperMessages.ExpertSystem_Kernels_Step0_Desc;
            }
            case 1: {
                return ViperMessages.ExpertSystem_Kernels_Step1_Desc;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ExpertSystemStepAction getStepAction(int stepIdx) {
        switch (stepIdx) {
            case 0: {
                return new ExpertSystemStepAction(KernelInstanceStage.getAnalysisRunAction(false), new ExpertSystemStepAction(ExpertSystemStageKind.BOUNDS));
            }
            case 1: {
                return new ExpertSystemStepAction(new ExpertSystemStepAction(false, AnalysisStage.KERNELS_PERFORMANCE), new ExpertSystemStepAction(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNELS_PERFORMANCE, AnalysisResultGlobalMemoryEfficiency.class), new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNELS_PERFORMANCE, AnalysisResultSharedMemoryEfficiency.class), new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNELS_PERFORMANCE, AnalysisResultWarpExecutionEfficiency.class), new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNELS, AnalysisResultKernelPriority.class)));
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean canPerformStep(int stepIdx) {
        if (stepIdx == 0) {
            return this.getSelectedInDepthKernel() != null;
        }
        return true;
    }

    @Override
    public boolean propertyChange(String propertyName) {
        return "session:sInterval".equals(propertyName);
    }
}

