/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.statushandlers.StatusManager;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static IFile getFile(IEditorInput editorInput) {
        if (editorInput == null) {
            return null;
        }
        Object o = editorInput.getAdapter(IFile.class);
        if (o instanceof IFile) {
            return (IFile)o;
        }
        return null;
    }

    public static IResource getResource(IEditorInput editorInput) {
        if (editorInput == null) {
            return null;
        }
        Object o = editorInput.getAdapter(IResource.class);
        if (o instanceof IResource) {
            return (IResource)o;
        }
        return ResourceUtil.getFile(editorInput);
    }

    public static IEditorPart findEditor(IWorkbenchPage page, IFile file) {
        IEditorPart editor = page.findEditor((IEditorInput)new FileEditorInput(file));
        if (editor != null) {
            return editor;
        }
        IEditorReference[] refs = page.getEditorReferences();
        int i = 0;
        while (i < refs.length) {
            IFile editorFile;
            IEditorReference ref = refs[i];
            IEditorPart part = ref.getEditor(false);
            if (part != null && (editorFile = ResourceUtil.getFile(part.getEditorInput())) != null && file.equals((Object)editorFile)) {
                return part;
            }
            ++i;
        }
        return null;
    }

    public static IResource getResource(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof IResource) {
            return (IResource)element;
        }
        return (IResource)ResourceUtil.getAdapter(element, IResource.class, true);
    }

    public static IFile getFile(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof IFile) {
            return (IFile)element;
        }
        ResourceMapping mapping = ResourceUtil.getResourceMapping(element);
        if (mapping != null) {
            return ResourceUtil.getFileFromResourceMapping(mapping);
        }
        Object adapter = ResourceUtil.getAdapter(element, IFile.class, true);
        if (adapter instanceof IFile) {
            return (IFile)adapter;
        }
        adapter = ResourceUtil.getAdapter(element, IResource.class, true);
        if (adapter instanceof IFile) {
            return (IFile)adapter;
        }
        return null;
    }

    public static ResourceMapping getResourceMapping(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof ResourceMapping) {
            return (ResourceMapping)element;
        }
        Object adapter = ResourceUtil.getAdapter(element, ResourceMapping.class, true);
        if (adapter instanceof ResourceMapping) {
            return (ResourceMapping)adapter;
        }
        return null;
    }

    private static IFile getFileFromResourceMapping(ResourceMapping mapping) {
        IResource resource = ResourceUtil.getResourceFromResourceMapping(mapping);
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    private static IResource getResourceFromResourceMapping(ResourceMapping mapping) {
        IResource[] resources;
        block5: {
            ResourceTraversal[] traversals;
            block4: {
                try {
                    traversals = mapping.getTraversals(null, null);
                    if (traversals.length == 1) break block4;
                    return null;
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "org.eclipse.ui.ide");
                    return null;
                }
            }
            ResourceTraversal traversal = traversals[0];
            resources = traversal.getResources();
            if (resources.length == 1) break block5;
            return null;
        }
        return resources[0];
    }

    public static Object getAdapter(Object element, Class adapterType, boolean forceLoad) {
        IAdaptable adaptable;
        Object o;
        if (element instanceof IAdaptable && (o = (adaptable = (IAdaptable)element).getAdapter(adapterType)) != null) {
            return o;
        }
        if (forceLoad) {
            return Platform.getAdapterManager().loadAdapter(element, adapterType.getName());
        }
        return Platform.getAdapterManager().getAdapter(element, adapterType);
    }
}

