/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.part;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.editparts.AbstractConnectionEditPart;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.erd.model.ERDObject;
import org.jkiss.dbeaver.erd.ui.part.DiagramPart;
import org.jkiss.dbeaver.model.DBPNamedObject;

public abstract class PropertyAwareConnectionPart
extends AbstractConnectionEditPart
implements PropertyChangeListener,
DBPNamedObject {
    @NotNull
    public DiagramPart getDiagramPart() {
        EditPart contents = this.getRoot().getContents();
        if (contents instanceof DiagramPart) {
            return (DiagramPart)contents;
        }
        throw new IllegalStateException("Diagram part must be top level part");
    }

    @NotNull
    public String getName() {
        return ((ERDObject)this.getModel()).getName();
    }

    protected boolean isEditEnabled() {
        return this.getRoot().getContents() instanceof DiagramPart && ((DiagramPart)this.getRoot().getContents()).getDiagram().isLayoutManualAllowed();
    }

    public void activate() {
        super.activate();
        ERDObject erdObject = (ERDObject)this.getModel();
        if (this.isEditEnabled()) {
            erdObject.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.isEditEnabled()) {
            ERDObject erdObject = (ERDObject)this.getModel();
            erdObject.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property;
        switch (property = evt.getPropertyName()) {
            case "CHILD": {
                this.refreshChildren();
                break;
            }
            case "INPUT": {
                this.refreshTargetConnections();
                break;
            }
            case "OUTPUT": {
                this.refreshSourceConnections();
            }
        }
        ((GraphicalEditPart)this.getViewer().getContents()).getFigure().revalidate();
    }
}

