/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.auth;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.access.DBASession;
import org.jkiss.dbeaver.model.auth.DBAAuthSpace;
import org.jkiss.dbeaver.model.auth.DBAAuthToken;
import org.jkiss.dbeaver.model.auth.DBASessionContext;
import org.jkiss.dbeaver.model.auth.DBASessionProviderService;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class SessionContextImpl
implements DBASessionContext {
    private static final Log log = Log.getLog(SessionContextImpl.class);
    private final DBASessionContext parentContext;
    private final List<DBASession> sessions = new ArrayList<DBASession>();

    public SessionContextImpl(DBASessionContext parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    @Nullable
    public DBASession getSpaceSession(@NotNull DBRProgressMonitor monitor, @NotNull DBAAuthSpace space, boolean open) throws DBException {
        DBASessionProviderService sessionProviderService;
        DBASession session2;
        for (DBASession session2 : this.sessions) {
            if (!CommonUtils.equalObjects((Object)session2.getSessionSpace(), (Object)space)) continue;
            return session2;
        }
        DBASession dBASession = session2 = this.parentContext == null ? null : this.parentContext.getSpaceSession(monitor, space, false);
        if (session2 == null && open && (sessionProviderService = DBWorkbench.getService(DBASessionProviderService.class)) != null) {
            try {
                session2 = sessionProviderService.acquireSession(monitor, this, space);
            }
            catch (Exception e) {
                throw new DBException("Error acquiring session", e);
            }
        }
        return session2;
    }

    @Override
    public DBAAuthToken[] getSavedTokens() {
        return new DBAAuthToken[0];
    }

    @Override
    public void addSession(@NotNull DBASession session) {
        if (!this.sessions.contains(session)) {
            this.sessions.add(session);
        } else {
            log.debug("Session '" + session + "' was added twice");
        }
    }

    @Override
    public boolean removeSession(@NotNull DBASession session) {
        if (this.sessions.remove(session)) {
            return true;
        }
        log.debug("Session '" + session + "' was removed twice");
        return false;
    }

    public void close() {
        this.sessions.clear();
    }
}

